import React from 'react';
import { IconButton, Tooltip } from '@mui/material';
import HighlightOffTwoToneIcon from '@mui/icons-material/HighlightOffTwoTone';

interface ToolbarCancelProps {
  selectedRows: any[];
  selectedRowsData: any[];
  onCancel: (ids: number[]) => void;
}

const ToolbarCancel: React.FC<ToolbarCancelProps> = ({
  selectedRows,
  selectedRowsData,
  onCancel,
}) => {
  // Logic sederhana
  const isEnabled =
    selectedRows.length > 0 &&
    selectedRowsData.every((row: any) => row.fgStatus === 'normal' || row.fgStatus === 'amendment');

  const handleClick = () => {
    if (!isEnabled) return;
    const ids = selectedRowsData.map((row: any) => row.id).filter((id: any) => id !== undefined);
    onCancel(ids);
  };

  return (
    <Tooltip title={isEnabled ? `Batalkan ${selectedRows.length} data` : 'Pilih data yang valid'}>
      <IconButton
        onClick={handleClick}
        disabled={!isEnabled}
        color={isEnabled ? 'error' : 'default'}
      >
        <HighlightOffTwoToneIcon />
      </IconButton>
    </Tooltip>
  );
};

export default ToolbarCancel;
