import { useQuery } from '@tanstack/react-query';
import type { TCountryResult } from '../types/types';
import fakturApi from '../utils/api';

export const useGetNegara = (params?: Record<string, any>) =>
  useQuery<TCountryResult>({
    queryKey: ['negara-faktur-pk'],
    queryFn: async () => {
      const res = await fakturApi.getCountry(params);
      return res.data; // ✅ langsung array negara
    },
  });

export default useGetNegara;
