import { useMutation } from '@tanstack/react-query';
import type { TBaseResponseAPI, TDeleteRequest } from '../types/types';
import digunggungApi from '../utils/api';

const useDeleteDigunggung = (props?: any) =>
  useMutation<TBaseResponseAPI<null>, Error, TDeleteRequest>({
    mutationKey: ['delete-digunggung'],
    mutationFn: (payload) => digunggungApi.deleteDigunggung(payload),
    ...props,
  });

export default useDeleteDigunggung;
