import React from 'react';
import type { GridPreferencePanelsValue} from '@mui/x-data-grid-premium';
import { useGridApiContext } from '@mui/x-data-grid-premium';
import { IconButton, Tooltip } from '@mui/material';
import ViewColumnIcon from '@mui/icons-material/ViewColumn';

// ✅ React.memo: cegah render ulang tanpa alasan
const CustomColumnsButton: React.FC = React.memo(() => {
  const apiRef = useGridApiContext();

  // ✅ useCallback biar referensi handleClick stabil di setiap render
  const handleClick = React.useCallback(() => {
    if (!apiRef.current) return;
    apiRef.current.showPreferences('columns' as GridPreferencePanelsValue);
  }, [apiRef]);

  return (
    <Tooltip title="Kolom">
      <IconButton
        size="small"
        onClick={handleClick}
        sx={{
          color: '#123375',
          '&:hover': { backgroundColor: 'rgba(18, 51, 117, 0.08)' },
        }}
      >
        <ViewColumnIcon fontSize="small" />
      </IconButton>
    </Tooltip>
  );
});

export default CustomColumnsButton;
