import Divider from '@mui/material/Divider';
import Grid from '@mui/material/Grid';
import { useFormContext } from 'react-hook-form';
import { Field } from 'src/components/hook-form';

type PPHDipotongProps = {
  kodeObjectPajak: {
    value: string;
    label: string;
  }[];
  fgFasilitasOptions: {
    value: string;
    label: string;
  }[];
};

const PerhitunganPPhPasal21 = ({ kodeObjectPajak, fgFasilitasOptions }: PPHDipotongProps) => {
  const { watch } = useFormContext();

  const fgFasilitas = watch('fgFasilitas');

  return (
    <Grid container rowSpacing={2} columnSpacing={2}>
      {/* Divider */}
      <Grid size={{ md: 12 }}>
        <Divider sx={{ fontWeight: 'bold' }} textAlign="left">
          Perhitungan PPh Pasal 21
        </Divider>
      </Grid>

      {/* Kode objek pajak */}
      <Grid size={{ md: 12 }}>
        <Field.Autocomplete name="kdObjPjk" label="Kode Objek Pajak" options={kodeObjectPajak} />
      </Grid>

      {/* Fasilitas */}
      <Grid size={{ md: 6 }}>
        <Field.Autocomplete name="fgFasilitas" label="Fasilitas" options={fgFasilitasOptions} />
      </Grid>

      {/* Dokumen lainnya */}
      <Grid size={{ md: 6 }}>
        <Field.Text
          name="noDokLainnya"
          label="Nomor Dokumen Lainnya"
          disabled={['9', ''].includes(fgFasilitas.value)}
          sx={{ '& .MuiInputBase-root.Mui-disabled': { backgroundColor: '#f6f6f6' } }}
        />
      </Grid>
    </Grid>
  );
};

export default PerhitunganPPhPasal21;
