import { useQuery } from '@tanstack/react-query';
import type { TBaseResponseAPI, TGetListDataKOPDnResult } from '../types/types';
import queryKey from '../constant/queryKey';
import dnApi from '../utils/api';

const useGetKodeObjekPajak = (params?: Record<string, any>) =>
  useQuery<TBaseResponseAPI<TGetListDataKOPDnResult>>({
    queryKey: queryKey.getKodeObjekPajak(params),
    queryFn: () => dnApi.getKodeObjekPajakDn(params),
  });

export default useGetKodeObjekPajak;
