export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

export type TBaseResponseCreateAPI<T> = {
  code: number;
  data?: T;
  message: string;
  status: string;
  time: Date;
};

export interface BupotRecord {
  // --- Kunci numerik dinamis ("1" sampai "53") ---
  // [key: `${number}`]: number | undefined;

  id: number;
  idBupot: string | null;
  noBupot: string | null;
  thnPajak: string;
  msPajak: string;
  namaPemotong: string | null;
  fgIdDipotong: string; // "true" / "false" (string)
  idDipotong: string;
  namaDipotong: string;
  tglPemotongan: string;
  kdJnsPjk: string;
  namaTtd: string | null;
  nikNpwpTtd: string | null;
  created_at: string;
  updated_at: string;
  errorMsg: string | null;
  created: string;
  updated: string;
  email: string | null;
  npwp16Pemotong: string;
  nitkuPemotong: string;
  npwp16Dipotong: string;
  fgKirimEmail: number;
  statusEmail: string | null;
  messageid: string | null;
  passphrasePenandatangan: string | null;
  dcPenandatangan: string | null;
  serialNumberPenandatangan: string | null;
  userId: string;
  foreignEmployee: string; // "true" / "false" (string)
  passportNo: string;
  countryCode: string | null;
  statusPtkp: string;
  jmlPtkp: number;
  posisiJabatan: string;
  kdObjPjk: string;
  nmObjPjk: string | null;
  pasalPPh: string | null;
  bruto: string;
  tarif: string;
  pphDipotong: string;
  fgStatus: string;
  fgFasilitas: string;
  noDokLainnya: string;
  kap: string;
  kjs: string;
  internal_id: string;
  fgLapor: number;
  revNo: number;
  tglPembatalan: string | null;
  fgGrossUp: number;
  link: string | null;
  glAccount: string;
  fgkirimemail: string;
  tunjanganPPh: string;
  pph21ditanggungperusahaan: string;
  pph21ditanggungkaryawan: string;
  alamat: string;
  keterangan1: string | null;
  keterangan2: string | null;
  keterangan3: string | null;
  keterangan4: string | null;
  keterangan5: string | null;
}

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TGetListDataTableDn = {
  id: number;
  idBupot: null | string;
  noBupot: null | string;
  revNo: string;
  fgTransaction: null | string;
  npwpPemotong: string;
  idTku: string;
  masaPajakAwal: string;
  masaPajakAkhir: string;
  tahunPajak: string;
  fgNpwpNik: string;
  npwp: string;
  nik: string;
  nama: string;
  alamat: string;
  foreignEmployee: null | string;
  passportNo: null | string;
  countryCode: null | string;
  jnsKelamin: string;
  statusPtkp: string;
  jmlPtkp: null | string;
  kodeObjekPajak: string;
  pasalPPh: string;
  blnPenghasilanDisetahunkan: string;
  fgKaryawanAsing: string;
  passport: null | string;
  kdNegara: string;
  posisiJabatan: string;
  gajiPensiun: number;
  tunjanganPPh: number;
  tunjanganPPhGrossUp: string;
  tunjanganLainnyaLembur: number;
  honorarium: number;
  premiAsuransi: number;
  natura: number;
  tantiemBonus: number;
  totalPenghasilanBruto: number;
  biayaJabatan: number;
  iuranPensiun: number;
  zakat: number;
  totalPengurang: number;
  totalPenghasilanNeto: number;
  fgStatusPemotonganPph: number;
  nominalPtkp: number;
  pkpSetahunDisetahunkan: number;
  pph21SetahunDisetahunkan: number;
  totalPenghasilanNetoDariBupotSebelumnya: number;
  pph21Terutang: number;
  totalPenghasilanNetoPph21: number;
  noBupotSebelumnya: null | string;
  pph21DariBupotSebelumnya: null | string;
  pph21DapatDikreditkan: number;
  pph21WithheldDtp: null | string;
  pph21KurangLebihBayar: number;
  kap: string;
  kjs: string;
  fgFasilitas: string;
  email: null | string;
  noDokFasilitas: string;
  tglPemotongan: string;
  tglPembatalan: null | string;
  userId: string;
  created_at: string;
  updated_at: string;
  created: string;
  updated: string;
  internal_id: string;
  fgStatus: string;
  npwpNikPenandatangan: null | string;
  namaPenandatangan: null | string;
  link: null | string;
  glAccount: string;
  errorMsg: null | string;
  fgkirimemail: string;
  keterangan1: null | string;
  keterangan2: null | string;
  keterangan3: null | string;
  keterangan4: null | string;
  keterangan5: null | string;
  glName: null | string;
  namaNegara: string;
};

export type TGetListDataTableDnResult = TGetListDataTableDn[];

export type TGetListDataKOPDn = {
  dtp: number;
  kap: string;
  kjs: string;
  kode: string;
  nama: string;
  noCertificate: number;
  normanetto: string;
  otherCert: number;
  pasal: string;
  skbBungaTabungan: number;
  skbPHTB: number;
  skbPasal22: number;
  skbPasal23: number;
  statuspph: string;
  suket: number;
  tarif: string;
};

export type TGetListDataKOPDnResult = TGetListDataKOPDn[];

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TPostTahunanA1Request = {
  id?: number | null;
  npwpPemotong: string;
  idTku: string;
  revNo: number;
  masaPajakAwal: string;
  masaPajakAkhir: string;
  tahunPajak: string;
  fgNpwpNik: boolean;
  npwp: string;
  nik: string;
  nama: string;
  alamat: string;
  jnsKelamin: 'M' | 'F';
  statusPtkp: string;
  jmlPtkp: number;
  nominalPtkp: number;
  kodeObjekPajak: string;
  pasalPPh: string;
  kap: string;
  kjs: string;
  fgStatusPemotonganPph: number;
  blnPenghasilanDisetahunkan: string;
  dataDetilA0: {
    fgKaryawanAsing: boolean;
    passport: string;
    kdNegara: string | null;
    posisiJabatan: string;
    gajiPensiun: number;
    tunjanganPPh: number;
    tunjanganPPhGrossUp: string;
    tunjanganLainnyaLembur: number;
    honorarium: number;
    premiAsuransi: number;
    natura: number;
    tantiemBonus: number;
    biayaJabatan: number;
    iuranPensiun: number;
    zakat: number;
    fgFasilitas: number;
    noDokFasilitas: string;
  };
  totalPenghasilanBruto: number;
  totalPengurang: number;
  totalPenghasilanNeto: number; // point 13
  noBupotSebelumnya: number; // di isi jika point 14 juga diisi
  totalPenghasilanNetoDariBupotSebelumnya: number; // point 14
  totalPenghasilanNetoPph21: number; // point 20
  pkpSetahunDisetahunkan: number; // point 17
  pph21SetahunDisetahunkan: number; // point 18
  pph21Terutang: number; // point 21
  pph21DariBupotSebelumnya: number; // point 19
  pph21DapatDikreditkan: number; // point 22
  pph21WithheldDtp: number;
  pph21KurangLebihBayar: number; // point 23
  tglPemotongan: string;
  noBupot?: string;
  idBupot?: string;
};

export type TPortBulananRequest = {
  id: string;
};

export type TPortBulananCenceledRequest = {
  tglPembatalan: string;
} & TPortBulananRequest;
