// hooks/useUpload.ts
import { useMutation } from '@tanstack/react-query';
import nrApi from '../utils/api';
import queryKey from '../../constant/queryKey';

const useUpload = (props?: any) =>
  useMutation({
    mutationKey: queryKey.bupot26.upload,
    mutationFn: (payload: { id: string | number }) => nrApi.upload(payload),
    ...props,
  });

export default useUpload;
