import { useMutation } from '@tanstack/react-query';
import dayjs from 'dayjs';
import type { TPostNrRequest } from '../types/types';
import nrApi from '../utils/api';

const transformParams = ({ isPengganti = false, ...nrData }: any): TPostNrRequest => {
  const {
    id,
    idBupot,
    noBupot,
    npwpPemotong,
    idTku,
    masaPajak,
    tahunPajak,
    tinDipotong,
    namaDipotong,
    alamatDipotong,
    negaraDipotong,
    tglLahirDipotong,
    tmptLahirDipotong,
    nomorPaspor,
    nomorKitasKitap,
    sertifikatInsentifDipotong,
    nomorSertifikatInsentif,
    kodeObjekPajak,
    pasalPph,
    statusPph,
    penghasilanBruto,
    normaPenghasilanNeto,
    tarif,
    pphDipotong,
    kap,
    kjs,
    metodePembayaranBendahara,
    nomorSP2D,
    tglPemotongan,
    userId,
    kanal,
    revNo: initialRevNo,
    glAccount,
    keterangan1,
    keterangan2,
    keterangan3,
    keterangan4,
    keterangan5,
  } = nrData;

  // Increment revNo kalau pengganti
  const revNo = isPengganti
    ? parseInt(initialRevNo?.toString() || '0', 10) + 1
    : parseInt(initialRevNo?.toString() || '0', 10);

  // Ambil NPWP dari localStorage kalau mau fallback
  const npwpLog = localStorage.getItem('npwp_log') ?? '';

  return {
    id: !isPengganti ? (id ?? null) : null,
    idBupot: idBupot ?? null,
    noBupot: noBupot ?? null,

    // Header-level Identitas
    npwpPemotong: npwpPemotong ?? npwpLog,
    idTku: idTku ?? '',
    masaPajak: masaPajak ? dayjs(masaPajak).format('MM') : '',
    tahunPajak: tahunPajak ? Number(dayjs(tahunPajak).format('YYYY')) : new Date().getFullYear(),

    // Data Wajib Pajak Dipotong
    tinDipotong: tinDipotong ?? '',
    namaDipotong: namaDipotong ?? '',
    alamatDipotong: alamatDipotong ?? '',
    negaraDipotong: negaraDipotong ?? '',
    tglLahirDipotong: tglLahirDipotong ? dayjs(tglLahirDipotong).format('DDMMYYYY') : '',
    tmptLahirDipotong: tmptLahirDipotong ?? '',
    nomorPaspor: nomorPaspor ?? '',
    nomorKitasKitap: nomorKitasKitap ?? '',
    keterangan1: keterangan1 ?? '',
    keterangan2: keterangan2 ?? '',
    keterangan3: keterangan3 ?? '',
    keterangan4: keterangan4 ?? '',
    keterangan5: keterangan5 ?? '',

    // Fasilitas
    sertifikatInsentifDipotong: sertifikatInsentifDipotong ?? '9',
    nomorSertifikatInsentif: nomorSertifikatInsentif ?? '',

    // Objek Pajak
    kodeObjekPajak: kodeObjekPajak ?? '',
    pasalPph: pasalPph ?? '',
    statusPph: statusPph ?? '',
    penghasilanBruto: Number(penghasilanBruto ?? 0),
    normaPenghasilanNeto: Number(normaPenghasilanNeto ?? 0),
    tarif: Number(tarif ?? 0),
    pphDipotong: Number(pphDipotong ?? 0),
    kap: Number(kap ?? 0),
    kjs: Number(kjs ?? 0),

    dokReferensi: (() => {
      const { namaDok, nomorDok, tglDok } = nrData;
      // pastikan tidak undefined dan tanggal valid
      if (!namaDok || !nomorDok || !tglDok) return [];

      const parsedDate = dayjs(tglDok);
      const tanggalFormatted = parsedDate.isValid() ? parsedDate.format('DDMMYYYY') : '';

      if (!tanggalFormatted) return [];

      return [
        {
          dokReferensi: namaDok,
          nomorDokumen: nomorDok,
          tanggal_Dokumen: tanggalFormatted,
        },
      ];
    })(),

    metodePembayaranBendahara: metodePembayaranBendahara ?? '',
    nomorSP2D: nomorSP2D ?? '',
    tglPemotongan: tglPemotongan ? dayjs(tglPemotongan).format('DDMMYYYY') : '',
    userId: userId ?? '',
    kanal: kanal ?? '',
    revNo,
    glAccount: glAccount ?? '',
  };
};

const useSaveNr = (props?: any) =>
  useMutation({
    mutationKey: ['Save-Nr'],
    mutationFn: (params: any) => nrApi.saveNr(transformParams(params)),
    ...props,
  });

export default useSaveNr;
