import { useMutation } from '@tanstack/react-query';
import fakturApi from '../utils/api';
import type { TKeteranganTambahanResult, TBaseResponseAPI } from '../types/types';

const useGetKeteranganTambahan = (props?: any) =>
  useMutation<TBaseResponseAPI<TKeteranganTambahanResult>, Error, Record<string, any> | undefined>({
    mutationFn: async (params) => {
      const res = await fakturApi.getKeteranganTambahan(params);
      return res;
    },
    ...props,
  });

export default useGetKeteranganTambahan;
