import * as React from 'react';
import { Grid, Typography, Divider, Box } from '@mui/material';

interface ListDetailItem {
  label: React.ReactNode;
  value: React.ReactNode;
}

interface ListDetailBuilderProps {
  rows?: ListDetailItem[];
  labelWidth?: number; // optional, default 4
  spacingY?: number; // optional, default 2
}

export default function ListDetailBuilder({
  rows = [],
  labelWidth = 4,
  spacingY = 2,
}: ListDetailBuilderProps) {
  if (rows.length === 0) return null;

  return (
    <Box
      sx={{
        width: '100%',
        bgcolor: 'background.paper',
        borderRadius: 2,
        overflow: 'hidden',
      }}
    >
      {rows.map((row, index) => (
        <React.Fragment key={index}>
          <Grid container alignItems="flex-start" spacing={2} sx={{ px: 2, py: spacingY }}>
            <Grid size={{ xs: 12, md: labelWidth }}>
              <Typography
                component="div"
                variant="body2"
                sx={{
                  fontWeight: 600,
                  color: 'text.secondary',
                  whiteSpace: 'pre-wrap',
                }}
              >
                {row.label}
              </Typography>
            </Grid>

            <Grid size={{ xs: 12, md: 12 - labelWidth }}>
              <Typography
                component="div"
                variant="body2"
                sx={{
                  color: 'text.primary',
                  whiteSpace: 'pre-wrap',
                  wordBreak: 'break-word',
                }}
              >
                {row.value ?? '-'}
              </Typography>
            </Grid>
          </Grid>

          {index < rows.length - 1 && <Divider sx={{ mx: 2 }} />}
        </React.Fragment>
      ))}
    </Box>
  );
}
