export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TableReturFakturPK = {
  id: number;

  masapajak: string;
  tahunpajak: string;
  masaretur: string;
  tahunretur: string;

  tanggalfaktur: string;
  tanggalretur: string;
  tanggalapproval: string | null;

  nomorfakturdiretur: string;
  nomorretur: string;

  npwppembeli: string;
  npwppenjual: string;

  namapembeli: string;
  namapenjual: string;

  statuspembeli: string;
  statusretur: string;

  nilaireturdpp: string;
  nilaireturppn: string;
  nilaireturppnbm: string;
  nilaireturdpplain: string;

  approvalsign: string | null;
  errormsg: string | null;

  created_by: string;
  updated_by: string;
  created_at: string;
  updated_at: string;

  internal_id: string;

  userid: string;

  // optional / nullable fields from response
  idperekam: number | null;
  agregat: string | null;
  agregatpenjual: string | null;
  agregatpembeli: string | null;
  nomorformdokumen: string | null;
  agregatnomorformdokumen: string | null;
};

export type TableReturFakturPKResult = TableReturFakturPK[];

export type TValidateFakturPMRequest = {
  id: number;
  nomorFaktur: string;
};

export interface TPostReturPMObjekFaktur {
  brgJasa: 'GOODS' | 'SERVICES';
  kdBrgJasa: string;
  namaBrgJasa: string;
  satuanBrgJasa: string;
  hargaSatuan: number;
  jmlBrgJasa: number;
  returJmlBrgJasa: number;
  totalHarga: number;
  diskon: number;
  returDiskon: number;
  cekDppLain: number;
  dpp: number;
  returDpp: number;
  dppLain: number;
  returDppLain: number;
  tarifPpn: number;
  ppn: number;
  returPpn: number;
  tarifPpnbm: number;
  ppnbm: number;
  returPpnbm: number;
}

export interface TPostReturPMRequest {
  masaPajakRetur: string; // contoh: "10"
  nilaiReturDpp: number;
  nilaiReturDppLain: number;
  nilaiReturDiskon: number;
  nilaiReturPpn: number;
  nilaireturppnbm: number;
  tahunPajakRetur: number; // contoh: 2025
  tanggalRetur: string; // format: DDMMYYYY (contoh: "25102025")
  objekFaktur: TPostReturPMObjekFaktur[];
  isCreditable: 0 | 1;
  nomorFakturDiretur: string;
  npwpPembeli: string;
  npwpPenjual: string;
}

export type TCancelReturPKRequest = {
  id: string;
};

// types/prepopulated.ts
export interface TRequestFakturMasukan {
  tahunPajak: string;
  masaPajak: string;
}

export interface TPrepopulatedPMRequest {
  fgPermintaan: number; // 1
  requestFakturMasukan: TRequestFakturMasukan;
}

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TCancelRequest = {
  id: string | number;
};

export type TCancelResponse = TBaseResponseAPI<{
  id: string | number;
}>;

export interface TPrepopulatedReturPKRequest {
  masaPajak: string;
  tahunPajak: string;
}
