import { useMutation } from '@tanstack/react-query';
import dayjs from 'dayjs';
// import type { TPostDokumenLainMasukanRequest } from '../types';
import fakturApi from '../utils/api';
import type { TPostDokumenLainMasukanRequest } from '../types/types';

/**
 * 🔒 Helper normalisasi tanggal
 * - Date / Dayjs  → format DDMMYYYY
 * - string 8 digit → pakai langsung
 */
const normalizeTanggal = (val: any): string => {
  if (!val) return dayjs().format('DDMMYYYY');

  if (typeof val === 'string' && /^\d{8}$/.test(val)) {
    return val;
  }

  return dayjs(val).format('DDMMYYYY');
};

/**
 * Transformasi data form → payload Dokumen Lain Masukan
 */
const transformParams = (formData: any): TPostDokumenLainMasukanRequest => {
  const {
    id,
    internal_id,
    isCreatedByBuyer,

    kdTransaksi,
    fgPengganti,
    nomorDokumenDiganti,
    detailTransaksi,
    keteranganTambahan,

    dokumenTransaksi,
    kodeDokumen,
    nomorDokumen,

    tanggalDokumen,
    masaPajak,
    tahunPajak,
    referensi,

    jumlahDpp,
    jumlahPpn,
    jumlahPpnbm,

    objekFaktur,

    namaPenjual,
    npwpPenjual,
  } = formData;

  return {
    id: id ?? null,
    internal_id: internal_id ?? '',

    isCreatedByBuyer: Boolean(isCreatedByBuyer),
    kdTransaksi: kdTransaksi ?? '',
    fgPengganti: fgPengganti ?? 'TD.00400',

    nomorDokumenDiganti: nomorDokumenDiganti ?? '',
    detailTransaksi: detailTransaksi ?? '',
    keteranganTambahan: keteranganTambahan ?? '',

    dokumenTransaksi: dokumenTransaksi ?? '',
    kodeDokumen: kodeDokumen ?? '',
    nomorDokumen: nomorDokumen ?? '',

    tanggalDokumen: normalizeTanggal(tanggalDokumen),
    masaPajak: String(masaPajak ?? dayjs().month() + 1).padStart(2, '0'),
    tahunPajak: String(tahunPajak ?? dayjs().year()),

    referensi: referensi ?? '',

    jumlahDpp: Number(jumlahDpp ?? 0),
    jumlahPpn: Number(jumlahPpn ?? 0),
    jumlahPpnbm: Number(jumlahPpnbm ?? 0),

    objekFaktur: objekFaktur ?? [],

    namaPenjual: namaPenjual ?? '',
    npwpPenjual: npwpPenjual ?? '0000000000000000',
  };
};

/**
 * Hook simpan Dokumen Lain Masukan
 */
const useSaveDokumenLainMasukan = (props?: any) =>
  useMutation({
    mutationKey: ['save-dokumen-lain-masukan'],
    mutationFn: async (params: any) => {
      const payload = transformParams(params);
      return fakturApi.saveDokumenLainMasukan(payload);
    },
    ...props,
  });

export default useSaveDokumenLainMasukan;
