import { createSlice } from '@reduxjs/toolkit';

const initialState = {
  role: [] as string[],
  data: {
    id: '',
    customer_name: '',
    email: '',
    npwp_trial: '',
    company_name: '',
    phone: '',
    quota: 0,
    start_date: null as string | null,
    end_date: null as string | null,
    updated_at: null as string | null,
    x_token: '',
    signer_npwp: '',
    signer: '',
    created_at: null as string | null,
    address: '',
    nitku_trial: '',
  },
  loginRedirectUrl: null as string | null,
};

const userSlice = createSlice({
  name: 'auth/user',
  initialState,
  reducers: {
    setUserData: (state, action) => ({
      ...state,
      ...action.payload,
      data: {
        ...state.data,
        ...action.payload.data,
      },
    }),
    userLoggedOut: () => initialState,
  },
});

export const { setUserData, userLoggedOut } = userSlice.actions;
export default userSlice.reducer;
