export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TableReturFakturPM = {
  id: number;
  masapajakretur: string;
  nilaireturdpp: string;
  nilaireturdiskon: string;
  nilaireturppn: string;
  nilaireturppnbm: string;
  tahunpajakretur: string;
  tanggalretur: string;
  nomorfakturdiretur: string;
  npwppembeli: string;
  npwppenjual: string;
  approvalsign: string | null;
  nomorretur: string | null;
  tanggalapproval: string | null;
  statusretur: string;
  kodeapproval: string | null;
  created_by: string;
  updated_by: string | null;
  created_at: string;
  updated_at: string | null;
  errormsg: string | null;
  internal_id: string;
  nilaireturdpplain: string;
  tanggalfakturretur: string | null;
  iscreditable: string;
  npwpnikpenandatangan: string | null;
  namapenandatangan: string | null;
  tempatpenandatangan: string | null;
  passphrasepenandatangan: string | null;
  fgkirimemail: string;
};

export type TableReturFakturPMResult = TableReturFakturPM[];

export type TValidateFakturPMRequest = {
  id: number;
  nomorFaktur: string;
};

export interface TPostReturPMObjekFaktur {
  brgJasa: 'GOODS' | 'SERVICES';
  kdBrgJasa: string;
  namaBrgJasa: string;
  satuanBrgJasa: string;
  hargaSatuan: number;
  jmlBrgJasa: number;
  returJmlBrgJasa: number;
  totalHarga: number;
  diskon: number;
  returDiskon: number;
  cekDppLain: number;
  dpp: number;
  returDpp: number;
  dppLain: number;
  returDppLain: number;
  tarifPpn: number;
  ppn: number;
  returPpn: number;
  tarifPpnbm: number;
  ppnbm: number;
  returPpnbm: number;
}

export interface TPostReturPMRequest {
  masaPajakRetur: string; // contoh: "10"
  nilaiReturDpp: number;
  nilaiReturDppLain: number;
  nilaiReturDiskon: number;
  nilaiReturPpn: number;
  nilaireturppnbm: number;
  tahunPajakRetur: number; // contoh: 2025
  tanggalRetur: string; // format: DDMMYYYY (contoh: "25102025")
  objekFaktur: TPostReturPMObjekFaktur[];
  isCreditable: 0 | 1;
  nomorFakturDiretur: string;
  npwpPembeli: string;
  npwpPenjual: string;
}

export type TCancelReturPMRequest = {
  id: string;
  nomorFaktur: string;
  nomorRetur: string;
  npwpPenjual: string;

  // optional (commented di payload)
  npwpPembeli?: string;
  userId?: string;
  kanal?: string;
};

// types/prepopulated.ts
export interface TRequestFakturMasukan {
  tahunPajak: string;
  masaPajak: string;
}

export interface TPrepopulatedPMRequest {
  fgPermintaan: number; // 1
  requestFakturMasukan: TRequestFakturMasukan;
}

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TPostUpload = {
  id: string;
};

export type TDeleteRequest = {
  id: string;
};

export type TCancelRequest = {
  id: string | number;
  nomorFaktur: string;
  nomorRetur: string;
  npwpPenjual: string;
};

export type TCancelResponse = TBaseResponseAPI<{
  id: string | number;
  nomorFaktur: string;
  nomorRetur: string;
  npwpPenjual: string;
}>;

export type TUploadReturPMRequest = {
  id: string;
};

export type TUploadReturPMResponse = {
  id: string;
};

export type TReturPmObjekFaktur = {
  brgJasa: 'GOODS' | 'SERVICES';
  kdBrgJasa: string;
  namaBrgJasa: string;
  satuanBrgJasa: string;

  hargaSatuan: number;
  jmlBrgJasa: number;
  returJmlBrgJasa: number;

  totalHarga: number;
  diskon: number;
  returDiskon: number;

  cekDppLain: number;

  dpp: number;
  returDpp: number;

  dppLain: number;
  returDppLain: number;

  tarifPpn: number;
  ppn: number;
  returPpn: number;

  tarifPpnbm: number;
  ppnbm: number;
  returPpnbm: number;
};

export type TReturPmForm = {
  // header
  masaPajakRetur: Date | null;
  tahunPajakRetur: Date | null;
  tanggalRetur: Date | null; // DDMMYYYY (untuk input & payload)
  nomorFakturDiretur: string;
  npwpPembeli: string;
  npwpPenjual: string;
  isCreditable: 0 | 1;

  // total
  nilaiReturDpp: number;
  nilaiReturDppLain: number;
  nilaiReturDiskon: number;
  nilaiReturPpn: number;
  nilaireturppnbm: number;

  // detail
  objekFaktur: TReturPmObjekFaktur[];
};

export type TGoods = {
  code: string;
  english: string;
  bahasa: string;
};

export type TGoodsResult = TGoods[];

export type TServices = {
  code: string;
  english: string;
  bahasa: string;
};

export type TServiceResult = TServices[];

export type TSatuan = {
  code: string;
  description: string;
};

export type TSatuanResult = TSatuan[];
