import { useQuery } from '@tanstack/react-query';
import type { TSatuanResult } from '../types/types';
import fakturApi from '../utils/api';

export const useGetSatuan = (params?: Record<string, any>) =>
  useQuery<TSatuanResult>({
    queryKey: ['satuan-faktur-pk'],
    queryFn: async () => {
      const res = await fakturApi.getSatuan(params);
      return res.data; // ✅ langsung array negara
    },
  });

export default useGetSatuan;
