export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TGetListDataDokumenLainKeluaran = {
  id: number;
  iscreatedbybuyer: boolean;
  kdtransaksi: string;
  fgpengganti: string;
  nomordokumendiganti: string;
  detailtransaksi: string;
  keterangantambahan: string | null;
  dokumentransaksi: string;
  kodedokumen: string;
  nomordokumen: string;
  tanggaldokumen: string;
  masapajak: string;
  tahunpajak: string;
  referensi: string;
  jumlahdpp: string;
  jumlahppn: string;
  jumlahppnbm: string;
  namapembeli: string;
  alamatpembeli: string;
  npwppembeli: string;
  npwppenjual: string;
  tempatpenandatangan: string | null;
  npwpnikpenandatangan: string;
  userid: string;
  kanal: string | null;
  approvalsign: string | null;
  tanggalapproval: string;
  statusdokumen: string;
  kodeapproval: string | null;
  created_by: string;
  updated_by: string | null;
  created_at: string;
  updated_at: string;
  internal_id: string;
  errormsg: string | null;
  namapenandatangan: string;
  fgbatal: string;
  tanggaldokumendiganti: string | null;
  jumlahdpplain: string;
};

export type TGetListDataDokumenLainKeluaranResult = TGetListDataDokumenLainKeluaran[];

export type TCountry = {
  kode: string;
  nama: string;
};

export type TCountryResult = TCountry[];

export type TGoods = {
  code: string;
  english: string;
  bahasa: string;
};

export type TGoodsResult = TGoods[];

export type TServices = {
  code: string;
  english: string;
  bahasa: string;
};

export type TServiceResult = TServices[];

export type TSatuan = {
  code: string;
  description: string;
};

export type TSatuanResult = TSatuan[];

export type TIdTambahan = {
  kode_awal: string;
  kode: string;
  deskripsi: string;
};

export type TIdTambahanResult = TIdTambahan[];

export type TKeteranganTambahan = {
  kode_awal: string;
  kode: string;
  deskripsi: string;
};

export type TKeteranganTambahanResult = TKeteranganTambahan[];

export type TPostDokumenLainKeluaranRequest = {
  id: string;
  isCreatedByBuyer: boolean;
  kdTransaksi: string;
  fgPengganti: string;
  detailTransaksi: string;
  keteranganTambahan: string | null;

  dokumenTransaksi: string;
  kodeDokumen: string;
  nomorDokumen: string;
  nomorDokumenDiganti: string;

  tanggalDokumen: string; // format: DDMMYYYY
  tanggalDokumenDiganti: string | null;

  masaPajak: string;
  tahunPajak: string;
  referensi: string;

  jumlahDpp: number;
  jumlahPpn: number;
  jumlahPpnbm: number;

  objekFaktur: TObjekDokumenLainKeluaranItem[];

  namaPembeli: string;
  alamatPembeli: string;
  npwpPembeli: string;
  keterangan1: string;
  keterangan2: string;
  keterangan3: string;
  keterangan4: string;
  keterangan5: string;
};

export type TObjekDokumenLainKeluaranItem = {
  brgJasa: 'GOODS' | 'SERVICES';
  kdBrgJasa: string;
  namaBrgJasa: string;
  satuanBrgJasa: string;

  hargaSatuan: string; // API kirim string
  jmlBrgJasa: string;
  totalHarga: string;
  diskon: string;
  cekDppLain: boolean;

  dpp: string;
  tarifPpn: string;
  ppn: number;

  tarifPpnbm: string;
  ppnbm: string;
};

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TPostUpload = {
  id: string;
};

export type TDeleteRequest = {
  id: string;
};

export type TCancelRequest = {
  id: string | number;
  revokeFlag?: boolean; // format: DDMMYYYY
  tglPembatalan?: string;
  isCreatedByBuyer?: boolean;
};

export type TCancelResponse = TBaseResponseAPI<{
  id: string | number;
  statusBatal?: string;
  message?: string;
}>;
