import React, { useEffect, useState } from 'react';
import DialogUmum from 'src/shared/components/dialog/DialogUmum';
import DialogContent from '@mui/material/DialogContent';
import ListDetailBuilder from '../ListDetailItem';
import StatusChip from '../StatusChip';
import dayjs from 'dayjs';
import utc from 'dayjs/plugin/utc';
import timezone from 'dayjs/plugin/timezone';

dayjs.extend(utc);
dayjs.extend(timezone);

interface ModalCetakReturPMProps {
  payload?: Record<string, any>;
  isOpen: boolean;
  onClose: () => void;
}

type Row = { label: string; value: React.ReactNode };

const ModalCetakReturPK: React.FC<ModalCetakReturPMProps> = ({ payload, isOpen, onClose }) => {
  const [rows, setRows] = useState<Row[]>([]);

  useEffect(() => {
    if (!payload) return;

    const formattedRows: Row[] = [
      { label: 'NPWP Pembeli', value: payload.npwppembeli },
      { label: 'Nama Pembeli', value: payload.namapembeli || '-' },
      { label: 'Nomor Retur', value: payload.nomorretur || '-' },
      {
        label: 'Nomor Faktur Pajak Direktur',
        value: payload.nomorfakturdiretur,
      },
      {
        label: 'Tanggal Retur',
        value: payload.tanggalretur ? dayjs.utc(payload.tanggalretur).format('DD/MM/YYYY') : '-',
      },
      {
        label: 'Masa Retur',
        value: payload.masaretur,
      },
      {
        label: 'Tahun Retur',
        value: payload.tahunretur,
        //
      },
      {
        label: 'Status',
        value: <StatusChip value={payload.statusretur} />,
      },
      {
        label: 'DPP',
        value: `${Number(payload.nilaireturdpp || 0)}`,
      },
      {
        label: 'DPP Lain',
        value: `${Number(payload.nilaireturdpplain || 0)}`,
      },
      {
        label: 'PPN',
        value: `${Number(payload.nilaireturppn || 0)}`,
      },
      {
        label: 'PPnBM',
        value: `${Number(payload.nilaireturppnbm || 0)}`,
      },

      {
        label: 'Tanggal Approval',
        value: dayjs.utc(payload.tanggalapproval).format('DD/MM/YYYY') || '-',
      },
      {
        label: 'Keterangan Tambahan',
        value: payload.userId || '-',
      },
      {
        label: 'Penandatangan',
        value: payload.namapenandatangan || '-',
      },
      {
        label: 'Referensi',
        value: payload.userId || '-',
      },
      {
        label: 'User Perekam',
        value: payload.created_by || '-',
      },
      {
        label: 'Tanggal Rekam',
        value: dayjs.utc(payload.created_at).format('DD/MM/YYYY') || '-',
      },
      {
        label: 'User Pengubah',
        value: payload.updated_by || '-',
      },
      {
        label: 'Tanggal Ubah',
        value: dayjs.utc(payload.updated_at).format('DD/MM/YYYY') || '-',
      },
    ];

    setRows(formattedRows);
  }, [payload]);

  return (
    <DialogUmum
      maxWidth="lg"
      isOpen={isOpen}
      onClose={onClose}
      title="Detail Retur Faktur Pajak Keluaran"
    >
      <DialogContent classes={{ root: 'p-16 sm:p-24' }}>
        <ListDetailBuilder rows={rows} />
      </DialogContent>
    </DialogUmum>
  );
};

export default ModalCetakReturPK;
