// utils/searchParams.ts
import dayjs from 'dayjs';

type FormValues = {
  filter: 'perioderetur' | 'periodemasa' | 'nomorFaktur' | 'nomorRetur' | 'npwp' | 'customDate';
  periodeRetur?: string | null; // Dayjs ISO or Date-like
  periode?: string | null;
  nomorFaktur?: string;
  nomorRetur?: string;
  npwp?: string;
};

export function buildSearchParams(values: FormValues) {
  const out: Record<string, any> = {};

  // common pagination defaults (consumer will add page & limit)
  // out.page = 1;
  // out.limit = 10;

  if (values.filter === 'perioderetur') {
    // expects: perioderetur=<ISO date quoted> & periodeRetur=MM/YYYY
    // assume values.periodeRetur contains a Dayjs/ISO string or Date
    if (values.periodeRetur) {
      const iso = dayjs(values.periodeRetur).toISOString();
      out.perioderetur = `"${iso}"`; // note: example had quotes encoded -> keep quotes for parity
      out.periodeRetur = dayjs(values.periodeRetur).format('MM/YYYY');
    }
  } else if (values.filter === 'periodemasa') {
    if (values.periode) {
      const iso = dayjs(values.periode).toISOString();
      out.periodemasa = `"${iso}"`;
      out.periode = dayjs(values.periode).format('MM/YYYY');
    }
  } else if (values.filter === 'nomorFaktur') {
    if (values.nomorFaktur && values.nomorFaktur.trim() !== '') {
      out.nomorFaktur = values.nomorFaktur.trim();
    }
  } else if (values.filter === 'nomorRetur') {
    if (values.nomorRetur && values.nomorRetur.trim() !== '') {
      out.nomorRetur = values.nomorRetur.trim();
    }
  } else if (values.filter === 'npwp') {
    if (values.npwp && values.npwp.trim() !== '') {
      out.npwp = values.npwp.trim();
    }
  }

  return out;
}
