import { useMutation } from '@tanstack/react-query';
import type { TCancelNrRequest, TCancelNrResponse } from '../types/types';
import nrApi from '../utils/api';

const useCancelNr = (props?: any) =>
  useMutation<TCancelNrResponse, Error, TCancelNrRequest>({
    mutationKey: ['cancel-nr'],
    mutationFn: (payload) => nrApi.cancel(payload),
    ...props,
  });

export default useCancelNr;
