import { useMutation } from '@tanstack/react-query';
import vswpApi from '../utils/api';
import type { TVswpData } from '../types/types';

type TVswpType = 'npwp' | 'nik';
type TVswpPayload = { type: TVswpType; value: string };

export const useGetVswp = () =>
  useMutation<TVswpData | null, Error, TVswpPayload>({
    mutationKey: ['vswp'],
    mutationFn: async ({ type, value }: TVswpPayload) => {
      if (type === 'npwp') return vswpApi.getVswpByNpwp(value);
      if (type === 'nik') return vswpApi.getVswpByNik(value);
      throw new Error('Invalid type');
    },
  });
