import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import type { TBaseResponseAPI, TUploadFakturPMRequest } from '../types/types';
import fakturApi from '../utils/api';

// Hook menerima UseMutationOptions sehingga pemanggil bisa inject onSuccess/onError dsb.
const useUploadPMPrepop = (
  options?: UseMutationOptions<TBaseResponseAPI<null>, Error, TUploadFakturPMRequest>
) =>
  useMutation<TBaseResponseAPI<null>, Error, TUploadFakturPMRequest>({
    mutationKey: ['upload-prepop-faktur-pm'],
    mutationFn: (payload) => fakturApi.uploadPMPrepop(payload),
    ...options,
  });

export default useUploadPMPrepop;
