import { Checkbox, FormControlLabel, Link as MuiLink } from '@mui/material';
import { Link } from 'react-router';
import React from 'react';

interface AgreementProps {
  isCheckedAgreement: boolean;
  setIsCheckedAgreement: React.Dispatch<React.SetStateAction<boolean>>;
  text?: string;
  showOnlyText?: boolean;
}

export default function Agreement({
  isCheckedAgreement,
  setIsCheckedAgreement,
  text,
  showOnlyText = false,
}: AgreementProps) {
  const handleToggleCheckbox = () => {
    setIsCheckedAgreement((prev) => !prev);
  };

  return (
    <FormControlLabel
      sx={{ marginTop: 3, alignItems: 'flex-start' }}
      control={
        <Checkbox
          checked={isCheckedAgreement}
          onChange={handleToggleCheckbox}
          sx={{
            mt: '-7px',
            color: "var(--palette-primary-main)",
            '&.Mui-checked': {
              color: "var(--palette-primary-main)",
            },
          }}
        />
      }
      label={
        <div>
          <span>
            {text ||
              'Dengan ini saya menyatakan bahwa SPT telah saya isi dengan benar dan telah saya tanda tangani secara elektronik sesuai dengan'}{' '}
          </span>
          {!showOnlyText && (
            <>
              <MuiLink
                component={Link}
                to="/terms-of-use"
                underline="always"
                // color="primary"
                sx={{ color: '#143B88' }}
                target="_blank"
              >
                Syarat dan Ketentuan
              </MuiLink>
              <span> serta </span>
              <MuiLink
                component={Link}
                to="/privacy-policy"
                underline="always"
                // color="primary"
                sx={{ color: '#143B88' }}
                target="_blank"
              >
                Kebijakan Privasi
              </MuiLink>
              <span> dari PajakExpress.</span>
            </>
          )}
        </div>
      }
    />
  );
}
