export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TGetListDataTableFakturPK = {
  id: number;
  fguangmuka: boolean;
  fgpelunasan: boolean;
  nomorfaktur: string;
  detailtransaksi: string;
  idketerangantambahan: string;
  keterangantambahan: string;
  masapajak: string;
  tahunpajak: string;
  refdoc: string;
  referensi: string;
  npwppenjual: string;
  namatokopenjual: string;
  npwppembeli: string;
  idlainpembeli: string;
  kdnegarapembeli: string;
  nikpasppembeli: string;
  namapembeli: string;
  tkupembeli: string;
  alamatpembeli: string;
  emailpembeli: string;
  totaldpp: string;
  totaldpplain: string;
  jumlahuangmuka: string;
  totalppn: string;
  totalppnbm: string;
  tempatpenandatangan: string | null;
  tanggalfaktur: string;
  npwpnikpenandatangan: string | null;
  passphrasepenandatangan: string | null;
  userid: string;
  kanal: string | null;
  approvalsign: string;
  idfaktur: string;
  tanggalapproval: string | null;
  statusfaktur: string;
  kodeapproval: string | null;
  created_by: string;
  updated_by: string | null;
  created_at: string;
  updated_at: string | null;
  testing1: string | null;
  internal_id: string;
  testing2: string | null;
  nomorfakturdiganti: string;
  revokepengganti: string | null;
  fgpengganti: string;
  capkettambahan: string;
  fgbatal: string;
  errormsg: string | null;
  namapenandatangan: string | null;
  tanggalfakturdiganti: string | null;
  keterangan1: string;
  keterangan2: string;
  keterangan3: string;
  keterangan4: string;
  keterangan5: string;
  fgproses: string | null;
  fgkirimemail: string;
  fgupload: string;
  masakreditpajak: string | null;
  statuspembeli: string;
  buyerstatus: string | null;
  detailkredittransaksi: string | null;
  tahunkreditpajak: string | null;
  sisapelunasan: string;
  nomorfakturpelunasan: string | null;
};

export type TGetListDataTableFakturPKResult = TGetListDataTableFakturPK[];

export type TCountry = {
  kode: string;
  nama: string;
};

export type TCountryResult = TCountry[];

export type TGoods = {
  code: string;
  english: string;
  bahasa: string;
};

export type TGoodsResult = TGoods[];

export type TServices = {
  code: string;
  english: string;
  bahasa: string;
};

export type TServiceResult = TServices[];

export type TSatuan = {
  code: string;
  description: string;
};

export type TSatuanResult = TSatuan[];

export type TIdTambahan = {
  kode_awal: string;
  kode: string;
  deskripsi: string;
};

export type TIdTambahanResult = TIdTambahan[];

export type TKeteranganTambahan = {
  kode_awal: string;
  kode: string;
  deskripsi: string;
};

export type TKeteranganTambahanResult = TKeteranganTambahan[];

export type TPostFakturPKRequest = {
  id: string;
  fgUangMuka: boolean;
  fgPelunasan: boolean;
  nomorFaktur: string;
  nomorFakturDiganti: string;
  detailTransaksi: string;
  idKeteranganTambahan: string;
  keteranganTambahan: string;
  masaPajak: string;
  tahunPajak: string;
  refDoc: string;
  referensi: string;
  npwpPembeli: string;
  idLainPembeli: string;
  kdNegaraPembeli: string;
  nikPaspPembeli: string;
  namaPembeli: string;
  tkuPembeli: string;
  alamatPembeli: string;
  emailPembeli: string;
  keterangan1: string;
  keterangan2: string;
  keterangan3: string;
  keterangan4: string;
  keterangan5: string;
  objekFaktur: TObjekFakturItem[];
  jumlahUangMuka: number;
  totalDpp: number;
  totalDppLain: number;
  totalPpn: number;
  totalPpnbm: number;
  tanggalFaktur: string;
  fgPengganti: string;
  capKetTambahan: string;
  totalDiskon: string;
  uangMukaDpp: number;
  uangMukaDppLain: number;
  uangMukaPpn: number;
  uangMukaPpnbm: number;
};

export type TObjekFakturItem = {
  id?: number;
  fakturPkHeaderId?: number;
  brgJasa: string; // "GOODS" atau "SERVICES"
  kdBrgJasa: string;
  namaBrgJasa: string;
  satuanBrgJasa: string;
  hargaSatuan: number;
  jmlBrgJasa: number;
  totalHarga: number;
  diskon: number;
  cekDppLain: boolean;
  dpp: number;
  dppLain: number;
  fgPmk?: string;
  tarifPpn: number;
  ppn: number;
  tarifPpnbm: number;
  ppnbm: number;
};

export type TDetailUangMuka = {
  id: number;
  fguangmuka: boolean;
  fgpelunasan: boolean;
  nomorfaktur: string;
  detailtransaksi: string;
  idketerangantambahan: string;
  keterangantambahan: string;
  masapajak: string;
  tahunpajak: string;
  refdoc: string;
  referensi: string;
  npwppenjual: string;
  namatokopenjual: string;
  npwppembeli: string;
  idlainpembeli: string;
  kdnegarapembeli: string;
  nikpasppembeli: string;
  namapembeli: string;
  tkupembeli: string;
  alamatpembeli: string;
  emailpembeli: string;
  totaldpp: string;
  totaldpplain: string;
  jumlahuangmuka: string;
  totalppn: string;
  totalppnbm: string;
  tempatpenandatangan: string | null;
  tanggalfaktur: string;
  npwpnikpenandatangan: string | null;
  passphrasepenandatangan: string | null;
  userid: string;
  kanal: string | null;
  approvalsign: string;
  idfaktur: string;
  tanggalapproval: string | null;
  statusfaktur: string;
  kodeapproval: string | null;
  created_by: string;
  updated_by: string | null;
  created_at: string;
  updated_at: string | null;
  testing1: string | null;
  internal_id: string;
  testing2: string | null;
  nomorfakturdiganti: string;
  revokepengganti: string | null;
  fgpengganti: string;
  capkettambahan: string;
  fgbatal: string;
  errormsg: string | null;
  namapenandatangan: string | null;
  tanggalfakturdiganti: string | null;
  keterangan1: string | null;
  keterangan2: string | null;
  keterangan3: string | null;
  keterangan4: string | null;
  keterangan5: string | null;
  fgproses: string | null;
  fgkirimemail: string;
  fgupload: string;
  masakreditpajak: string | null;
  statuspembeli: string;
  buyerstatus: string | null;
  detailkredittransaksi: string | null;
  tahunkreditpajak: string | null;
  sisapelunasan: string;
  nomorfakturpelunasan: string | null;
  sisappn: string;
  sisappnbm: string;
  sisadpplain: string;
  uangmukadpp: string;
  uangmukadpplain: string;
  uangmukappnbm: string;
  sisadpp: string;
  uangmukappn: string;
  objekFaktur: TObjekFakturItem[];
};

export type TDetailUangMukaResult = TDetailUangMuka[];

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TPostUpload = {
  id: string;
};

export type TDeleteRequest = {
  id: string;
};

export type TCancelRequest = {
  id: string | number;
  revokeFlag?: boolean; // format: DDMMYYYY
  tglPembatalan?: string;
};

export type TCancelResponse = TBaseResponseAPI<{
  id: string | number;
  statusBatal?: string;
  message?: string;
}>;
