import React from 'react';
import { CloseRounded } from '@mui/icons-material';
import { IconButton, IconButtonProps } from '@mui/material';

// ✅ definisikan tipe props dengan explicit
interface CloseButtonDialogProps extends Omit<IconButtonProps, 'onClick'> {
  onClick?: React.MouseEventHandler<HTMLButtonElement>;
  disabled?: boolean;
}

const CloseButtonDialog: React.FC<CloseButtonDialogProps> = ({
  onClick,
  disabled = false,
  ...iconButtonProps
}) => (
  <IconButton
    size="small"
    disabled={disabled}
    sx={{
      backgroundColor: '#143b88',
      color: '#fff',
      '&:hover': {
        backgroundColor: '#143b88',
        color: '#fff',
      },
    }}
    aria-label="Close Dialog"
    color="primary"
    onClick={onClick}
    {...iconButtonProps}
  >
    <CloseRounded />
  </IconButton>
);

export default CloseButtonDialog;
