import React from 'react';
import { FormatListBulletedRounded } from '@mui/icons-material';
import Card from '@mui/material/Card';
import Tab from '@mui/material/Tab';

type TableHeaderLabelProps = {
  label: string;
};

const TableHeaderLabel = ({ label }: TableHeaderLabelProps) => (
  <Card
    sx={{
      width: 'fit-content',
      mt: 5,
      background: '#143b88',
      px: 1,
      borderRadius: '16px 32px 0px 0px',
    }}
  >
    <Tab
      label={label}
      icon={<FormatListBulletedRounded sx={{ color: '#F38C28' }} />}
      iconPosition="start"
      sx={{
        p: '12px 16px',
        whiteSpace: 'nowrap',
        fontWeight: 'bold',
        '&.Mui-disabled': {
          opacity: 1,
          color: '#fff',
        },
      }}
      disabled
    />
  </Card>
);

export default TableHeaderLabel;
