// hooks/useUpload.ts
import { useMutation } from '@tanstack/react-query';

import fakturApi from '../utils/api';

const useUpload = (props?: any) =>
  useMutation({
    mutationKey: ['upload-faktur'],
    mutationFn: (payload: { id: string | number }) => fakturApi.upload(payload),
    ...props,
  });

export default useUpload;
