export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

export type TBaseResponseCreateAPI<T> = {
  code: number;
  data?: T;
  message: string;
  status: string;
  time: Date;
};

export interface BupotRecord {
  // --- Kunci numerik dinamis ("1" sampai "53") ---
  // [key: `${number}`]: number | undefined;

  id: number;
  idBupot: string | null;
  noBupot: string | null;
  thnPajak: string;
  msPajak: string;
  namaPemotong: string | null;
  fgIdDipotong: string; // "true" / "false" (string)
  idDipotong: string;
  namaDipotong: string;
  tglPemotongan: string;
  kdJnsPjk: string;
  namaTtd: string | null;
  nikNpwpTtd: string | null;
  created_at: string;
  updated_at: string;
  errorMsg: string | null;
  created: string;
  updated: string;
  email: string | null;
  npwp16Pemotong: string;
  nitkuPemotong: string;
  npwp16Dipotong: string;
  fgKirimEmail: number;
  statusEmail: string | null;
  messageid: string | null;
  passphrasePenandatangan: string | null;
  dcPenandatangan: string | null;
  serialNumberPenandatangan: string | null;
  userId: string;
  foreignEmployee: string; // "true" / "false" (string)
  passportNo: string;
  countryCode: string | null;
  statusPtkp: string;
  jmlPtkp: number;
  posisiJabatan: string;
  kdObjPjk: string;
  nmObjPjk: string | null;
  pasalPPh: string | null;
  bruto: string;
  tarif: string;
  pphDipotong: string;
  fgStatus: string;
  fgFasilitas: string;
  noDokLainnya: string;
  kap: string;
  kjs: string;
  internal_id: string;
  fgLapor: number;
  revNo: number;
  tglPembatalan: string | null;
  fgGrossUp: number;
  link: string | null;
  glAccount: string;
  fgkirimemail: string;
  tunjanganPPh: string;
  pph21ditanggungperusahaan: string;
  pph21ditanggungkaryawan: string;
  alamat: string;
  keterangan1: string | null;
  keterangan2: string | null;
  keterangan3: string | null;
  keterangan4: string | null;
  keterangan5: string | null;
}

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TGetListDataTableBupotFinal = {
  alamat: string;
  bruto: string;
  countryCode: string | null;
  created?: string;
  created_at: string;
  dokReferensi: string;
  email: string | null;
  errorMsg: string | null;
  fgFasilitas: string;
  fgGrossUp: number;
  fgIdDipotong: string;
  fgKirimEmail: string;
  fgLapor?: string;
  fgPdf: string;
  fgSignStatus: string | null;
  fgStatus: string;
  fgkirimemail: string;
  foreignEmployee: string;
  glAccount: string | null;
  glName: string | null;
  id: number;
  idBupot: string | null;
  idDipotong: string;
  internal_id: string;
  jmlBruto?: string;
  jmlPtkp: number;
  kap: string;
  kdJnsPjk: string;
  kdObjPjk: string;
  keterangan1: string | null;
  keterangan2: string | null;
  keterangan3: string | null;
  keterangan4: string | null;
  keterangan5: string | null;
  kjs: string;
  link: string | null;
  masaPajak: string;
  metodePembayaranBendahara: string;
  msPajak: string;
  namaDipotong?: string;
  namaNegara: string | null;
  namaPenandatangan: string | null;
  nitkuPemotong: string;
  noBupot: string | null;
  noDokLainnya: string;
  nomorDokumen: string;
  nomorSP2D: string;
  npwp16Dipotong: string;
  npwp16Pemotong: string;
  npwpNikPenandatangan: string | null;
  npwpPemotong?: string;
  passportNo: string;
  pasalPPh: string;
  posisiJabatan: string;
  pph21ditanggungkaryawan: string;
  pph21ditanggungperusahaan: string;
  pphDipotong: string;
  revNo: number;
  statusPtkp: string;
  tarif: string;
  tglpemotongan: string;
  thnPajak: string;
  tunjanganPPh: string;
  updated?: string;
  updated_at: string;
  userId: string;
};

export type TGetListDataTableBupotFinalResult = {
  id: number;
  idBupot: null | string;
  noBupot: null | string;
  revNo:string;
  fgTransaction:string;
  npwpPemotong:string;
  namaPemotong: null | string;
  idTku:string;
  masaPajak:string;
  tahunPajak:string;
  fgNpwpNik:string;
  npwp:string;
  nik:string;
  nama:string;
  foreignEmployee:string;
  passportNo:string;
  countryCode: null | string;
  statusPPh:string;
  posisiJabatan:string;
  kodeObjekPajak:string;
  pasalPPh:string;
  penghasilanKotorSebelumnya:string;
  penghasilanKotor:string;
  tarif:string;
  pphDipotong:string;
  NormaPenghasilan:string;
  kap:string;
  kjs:string;
  sertifikatInsentifDipotong:string;
  nomorSertifikatInsentif:string;
  tglpemotongan: null | string;
  tglpembatalan: null | string;
  userId:string;
  created_at:string;
  updated_at:string;
  created:string;
  updated:string;
  namaPenandatangan: null | string;
  npwpNikPenandatangan: null | string;
  fgStatus:string;
  alamat:string;
  dokumen_referensi: [
    {
      dokReferensi: null | string;
      nomorDokumen:string;
      tanggal_Dokumen:string;
      tanggalSP2D: null | string;
    },
  ];
  link: null | string;
  email: null | string;
  glAccount: null | string;
  fgkirimemail:string;
  fgGrossUp: number;
  tunjanganPPh: null | string;
  glName: null | string;
  errorMsg: null | string;
  keterangan1: null | string;
  keterangan2: null | string;
  keterangan3: null | string;
  keterangan4: null | string;
  keterangan5: null | string;
  internal_id:string;
  namaNegara: null | string;
}[];

export type TGetListDataKOPBupotFinal = {
  dtp: number;
  kap: string;
  kjs: string;
  kode: string;
  nama: string;
  noCertificate: number;
  normanetto: string;
  otherCert: number;
  pasal: string;
  skbBungaTabungan: number;
  skbPHTB: number;
  skbPasal22: number;
  skbPasal23: number;
  statuspph: string;
  suket: number;
  tarif: string;
};

export type TGetListDataKOPBupotFinalResult = TGetListDataKOPBupotFinal[];

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TPostBulananRequest = {
  id?: number | null;
  npwpPemotong: string;
  idTku: string;
  masaPajak: string;
  tahunPajak: string;
  fgNpwpNik: boolean;
  npwp: string;
  nik: string;
  nama: string;
  fgJnsBupot: string;
  alamat: string;
  dataDetilA0: {
    foreignEmployee: boolean;
    passportNo: string;
    countryCode: string | null;
    statusPtkp: string;
    jmlPtkp: string;
    posisiJabatan: string;
    kodeObjekPajak: string;
    pasalPPh: string;
    penghasilanKotor: number;
    tarif: number;
    pphDipotong: number;
    kap: string;
    kjs: string;
    sertifikatInsentifDipotong: string;
    nomorSertifikatInsentif: string;
  };
  tglPemotongan: string;
  noBupot?: string;
  idBupot?: string;
  revNo: number;
  fgGrossUp: number;
};

export type TPostBupotFinalRequest = {
  id?: number | null;
  noBupot?: string;
  idBupot?: string;
  revNo?: number;
  npwpPemotong: string;
  idTku: string;
  masaPajak: string;
  tahunPajak: string;
  fgTransaction: 'NEW' | 'EDIT' | 'CANCELED'; // create & edit = NEW, pengganti = EDIT, cancel = CANCELED
  fgNpwpNik: boolean;
  npwp: string;
  nik: string;
  nama: string;
  fgJnsBupot: string;
  alamat: string;
  dataDetilBp21: {
    sertifikatInsentifDipotong: string;
    nomorSertifikatInsentif: string;
    kodeObjekPajak: string;
    pasalPPh: string;
    statusPPh: string;
    kap: string;
    kjs: string;
    penghasilanKotorSebelumnya: string;
    penghasilanKotor: number;
    tarif: number;
    pphDipotong: number;
    tunjanganPPh: string;
    NormaPenghasilan: number;
    dokReferensi: {
      dokReferensi: string;
      nomorDokumen: string;
      tanggal_Dokumen: string;
    }[];
  };
  tglPemotongan: string;
  feature: 'final';
  kanal: '14';
  fgGrossUp: number;
};

export type TPortBulananRequest = {
  id: string;
};

export type TPortBulananCenceledRequest = {
  tglPembatalan: string;
} & TPortBulananRequest;
