import type {
  TBaseResponseAPI,
  TCancelSspRequest,
  TCancelSspResponse,
  TDeleteSspRequest,
  TGetListDataKOPSspResult,
  TGetListDataTableSspResult,
  TPostSspRequest,
} from '../types/types';

import unifikasiClient from './unifikasiClient';

const sspApi = () => {};

// API untuk get list table
sspApi.getSsp = async (config: any) => {
  const {
    data: { message, metaPage, data },
    status: statusCode,
  } = await unifikasiClient.get<TBaseResponseAPI<TGetListDataTableSspResult>>('IF_TXR_070/', {
    ...config,
  });

  if (statusCode !== 200) {
    throw new Error(message);
  }

  return { total: metaPage ? Number(metaPage.totalRow) : 0, data };
};

sspApi.getKodeObjekPajakNr = async (params?: Record<string, any>) => {
  const response = await unifikasiClient.get<TBaseResponseAPI<TGetListDataKOPSspResult>>(
    '/sandbox/mst_kop_bpsp',
    { params }
  );

  const body = response.data;

  if (response.status !== 200 || body.status !== 'success') {
    throw new Error(body.message);
  }

  return body;
};

sspApi.saveSsp = async (config: TPostSspRequest) => {
  const {
    data: { message, data, code },
  } = await unifikasiClient.post<TBaseResponseAPI<TPostSspRequest>>('/IF_TXR_070/', {
    ...config,
  });
  if (code === 0) {
    throw new Error(message);
  }

  return data;
};

sspApi.getSspById = async (id: string) => {
  const res = await unifikasiClient.get('/IF_TXR_070/', { params: { id } });

  const {
    data: { status, message, data },
    status: statusCode,
  } = res;

  if (statusCode !== 200 || status?.toLowerCase() !== 'success') {
    console.error('getNrId failed:', { statusCode, status, message });
    throw new Error(message || 'Gagal mengambil data NR');
  }

  const dnData = Array.isArray(data) ? data[0] : data;

  return dnData;
};

sspApi.upload = async ({ id }: { id: string | number }) => {
  const {
    data: { status, message, data, code },
    status: statusCode,
  } = await unifikasiClient.post('/IF_TXR_070/upload', { id });

  return { status, message, data, code, statusCode };
};

sspApi.deleteNr = async (
  payload: TDeleteSspRequest,
  config?: Record<string, any>
): Promise<any> => {
  const {
    data: { status, message, data },
    status: statusCode,
  } = await unifikasiClient.post<TBaseResponseAPI<any>>('/IF_TXR_070/delete', payload, {
    ...config,
  });

  if (statusCode !== 200 || status?.toLowerCase() === 'error') {
    throw new Error(message || 'Gagal menghapus data NR');
  }

  return data;
};

sspApi.cancel = async ({ id, tglPembatalan }: TCancelSspRequest): Promise<TCancelSspResponse> => {
  const {
    data: { status, message, data, code, time, metaPage, total },
  } = await unifikasiClient.post('/IF_TXR_070/batal', {
    id,
    tglPembatalan,
  });

  console.log('Cancel SSP response:', { code, message, status });
  if (code === 0) {
    throw new Error(message || 'Gagal membatalkan data');
  }

  return {
    status,
    message,
    data,
    code,
    time,
    metaPage,
    total,
  };
};

export default sspApi;
