import { Typography } from '@mui/material';

const CustomNoRowsOverlay = () => (
  <div
    style={{
      display: 'flex',
      flexDirection: 'column',
      alignItems: 'center',
      justifyContent: 'center',
      height: '100%',
    }}
  >
    <svg
      width="500"
      height="500"
      viewBox="0 0 500 500"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M250.111 453.581C380.821 453.581 486.781 392.405 486.781 316.941C486.781 241.477 380.821 180.301 250.111 180.301C119.402 180.301 13.4414 241.477 13.4414 316.941C13.4414 392.405 119.402 453.581 250.111 453.581Z"
        fill="#F5F5F5"
      />
      <path
        d="M428.84 423.459C454.836 423.459 475.91 411.295 475.91 396.289C475.91 381.284 454.836 369.119 428.84 369.119C402.843 369.119 381.77 381.284 381.77 396.289C381.77 411.295 402.843 423.459 428.84 423.459Z"
        fill="#E6E6E6"
      />
      <path
        d="M129.09 343.48L248.92 412.67C250.247 413.341 251.713 413.69 253.2 413.69C254.687 413.69 256.153 413.341 257.48 412.67L413.83 322.67C416.19 321.31 416.19 319.11 413.83 317.75L293.44 248.42C292.113 247.75 290.647 247.4 289.16 247.4C287.673 247.4 286.207 247.75 284.88 248.42L129.09 338.54C126.73 339.91 126.73 342.12 129.09 343.48Z"
        fill="#E6E6E6"
      />
      <path
        d="M103.61 326.57L43.2105 291.7C40.8205 290.32 40.8205 288.07 43.2105 286.7C58.2105 277.97 107.32 249.49 107.95 249.34C108.58 249.19 157.81 277.97 172.85 286.77C175.23 288.17 175.22 290.41 172.85 291.77L112.3 326.56C110.956 327.248 109.467 327.607 107.957 327.609C106.446 327.61 104.957 327.255 103.61 326.57Z"
        fill="#E6E6E6"
      />
      <path
        d="M311.302 219.16C324.652 211.46 346.302 211.46 359.632 219.16C370.942 225.69 372.632 235.66 364.792 243.24C365.234 243.362 365.661 243.536 366.062 243.76L408.222 268.1C410.012 269.1 410.012 270.81 408.222 271.84L405.582 273.36C404.59 273.868 403.487 274.118 402.374 274.087C401.26 274.055 400.172 273.743 399.212 273.18L360.002 247.49C359.838 247.389 359.686 247.268 359.552 247.13C346.192 254.76 324.652 254.74 311.352 247.06C298.052 239.38 298.002 226.87 311.302 219.16Z"
        fill="#E6E6E6"
      />
      <path
        d="M305.551 224.18V232.48C305.551 236.98 308.551 241.48 314.481 244.93C326.391 251.8 345.701 251.8 357.611 244.93C363.561 241.49 366.541 236.93 366.541 232.48V224.18C366.541 219.67 363.541 215.18 357.611 211.73C345.701 204.85 326.391 204.85 314.481 211.73C308.481 215.16 305.551 219.67 305.551 224.18ZM363.551 224.18C363.551 227.78 360.901 231.3 356.101 234.07C350.781 237.14 343.641 238.83 336.011 238.83C328.381 238.83 321.231 237.14 315.921 234.07C311.111 231.3 308.461 227.78 308.461 224.18C308.461 220.58 311.111 217.06 315.921 214.28C321.231 211.21 328.371 209.52 336.011 209.52C343.651 209.52 350.781 211.21 356.101 214.28C360.941 217.06 363.591 220.57 363.591 224.18H363.551Z"
        fill="#143B88"
      />
      <path
        opacity="0.05"
        d="M337.001 241.77V250.06C328.871 250.21 320.651 248.51 314.441 244.93C308.441 241.49 305.511 236.93 305.511 232.48V224.18C305.496 223.897 305.496 223.613 305.511 223.33C305.121 228.11 308.081 232.97 314.411 236.63C320.741 240.29 328.911 241.92 337.001 241.77Z"
        fill="black"
      />
      <path
        opacity="0.6"
        d="M357.609 211.73C345.699 204.85 326.389 204.85 314.479 211.73C302.569 218.61 302.569 229.73 314.479 236.63C326.389 243.53 345.699 243.5 357.609 236.63C369.519 229.76 369.519 218.6 357.609 211.73ZM356.139 234.07C350.819 237.14 343.679 238.83 336.049 238.83C328.419 238.83 321.279 237.14 315.959 234.07C311.149 231.3 308.499 227.78 308.499 224.18C308.499 220.58 311.149 217.06 315.959 214.28C321.279 211.21 328.409 209.52 336.049 209.52C343.689 209.52 350.819 211.21 356.139 214.28C360.949 217.06 363.589 220.57 363.589 224.18C363.589 227.79 360.999 231.3 356.139 234.07Z"
        fill="white"
      />
      <path
        d="M363.6 224.18C363.58 225.646 363.166 227.079 362.4 228.33C360.85 225.897 358.687 223.914 356.13 222.58C350.82 219.51 343.68 217.82 336.04 217.82C328.4 217.82 321.28 219.51 315.96 222.58C313.406 223.923 311.243 225.904 309.68 228.33C308.929 227.074 308.522 225.642 308.5 224.18C308.5 220.57 311.15 217.06 315.96 214.28C321.28 211.21 328.41 209.52 336.04 209.52C343.67 209.52 350.82 211.21 356.13 214.28C361 217.06 363.6 220.57 363.6 224.18Z"
        fill="#143B88"
      />
      <path
        opacity="0.5"
        d="M356.139 218C350.819 214.93 343.679 213.24 336.049 213.24C328.419 213.24 321.279 215 315.999 218C311.999 220.29 309.539 223.08 308.789 226C309.539 228.93 312.029 231.72 315.999 234C321.319 237.07 328.449 238.76 336.089 238.76C343.729 238.76 350.859 237.07 356.179 234C360.179 231.71 362.639 228.92 363.389 226C362.599 223.12 360.109 220.33 356.139 218Z"
        fill="white"
      />
      <path
        d="M356.701 241.91C356.742 241.17 356.955 240.449 357.323 239.805C357.691 239.161 358.204 238.611 358.821 238.2C359.037 238.043 359.29 237.945 359.555 237.917C359.82 237.889 360.088 237.931 360.331 238.04L370.591 243.89C370.807 244.046 370.979 244.255 371.089 244.497C371.2 244.739 371.245 245.005 371.221 245.27C371.181 246.012 370.968 246.734 370.598 247.379C370.228 248.023 369.712 248.571 369.091 248.98C368.875 249.136 368.622 249.232 368.357 249.259C368.091 249.285 367.824 249.241 367.581 249.13L357.321 243.27C357.109 243.117 356.94 242.911 356.831 242.672C356.723 242.434 356.678 242.171 356.701 241.91Z"
        fill="#37474F"
      />
      <path
        d="M357.342 243.291C357.123 243.138 356.948 242.929 356.835 242.687C356.723 242.445 356.677 242.177 356.702 241.911C356.717 241.358 356.843 240.814 357.072 240.311L370.302 247.881C369.985 248.331 369.58 248.712 369.112 249.001C368.896 249.157 368.642 249.253 368.377 249.279C368.112 249.305 367.844 249.261 367.602 249.151L357.342 243.291Z"
        fill="#263238"
      />
      <path d="M368.31 246L368.09 246.35L368.31 246Z" fill="black" />
      <path
        d="M403.69 266.469L368.32 245.999C368.76 245.225 369.385 244.572 370.14 244.099C370.417 243.902 370.739 243.778 371.077 243.739C371.415 243.701 371.756 243.749 372.07 243.879L406.07 262.059L403.69 266.469Z"
        fill="#143B88"
      />
      <path
        opacity="0.6"
        d="M403.69 266.469L368.32 245.999C368.76 245.225 369.385 244.572 370.14 244.099C370.417 243.902 370.739 243.778 371.077 243.739C371.415 243.701 371.756 243.749 372.07 243.879L406.07 262.059L403.69 266.469Z"
        fill="white"
      />
      <path
        d="M403.692 266.471L401.082 271.091L368.212 250.771C367.93 250.569 367.704 250.297 367.559 249.981C367.413 249.665 367.352 249.317 367.382 248.971C367.392 248.44 367.483 247.914 367.652 247.411C367.652 247.321 367.732 247.211 367.762 247.121C367.872 246.871 367.982 246.631 368.102 246.391L368.312 246.041L403.692 266.471Z"
        fill="#143B88"
      />
      <path
        opacity="0.05"
        d="M403.692 266.471L401.082 271.091L368.212 250.771C367.93 250.569 367.704 250.297 367.559 249.981C367.413 249.665 367.352 249.317 367.382 248.971C367.392 248.44 367.483 247.914 367.652 247.411C367.652 247.321 367.732 247.211 367.762 247.121C367.872 246.871 367.982 246.631 368.102 246.391L368.312 246.041L403.692 266.471Z"
        fill="black"
      />
      <path
        d="M403.642 270.83C404.702 270.133 405.582 269.195 406.211 268.093C406.84 266.992 407.2 265.757 407.262 264.49C407.262 262.17 405.622 261.23 403.612 262.4C402.554 263.096 401.674 264.032 401.045 265.132C400.416 266.232 400.056 267.465 399.992 268.73C400.002 271.06 401.632 272 403.642 270.83Z"
        fill="#143B88"
      />
      <g opacity="0.3">
        <path
          d="M403.642 270.83C404.702 270.133 405.582 269.195 406.211 268.093C406.84 266.992 407.2 265.757 407.262 264.49C407.262 262.17 405.622 261.23 403.612 262.4C402.554 263.096 401.674 264.032 401.045 265.132C400.416 266.232 400.056 267.465 399.992 268.73C400.002 271.06 401.632 272 403.642 270.83Z"
          fill="black"
        />
      </g>
      <path
        d="M172.93 385.59C171.937 385.607 170.956 385.37 170.08 384.9L77.7904 331.61C77.4012 331.459 77.0667 331.194 76.8308 330.849C76.595 330.505 76.4688 330.097 76.4688 329.68C76.4688 329.262 76.595 328.855 76.8308 328.51C77.0667 328.166 77.4012 327.901 77.7904 327.75L99.5504 315.18L100.05 316.05L78.2904 328.61C78.0712 328.701 77.8795 328.847 77.734 329.035C77.5885 329.223 77.4942 329.445 77.4604 329.68C77.497 329.914 77.5923 330.135 77.7374 330.322C77.8826 330.509 78.0729 330.656 78.2904 330.75L170.58 384C171.31 384.365 172.115 384.555 172.93 384.555C173.746 384.555 174.551 384.365 175.28 384L193 373.8L193.5 374.67L175.78 384.9C174.905 385.368 173.924 385.606 172.93 385.59Z"
        fill="#F38C28"
      />
      <path
        d="M172.93 394.999C171.937 395.016 170.956 394.778 170.08 394.309L61.5404 331.608C61.1512 331.458 60.8167 331.193 60.5808 330.848C60.345 330.504 60.2188 330.096 60.2188 329.678C60.2187 329.261 60.345 328.853 60.5808 328.509C60.8167 328.164 61.1512 327.899 61.5404 327.749L91.4404 310.479L91.9404 311.349L62.0004 328.608C61.7598 328.666 61.5455 328.803 61.3922 328.997C61.2389 329.191 61.1556 329.431 61.1556 329.678C61.1556 329.926 61.2389 330.166 61.3922 330.36C61.5455 330.554 61.7598 330.691 62.0004 330.749L170.54 393.409C171.27 393.774 172.075 393.964 172.89 393.964C173.706 393.964 174.511 393.774 175.24 393.409L201.07 378.499L201.57 379.358L175.74 394.279C174.879 394.751 173.913 394.999 172.93 394.999Z"
        fill="#F38C28"
      />
      <path
        d="M172.93 404.349C171.937 404.367 170.955 404.129 170.08 403.659L45.29 331.609C44.9225 331.431 44.6091 331.159 44.3823 330.82C44.1555 330.48 44.0235 330.087 44 329.679C44.0277 329.268 44.1646 328.871 44.3967 328.53C44.6287 328.189 44.9474 327.916 45.32 327.739L83.32 305.789L83.82 306.659L45.82 328.609C45.5839 328.67 45.3748 328.808 45.2256 329.001C45.0763 329.193 44.9953 329.43 44.9953 329.674C44.9953 329.918 45.0763 330.155 45.2256 330.348C45.3748 330.54 45.5839 330.678 45.82 330.739L170.61 402.789C171.34 403.154 172.144 403.344 172.96 403.344C173.776 403.344 174.58 403.154 175.31 402.789L209.31 383.189L209.81 384.049L175.81 403.659C174.925 404.133 173.933 404.37 172.93 404.349Z"
        fill="#F38C28"
      />
      <path
        d="M42.9414 268.7L107.941 306.23L172.931 268.7L107.941 231.18L42.9414 268.7Z"
        fill="#263238"
      />
      <path
        d="M107.931 306.219V323.519C106.43 323.558 104.943 323.214 103.611 322.519L75.4414 306.229L45.5414 288.999C44.784 288.507 44.1537 287.843 43.7019 287.061C43.25 286.279 42.9895 285.401 42.9414 284.499V268.699L106.141 305.189L107.931 306.219Z"
        fill="#455A64"
      />
      <path
        d="M172.93 268.699V284.459C172.879 285.361 172.618 286.237 172.166 287.019C171.714 287.801 171.085 288.465 170.33 288.959L144.49 303.879L112.26 322.489C110.925 323.185 109.435 323.529 107.93 323.489V306.189L109.93 305.029L172.93 268.699Z"
        fill="#37474F"
      />
      <path
        d="M47 276.24V278.36C47.011 278.509 47.0553 278.654 47.1298 278.784C47.2042 278.914 47.3068 279.025 47.43 279.11L47.92 279.39C48.15 279.53 48.35 279.39 48.35 279.14V277C48.339 276.851 48.2947 276.706 48.2202 276.576C48.1458 276.446 48.0432 276.335 47.92 276.25L47.43 275.97C47.2 275.85 47 276 47 276.24Z"
        fill="#F38C28"
      />
      <path
        d="M49.1914 277.5V279.62C49.1989 279.771 49.2429 279.919 49.3195 280.049C49.3961 280.18 49.5031 280.29 49.6314 280.37L50.1114 280.65C50.3514 280.79 50.5514 280.65 50.5514 280.4V278.28C50.5393 278.13 50.4934 277.985 50.4172 277.855C50.341 277.725 50.2365 277.614 50.1114 277.53L49.6314 277.25C49.3914 277.11 49.1914 277.22 49.1914 277.5Z"
        fill="#F38C28"
      />
      <path
        d="M51.3828 278.76V280.89C51.3938 281.039 51.4382 281.184 51.5126 281.314C51.587 281.444 51.6896 281.555 51.8128 281.64L52.3028 281.92C52.5428 282.05 52.7428 281.92 52.7428 281.67V279.54C52.7307 279.39 52.6848 279.244 52.6086 279.115C52.5324 278.985 52.4279 278.874 52.3028 278.79L51.8128 278.51C51.5828 278.37 51.3828 278.48 51.3828 278.76Z"
        fill="#F38C28"
      />
      <path
        d="M53.5703 280V282.13C53.5813 282.28 53.6257 282.424 53.7001 282.554C53.7745 282.684 53.8771 282.795 54.0003 282.88L54.4903 283.16C54.7303 283.3 54.9203 283.16 54.9203 282.91V280.8C54.9093 280.651 54.865 280.506 54.7906 280.376C54.7161 280.247 54.6135 280.135 54.4903 280.05L54.0003 279.77C53.7603 279.63 53.5703 279.75 53.5703 280Z"
        fill="#F38C28"
      />
      <path
        d="M55.7617 281.281V283.411C55.7727 283.56 55.8171 283.705 55.8915 283.835C55.9659 283.965 56.0685 284.076 56.1917 284.161L56.6817 284.441C56.9217 284.581 57.1117 284.441 57.1117 284.191V282.061C57.1007 281.912 57.0564 281.767 56.982 281.637C56.9075 281.507 56.8049 281.396 56.6817 281.311L56.1917 281.031C56.0017 280.901 55.7617 281.001 55.7617 281.281Z"
        fill="#263238"
      />
      <path
        d="M58 282.541V284.671C58.011 284.82 58.0553 284.965 58.1298 285.095C58.2042 285.225 58.3068 285.336 58.43 285.421L58.92 285.701C59.16 285.841 59.35 285.701 59.35 285.451V283.331C59.3444 283.18 59.3023 283.033 59.2274 282.903C59.1525 282.772 59.047 282.662 58.92 282.581L58.43 282.291C58.14 282.161 58 282.271 58 282.541Z"
        fill="#F38C28"
      />
      <path
        d="M60.1406 283.811V285.931C60.1516 286.08 60.196 286.225 60.2704 286.355C60.3448 286.484 60.4474 286.596 60.5706 286.681L61.0606 286.961C61.2906 287.101 61.4906 286.961 61.4906 286.711V284.591C61.4796 284.441 61.4353 284.297 61.3609 284.167C61.2864 284.037 61.1838 283.926 61.0606 283.841L60.5706 283.561C60.3306 283.421 60.1406 283.531 60.1406 283.811Z"
        fill="#263238"
      />
      <path
        d="M62.3203 285.07V287.19C62.3325 287.341 62.3783 287.486 62.4545 287.616C62.5307 287.746 62.6352 287.857 62.7603 287.94L63.2403 288.22C63.4803 288.36 63.6803 288.22 63.6803 287.97V285.85C63.6682 285.7 63.6223 285.555 63.5461 285.425C63.4699 285.295 63.3654 285.184 63.2403 285.1L62.7603 284.82C62.5203 284.68 62.3203 284.79 62.3203 285.07Z"
        fill="#263238"
      />
      <path
        d="M64.5117 286.33V288.45C64.5227 288.599 64.5671 288.744 64.6415 288.874C64.7159 289.004 64.8185 289.115 64.9417 289.2L65.4317 289.49C65.6717 289.62 65.8717 289.49 65.8717 289.24V287.11C65.8596 286.96 65.8137 286.815 65.7375 286.685C65.6613 286.555 65.5568 286.444 65.4317 286.36L64.9417 286.08C64.7117 285.94 64.5117 286.05 64.5117 286.33Z"
        fill="#263238"
      />
      <path
        d="M66.7031 287.59V289.72C66.7141 289.869 66.7585 290.014 66.8329 290.144C66.9073 290.274 67.0099 290.385 67.1331 290.47L67.6231 290.75C67.8631 290.89 68.0531 290.75 68.0531 290.5V288.37C68.0421 288.221 67.9978 288.076 67.9234 287.946C67.8489 287.816 67.7463 287.705 67.6231 287.62L67.1331 287.34C66.8931 287.2 66.7031 287.31 66.7031 287.59Z"
        fill="#F38C28"
      />
      <path
        d="M68.8906 288.851V291.001C68.9016 291.15 68.946 291.295 69.0204 291.425C69.0948 291.554 69.1974 291.666 69.3206 291.751L69.8106 292.031C70.0506 292.171 70.2406 292.031 70.2406 291.781V289.651C70.2296 289.502 70.1853 289.357 70.1109 289.227C70.0364 289.097 69.9338 288.986 69.8106 288.901L69.3206 288.621C69.0806 288.461 68.8906 288.581 68.8906 288.851Z"
        fill="#F38C28"
      />
      <path
        d="M71.082 290.109V292.239C71.093 292.388 71.1374 292.533 71.2118 292.663C71.2862 292.793 71.3888 292.904 71.512 292.989L72.002 293.269C72.242 293.409 72.432 293.269 72.432 293.019V290.899C72.4264 290.749 72.3844 290.602 72.3095 290.471C72.2346 290.341 72.1291 290.23 72.002 290.149L71.512 289.859C71.272 289.729 71.082 289.839 71.082 290.109Z"
        fill="#263238"
      />
      <path
        d="M73.2695 291.381V293.501C73.2805 293.65 73.3249 293.795 73.3993 293.924C73.4737 294.054 73.5763 294.166 73.6995 294.251L74.1895 294.531C74.4195 294.671 74.6195 294.531 74.6195 294.281V292.161C74.6085 292.011 74.5642 291.866 74.4898 291.737C74.4153 291.607 74.3128 291.495 74.1895 291.411L73.6995 291.131C73.4595 291.001 73.2695 291.101 73.2695 291.381Z"
        fill="#263238"
      />
      <path
        d="M75.4531 292.641V294.761C75.4653 294.911 75.5112 295.056 75.5873 295.186C75.6635 295.316 75.7681 295.427 75.8931 295.511L76.3731 295.791C76.6131 295.931 76.8131 295.791 76.8131 295.541V293.421C76.801 293.271 76.7551 293.125 76.6789 292.995C76.6027 292.866 76.4982 292.755 76.3731 292.671L75.8931 292.391C75.6531 292.251 75.4531 292.361 75.4531 292.641Z"
        fill="#F38C28"
      />
      <path
        d="M77.6406 293.9V296C77.6481 296.151 77.6921 296.298 77.7687 296.429C77.8453 296.56 77.9523 296.67 78.0806 296.75L78.5606 297.03C78.8006 297.17 79.0006 297.03 79.0006 296.78V294.66C78.9885 294.51 78.9426 294.365 78.8664 294.235C78.7902 294.105 78.6857 293.994 78.5606 293.91L78.0806 293.63C77.8406 293.51 77.6406 293.62 77.6406 293.9Z"
        fill="#F38C28"
      />
      <path
        d="M79.832 295.16V297.29C79.843 297.44 79.8874 297.584 79.9618 297.714C80.0362 297.844 80.1388 297.955 80.262 298.04L80.752 298.32C80.992 298.45 81.182 298.32 81.182 298.07V295.94C81.171 295.791 81.1267 295.646 81.0523 295.516C80.9778 295.387 80.8752 295.275 80.752 295.19L80.262 294.91C80.002 294.77 79.832 294.88 79.832 295.16Z"
        fill="#F38C28"
      />
      <path
        d="M82 296.42V298.55C82.011 298.699 82.0553 298.844 82.1298 298.974C82.2042 299.103 82.3068 299.215 82.43 299.3L82.92 299.58C83.16 299.72 83.35 299.58 83.35 299.33V297.2C83.339 297.05 83.2947 296.906 83.2202 296.776C83.1458 296.646 83.0432 296.535 82.92 296.45L82.43 296.17C82.21 296 82 296.15 82 296.42Z"
        fill="#F38C28"
      />
      <path
        d="M47 282.541V284.671C47.011 284.82 47.0553 284.965 47.1298 285.095C47.2042 285.225 47.3068 285.336 47.43 285.421L47.92 285.701C48.15 285.841 48.35 285.701 48.35 285.451V283.331C48.339 283.182 48.2947 283.037 48.2202 282.907C48.1458 282.777 48.0432 282.666 47.92 282.581L47.43 282.291C47.2 282.161 47 282.271 47 282.541Z"
        fill="#F38C28"
      />
      <path
        d="M49.1914 283.811V285.931C49.2036 286.081 49.2494 286.226 49.3256 286.356C49.4018 286.486 49.5063 286.597 49.6314 286.681L50.1114 286.961C50.3514 287.101 50.5514 286.961 50.5514 286.711V284.591C50.5393 284.441 50.4934 284.295 50.4172 284.165C50.341 284.035 50.2365 283.925 50.1114 283.841L49.6314 283.561C49.3914 283.421 49.1914 283.531 49.1914 283.811Z"
        fill="#263238"
      />
      <path
        d="M51.3828 285.07V287.19C51.3938 287.34 51.4382 287.485 51.5126 287.614C51.587 287.744 51.6896 287.856 51.8128 287.94L52.3028 288.22C52.5428 288.36 52.7428 288.22 52.7428 287.97V285.85C52.7307 285.7 52.6848 285.555 52.6086 285.425C52.5324 285.295 52.4279 285.184 52.3028 285.1L51.8128 284.82C51.5828 284.68 51.3828 284.79 51.3828 285.07Z"
        fill="#F38C28"
      />
      <path
        d="M53.5703 286.33V288.45C53.5759 288.601 53.618 288.748 53.6929 288.878C53.7678 289.009 53.8733 289.119 54.0003 289.2L54.4903 289.49C54.7303 289.62 54.9203 289.49 54.9203 289.24V287.11C54.9093 286.961 54.865 286.816 54.7906 286.686C54.7161 286.557 54.6135 286.445 54.4903 286.36L54.0003 286.08C53.7603 285.94 53.5703 286.05 53.5703 286.33Z"
        fill="#263238"
      />
      <path
        d="M55.7617 287.59V289.72C55.7727 289.869 55.8171 290.014 55.8915 290.144C55.9659 290.274 56.0685 290.385 56.1917 290.47L56.6817 290.75C56.9217 290.89 57.1117 290.75 57.1117 290.5V288.37C57.1007 288.221 57.0564 288.076 56.982 287.946C56.9075 287.816 56.8049 287.705 56.6817 287.62L56.1917 287.34C56.0017 287.2 55.7617 287.31 55.7617 287.59Z"
        fill="#263238"
      />
      <path
        d="M58 288.851V291.001C58.011 291.15 58.0553 291.295 58.1298 291.425C58.2042 291.554 58.3068 291.666 58.43 291.751L58.92 292.031C59.16 292.171 59.35 292.031 59.35 291.781V289.651C59.339 289.502 59.2947 289.357 59.2202 289.227C59.1458 289.097 59.0432 288.986 58.92 288.901L58.43 288.621C58.14 288.461 58 288.581 58 288.851Z"
        fill="#F38C28"
      />
      <path
        d="M60.1406 290.109V292.239C60.1516 292.388 60.196 292.533 60.2704 292.663C60.3448 292.793 60.4474 292.904 60.5706 292.989L61.0606 293.269C61.2906 293.409 61.4906 293.269 61.4906 293.019V290.899C61.4796 290.75 61.4353 290.605 61.3609 290.475C61.2864 290.346 61.1838 290.234 61.0606 290.149L60.5706 289.859C60.3306 289.729 60.1406 289.839 60.1406 290.109Z"
        fill="#F38C28"
      />
      <path
        d="M62.3203 291.381V293.501C62.3325 293.651 62.3783 293.796 62.4545 293.926C62.5307 294.056 62.6352 294.167 62.7603 294.251L63.2403 294.531C63.4803 294.671 63.6803 294.531 63.6803 294.281V292.161C63.6728 292.009 63.6289 291.862 63.5522 291.732C63.4756 291.601 63.3686 291.491 63.2403 291.411L62.7603 291.131C62.5203 291.001 62.3203 291.101 62.3203 291.381Z"
        fill="#F38C28"
      />
      <path
        d="M64.5117 292.641V294.761C64.5227 294.91 64.5671 295.055 64.6415 295.185C64.7159 295.314 64.8185 295.426 64.9417 295.511L65.4317 295.791C65.6717 295.931 65.8717 295.791 65.8717 295.541V293.421C65.8596 293.271 65.8137 293.125 65.7375 292.995C65.6613 292.866 65.5568 292.755 65.4317 292.671L64.9417 292.391C64.7117 292.251 64.5117 292.361 64.5117 292.641Z"
        fill="#F38C28"
      />
      <path
        d="M66.7031 293.9V296C66.7087 296.151 66.7508 296.297 66.8257 296.428C66.9006 296.559 67.0061 296.669 67.1331 296.75L67.6231 297.03C67.8631 297.17 68.0531 297.03 68.0531 296.78V294.66C68.0421 294.511 67.9978 294.366 67.9234 294.236C67.8489 294.106 67.7463 293.995 67.6231 293.91L67.1331 293.63C66.8931 293.51 66.7031 293.62 66.7031 293.9Z"
        fill="#263238"
      />
      <path
        d="M68.8906 295.16V297.29C68.9016 297.44 68.946 297.584 69.0204 297.714C69.0948 297.844 69.1974 297.955 69.3206 298.04L69.8106 298.32C70.0506 298.45 70.2406 298.32 70.2406 298.07V295.94C70.2296 295.791 70.1853 295.646 70.1109 295.516C70.0364 295.387 69.9338 295.275 69.8106 295.19L69.3206 294.91C69.0806 294.77 68.8906 294.88 68.8906 295.16Z"
        fill="#263238"
      />
      <path
        d="M71.082 296.42V298.55C71.093 298.699 71.1374 298.844 71.2118 298.974C71.2862 299.103 71.3888 299.215 71.512 299.3L72.002 299.58C72.242 299.72 72.432 299.58 72.432 299.33V297.2C72.421 297.05 72.3767 296.906 72.3023 296.776C72.2278 296.646 72.1252 296.535 72.002 296.45L71.512 296.17C71.272 296 71.082 296.15 71.082 296.42Z"
        fill="#F38C28"
      />
      <path
        d="M73.2695 297.68V299.81C73.2805 299.959 73.3249 300.104 73.3993 300.233C73.4737 300.363 73.5763 300.475 73.6995 300.56L74.1895 300.84C74.4195 300.98 74.6195 300.84 74.6195 300.59V298.46C74.6085 298.31 74.5642 298.165 74.4898 298.036C74.4153 297.906 74.3128 297.794 74.1895 297.71L73.6995 297.43C73.4595 297.3 73.2695 297.41 73.2695 297.68Z"
        fill="#F38C28"
      />
      <path
        d="M75.4531 298.939V301.069C75.4653 301.219 75.5112 301.365 75.5873 301.495C75.6635 301.624 75.7681 301.735 75.8931 301.819L76.3731 302.099C76.6131 302.239 76.8131 302.099 76.8131 301.849V299.729C76.8056 299.578 76.7617 299.431 76.6851 299.3C76.6085 299.17 76.5014 299.06 76.3731 298.979L75.8931 298.689C75.6531 298.559 75.4531 298.669 75.4531 298.939Z"
        fill="#263238"
      />
      <path
        d="M77.6406 300.21V302.33C77.6528 302.48 77.6987 302.625 77.7748 302.755C77.851 302.885 77.9556 302.996 78.0806 303.08L78.5606 303.36C78.8006 303.5 79.0006 303.36 79.0006 303.11V301C78.9885 300.85 78.9426 300.704 78.8664 300.574C78.7902 300.444 78.6857 300.333 78.5606 300.25L78.0806 299.97C77.8406 299.82 77.6406 299.93 77.6406 300.21Z"
        fill="#263238"
      />
      <path
        d="M79.832 301.471V303.591C79.843 303.74 79.8874 303.885 79.9618 304.015C80.0362 304.144 80.1388 304.256 80.262 304.341L80.752 304.621C80.992 304.761 81.182 304.621 81.182 304.371V302.251C81.171 302.102 81.1267 301.957 81.0523 301.827C80.9778 301.697 80.8752 301.586 80.752 301.501L80.262 301.221C80.002 301.081 79.832 301.191 79.832 301.471Z"
        fill="#263238"
      />
      <path
        d="M82 302.731V304.851C82.0056 305.001 82.0477 305.148 82.1226 305.279C82.1975 305.409 82.303 305.52 82.43 305.601L82.92 305.891C83.16 306.021 83.35 305.891 83.35 305.641V303.511C83.339 303.361 83.2947 303.217 83.2202 303.087C83.1458 302.957 83.0432 302.845 82.92 302.761L82.43 302.481C82.21 302.341 82 302.451 82 302.731Z"
        fill="#263238"
      />
      <path
        d="M89.332 303.621L90.332 303.051C90.5448 302.956 90.7791 302.918 91.0109 302.943C91.2428 302.968 91.464 303.053 91.652 303.191C92.1995 303.548 92.6551 304.03 92.9817 304.596C93.3084 305.163 93.4969 305.798 93.532 306.451C93.5577 306.683 93.5202 306.919 93.4234 307.132C93.3266 307.344 93.1741 307.527 92.982 307.661L92.062 308.191L91.892 307.921C91.7039 307.874 91.5225 307.803 91.352 307.711C90.8045 307.353 90.349 306.872 90.0223 306.306C89.6957 305.739 89.5072 305.104 89.472 304.451C89.4697 304.289 89.4899 304.127 89.532 303.971L89.332 303.621Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M89.332 303.621L90.332 303.051C90.5448 302.956 90.7791 302.918 91.0109 302.943C91.2428 302.968 91.464 303.053 91.652 303.191C92.1995 303.548 92.6551 304.03 92.9817 304.596C93.3084 305.163 93.4969 305.798 93.532 306.451C93.5577 306.683 93.5202 306.919 93.4234 307.132C93.3266 307.344 93.1741 307.527 92.982 307.661L92.062 308.191L91.892 307.921C91.7039 307.874 91.5225 307.803 91.352 307.711C90.8045 307.353 90.349 306.872 90.0223 306.306C89.6957 305.739 89.5072 305.104 89.472 304.451C89.4697 304.289 89.4899 304.127 89.532 303.971L89.332 303.621Z"
        fill="black"
      />
      <path
        d="M90.7003 303.731C91.2503 304.088 91.7075 304.571 92.0343 305.139C92.3612 305.708 92.5483 306.346 92.5803 307.001C92.5803 308.201 91.7403 308.681 90.7003 308.081C90.1528 307.723 89.6972 307.242 89.3706 306.675C89.044 306.109 88.8554 305.474 88.8203 304.821C88.8203 303.611 89.6603 303.131 90.7003 303.731Z"
        fill="#F38C28"
      />
      <path
        d="M97.5 308.331L98.5 307.761C98.7112 307.661 98.9455 307.62 99.178 307.643C99.4105 307.666 99.6324 307.751 99.82 307.891C100.368 308.248 100.823 308.729 101.15 309.296C101.476 309.862 101.665 310.498 101.7 311.151C101.724 311.384 101.686 311.62 101.59 311.835C101.493 312.049 101.341 312.234 101.15 312.371L100.23 312.901L100.06 312.621C99.8705 312.578 99.6884 312.507 99.52 312.411C98.9725 312.053 98.5169 311.572 98.1903 311.005C97.8637 310.439 97.6751 309.803 97.64 309.151C97.6383 308.989 97.6585 308.827 97.7 308.671L97.5 308.331Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M97.5 308.331L98.5 307.761C98.7112 307.661 98.9455 307.62 99.178 307.643C99.4105 307.666 99.6324 307.751 99.82 307.891C100.368 308.248 100.823 308.729 101.15 309.296C101.476 309.862 101.665 310.498 101.7 311.151C101.724 311.384 101.686 311.62 101.59 311.835C101.493 312.049 101.341 312.234 101.15 312.371L100.23 312.901L100.06 312.621C99.8705 312.578 99.6884 312.507 99.52 312.411C98.9725 312.053 98.5169 311.572 98.1903 311.005C97.8637 310.439 97.6751 309.803 97.64 309.151C97.6383 308.989 97.6585 308.827 97.7 308.671L97.5 308.331Z"
        fill="black"
      />
      <path
        d="M98.87 308.44C99.4175 308.797 99.8731 309.279 100.2 309.845C100.526 310.412 100.715 311.047 100.75 311.7C100.75 312.9 99.91 313.39 98.87 312.79C98.3249 312.431 97.8717 311.949 97.5469 311.382C97.2221 310.816 97.0348 310.182 97 309.53C97 308.33 97.83 307.84 98.87 308.44Z"
        fill="#F38C28"
      />
      <path
        d="M42.9414 240.561L107.941 278.081L172.931 240.561L107.941 203.041L42.9414 240.561Z"
        fill="#263238"
      />
      <path d="M42.9414 259.321L107.941 296.851V278.081L42.9414 240.561V259.321Z" fill="#455A64" />
      <path d="M107.941 296.851L172.931 259.321V240.561L107.941 278.081V296.851Z" fill="#37474F" />
      <path d="M51.0703 268.7V264.01L107.94 296.85V301.54L51.0703 268.7Z" fill="#F38C28" />
      <path d="M168.871 261.67V266.36L107.941 301.54V296.85L168.871 261.67Z" fill="#F38C28" />
      <path
        opacity="0.2"
        d="M168.871 261.67V266.36L107.941 301.54V296.85L168.871 261.67Z"
        fill="black"
      />
      <path
        d="M47 248.1V250.22C47.011 250.369 47.0553 250.514 47.1298 250.644C47.2042 250.773 47.3068 250.885 47.43 250.97L47.92 251.25C48.15 251.39 48.35 251.25 48.35 251V248.88C48.339 248.731 48.2947 248.586 48.2202 248.456C48.1458 248.326 48.0432 248.215 47.92 248.13L47.43 247.85C47.2 247.71 47 247.82 47 248.1Z"
        fill="#263238"
      />
      <path
        d="M49.1914 249.36V251.48C49.2036 251.63 49.2494 251.775 49.3256 251.905C49.4018 252.035 49.5063 252.146 49.6314 252.23L50.1114 252.51C50.3514 252.65 50.5514 252.51 50.5514 252.26V250.14C50.5393 249.99 50.4934 249.845 50.4172 249.715C50.341 249.585 50.2365 249.474 50.1114 249.39L49.6314 249.11C49.3914 249 49.1914 249.08 49.1914 249.36Z"
        fill="#F38C28"
      />
      <path
        d="M51.3828 250.619V252.739C51.3938 252.889 51.4382 253.033 51.5126 253.163C51.587 253.293 51.6896 253.404 51.8128 253.489L52.3028 253.769C52.5428 253.909 52.7428 253.769 52.7428 253.519V251.399C52.7307 251.249 52.6848 251.104 52.6086 250.974C52.5324 250.844 52.4279 250.733 52.3028 250.649L51.8128 250.369C51.5828 250.229 51.3828 250.339 51.3828 250.619Z"
        fill="#F38C28"
      />
      <path
        d="M53.5703 251.881V254.001C53.5813 254.15 53.6257 254.295 53.7001 254.425C53.7745 254.554 53.8771 254.666 54.0003 254.751L54.4903 255.031C54.7303 255.161 54.9203 255.031 54.9203 254.781V252.651C54.9093 252.501 54.865 252.357 54.7906 252.227C54.7161 252.097 54.6135 251.986 54.4903 251.901L54.0003 251.621C53.7603 251.491 53.5703 251.601 53.5703 251.881Z"
        fill="#263238"
      />
      <path
        d="M55.7617 253.141V255.271C55.7727 255.42 55.8171 255.565 55.8915 255.695C55.9659 255.825 56.0685 255.936 56.1917 256.021L56.6817 256.301C56.9217 256.441 57.1117 256.301 57.1117 256.051V253.921C57.1007 253.772 57.0564 253.627 56.982 253.497C56.9075 253.367 56.8049 253.256 56.6817 253.171L56.1917 252.891C56.0017 252.751 55.7617 252.871 55.7617 253.141Z"
        fill="#263238"
      />
      <path
        d="M58 254.399V256.529C58.011 256.678 58.0553 256.823 58.1298 256.953C58.2042 257.083 58.3068 257.194 58.43 257.279L58.92 257.559C59.16 257.699 59.35 257.559 59.35 257.309V255.179C59.339 255.03 59.2947 254.885 59.2202 254.755C59.1458 254.626 59.0432 254.514 58.92 254.429L58.43 254.149C58.14 253.999 58 254.129 58 254.399Z"
        fill="#F38C28"
      />
      <path
        d="M60.1406 255.66V257.79C60.1516 257.939 60.196 258.084 60.2704 258.214C60.3448 258.344 60.4474 258.455 60.5706 258.54L61.0606 258.82C61.2906 258.96 61.4906 258.82 61.4906 258.57V256.45C61.4796 256.301 61.4353 256.156 61.3609 256.026C61.2864 255.896 61.1838 255.785 61.0606 255.7L60.5706 255.41C60.3306 255.28 60.1406 255.39 60.1406 255.66Z"
        fill="#F38C28"
      />
      <path
        d="M62.3203 256.93V259.05C62.3325 259.2 62.3783 259.345 62.4545 259.475C62.5307 259.605 62.6352 259.716 62.7603 259.8L63.2403 260.08C63.4803 260.22 63.6803 260.08 63.6803 259.83V257.71C63.6682 257.56 63.6223 257.414 63.5461 257.285C63.4699 257.155 63.3654 257.044 63.2403 256.96L62.7603 256.68C62.5203 256.54 62.3203 256.65 62.3203 256.93Z"
        fill="#F38C28"
      />
      <path
        d="M64.5117 258.189V260.309C64.5227 260.459 64.5671 260.604 64.6415 260.733C64.7159 260.863 64.8185 260.975 64.9417 261.059L65.4317 261.339C65.6717 261.479 65.8717 261.339 65.8717 261.089V258.999C65.8596 258.849 65.8137 258.704 65.7375 258.574C65.6613 258.444 65.5568 258.333 65.4317 258.249L64.9417 257.969C64.7117 257.799 64.5117 257.909 64.5117 258.189Z"
        fill="#F38C28"
      />
      <path
        d="M66.7031 259.449V261.569C66.7087 261.72 66.7508 261.867 66.8257 261.997C66.9006 262.128 67.0061 262.238 67.1331 262.319L67.6231 262.609C67.8631 262.739 68.0531 262.609 68.0531 262.359V260.229C68.0421 260.08 67.9978 259.935 67.9234 259.805C67.8489 259.676 67.7463 259.564 67.6231 259.479L67.1331 259.199C66.8931 259.059 66.7031 259.169 66.7031 259.449Z"
        fill="#263238"
      />
      <path
        d="M68.8906 260.711V262.841C68.9016 262.99 68.946 263.135 69.0204 263.265C69.0948 263.395 69.1974 263.506 69.3206 263.591L69.8106 263.871C70.0506 264.011 70.2406 263.871 70.2406 263.621V261.491C70.2296 261.342 70.1853 261.197 70.1109 261.067C70.0364 260.937 69.9338 260.826 69.8106 260.741L69.3206 260.461C69.0806 260.321 68.8906 260.431 68.8906 260.711Z"
        fill="#263238"
      />
      <path
        d="M71.082 262V264.13C71.093 264.28 71.1374 264.424 71.2118 264.554C71.2862 264.684 71.3888 264.795 71.512 264.88L72.002 265.16C72.242 265.3 72.432 265.16 72.432 264.91V262.78C72.4255 262.626 72.3833 262.475 72.3087 262.34C72.2341 262.204 72.1291 262.088 72.002 262L71.512 261.72C71.272 261.58 71.082 261.7 71.082 262Z"
        fill="#263238"
      />
      <path
        d="M73.2695 263.23V265.36C73.2805 265.509 73.3249 265.654 73.3993 265.784C73.4737 265.913 73.5763 266.025 73.6995 266.11L74.1895 266.39C74.4195 266.53 74.6195 266.39 74.6195 266.14V264C74.6085 263.851 74.5642 263.706 74.4898 263.576C74.4153 263.446 74.3128 263.335 74.1895 263.25L73.6995 263C73.4595 262.85 73.2695 263 73.2695 263.23Z"
        fill="#F38C28"
      />
      <path
        d="M75.4531 264.5V266.62C75.4653 266.77 75.5112 266.916 75.5873 267.045C75.6635 267.175 75.7681 267.286 75.8931 267.37L76.3731 267.65C76.6131 267.79 76.8131 267.65 76.8131 267.4V265.28C76.8056 265.129 76.7617 264.982 76.6851 264.851C76.6085 264.721 76.5014 264.61 76.3731 264.53L75.8931 264.25C75.6531 264.11 75.4531 264.22 75.4531 264.5Z"
        fill="#F38C28"
      />
      <path
        d="M77.6406 265.76V267.88C77.6528 268.03 77.6987 268.175 77.7748 268.305C77.851 268.435 77.9556 268.546 78.0806 268.63L78.5606 268.91C78.8006 269.05 79.0006 268.91 79.0006 268.66V266.54C78.9885 266.39 78.9426 266.244 78.8664 266.115C78.7902 265.985 78.6857 265.874 78.5606 265.79L78.0806 265.51C77.8406 265.37 77.6406 265.48 77.6406 265.76Z"
        fill="#F38C28"
      />
      <path
        d="M79.832 267V269.12C79.8376 269.271 79.8797 269.418 79.9546 269.548C80.0295 269.679 80.135 269.789 80.262 269.87L80.752 270.15C80.992 270.29 81.182 270.15 81.182 269.9V267.8C81.171 267.651 81.1267 267.506 81.0523 267.376C80.9778 267.247 80.8752 267.135 80.752 267.05L80.262 266.77C80.002 266.63 79.832 266.74 79.832 267Z"
        fill="#263238"
      />
      <path
        d="M82 268.279V270.399C82.0056 270.55 82.0477 270.697 82.1226 270.827C82.1975 270.958 82.303 271.069 82.43 271.149L82.92 271.439C83.16 271.569 83.35 271.439 83.35 271.189V269.059C83.339 268.91 83.2947 268.765 83.2202 268.636C83.1458 268.506 83.0432 268.394 82.92 268.309L82.43 268.029C82.21 267.889 82 267.999 82 268.279Z"
        fill="#F38C28"
      />
      <path
        d="M47 254.399V256.529C47.011 256.678 47.0553 256.823 47.1298 256.953C47.2042 257.083 47.3068 257.194 47.43 257.279L47.92 257.559C48.15 257.699 48.35 257.559 48.35 257.309V255.179C48.339 255.03 48.2947 254.885 48.2202 254.755C48.1458 254.626 48.0432 254.514 47.92 254.429L47.43 254.149C47.2 253.999 47 254.129 47 254.399Z"
        fill="#F38C28"
      />
      <path
        d="M49.1914 255.66V257.79C49.2036 257.94 49.2494 258.085 49.3256 258.215C49.4018 258.345 49.5063 258.456 49.6314 258.54L50.1114 258.82C50.3514 258.96 50.5514 258.82 50.5514 258.57V256.45C50.5439 256.299 50.5 256.152 50.4233 256.021C50.3467 255.89 50.2397 255.78 50.1114 255.7L49.6314 255.41C49.3914 255.28 49.1914 255.39 49.1914 255.66Z"
        fill="#F38C28"
      />
      <path
        d="M51.3828 256.93V259.05C51.3938 259.199 51.4382 259.344 51.5126 259.474C51.587 259.604 51.6896 259.715 51.8128 259.8L52.3028 260.08C52.5428 260.22 52.7428 260.08 52.7428 259.83V257.71C52.7307 257.56 52.6848 257.414 52.6086 257.285C52.5324 257.155 52.4279 257.044 52.3028 256.96L51.8128 256.68C51.5828 256.54 51.3828 256.65 51.3828 256.93Z"
        fill="#F38C28"
      />
      <path
        d="M53.5703 258.189V260.309C53.5813 260.459 53.6257 260.604 53.7001 260.733C53.7745 260.863 53.8771 260.975 54.0003 261.059L54.4903 261.339C54.7303 261.479 54.9203 261.339 54.9203 261.089V258.999C54.9093 258.85 54.865 258.705 54.7906 258.576C54.7161 258.446 54.6135 258.334 54.4903 258.249L54.0003 257.969C53.7603 257.799 53.5703 257.909 53.5703 258.189Z"
        fill="#F38C28"
      />
      <path
        d="M55.7617 259.449V261.569C55.7673 261.72 55.8094 261.867 55.8843 261.997C55.9592 262.128 56.0647 262.238 56.1917 262.319L56.6817 262.609C56.9217 262.739 57.1117 262.609 57.1117 262.359V260.229C57.1007 260.08 57.0564 259.935 56.982 259.805C56.9075 259.676 56.8049 259.564 56.6817 259.479L56.1917 259.199C56.0017 259.059 55.7617 259.169 55.7617 259.449Z"
        fill="#263238"
      />
      <path
        d="M58 260.711V262.841C58.011 262.99 58.0553 263.135 58.1298 263.265C58.2042 263.395 58.3068 263.506 58.43 263.591L58.92 263.871C59.16 264.011 59.35 263.871 59.35 263.621V261.491C59.339 261.342 59.2947 261.197 59.2202 261.067C59.1458 260.937 59.0432 260.826 58.92 260.741L58.43 260.461C58.14 260.321 58 260.431 58 260.711Z"
        fill="#263238"
      />
      <path
        d="M60.1406 262V264.13C60.1516 264.279 60.196 264.424 60.2704 264.554C60.3448 264.683 60.4474 264.795 60.5706 264.88L61.0606 265.16C61.2906 265.3 61.4906 265.16 61.4906 264.91V262.78C61.4796 262.63 61.4353 262.486 61.3609 262.356C61.2864 262.226 61.1838 262.115 61.0606 262.03L60.5706 261.75C60.3306 261.58 60.1406 261.7 60.1406 262Z"
        fill="#F38C28"
      />
      <path
        d="M62.3203 263.231V265.361C62.3325 265.511 62.3783 265.656 62.4545 265.786C62.5307 265.916 62.6352 266.027 62.7603 266.111L63.2403 266.391C63.4803 266.531 63.6803 266.391 63.6803 266.141V264.001C63.6728 263.849 63.6289 263.702 63.5522 263.572C63.4756 263.441 63.3686 263.331 63.2403 263.251L62.7603 262.961C62.5203 262.851 62.3203 263.001 62.3203 263.231Z"
        fill="#F38C28"
      />
      <path
        d="M64.5117 264.5V266.62C64.5227 266.769 64.5671 266.914 64.6415 267.044C64.7159 267.174 64.8185 267.285 64.9417 267.37L65.4317 267.65C65.6717 267.79 65.8717 267.65 65.8717 267.4V265.28C65.8642 265.129 65.8203 264.982 65.7437 264.851C65.667 264.721 65.56 264.61 65.4317 264.53L64.9417 264.25C64.7117 264.11 64.5117 264.22 64.5117 264.5Z"
        fill="#F38C28"
      />
      <path
        d="M66.7031 265.76V267.88C66.7141 268.029 66.7585 268.174 66.8329 268.304C66.9073 268.434 67.0099 268.545 67.1331 268.63L67.6231 268.91C67.8631 269.05 68.0531 268.91 68.0531 268.66V266.54C68.0421 266.391 67.9978 266.246 67.9234 266.116C67.8489 265.986 67.7463 265.875 67.6231 265.79L67.1331 265.51C66.8931 265.37 66.7031 265.48 66.7031 265.76Z"
        fill="#F38C28"
      />
      <path
        d="M68.8906 267V269.12C68.8962 269.271 68.9383 269.418 69.0132 269.548C69.0881 269.679 69.1936 269.789 69.3206 269.87L69.8106 270.15C70.0506 270.29 70.2406 270.15 70.2406 269.9V267.8C70.2296 267.651 70.1853 267.506 70.1109 267.376C70.0364 267.247 69.9338 267.135 69.8106 267.05L69.3206 266.77C69.0806 266.63 68.8906 266.74 68.8906 267Z"
        fill="#F38C28"
      />
      <path
        d="M71.082 268.279V270.399C71.0876 270.55 71.1297 270.697 71.2046 270.827C71.2795 270.958 71.385 271.069 71.512 271.149L72.002 271.439C72.242 271.569 72.432 271.439 72.432 271.189V269.059C72.421 268.91 72.3767 268.765 72.3023 268.636C72.2278 268.506 72.1252 268.394 72.002 268.309L71.512 268.029C71.272 267.889 71.082 267.999 71.082 268.279Z"
        fill="#263238"
      />
      <path
        d="M73.2695 269.539V271.669C73.2805 271.819 73.3249 271.963 73.3993 272.093C73.4737 272.223 73.5763 272.334 73.6995 272.419L74.1895 272.699C74.4195 272.839 74.6195 272.699 74.6195 272.449V270.319C74.6085 270.17 74.5642 270.025 74.4898 269.895C74.4153 269.766 74.3128 269.654 74.1895 269.569L73.6995 269.289C73.4595 269.149 73.2695 269.269 73.2695 269.539Z"
        fill="#F38C28"
      />
      <path
        d="M75.4527 270.799V272.929C75.4648 273.079 75.5107 273.225 75.5869 273.355C75.6631 273.485 75.7676 273.596 75.8927 273.679L76.3727 273.959C76.6127 274.099 76.8127 273.959 76.8127 273.709V271.579C76.8005 271.429 76.7547 271.284 76.6785 271.154C76.6023 271.024 76.4978 270.913 76.3727 270.829L75.8927 270.549C75.8505 270.514 75.7985 270.492 75.7436 270.487C75.6888 270.482 75.6337 270.494 75.5858 270.522C75.538 270.549 75.4995 270.59 75.4757 270.64C75.4519 270.689 75.4439 270.745 75.4527 270.799Z"
        fill="#F38C28"
      />
      <path
        d="M77.6406 272.06V274.19C77.6528 274.34 77.6987 274.486 77.7748 274.616C77.851 274.746 77.9556 274.857 78.0806 274.94L78.5606 275.22C78.8006 275.36 79.0006 275.22 79.0006 274.97V272.85C78.9931 272.699 78.9492 272.552 78.8726 272.421C78.796 272.291 78.6889 272.181 78.5606 272.1L78.0806 271.81C77.8406 271.68 77.6406 271.79 77.6406 272.06Z"
        fill="#F38C28"
      />
      <path
        d="M79.832 273.33V275.45C79.843 275.599 79.8874 275.744 79.9618 275.874C80.0362 276.004 80.1388 276.115 80.262 276.2L80.752 276.48C80.992 276.62 81.182 276.48 81.182 276.23V274.11C81.171 273.961 81.1267 273.816 81.0523 273.686C80.9778 273.557 80.8752 273.445 80.752 273.36L80.262 273.08C80.002 272.94 79.832 273.05 79.832 273.33Z"
        fill="#F38C28"
      />
      <path
        d="M82 274.59V276.71C82.011 276.859 82.0553 277.004 82.1298 277.134C82.2042 277.264 82.3068 277.375 82.43 277.46L82.92 277.74C83.16 277.88 83.35 277.74 83.35 277.49V275.37C83.339 275.221 83.2947 275.076 83.2202 274.946C83.1458 274.816 83.0432 274.705 82.92 274.62L82.43 274.34C82.21 274.2 82 274.31 82 274.59Z"
        fill="#F38C28"
      />
      <path
        d="M89.332 275.481L90.332 274.901C90.5448 274.805 90.7791 274.768 91.0109 274.793C91.2428 274.817 91.464 274.903 91.652 275.041C92.1993 275.396 92.6549 275.875 92.9816 276.44C93.3084 277.005 93.4969 277.639 93.532 278.291C93.5563 278.524 93.5183 278.76 93.4217 278.975C93.325 279.189 93.1733 279.374 92.982 279.511L92.062 280.041L91.892 279.761C91.7025 279.718 91.5204 279.647 91.352 279.551C90.8045 279.193 90.349 278.712 90.0223 278.145C89.6957 277.579 89.5072 276.943 89.472 276.291C89.4711 276.129 89.4912 275.967 89.532 275.811L89.332 275.481Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M89.332 275.481L90.332 274.901C90.5448 274.805 90.7791 274.768 91.0109 274.793C91.2428 274.817 91.464 274.903 91.652 275.041C92.1993 275.396 92.6549 275.875 92.9816 276.44C93.3084 277.005 93.4969 277.639 93.532 278.291C93.5563 278.524 93.5183 278.76 93.4217 278.975C93.325 279.189 93.1733 279.374 92.982 279.511L92.062 280.041L91.892 279.761C91.7025 279.718 91.5204 279.647 91.352 279.551C90.8045 279.193 90.349 278.712 90.0223 278.145C89.6957 277.579 89.5072 276.943 89.472 276.291C89.4711 276.129 89.4912 275.967 89.532 275.811L89.332 275.481Z"
        fill="black"
      />
      <path
        d="M90.7003 275.58C91.2478 275.937 91.7034 276.418 92.03 276.985C92.3567 277.551 92.5452 278.187 92.5803 278.84C92.5803 280.04 91.7403 280.53 90.7003 279.93C90.1528 279.572 89.6972 279.091 89.3706 278.524C89.044 277.958 88.8554 277.322 88.8203 276.67C88.8203 275.47 89.6603 275 90.7003 275.58Z"
        fill="#F38C28"
      />
      <path
        d="M97.5 280.19L98.5 279.62C98.7112 279.52 98.9455 279.479 99.178 279.502C99.4105 279.525 99.6324 279.611 99.82 279.75C100.366 280.106 100.821 280.586 101.148 281.151C101.474 281.715 101.663 282.349 101.7 283C101.724 283.234 101.686 283.47 101.59 283.684C101.493 283.898 101.341 284.083 101.15 284.22L100.23 284.75L100.06 284.47C99.8705 284.428 99.6884 284.357 99.52 284.26C98.9725 283.903 98.5169 283.421 98.1903 282.855C97.8637 282.288 97.6751 281.653 97.64 281C97.6377 280.838 97.6579 280.676 97.7 280.52L97.5 280.19Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M97.5 280.19L98.5 279.62C98.7112 279.52 98.9455 279.479 99.178 279.502C99.4105 279.525 99.6324 279.611 99.82 279.75C100.366 280.106 100.821 280.586 101.148 281.151C101.474 281.715 101.663 282.349 101.7 283C101.724 283.234 101.686 283.47 101.59 283.684C101.493 283.898 101.341 284.083 101.15 284.22L100.23 284.75L100.06 284.47C99.8705 284.428 99.6884 284.357 99.52 284.26C98.9725 283.903 98.5169 283.421 98.1903 282.855C97.8637 282.288 97.6751 281.653 97.64 281C97.6377 280.838 97.6579 280.676 97.7 280.52L97.5 280.19Z"
        fill="black"
      />
      <path
        d="M98.87 280.301C99.4175 280.658 99.8731 281.14 100.2 281.706C100.526 282.273 100.715 282.908 100.75 283.561C100.75 284.761 99.91 285.241 98.87 284.641C98.3251 284.284 97.8719 283.804 97.547 283.239C97.2222 282.675 97.0348 282.042 97 281.391C97 280.181 97.83 279.701 98.87 280.301Z"
        fill="#F38C28"
      />
      <path
        d="M42.9414 212.421L107.941 249.941L172.931 212.421L107.941 174.891L42.9414 212.421Z"
        fill="#263238"
      />
      <path d="M42.9414 231.18L107.941 268.7V249.94L42.9414 212.42V231.18Z" fill="#455A64" />
      <path d="M107.941 268.7L172.931 231.18V212.42L107.941 249.94V268.7Z" fill="#37474F" />
      <path d="M51.0703 240.561V235.871L107.94 268.701V273.391L51.0703 240.561Z" fill="#F38C28" />
      <path d="M168.871 233.52V238.21L107.941 273.39V268.7L168.871 233.52Z" fill="#F38C28" />
      <path
        opacity="0.2"
        d="M168.871 233.52V238.21L107.941 273.39V268.7L168.871 233.52Z"
        fill="black"
      />
      <path
        d="M47 220.001V222.131C47.011 222.28 47.0553 222.425 47.1298 222.555C47.2042 222.685 47.3068 222.796 47.43 222.881L47.92 223.161C48.15 223.301 48.35 223.161 48.35 222.911V220.781C48.339 220.632 48.2947 220.487 48.2202 220.357C48.1458 220.227 48.0432 220.116 47.92 220.031L47.43 219.751C47.2 219.561 47 219.681 47 220.001Z"
        fill="#F38C28"
      />
      <path
        d="M49.1914 221.211V223.341C49.2036 223.491 49.2494 223.636 49.3256 223.766C49.4018 223.896 49.5063 224.007 49.6314 224.091L50.1114 224.371C50.3514 224.511 50.5514 224.371 50.5514 224.121V222.001C50.5439 221.85 50.5 221.702 50.4233 221.572C50.3467 221.441 50.2397 221.331 50.1114 221.251L49.6314 220.961C49.3914 220.831 49.1914 220.941 49.1914 221.211Z"
        fill="#F38C28"
      />
      <path
        d="M51.3828 222.481V224.601C51.3938 224.75 51.4382 224.895 51.5126 225.024C51.587 225.154 51.6896 225.266 51.8128 225.351L52.3028 225.631C52.5428 225.771 52.7428 225.631 52.7428 225.381V223.261C52.7307 223.111 52.6848 222.965 52.6086 222.835C52.5324 222.705 52.4279 222.594 52.3028 222.511L51.8128 222.231C51.5828 222.091 51.3828 222.201 51.3828 222.481Z"
        fill="#F38C28"
      />
      <path
        d="M53.5703 223.74V225.86C53.5813 226.01 53.6257 226.154 53.7001 226.284C53.7745 226.414 53.8771 226.525 54.0003 226.61L54.4903 226.89C54.7303 227.03 54.9203 226.89 54.9203 226.64V224.52C54.9093 224.371 54.865 224.226 54.7906 224.096C54.7161 223.967 54.6135 223.855 54.4903 223.77L54.0003 223.49C53.7603 223.35 53.5703 223.46 53.5703 223.74Z"
        fill="#263238"
      />
      <path
        d="M55.7617 225V227.12C55.7673 227.271 55.8094 227.418 55.8843 227.548C55.9592 227.679 56.0647 227.789 56.1917 227.87L56.6817 228.16C56.9217 228.29 57.1117 228.16 57.1117 227.91V225.78C57.1007 225.631 57.0564 225.486 56.982 225.356C56.9075 225.226 56.8049 225.115 56.6817 225.03L56.1917 224.75C56.0017 224.61 55.7617 224.72 55.7617 225Z"
        fill="#263238"
      />
      <path
        d="M58 226.259V228.389C58.011 228.538 58.0553 228.683 58.1298 228.813C58.2042 228.943 58.3068 229.054 58.43 229.139L58.92 229.419C59.16 229.549 59.35 229.419 59.35 229.169V226.999C59.339 226.85 59.2947 226.705 59.2202 226.575C59.1458 226.446 59.0432 226.334 58.92 226.249L58.43 225.969C58.14 225.869 58 225.999 58 226.259Z"
        fill="#F38C28"
      />
      <path
        d="M60.1406 227.52V229.65C60.1516 229.799 60.196 229.944 60.2704 230.074C60.3448 230.203 60.4474 230.315 60.5706 230.4L61.0606 230.68C61.2906 230.82 61.4906 230.68 61.4906 230.43V228.3C61.4796 228.151 61.4353 228.006 61.3609 227.876C61.2864 227.746 61.1838 227.635 61.0606 227.55L60.5706 227.27C60.3306 227.13 60.1406 227.25 60.1406 227.52Z"
        fill="#F38C28"
      />
      <path
        d="M62.3203 228.781V230.911C62.3325 231.061 62.3783 231.207 62.4545 231.336C62.5307 231.466 62.6352 231.577 62.7603 231.661L63.2403 231.941C63.4803 232.081 63.6803 231.941 63.6803 231.691V229.561C63.6682 229.411 63.6223 229.266 63.5461 229.136C63.4699 229.006 63.3654 228.895 63.2403 228.811L62.7603 228.531C62.5203 228.401 62.3203 228.511 62.3203 228.781Z"
        fill="#F38C28"
      />
      <path
        d="M64.5117 230.051V232.171C64.5227 232.32 64.5671 232.465 64.6415 232.595C64.7159 232.725 64.8185 232.836 64.9417 232.921L65.4317 233.201C65.6717 233.341 65.8717 233.201 65.8717 232.951V230.831C65.8642 230.68 65.8203 230.533 65.7437 230.402C65.667 230.271 65.56 230.161 65.4317 230.081L64.9417 229.801C64.7117 229.661 64.5117 229.771 64.5117 230.051Z"
        fill="#F38C28"
      />
      <path
        d="M66.7031 231.311V233.431C66.7141 233.58 66.7585 233.725 66.8329 233.855C66.9073 233.984 67.0099 234.096 67.1331 234.181L67.6231 234.461C67.8631 234.601 68.0531 234.461 68.0531 234.211V232.091C68.0421 231.941 67.9978 231.797 67.9234 231.667C67.8489 231.537 67.7463 231.426 67.6231 231.341L67.1331 231.061C66.8931 230.921 66.7031 231.001 66.7031 231.311Z"
        fill="#F38C28"
      />
      <path
        d="M68.8906 232.57V234.69C68.8962 234.841 68.9383 234.988 69.0132 235.118C69.0881 235.249 69.1936 235.36 69.3206 235.44L69.8106 235.72C70.0506 235.86 70.2406 235.72 70.2406 235.47V233.35C70.2296 233.201 70.1853 233.056 70.1109 232.927C70.0364 232.797 69.9338 232.685 69.8106 232.6L69.3206 232.32C69.0806 232.18 68.8906 232.29 68.8906 232.57Z"
        fill="#F38C28"
      />
      <path
        d="M71.082 233.831V236.001C71.0876 236.151 71.1297 236.298 71.2046 236.429C71.2795 236.559 71.385 236.67 71.512 236.751L72.002 237.001C72.242 237.131 72.432 237.001 72.432 236.751V234.621C72.421 234.471 72.3767 234.327 72.3023 234.197C72.2278 234.067 72.1252 233.956 72.002 233.871L71.512 233.591C71.272 233.441 71.082 233.551 71.082 233.831Z"
        fill="#F38C28"
      />
      <path
        d="M73.2695 235.09V237.22C73.2805 237.369 73.3249 237.514 73.3993 237.644C73.4737 237.774 73.5763 237.885 73.6995 237.97L74.1895 238.25C74.4195 238.39 74.6195 238.25 74.6195 238V235.87C74.6085 235.721 74.5642 235.576 74.4898 235.446C74.4153 235.316 74.3128 235.205 74.1895 235.12L73.6995 234.84C73.4595 234.7 73.2695 234.81 73.2695 235.09Z"
        fill="#263238"
      />
      <path
        d="M75.4527 236.35V238.48C75.4648 238.63 75.5107 238.776 75.5869 238.906C75.6631 239.035 75.7676 239.146 75.8927 239.23L76.3727 239.51C76.6127 239.65 76.8127 239.51 76.8127 239.26V237.13C76.8005 236.98 76.7547 236.835 76.6785 236.705C76.6023 236.575 76.4978 236.464 76.3727 236.38L75.8927 236.1C75.8505 236.065 75.7985 236.043 75.7436 236.038C75.6888 236.033 75.6337 236.045 75.5858 236.072C75.538 236.1 75.4995 236.141 75.4757 236.19C75.4519 236.24 75.4439 236.296 75.4527 236.35Z"
        fill="#F38C28"
      />
      <path
        d="M77.6406 237.609V239.739C77.6528 239.889 77.6987 240.035 77.7748 240.165C77.851 240.294 77.9556 240.405 78.0806 240.489L78.5606 240.769C78.8006 240.909 79.0006 240.769 79.0006 240.519V238.399C78.9931 238.248 78.9492 238.101 78.8726 237.97C78.796 237.84 78.6889 237.73 78.5606 237.649L78.0806 237.359C77.8406 237.229 77.6406 237.339 77.6406 237.609Z"
        fill="#F38C28"
      />
      <path
        d="M79.832 238.881V241.001C79.843 241.15 79.8874 241.295 79.9618 241.425C80.0362 241.555 80.1388 241.666 80.262 241.751L80.752 242.031C80.992 242.171 81.182 242.031 81.182 241.781V239.661C81.171 239.512 81.1267 239.367 81.0523 239.237C80.9778 239.107 80.8752 238.996 80.752 238.911L80.262 238.631C80.002 238.491 79.832 238.601 79.832 238.881Z"
        fill="#F38C28"
      />
      <path
        d="M82 240.141V242.261C82.011 242.41 82.0553 242.555 82.1298 242.685C82.2042 242.814 82.3068 242.926 82.43 243.011L82.92 243.291C83.16 243.431 83.35 243.291 83.35 243.041V240.921C83.339 240.772 83.2947 240.627 83.2202 240.497C83.1458 240.367 83.0432 240.256 82.92 240.171L82.43 239.891C82.21 239.751 82 239.861 82 240.141Z"
        fill="#F38C28"
      />
      <path
        d="M47 226.259V228.389C47.011 228.538 47.0553 228.683 47.1298 228.813C47.2042 228.943 47.3068 229.054 47.43 229.139L47.92 229.419C47.9624 229.451 48.0133 229.47 48.0663 229.473C48.1193 229.476 48.172 229.463 48.2179 229.437C48.2638 229.41 48.3008 229.371 48.3243 229.323C48.3478 229.275 48.3567 229.222 48.35 229.169V226.999C48.339 226.85 48.2947 226.705 48.2202 226.575C48.1458 226.446 48.0432 226.334 47.92 226.249L47.43 225.969C47.2 225.869 47 225.999 47 226.259Z"
        fill="#F38C28"
      />
      <path
        d="M49.191 227.52V229.65C49.2031 229.8 49.249 229.946 49.3252 230.075C49.4014 230.205 49.5059 230.316 49.631 230.4L50.111 230.68C50.1532 230.716 50.2052 230.737 50.26 230.742C50.3149 230.747 50.3699 230.735 50.4178 230.708C50.4657 230.681 50.5041 230.64 50.5279 230.59C50.5517 230.54 50.5598 230.484 50.551 230.43V228.3C50.5388 228.15 50.4929 228.005 50.4167 227.875C50.3406 227.745 50.236 227.634 50.111 227.55L49.631 227.27C49.5888 227.235 49.5367 227.213 49.4819 227.208C49.4271 227.203 49.372 227.215 49.3241 227.242C49.2762 227.269 49.2378 227.311 49.214 227.36C49.1902 227.41 49.1822 227.466 49.191 227.52Z"
        fill="#263238"
      />
      <path
        d="M51.3811 228.781V230.911C51.3921 231.06 51.4364 231.205 51.5108 231.335C51.5853 231.464 51.6879 231.576 51.8111 231.661L52.3011 231.941C52.5411 232.081 52.7411 231.941 52.7411 231.691V229.561C52.7289 229.411 52.683 229.265 52.6069 229.135C52.5307 229.005 52.4261 228.895 52.3011 228.811L51.8111 228.531C51.7686 228.499 51.7178 228.48 51.6648 228.477C51.6118 228.474 51.5591 228.486 51.5132 228.513C51.4673 228.54 51.4303 228.579 51.4068 228.627C51.3833 228.675 51.3744 228.728 51.3811 228.781Z"
        fill="#263238"
      />
      <path
        d="M53.5703 230.051V232.171C53.5813 232.32 53.6257 232.465 53.7001 232.595C53.7745 232.725 53.8771 232.836 54.0003 232.921L54.4903 233.201C54.7303 233.341 54.9203 233.201 54.9203 232.951V230.831C54.9147 230.68 54.8727 230.534 54.7978 230.403C54.7229 230.272 54.6174 230.162 54.4903 230.081L54.0003 229.801C53.7603 229.661 53.5703 229.771 53.5703 230.051Z"
        fill="#F38C28"
      />
      <path
        d="M55.7617 231.311V233.431C55.7727 233.58 55.8171 233.725 55.8915 233.855C55.9659 233.984 56.0685 234.096 56.1917 234.181L56.6817 234.461C56.9217 234.601 57.1117 234.461 57.1117 234.211V232.091C57.1007 231.941 57.0564 231.797 56.982 231.667C56.9075 231.537 56.8049 231.426 56.6817 231.341L56.1917 231.061C56.0017 230.921 55.7617 231.001 55.7617 231.311Z"
        fill="#F38C28"
      />
      <path
        d="M58 232.57V234.69C58.0056 234.841 58.0477 234.988 58.1226 235.118C58.1975 235.249 58.303 235.36 58.43 235.44L58.92 235.72C59.16 235.86 59.35 235.72 59.35 235.47V233.35C59.339 233.201 59.2947 233.056 59.2202 232.927C59.1458 232.797 59.0432 232.685 58.92 232.6L58.43 232.32C58.14 232.18 58 232.29 58 232.57Z"
        fill="#263238"
      />
      <path
        d="M60.1406 233.83V236C60.1462 236.151 60.1883 236.297 60.2632 236.428C60.3381 236.559 60.4436 236.669 60.5706 236.75L61.0606 237.04C61.1031 237.072 61.1539 237.091 61.2069 237.094C61.2599 237.097 61.3126 237.084 61.3585 237.058C61.4044 237.031 61.4414 236.991 61.4649 236.944C61.4884 236.896 61.4973 236.843 61.4906 236.79V234.66C61.4796 234.511 61.4353 234.366 61.3609 234.236C61.2864 234.106 61.1838 233.995 61.0606 233.91L60.5706 233.63C60.3306 233.44 60.1406 233.55 60.1406 233.83Z"
        fill="#F38C28"
      />
      <path
        d="M62.3203 235.09V237.22C62.3325 237.37 62.3783 237.515 62.4545 237.645C62.5307 237.775 62.6352 237.886 62.7603 237.97L63.2403 238.25C63.2825 238.285 63.3345 238.307 63.3894 238.312C63.4442 238.317 63.4993 238.305 63.5472 238.278C63.595 238.251 63.6335 238.209 63.6573 238.16C63.6811 238.11 63.6891 238.054 63.6803 238V235.87C63.6682 235.72 63.6223 235.575 63.5461 235.445C63.4699 235.315 63.3654 235.204 63.2403 235.12L62.7603 234.84C62.5203 234.7 62.3203 234.81 62.3203 235.09Z"
        fill="#F38C28"
      />
      <path
        d="M64.5117 236.35V238.48C64.5227 238.629 64.5671 238.774 64.6415 238.904C64.7159 239.034 64.8185 239.145 64.9417 239.23L65.4317 239.51C65.6717 239.65 65.8717 239.51 65.8717 239.26V237.13C65.8596 236.98 65.8137 236.835 65.7375 236.705C65.6613 236.575 65.5568 236.464 65.4317 236.38L64.9417 236.1C64.7117 236 64.5117 236.08 64.5117 236.35Z"
        fill="#F38C28"
      />
      <path
        d="M66.7031 237.609V239.739C66.7141 239.888 66.7585 240.033 66.8329 240.163C66.9073 240.293 67.0099 240.404 67.1331 240.489L67.6231 240.769C67.8631 240.909 68.0531 240.769 68.0531 240.519V238.399C68.0475 238.249 68.0055 238.102 67.9306 237.971C67.8557 237.841 67.7502 237.73 67.6231 237.649L67.1331 237.359C66.8931 237.229 66.7031 237.339 66.7031 237.609Z"
        fill="#F38C28"
      />
      <path
        d="M68.8906 238.881V241.001C68.9016 241.15 68.946 241.295 69.0204 241.425C69.0948 241.555 69.1974 241.666 69.3206 241.751L69.8106 242.031C70.0506 242.171 70.2406 242.031 70.2406 241.781V239.661C70.2296 239.512 70.1853 239.367 70.1109 239.237C70.0364 239.107 69.9338 238.996 69.8106 238.911L69.3206 238.631C69.0806 238.491 68.8906 238.601 68.8906 238.881Z"
        fill="#263238"
      />
      <path
        d="M71.082 240.141V242.261C71.093 242.41 71.1374 242.555 71.2118 242.685C71.2862 242.814 71.3888 242.926 71.512 243.011L72.002 243.291C72.242 243.431 72.432 243.291 72.432 243.041V240.921C72.421 240.772 72.3767 240.627 72.3023 240.497C72.2278 240.367 72.1252 240.256 72.002 240.171L71.512 239.891C71.272 239.751 71.082 239.861 71.082 240.141Z"
        fill="#263238"
      />
      <path
        d="M73.2695 241.401V243.521C73.2751 243.672 73.3172 243.818 73.3921 243.949C73.467 244.08 73.5725 244.19 73.6995 244.271L74.1895 244.561C74.232 244.593 74.2829 244.612 74.3358 244.615C74.3888 244.618 74.4415 244.605 74.4874 244.579C74.5333 244.552 74.5703 244.512 74.5938 244.465C74.6173 244.417 74.6262 244.364 74.6195 244.311V242.181C74.6085 242.032 74.5642 241.887 74.4898 241.757C74.4153 241.627 74.3128 241.516 74.1895 241.431L73.6995 241.151C73.4595 241.001 73.2695 241.121 73.2695 241.401Z"
        fill="#F38C28"
      />
      <path
        d="M75.4531 242.66V244.79C75.4653 244.94 75.5112 245.086 75.5873 245.216C75.6635 245.345 75.7681 245.456 75.8931 245.54L76.3731 245.82C76.6131 245.95 76.8131 245.82 76.8131 245.57V243.44C76.801 243.29 76.7551 243.145 76.6789 243.015C76.6027 242.885 76.4982 242.774 76.3731 242.69L75.8931 242.41C75.6531 242.27 75.4531 242.38 75.4531 242.66Z"
        fill="#F38C28"
      />
      <path
        d="M77.6402 243.921V246.051C77.6523 246.201 77.6982 246.346 77.7744 246.476C77.8506 246.606 77.9551 246.717 78.0802 246.801L78.5602 247.081C78.6024 247.116 78.6544 247.138 78.7092 247.142C78.7641 247.147 78.8191 247.136 78.867 247.108C78.9149 247.081 78.9533 247.04 78.9771 246.99C79.0009 246.941 79.009 246.885 79.0002 246.831V244.701C78.988 244.55 78.9422 244.405 78.866 244.275C78.7898 244.145 78.6852 244.034 78.5602 243.951L78.0802 243.671C78.038 243.635 77.986 243.614 77.9311 243.609C77.8763 243.604 77.8212 243.615 77.7733 243.643C77.7255 243.67 77.687 243.711 77.6632 243.761C77.6394 243.81 77.6314 243.866 77.6402 243.921Z"
        fill="#F38C28"
      />
      <path
        d="M79.832 245.18V247.31C79.843 247.459 79.8874 247.604 79.9618 247.734C80.0362 247.863 80.1388 247.975 80.262 248.06L80.752 248.34C80.992 248.48 81.182 248.34 81.182 248.09V246C81.171 245.851 81.1267 245.706 81.0523 245.576C80.9778 245.446 80.8752 245.335 80.752 245.25L80.262 244.97C80.002 244.8 79.832 244.91 79.832 245.18Z"
        fill="#263238"
      />
      <path
        d="M82 246.439V248.569C82.011 248.719 82.0553 248.863 82.1298 248.993C82.2042 249.123 82.3068 249.234 82.43 249.319L82.92 249.599C83.16 249.739 83.35 249.599 83.35 249.349V247.229C83.3444 247.079 83.3023 246.932 83.2274 246.801C83.1525 246.671 83.047 246.56 82.92 246.479L82.43 246.189C82.21 246.059 82 246.169 82 246.439Z"
        fill="#F38C28"
      />
      <path
        d="M89.332 247.33L90.332 246.76C90.544 246.663 90.7777 246.624 91.0095 246.647C91.2414 246.67 91.463 246.754 91.652 246.89C92.1995 247.247 92.6551 247.729 92.9817 248.295C93.3084 248.861 93.4969 249.497 93.532 250.15C93.5563 250.384 93.5183 250.62 93.4217 250.834C93.325 251.048 93.1733 251.233 92.982 251.37L92.062 251.9L91.892 251.62C91.7025 251.577 91.5204 251.507 91.352 251.41C90.8045 251.052 90.349 250.571 90.0223 250.005C89.6957 249.438 89.5072 248.803 89.472 248.15C89.4703 247.988 89.4905 247.826 89.532 247.67L89.332 247.33Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M89.332 247.33L90.332 246.76C90.544 246.663 90.7777 246.624 91.0095 246.647C91.2414 246.67 91.463 246.754 91.652 246.89C92.1995 247.247 92.6551 247.729 92.9817 248.295C93.3084 248.861 93.4969 249.497 93.532 250.15C93.5563 250.384 93.5183 250.62 93.4217 250.834C93.325 251.048 93.1733 251.233 92.982 251.37L92.062 251.9L91.892 251.62C91.7025 251.577 91.5204 251.507 91.352 251.41C90.8045 251.052 90.349 250.571 90.0223 250.005C89.6957 249.438 89.5072 248.803 89.472 248.15C89.4703 247.988 89.4905 247.826 89.532 247.67L89.332 247.33Z"
        fill="black"
      />
      <path
        d="M90.7003 247.44C91.2478 247.797 91.7034 248.279 92.03 248.845C92.3567 249.412 92.5452 250.047 92.5803 250.7C92.5803 251.9 91.7403 252.39 90.7003 251.79C90.1528 251.432 89.6972 250.951 89.3706 250.385C89.044 249.818 88.8554 249.183 88.8203 248.53C88.8203 247.33 89.6603 246.84 90.7003 247.44Z"
        fill="#F38C28"
      />
      <path
        d="M97.5 252.051L98.5 251.481C98.7128 251.385 98.947 251.348 99.1789 251.373C99.4107 251.397 99.6319 251.483 99.82 251.621C100.368 251.978 100.823 252.459 101.15 253.026C101.476 253.592 101.665 254.228 101.7 254.881C101.726 255.113 101.688 255.348 101.591 255.561C101.495 255.774 101.342 255.957 101.15 256.091L100.23 256.611L100.06 256.341C99.8719 256.294 99.6904 256.223 99.52 256.131C98.9725 255.773 98.5169 255.292 98.1903 254.725C97.8637 254.159 97.6751 253.523 97.64 252.871C97.6377 252.709 97.6579 252.547 97.7 252.391L97.5 252.051Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M97.5 252.051L98.5 251.481C98.7128 251.385 98.947 251.348 99.1789 251.373C99.4107 251.397 99.6319 251.483 99.82 251.621C100.368 251.978 100.823 252.459 101.15 253.026C101.476 253.592 101.665 254.228 101.7 254.881C101.726 255.113 101.688 255.348 101.591 255.561C101.495 255.774 101.342 255.957 101.15 256.091L100.23 256.611L100.06 256.341C99.8719 256.294 99.6904 256.223 99.52 256.131C98.9725 255.773 98.5169 255.292 98.1903 254.725C97.8637 254.159 97.6751 253.523 97.64 252.871C97.6377 252.709 97.6579 252.547 97.7 252.391L97.5 252.051Z"
        fill="black"
      />
      <path
        d="M98.87 252.16C99.4175 252.518 99.8731 252.999 100.2 253.565C100.526 254.132 100.715 254.767 100.75 255.42C100.75 256.62 99.91 257.1 98.87 256.5C98.3249 256.141 97.8717 255.659 97.5469 255.093C97.2221 254.527 97.0348 253.892 97 253.24C97 252 97.83 251.56 98.87 252.16Z"
        fill="#F38C28"
      />
      <path
        d="M42.9414 184.27L107.941 221.8L172.931 184.27L107.941 146.75L42.9414 184.27Z"
        fill="#263238"
      />
      <path d="M42.9414 203.04L107.941 240.56V221.8L42.9414 184.27V203.04Z" fill="#455A64" />
      <path d="M107.941 240.56L172.931 203.04V184.27L107.941 221.8V240.56Z" fill="#37474F" />
      <path d="M51.0703 212.421V207.721L107.94 240.561V245.251L51.0703 212.421Z" fill="#F38C28" />
      <path d="M168.871 205.381V210.071L107.941 245.251V240.561L168.871 205.381Z" fill="#F38C28" />
      <path
        opacity="0.2"
        d="M168.871 205.381V210.071L107.941 245.251V240.561L168.871 205.381Z"
        fill="black"
      />
      <path
        d="M47 191.811V193.941C47.011 194.09 47.0553 194.235 47.1298 194.365C47.2042 194.494 47.3068 194.606 47.43 194.691L47.92 194.971C47.9624 195.003 48.0133 195.021 48.0663 195.024C48.1193 195.027 48.172 195.015 48.2179 194.988C48.2638 194.962 48.3008 194.922 48.3243 194.874C48.3478 194.827 48.3567 194.773 48.35 194.721V192.591C48.339 192.441 48.2947 192.297 48.2202 192.167C48.1458 192.037 48.0432 191.926 47.92 191.841L47.43 191.561C47.2 191.421 47 191.531 47 191.811Z"
        fill="#F38C28"
      />
      <path
        d="M49.191 193.071V195.201C49.2031 195.351 49.249 195.496 49.3252 195.626C49.4014 195.756 49.5059 195.867 49.631 195.951L50.111 196.231C50.1532 196.266 50.2052 196.288 50.26 196.293C50.3149 196.298 50.3699 196.286 50.4178 196.259C50.4657 196.232 50.5041 196.19 50.5279 196.141C50.5517 196.091 50.5598 196.035 50.551 195.981V193.851C50.5388 193.701 50.4929 193.555 50.4167 193.426C50.3406 193.296 50.236 193.185 50.111 193.101L49.631 192.821C49.5888 192.786 49.5367 192.764 49.4819 192.759C49.4271 192.754 49.372 192.766 49.3241 192.793C49.2762 192.82 49.2378 192.861 49.214 192.911C49.1902 192.961 49.1822 193.017 49.191 193.071Z"
        fill="#263238"
      />
      <path
        d="M51.3811 194.33V196.46C51.3921 196.609 51.4364 196.754 51.5108 196.883C51.5853 197.013 51.6879 197.125 51.8111 197.21L52.3011 197.49C52.5411 197.63 52.7411 197.49 52.7411 197.24V195.11C52.7289 194.959 52.683 194.814 52.6069 194.684C52.5307 194.554 52.4261 194.443 52.3011 194.36L51.8111 194.08C51.7686 194.048 51.7178 194.029 51.6648 194.026C51.6118 194.023 51.5591 194.035 51.5132 194.062C51.4673 194.089 51.4303 194.128 51.4068 194.176C51.3833 194.223 51.3744 194.277 51.3811 194.33Z"
        fill="#F38C28"
      />
      <path
        d="M53.5703 195.59V197.72C53.5813 197.869 53.6257 198.014 53.7001 198.144C53.7745 198.273 53.8771 198.385 54.0003 198.47L54.4903 198.75C54.7303 198.89 54.9203 198.75 54.9203 198.5V196.38C54.9147 196.229 54.8727 196.082 54.7978 195.952C54.7229 195.821 54.6174 195.711 54.4903 195.63L54.0003 195.34C53.7603 195.21 53.5703 195.32 53.5703 195.59Z"
        fill="#263238"
      />
      <path
        d="M55.7617 196.861V199.001C55.7727 199.15 55.8171 199.295 55.8915 199.424C55.9659 199.554 56.0685 199.666 56.1917 199.751L56.6817 200.031C56.9217 200.171 57.1117 200.031 57.1117 199.781V197.661C57.1007 197.511 57.0564 197.367 56.982 197.237C56.9075 197.107 56.8049 196.995 56.6817 196.911L56.1917 196.631C56.0017 196.471 55.7617 196.581 55.7617 196.861Z"
        fill="#263238"
      />
      <path
        d="M58 198.119V200.239C58.011 200.389 58.0553 200.533 58.1298 200.663C58.2042 200.793 58.3068 200.904 58.43 200.989L58.92 201.269C59.16 201.409 59.35 201.269 59.35 201.019V198.899C59.339 198.75 59.2947 198.605 59.2202 198.475C59.1458 198.346 59.0432 198.234 58.92 198.149L58.43 197.869C58.14 197.729 58 197.839 58 198.119Z"
        fill="#263238"
      />
      <path
        d="M60.1406 199.381V201.501C60.1462 201.651 60.1883 201.798 60.2632 201.929C60.3381 202.059 60.4436 202.17 60.5706 202.251L61.0606 202.54C61.1031 202.572 61.1539 202.591 61.2069 202.594C61.2599 202.597 61.3126 202.585 61.3585 202.558C61.4044 202.531 61.4414 202.492 61.4649 202.444C61.4884 202.397 61.4973 202.343 61.4906 202.29V200.161C61.4796 200.011 61.4353 199.866 61.3609 199.737C61.2864 199.607 61.1838 199.495 61.0606 199.411L60.5706 199.131C60.3306 199.001 60.1406 199.101 60.1406 199.381Z"
        fill="#263238"
      />
      <path
        d="M62.3203 200.641V202.771C62.3325 202.921 62.3783 203.066 62.4545 203.196C62.5307 203.326 62.6352 203.437 62.7603 203.521L63.2403 203.801C63.2825 203.836 63.3345 203.858 63.3894 203.863C63.4442 203.868 63.4993 203.856 63.5472 203.829C63.595 203.801 63.6335 203.76 63.6573 203.711C63.6811 203.661 63.6891 203.605 63.6803 203.551V201.421C63.6682 201.271 63.6223 201.125 63.5461 200.995C63.4699 200.866 63.3654 200.755 63.2403 200.671L62.7603 200.391C62.5203 200.251 62.3203 200.361 62.3203 200.641Z"
        fill="#F38C28"
      />
      <path
        d="M64.5117 201.901V204.001C64.5227 204.15 64.5671 204.295 64.6415 204.425C64.7159 204.554 64.8185 204.666 64.9417 204.751L65.4317 205.031C65.4739 205.066 65.5259 205.088 65.5808 205.093C65.6356 205.098 65.6907 205.086 65.7386 205.059C65.7864 205.031 65.8249 204.99 65.8487 204.94C65.8725 204.891 65.8805 204.835 65.8717 204.781V202.651C65.8596 202.501 65.8137 202.355 65.7375 202.225C65.6613 202.096 65.5568 201.985 65.4317 201.901L64.9417 201.621C64.7117 201.511 64.5117 201.631 64.5117 201.901Z"
        fill="#F38C28"
      />
      <path
        d="M66.7031 203.159V205.289C66.7141 205.438 66.7585 205.583 66.8329 205.713C66.9073 205.843 67.0099 205.954 67.1331 206.039L67.6231 206.319C67.8631 206.459 68.0531 206.319 68.0531 206.069V203.999C68.0475 203.849 68.0055 203.702 67.9306 203.571C67.8557 203.441 67.7502 203.33 67.6231 203.249L67.1331 202.959C66.8931 202.779 66.7031 202.889 66.7031 203.159Z"
        fill="#F38C28"
      />
      <path
        d="M68.8906 204.43V206.55C68.9016 206.699 68.946 206.844 69.0204 206.974C69.0948 207.104 69.1974 207.215 69.3206 207.3L69.8106 207.58C70.0506 207.72 70.2406 207.58 70.2406 207.33V205.21C70.235 205.059 70.193 204.913 70.1181 204.782C70.0432 204.651 69.9377 204.541 69.8106 204.46L69.3206 204.18C69.0806 204 68.8906 204.15 68.8906 204.43Z"
        fill="#F38C28"
      />
      <path
        d="M71.082 205.69V207.81C71.093 207.959 71.1374 208.104 71.2118 208.233C71.2862 208.363 71.3888 208.475 71.512 208.56L72.002 208.84C72.242 208.98 72.432 208.84 72.432 208.59V206.47C72.421 206.32 72.3767 206.176 72.3023 206.046C72.2278 205.916 72.1252 205.804 72.002 205.72L71.512 205.44C71.272 205.3 71.082 205.41 71.082 205.69Z"
        fill="#263238"
      />
      <path
        d="M73.2695 206.999V209.119C73.2751 209.27 73.3172 209.417 73.3921 209.547C73.467 209.678 73.5725 209.788 73.6995 209.869L74.1895 210.149C74.4195 210.289 74.6195 210.149 74.6195 209.899V207.779C74.6085 207.63 74.5642 207.485 74.4898 207.355C74.4153 207.226 74.3128 207.114 74.1895 207.029L73.6995 206.749C73.4595 206.559 73.2695 206.669 73.2695 206.999Z"
        fill="#263238"
      />
      <path
        d="M75.4531 208.21V210.34C75.4653 210.49 75.5112 210.635 75.5873 210.765C75.6635 210.895 75.7681 211.006 75.8931 211.09L76.3731 211.37C76.6131 211.5 76.8131 211.37 76.8131 211.12V209C76.801 208.85 76.7551 208.704 76.6789 208.574C76.6027 208.444 76.4982 208.333 76.3731 208.25L75.8931 207.97C75.6531 207.82 75.4531 207.93 75.4531 208.21Z"
        fill="#263238"
      />
      <path
        d="M77.6402 209.469V211.599C77.6523 211.749 77.6982 211.895 77.7744 212.025C77.8506 212.155 77.9551 212.266 78.0802 212.349L78.5602 212.629C78.6024 212.665 78.6544 212.686 78.7092 212.691C78.7641 212.696 78.8191 212.684 78.867 212.657C78.9149 212.63 78.9533 212.589 78.9771 212.539C79.0009 212.489 79.009 212.434 79.0002 212.379V210.249C78.988 210.099 78.9422 209.954 78.866 209.824C78.7898 209.694 78.6852 209.583 78.5602 209.499L78.0802 209.219C78.038 209.184 77.986 209.162 77.9311 209.157C77.8763 209.152 77.8212 209.164 77.7733 209.191C77.7255 209.219 77.687 209.26 77.6632 209.31C77.6394 209.359 77.6314 209.415 77.6402 209.469Z"
        fill="#F38C28"
      />
      <path
        d="M79.832 210.731V212.861C79.843 213.01 79.8874 213.155 79.9618 213.285C80.0362 213.414 80.1388 213.526 80.262 213.611L80.752 213.891C80.992 214.031 81.182 213.891 81.182 213.641V211.511C81.171 211.362 81.1267 211.217 81.0523 211.087C80.9778 210.957 80.8752 210.846 80.752 210.761L80.262 210.481C80.002 210.341 79.832 210.461 79.832 210.731Z"
        fill="#263238"
      />
      <path
        d="M82 212V214.13C82.011 214.279 82.0553 214.424 82.1298 214.554C82.2042 214.684 82.3068 214.795 82.43 214.88L82.92 215.16C83.16 215.3 83.35 215.16 83.35 214.91V212.79C83.3444 212.64 83.3023 212.493 83.2274 212.362C83.1525 212.231 83.047 212.121 82.92 212.04L82.43 211.75C82.21 211.61 82 211.72 82 212Z"
        fill="#263238"
      />
      <path
        d="M47 198.119V200.239C47.011 200.389 47.0553 200.533 47.1298 200.663C47.2042 200.793 47.3068 200.904 47.43 200.989L47.92 201.269C48.15 201.409 48.35 201.269 48.35 201.019V198.899C48.339 198.75 48.2947 198.605 48.2202 198.475C48.1458 198.346 48.0432 198.234 47.92 198.149L47.43 197.869C47.2 197.729 47 197.839 47 198.119Z"
        fill="#263238"
      />
      <path
        d="M49.1914 199.381V201.501C49.1989 201.652 49.2429 201.799 49.3195 201.929C49.3961 202.06 49.5031 202.17 49.6314 202.251L50.1114 202.54C50.3514 202.67 50.5514 202.54 50.5514 202.29V200.161C50.5393 200.01 50.4934 199.865 50.4172 199.735C50.341 199.605 50.2365 199.494 50.1114 199.411L49.6314 199.131C49.3914 199.001 49.1914 199.101 49.1914 199.381Z"
        fill="#263238"
      />
      <path
        d="M51.3828 200.641V202.771C51.3938 202.92 51.4382 203.065 51.5126 203.195C51.587 203.324 51.6896 203.436 51.8128 203.521L52.3028 203.801C52.345 203.836 52.397 203.858 52.4519 203.863C52.5067 203.868 52.5618 203.856 52.6097 203.829C52.6575 203.801 52.696 203.76 52.7198 203.711C52.7436 203.661 52.7516 203.605 52.7428 203.551V201.421C52.7307 201.271 52.6848 201.125 52.6086 200.995C52.5324 200.866 52.4279 200.755 52.3028 200.671L51.8128 200.391C51.5828 200.251 51.3828 200.361 51.3828 200.641Z"
        fill="#F38C28"
      />
      <path
        d="M53.5703 201.901V204.001C53.5813 204.15 53.6257 204.295 53.7001 204.425C53.7745 204.554 53.8771 204.666 54.0003 204.751L54.4903 205.031C54.7303 205.171 54.9203 205.031 54.9203 204.781V202.651C54.9093 202.501 54.865 202.357 54.7906 202.227C54.7161 202.097 54.6135 201.986 54.4903 201.901L54.0003 201.621C53.7603 201.511 53.5703 201.631 53.5703 201.901Z"
        fill="#263238"
      />
      <path
        d="M55.7617 203.159V205.289C55.7727 205.438 55.8171 205.583 55.8915 205.713C55.9659 205.843 56.0685 205.954 56.1917 206.039L56.6817 206.319C56.9217 206.459 57.1117 206.319 57.1117 206.069V203.999C57.1061 203.849 57.0641 203.702 56.9892 203.571C56.9143 203.441 56.8088 203.33 56.6817 203.249L56.1917 202.959C56.0017 202.779 55.7617 202.889 55.7617 203.159Z"
        fill="#263238"
      />
      <path
        d="M58 204.43V206.55C58.011 206.699 58.0553 206.844 58.1298 206.974C58.2042 207.104 58.3068 207.215 58.43 207.3L58.92 207.58C59.16 207.72 59.35 207.58 59.35 207.33V205.21C59.3444 205.059 59.3023 204.913 59.2274 204.782C59.1525 204.651 59.047 204.541 58.92 204.46L58.43 204.18C58.14 204 58 204.15 58 204.43Z"
        fill="#263238"
      />
      <path
        d="M60.1406 205.69V207.81C60.1516 207.959 60.196 208.104 60.2704 208.233C60.3448 208.363 60.4474 208.475 60.5706 208.56L61.0606 208.84C61.2906 208.98 61.4906 208.84 61.4906 208.59V206.47C61.4796 206.32 61.4353 206.176 61.3609 206.046C61.2864 205.916 61.1838 205.804 61.0606 205.72L60.5706 205.44C60.3306 205.3 60.1406 205.41 60.1406 205.69Z"
        fill="#263238"
      />
      <path
        d="M62.3203 206.999V209.119C62.3278 209.27 62.3718 209.418 62.4484 209.548C62.525 209.679 62.632 209.789 62.7603 209.869L63.2403 210.149C63.4803 210.289 63.6803 210.149 63.6803 209.899V207.779C63.6682 207.629 63.6223 207.484 63.5461 207.354C63.4699 207.224 63.3654 207.113 63.2403 207.029L62.7603 206.749C62.5203 206.559 62.3203 206.669 62.3203 206.999Z"
        fill="#F38C28"
      />
      <path
        d="M64.5117 208.21V210.34C64.5227 210.489 64.5671 210.634 64.6415 210.763C64.7159 210.893 64.8185 211.005 64.9417 211.09L65.4317 211.37C65.6717 211.5 65.8717 211.37 65.8717 211.12V209C65.8596 208.85 65.8137 208.704 65.7375 208.574C65.6613 208.444 65.5568 208.333 65.4317 208.25L64.9417 207.97C64.7117 207.82 64.5117 207.93 64.5117 208.21Z"
        fill="#263238"
      />
      <path
        d="M66.7031 209.471V211.601C66.7141 211.75 66.7585 211.895 66.8329 212.025C66.9073 212.155 67.0099 212.266 67.1331 212.351L67.6231 212.631C67.8631 212.771 68.0531 212.631 68.0531 212.381V210.251C68.0421 210.102 67.9978 209.957 67.9234 209.827C67.8489 209.697 67.7463 209.586 67.6231 209.501L67.1331 209.221C66.8931 209.081 66.7031 209.201 66.7031 209.471Z"
        fill="#263238"
      />
      <path
        d="M68.8906 210.731V212.861C68.9016 213.01 68.946 213.155 69.0204 213.285C69.0948 213.414 69.1974 213.526 69.3206 213.611L69.8106 213.891C70.0506 214.031 70.2406 213.891 70.2406 213.641V211.511C70.2296 211.362 70.1853 211.217 70.1109 211.087C70.0364 210.957 69.9338 210.846 69.8106 210.761L69.3206 210.481C69.0806 210.341 68.8906 210.461 68.8906 210.731Z"
        fill="#263238"
      />
      <path
        d="M71.082 212V214.13C71.093 214.279 71.1374 214.424 71.2118 214.554C71.2862 214.684 71.3888 214.795 71.512 214.88L72.002 215.16C72.242 215.3 72.432 215.16 72.432 214.91V212.79C72.433 212.633 72.3941 212.478 72.3189 212.34C72.2437 212.201 72.1347 212.085 72.002 212L71.512 211.71C71.272 211.61 71.082 211.72 71.082 212Z"
        fill="#F38C28"
      />
      <path
        d="M73.2695 213.26V215.38C73.2805 215.529 73.3249 215.674 73.3993 215.804C73.4737 215.934 73.5763 216.045 73.6995 216.13L74.1895 216.41C74.4195 216.55 74.6195 216.41 74.6195 216.16V214C74.6085 213.851 74.5642 213.706 74.4898 213.576C74.4153 213.447 74.3128 213.335 74.1895 213.25L73.6995 213C73.4595 212.87 73.2695 213 73.2695 213.26Z"
        fill="#F38C28"
      />
      <path
        d="M75.4531 214.52V216.64C75.4653 216.79 75.5112 216.935 75.5873 217.065C75.6635 217.195 75.7681 217.306 75.8931 217.39L76.3731 217.67C76.6131 217.81 76.8131 217.67 76.8131 217.42V215.3C76.801 215.15 76.7551 215.004 76.6789 214.874C76.6027 214.744 76.4982 214.633 76.3731 214.55L75.8931 214.27C75.6531 214.13 75.4531 214.24 75.4531 214.52Z"
        fill="#263238"
      />
      <path
        d="M77.6406 215.779V217.899C77.6481 218.051 77.6921 218.198 77.7687 218.328C77.8453 218.459 77.9523 218.569 78.0806 218.649L78.5606 218.939C78.8006 219.069 79.0006 218.939 79.0006 218.689V216.559C78.9885 216.409 78.9426 216.264 78.8664 216.134C78.7902 216.004 78.6857 215.893 78.5606 215.809L78.0806 215.529C77.8406 215.389 77.6406 215.499 77.6406 215.779Z"
        fill="#263238"
      />
      <path
        d="M79.832 217V219.13C79.843 219.279 79.8874 219.424 79.9618 219.554C80.0362 219.683 80.1388 219.795 80.262 219.88L80.752 220.16C80.992 220.3 81.182 220.16 81.182 219.91V217.78C81.171 217.631 81.1267 217.486 81.0523 217.356C80.9778 217.226 80.8752 217.115 80.752 217.03L80.262 216.75C80.002 216.65 79.832 216.76 79.832 217Z"
        fill="#263238"
      />
      <path
        d="M82 218.301V220.431C82.011 220.58 82.0553 220.725 82.1298 220.855C82.2042 220.984 82.3068 221.096 82.43 221.181L82.92 221.461C83.16 221.601 83.35 221.461 83.35 221.211V219.081C83.339 218.932 83.2947 218.787 83.2202 218.657C83.1458 218.527 83.0432 218.416 82.92 218.331L82.43 218.051C82.21 217.911 82 218.001 82 218.301Z"
        fill="#263238"
      />
      <path
        d="M89.332 219.19L90.332 218.62C90.5432 218.52 90.7775 218.479 91.01 218.502C91.2425 218.525 91.4644 218.611 91.652 218.75C92.1982 219.106 92.653 219.586 92.9795 220.151C93.3061 220.715 93.4954 221.349 93.532 222C93.5563 222.234 93.5183 222.47 93.4217 222.684C93.325 222.898 93.1733 223.083 92.982 223.22L92.062 223.75L91.892 223.47C91.7025 223.428 91.5204 223.357 91.352 223.26C90.8045 222.903 90.349 222.421 90.0223 221.855C89.6957 221.288 89.5072 220.653 89.472 220C89.4697 219.838 89.4899 219.676 89.532 219.52L89.332 219.19Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M89.332 219.19L90.332 218.62C90.5432 218.52 90.7775 218.479 91.01 218.502C91.2425 218.525 91.4644 218.611 91.652 218.75C92.1982 219.106 92.653 219.586 92.9795 220.151C93.3061 220.715 93.4954 221.349 93.532 222C93.5563 222.234 93.5183 222.47 93.4217 222.684C93.325 222.898 93.1733 223.083 92.982 223.22L92.062 223.75L91.892 223.47C91.7025 223.428 91.5204 223.357 91.352 223.26C90.8045 222.903 90.349 222.421 90.0223 221.855C89.6957 221.288 89.5072 220.653 89.472 220C89.4697 219.838 89.4899 219.676 89.532 219.52L89.332 219.19Z"
        fill="black"
      />
      <path
        d="M90.7003 219.299C91.2478 219.657 91.7034 220.138 92.03 220.704C92.3567 221.271 92.5452 221.906 92.5803 222.559C92.5803 223.759 91.7403 224.239 90.7003 223.639C90.153 223.284 89.6974 222.804 89.3707 222.24C89.044 221.675 88.8554 221.041 88.8203 220.389C88.8203 219.189 89.6603 218.699 90.7003 219.299Z"
        fill="#F38C28"
      />
      <path
        d="M97.5 223.911L98.5 223.331C98.7124 223.236 98.9458 223.199 99.1772 223.221C99.4087 223.244 99.6302 223.327 99.82 223.461C100.368 223.818 100.823 224.3 101.15 224.866C101.476 225.433 101.665 226.068 101.7 226.721C101.724 226.955 101.686 227.191 101.59 227.405C101.493 227.62 101.341 227.804 101.15 227.941L100.23 228.471L100.06 228.191C99.8705 228.149 99.6884 228.078 99.52 227.981C98.9725 227.624 98.5169 227.142 98.1903 226.576C97.8637 226.009 97.6751 225.374 97.64 224.721C97.639 224.559 97.6592 224.398 97.7 224.241L97.5 223.911Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M97.5 223.911L98.5 223.331C98.7124 223.236 98.9458 223.199 99.1772 223.221C99.4087 223.244 99.6302 223.327 99.82 223.461C100.368 223.818 100.823 224.3 101.15 224.866C101.476 225.433 101.665 226.068 101.7 226.721C101.724 226.955 101.686 227.191 101.59 227.405C101.493 227.62 101.341 227.804 101.15 227.941L100.23 228.471L100.06 228.191C99.8705 228.149 99.6884 228.078 99.52 227.981C98.9725 227.624 98.5169 227.142 98.1903 226.576C97.8637 226.009 97.6751 225.374 97.64 224.721C97.639 224.559 97.6592 224.398 97.7 224.241L97.5 223.911Z"
        fill="black"
      />
      <path
        d="M98.87 224C99.4175 224.357 99.8731 224.839 100.2 225.405C100.526 225.972 100.715 226.607 100.75 227.26C100.75 228.46 99.91 228.95 98.87 228.35C98.3262 227.992 97.8738 227.511 97.5491 226.947C97.2244 226.383 97.0363 225.75 97 225.1C97 223.9 97.83 223.41 98.87 224Z"
        fill="#F38C28"
      />
      <path
        d="M42.9414 156.129L107.941 193.659L172.931 156.129L107.941 118.609L42.9414 156.129Z"
        fill="#263238"
      />
      <path d="M42.9414 174.891L107.941 212.421V193.661L42.9414 156.131V174.891Z" fill="#455A64" />
      <path d="M107.941 212.421L172.931 174.891V156.131L107.941 193.661V212.421Z" fill="#37474F" />
      <path d="M51.0703 184.27V179.58L107.94 212.42V217.11L51.0703 184.27Z" fill="#F38C28" />
      <path d="M168.871 177.24V181.93L107.941 217.11V212.42L168.871 177.24Z" fill="#F38C28" />
      <path
        opacity="0.2"
        d="M168.871 177.24V181.93L107.941 217.11V212.42L168.871 177.24Z"
        fill="black"
      />
      <path
        d="M47 163.67V165.79C47.011 165.939 47.0553 166.084 47.1298 166.214C47.2042 166.344 47.3068 166.455 47.43 166.54L47.92 166.82C48.15 166.96 48.35 166.82 48.35 166.57V164.45C48.339 164.301 48.2947 164.156 48.2202 164.026C48.1458 163.896 48.0432 163.785 47.92 163.7L47.43 163.42C47.2 163.28 47 163.39 47 163.67Z"
        fill="#F38C28"
      />
      <path
        d="M49.1914 164.93V167.05C49.1989 167.201 49.2429 167.348 49.3195 167.479C49.3961 167.609 49.5031 167.719 49.6314 167.8L50.1114 168.09C50.3514 168.22 50.5514 168.09 50.5514 167.84V165.71C50.5393 165.56 50.4934 165.414 50.4172 165.285C50.341 165.155 50.2365 165.044 50.1114 164.96L49.6314 164.68C49.3914 164.54 49.1914 164.65 49.1914 164.93Z"
        fill="#F38C28"
      />
      <path
        d="M51.3828 166.189V168.319C51.3938 168.469 51.4382 168.614 51.5126 168.743C51.587 168.873 51.6896 168.985 51.8128 169.069L52.3028 169.349C52.5428 169.479 52.7428 169.349 52.7428 169.099V166.999C52.7307 166.849 52.6848 166.704 52.6086 166.574C52.5324 166.444 52.4279 166.333 52.3028 166.249L51.8128 165.969C51.5828 165.799 51.3828 165.909 51.3828 166.189Z"
        fill="#263238"
      />
      <path
        d="M53.5703 167.45V169.58C53.5813 169.729 53.6257 169.874 53.7001 170.003C53.7745 170.133 53.8771 170.245 54.0003 170.33L54.4903 170.61C54.7303 170.75 54.9203 170.61 54.9203 170.36V168.23C54.9093 168.08 54.865 167.935 54.7906 167.806C54.7161 167.676 54.6135 167.564 54.4903 167.48L54.0003 167.2C53.7603 167.06 53.5703 167.18 53.5703 167.45Z"
        fill="#F38C28"
      />
      <path
        d="M55.7617 168.711V170.841C55.7727 170.99 55.8171 171.135 55.8915 171.265C55.9659 171.394 56.0685 171.506 56.1917 171.591L56.6817 171.871C56.9217 172.011 57.1117 171.871 57.1117 171.621V169.491C57.1007 169.342 57.0564 169.197 56.982 169.067C56.9075 168.937 56.8049 168.826 56.6817 168.741L56.1917 168.461C56.0017 168.331 55.7617 168.441 55.7617 168.711Z"
        fill="#F38C28"
      />
      <path
        d="M58 170.001V172.121C58.011 172.27 58.0553 172.415 58.1298 172.545C58.2042 172.675 58.3068 172.786 58.43 172.871L58.92 173.151C59.16 173.291 59.35 173.151 59.35 172.901V170.781C59.3444 170.631 59.3023 170.484 59.2274 170.353C59.1525 170.222 59.047 170.112 58.92 170.031L58.43 169.751C58.14 169.591 58 169.701 58 170.001Z"
        fill="#263238"
      />
      <path
        d="M60.1406 171.24V173.36C60.1516 173.509 60.196 173.654 60.2704 173.784C60.3448 173.914 60.4474 174.025 60.5706 174.11L61.0606 174.39C61.2906 174.53 61.4906 174.39 61.4906 174.14V172C61.4796 171.851 61.4353 171.706 61.3609 171.576C61.2864 171.446 61.1838 171.335 61.0606 171.25L60.5706 170.97C60.3306 170.85 60.1406 171 60.1406 171.24Z"
        fill="#263238"
      />
      <path
        d="M62.3203 172.5V174.62C62.3278 174.771 62.3718 174.918 62.4484 175.049C62.525 175.18 62.632 175.29 62.7603 175.37L63.2403 175.65C63.4803 175.79 63.6803 175.65 63.6803 175.4V173.28C63.6682 173.13 63.6223 172.985 63.5461 172.855C63.4699 172.725 63.3654 172.614 63.2403 172.53L62.7603 172.25C62.5203 172.11 62.3203 172.22 62.3203 172.5Z"
        fill="#F38C28"
      />
      <path
        d="M64.5117 173.76V175.88C64.5227 176.029 64.5671 176.174 64.6415 176.304C64.7159 176.434 64.8185 176.545 64.9417 176.63L65.4317 176.92C65.6717 177.05 65.8717 176.92 65.8717 176.67V174.54C65.8596 174.39 65.8137 174.244 65.7375 174.115C65.6613 173.985 65.5568 173.874 65.4317 173.79L64.9417 173.51C64.7117 173.37 64.5117 173.48 64.5117 173.76Z"
        fill="#263238"
      />
      <path
        d="M66.7031 175V177.13C66.7141 177.28 66.7585 177.424 66.8329 177.554C66.9073 177.684 67.0099 177.795 67.1331 177.88L67.6231 178.16C67.8631 178.3 68.0531 178.16 68.0531 177.91V175.8C68.0421 175.651 67.9978 175.506 67.9234 175.376C67.8489 175.247 67.7463 175.135 67.6231 175.05L67.1331 174.77C66.8931 174.63 66.7031 174.75 66.7031 175Z"
        fill="#F38C28"
      />
      <path
        d="M68.8906 176.279V178.409C68.9016 178.559 68.946 178.703 69.0204 178.833C69.0948 178.963 69.1974 179.075 69.3206 179.159L69.8106 179.439C70.0506 179.579 70.2406 179.439 70.2406 179.189V177.059C70.2296 176.91 70.1853 176.765 70.1109 176.636C70.0364 176.506 69.9338 176.394 69.8106 176.309L69.3206 176.029C69.0806 175.889 68.8906 175.999 68.8906 176.279Z"
        fill="#F38C28"
      />
      <path
        d="M71.082 177.541V179.671C71.093 179.82 71.1374 179.965 71.2118 180.095C71.2862 180.225 71.3888 180.336 71.512 180.421L72.002 180.701C72.242 180.841 72.432 180.701 72.432 180.451V178.331C72.4264 178.18 72.3844 178.033 72.3095 177.903C72.2346 177.772 72.1291 177.662 72.002 177.581L71.512 177.291C71.272 177.161 71.082 177.271 71.082 177.541Z"
        fill="#F38C28"
      />
      <path
        d="M73.2695 178.811V180.931C73.2805 181.08 73.3249 181.225 73.3993 181.355C73.4737 181.484 73.5763 181.596 73.6995 181.681L74.1895 181.961C74.4195 182.101 74.6195 181.961 74.6195 181.711V179.591C74.6085 179.441 74.5642 179.297 74.4898 179.167C74.4153 179.037 74.3128 178.926 74.1895 178.841L73.6995 178.561C73.4595 178.421 73.2695 178.531 73.2695 178.811Z"
        fill="#F38C28"
      />
      <path
        d="M75.4531 180.07V182.19C75.4653 182.341 75.5112 182.486 75.5873 182.616C75.6635 182.746 75.7681 182.857 75.8931 182.94L76.3731 183.22C76.6131 183.36 76.8131 183.22 76.8131 182.97V180.85C76.801 180.7 76.7551 180.555 76.6789 180.425C76.6027 180.295 76.4982 180.184 76.3731 180.1L75.8931 179.82C75.6531 179.68 75.4531 179.79 75.4531 180.07Z"
        fill="#263238"
      />
      <path
        d="M77.6406 181.33V183.45C77.6481 183.601 77.6921 183.749 77.7687 183.879C77.8453 184.01 77.9523 184.12 78.0806 184.2L78.5606 184.49C78.8006 184.62 79.0006 184.49 79.0006 184.24V182.11C78.9885 181.96 78.9426 181.815 78.8664 181.685C78.7902 181.555 78.6857 181.444 78.5606 181.36L78.0806 181.08C77.8406 180.94 77.6406 181.05 77.6406 181.33Z"
        fill="#263238"
      />
      <path
        d="M79.832 182.59V184.72C79.843 184.869 79.8874 185.014 79.9618 185.144C80.0362 185.274 80.1388 185.385 80.262 185.47L80.752 185.75C80.992 185.88 81.182 185.75 81.182 185.5V183.37C81.171 183.221 81.1267 183.076 81.0523 182.946C80.9778 182.816 80.8752 182.705 80.752 182.62L80.262 182.34C80.002 182.2 79.832 182.31 79.832 182.59Z"
        fill="#263238"
      />
      <path
        d="M82 183.851V186.001C82.011 186.15 82.0553 186.295 82.1298 186.425C82.2042 186.554 82.3068 186.666 82.43 186.751L82.92 187.031C83.16 187.171 83.35 187.031 83.35 186.781V184.651C83.339 184.502 83.2947 184.357 83.2202 184.227C83.1458 184.097 83.0432 183.986 82.92 183.901L82.43 183.621C82.21 183.461 82 183.581 82 183.851Z"
        fill="#F38C28"
      />
      <path
        d="M47 170.001V172.121C47.011 172.27 47.0553 172.415 47.1298 172.545C47.2042 172.675 47.3068 172.786 47.43 172.871L47.92 173.151C48.15 173.291 48.35 173.151 48.35 172.901V170.781C48.339 170.632 48.2947 170.487 48.2202 170.357C48.1458 170.227 48.0432 170.116 47.92 170.031L47.43 169.751C47.2 169.591 47 169.701 47 170.001Z"
        fill="#F38C28"
      />
      <path
        d="M49.1914 171.24V173.36C49.2036 173.51 49.2494 173.655 49.3256 173.785C49.4018 173.915 49.5063 174.026 49.6314 174.11L50.1114 174.39C50.3514 174.53 50.5514 174.39 50.5514 174.14V172C50.5393 171.85 50.4934 171.705 50.4172 171.575C50.341 171.445 50.2365 171.334 50.1114 171.25L49.6314 170.97C49.3914 170.85 49.1914 171 49.1914 171.24Z"
        fill="#F38C28"
      />
      <path
        d="M51.3828 172.5V174.62C51.3938 174.769 51.4382 174.914 51.5126 175.044C51.587 175.174 51.6896 175.285 51.8128 175.37L52.3028 175.65C52.5428 175.79 52.7428 175.65 52.7428 175.4V173.28C52.7307 173.13 52.6848 172.985 52.6086 172.855C52.5324 172.725 52.4279 172.614 52.3028 172.53L51.8128 172.25C51.5828 172.11 51.3828 172.22 51.3828 172.5Z"
        fill="#F38C28"
      />
      <path
        d="M53.5703 173.76V175.88C53.5759 176.03 53.618 176.177 53.6929 176.308C53.7678 176.439 53.8733 176.549 54.0003 176.63L54.4903 176.92C54.7303 177.05 54.9203 176.92 54.9203 176.67V174.54C54.9093 174.391 54.865 174.246 54.7906 174.116C54.7161 173.986 54.6135 173.875 54.4903 173.79L54.0003 173.51C53.7603 173.37 53.5703 173.48 53.5703 173.76Z"
        fill="#263238"
      />
      <path
        d="M55.7617 175V177.13C55.7727 177.28 55.8171 177.424 55.8915 177.554C55.9659 177.684 56.0685 177.795 56.1917 177.88L56.6817 178.16C56.9217 178.3 57.1117 178.16 57.1117 177.91V175.8C57.1007 175.651 57.0564 175.506 56.982 175.376C56.9075 175.247 56.8049 175.135 56.6817 175.05L56.1917 174.77C56.0017 174.63 55.7617 174.75 55.7617 175Z"
        fill="#263238"
      />
      <path
        d="M58 176.279V178.409C58.011 178.559 58.0553 178.703 58.1298 178.833C58.2042 178.963 58.3068 179.075 58.43 179.159L58.92 179.439C59.16 179.579 59.35 179.439 59.35 179.189V177.059C59.339 176.91 59.2947 176.765 59.2202 176.636C59.1458 176.506 59.0432 176.394 58.92 176.309L58.43 176.029C58.14 175.889 58 175.999 58 176.279Z"
        fill="#F38C28"
      />
      <path
        d="M60.1406 177.541V179.671C60.1516 179.82 60.196 179.965 60.2704 180.095C60.3448 180.225 60.4474 180.336 60.5706 180.421L61.0606 180.701C61.2906 180.841 61.4906 180.701 61.4906 180.451V178.331C61.4796 178.182 61.4353 178.037 61.3609 177.907C61.2864 177.777 61.1838 177.666 61.0606 177.581L60.5706 177.291C60.3306 177.161 60.1406 177.271 60.1406 177.541Z"
        fill="#F38C28"
      />
      <path
        d="M62.3203 178.811V180.931C62.3325 181.081 62.3783 181.226 62.4545 181.356C62.5307 181.486 62.6352 181.597 62.7603 181.681L63.2403 181.961C63.4803 182.101 63.6803 181.961 63.6803 181.711V179.591C63.6682 179.441 63.6223 179.295 63.5461 179.165C63.4699 179.035 63.3654 178.925 63.2403 178.841L62.7603 178.561C62.5203 178.421 62.3203 178.531 62.3203 178.811Z"
        fill="#F38C28"
      />
      <path
        d="M64.5117 180.07V182.19C64.5227 182.34 64.5671 182.485 64.6415 182.614C64.7159 182.744 64.8185 182.856 64.9417 182.94L65.4317 183.22C65.6717 183.36 65.8717 183.22 65.8717 182.97V180.85C65.8596 180.7 65.8137 180.555 65.7375 180.425C65.6613 180.295 65.5568 180.184 65.4317 180.1L64.9417 179.82C64.7117 179.68 64.5117 179.79 64.5117 180.07Z"
        fill="#263238"
      />
      <path
        d="M66.7031 181.33V183.45C66.7087 183.601 66.7508 183.748 66.8257 183.878C66.9006 184.009 67.0061 184.119 67.1331 184.2L67.6231 184.49C67.8631 184.62 68.0531 184.49 68.0531 184.24V182.11C68.0421 181.961 67.9978 181.816 67.9234 181.686C67.8489 181.557 67.7463 181.445 67.6231 181.36L67.1331 181.08C66.8931 180.94 66.7031 181.05 66.7031 181.33Z"
        fill="#263238"
      />
      <path
        d="M68.8906 182.59V184.72C68.9016 184.869 68.946 185.014 69.0204 185.144C69.0948 185.274 69.1974 185.385 69.3206 185.47L69.8106 185.75C70.0506 185.88 70.2406 185.75 70.2406 185.5V183.37C70.2296 183.221 70.1853 183.076 70.1109 182.946C70.0364 182.816 69.9338 182.705 69.8106 182.62L69.3206 182.34C69.0806 182.2 68.8906 182.31 68.8906 182.59Z"
        fill="#263238"
      />
      <path
        d="M71.082 183.85V186C71.093 186.149 71.1374 186.294 71.2118 186.424C71.2862 186.553 71.3888 186.665 71.512 186.75L72.002 187C72.242 187.14 72.432 187 72.432 186.75V184.62C72.421 184.47 72.3767 184.326 72.3023 184.196C72.2278 184.066 72.1252 183.955 72.002 183.87L71.512 183.59C71.272 183.46 71.082 183.58 71.082 183.85Z"
        fill="#263238"
      />
      <path
        d="M73.2695 185.109V187.239C73.2805 187.388 73.3249 187.533 73.3993 187.663C73.4737 187.793 73.5763 187.904 73.6995 187.989L74.1895 188.269C74.4195 188.409 74.6195 188.269 74.6195 188.019V185.889C74.6085 185.74 74.5642 185.595 74.4898 185.465C74.4153 185.336 74.3128 185.224 74.1895 185.139L73.6995 184.859C73.4595 184.729 73.2695 184.839 73.2695 185.109Z"
        fill="#F38C28"
      />
      <path
        d="M75.4531 186.37V188.5C75.4653 188.651 75.5112 188.796 75.5873 188.926C75.6635 189.056 75.7681 189.167 75.8931 189.25L76.3731 189.53C76.6131 189.67 76.8131 189.53 76.8131 189.28V187.16C76.8056 187.009 76.7617 186.862 76.6851 186.732C76.6085 186.601 76.5014 186.491 76.3731 186.41L75.8931 186.12C75.6531 186 75.4531 186.1 75.4531 186.37Z"
        fill="#F38C28"
      />
      <path
        d="M77.6406 187.641V189.761C77.6528 189.911 77.6987 190.056 77.7748 190.186C77.851 190.316 77.9556 190.427 78.0806 190.511L78.5606 190.791C78.8006 190.931 79.0006 190.791 79.0006 190.541V188.421C78.9885 188.271 78.9426 188.125 78.8664 187.995C78.7902 187.866 78.6857 187.755 78.5606 187.671L78.0806 187.391C77.8406 187.251 77.6406 187.361 77.6406 187.641Z"
        fill="#F38C28"
      />
      <path
        d="M79.832 188.9V191C79.8376 191.151 79.8797 191.297 79.9546 191.428C80.0295 191.559 80.135 191.669 80.262 191.75L80.752 192.03C80.992 192.17 81.182 192.03 81.182 191.78V189.66C81.171 189.511 81.1267 189.366 81.0523 189.236C80.9778 189.106 80.8752 188.995 80.752 188.91L80.262 188.63C80.002 188.51 79.832 188.62 79.832 188.9Z"
        fill="#F38C28"
      />
      <path
        d="M82 190.16V192.28C82.0056 192.431 82.0477 192.578 82.1226 192.708C82.1975 192.839 82.303 192.949 82.43 193.03L82.92 193.32C83.16 193.45 83.35 193.32 83.35 193.07V190.94C83.339 190.791 83.2947 190.646 83.2202 190.516C83.1458 190.387 83.0432 190.275 82.92 190.19L82.43 189.91C82.21 189.77 82 189.88 82 190.16Z"
        fill="#F38C28"
      />
      <path
        d="M89.332 191.051L90.332 190.481C90.5448 190.385 90.7791 190.348 91.0109 190.373C91.2428 190.397 91.464 190.483 91.652 190.621C92.1995 190.978 92.6551 191.459 92.9817 192.026C93.3084 192.592 93.4969 193.228 93.532 193.881C93.5577 194.113 93.5202 194.348 93.4234 194.561C93.3266 194.774 93.1741 194.957 92.982 195.091L92.062 195.611L91.892 195.341C91.7039 195.294 91.5225 195.223 91.352 195.131C90.8045 194.773 90.349 194.292 90.0223 193.725C89.6957 193.159 89.5072 192.523 89.472 191.871C89.4697 191.709 89.4899 191.547 89.532 191.391L89.332 191.051Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M89.332 191.051L90.332 190.481C90.5448 190.385 90.7791 190.348 91.0109 190.373C91.2428 190.397 91.464 190.483 91.652 190.621C92.1995 190.978 92.6551 191.459 92.9817 192.026C93.3084 192.592 93.4969 193.228 93.532 193.881C93.5577 194.113 93.5202 194.348 93.4234 194.561C93.3266 194.774 93.1741 194.957 92.982 195.091L92.062 195.611L91.892 195.341C91.7039 195.294 91.5225 195.223 91.352 195.131C90.8045 194.773 90.349 194.292 90.0223 193.725C89.6957 193.159 89.5072 192.523 89.472 191.871C89.4697 191.709 89.4899 191.547 89.532 191.391L89.332 191.051Z"
        fill="black"
      />
      <path
        d="M90.7003 191.16C91.2478 191.518 91.7034 191.999 92.03 192.565C92.3567 193.132 92.5452 193.767 92.5803 194.42C92.5803 195.62 91.7403 196.1 90.7003 195.5C90.1528 195.143 89.6972 194.661 89.3706 194.095C89.044 193.529 88.8554 192.893 88.8203 192.24C88.8203 191 89.6603 190.56 90.7003 191.16Z"
        fill="#F38C28"
      />
      <path
        d="M97.5 195.759L98.5 195.19C98.7119 195.093 98.9457 195.054 99.1775 195.077C99.4094 195.1 99.631 195.183 99.82 195.32C100.368 195.677 100.823 196.158 101.15 196.725C101.476 197.291 101.665 197.927 101.7 198.58C101.724 198.813 101.686 199.049 101.59 199.264C101.493 199.478 101.341 199.663 101.15 199.8L100.23 200.33L100.06 200.05C99.8705 200.007 99.6884 199.936 99.52 199.84C98.9725 199.482 98.5169 199.001 98.1903 198.434C97.8637 197.868 97.6751 197.232 97.64 196.58C97.6383 196.418 97.6585 196.256 97.7 196.1L97.5 195.759Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M97.5 195.759L98.5 195.19C98.7119 195.093 98.9457 195.054 99.1775 195.077C99.4094 195.1 99.631 195.183 99.82 195.32C100.368 195.677 100.823 196.158 101.15 196.725C101.476 197.291 101.665 197.927 101.7 198.58C101.724 198.813 101.686 199.049 101.59 199.264C101.493 199.478 101.341 199.663 101.15 199.8L100.23 200.33L100.06 200.05C99.8705 200.007 99.6884 199.936 99.52 199.84C98.9725 199.482 98.5169 199.001 98.1903 198.434C97.8637 197.868 97.6751 197.232 97.64 196.58C97.6383 196.418 97.6585 196.256 97.7 196.1L97.5 195.759Z"
        fill="black"
      />
      <path
        d="M98.87 195.871C99.4175 196.228 99.8731 196.709 100.2 197.276C100.526 197.842 100.715 198.478 100.75 199.131C100.75 200.331 99.91 200.821 98.87 200.221C98.3301 199.865 97.8802 199.39 97.5556 198.831C97.2311 198.272 97.0409 197.645 97 197.001C97 195.761 97.83 195.271 98.87 195.871Z"
        fill="#F38C28"
      />
      <path
        d="M170.331 126.49L110.501 92.0002C109.694 91.5955 108.804 91.3848 107.901 91.3848C106.999 91.3848 106.108 91.5955 105.301 92.0002L45.5414 126.49C44.7857 126.984 44.1567 127.649 43.705 128.43C43.2534 129.212 42.9918 130.089 42.9414 130.99V146.75L107.941 184.27L172.941 146.75V131C172.891 130.096 172.629 129.217 172.176 128.433C171.722 127.65 171.09 126.984 170.331 126.49Z"
        fill="#37474F"
      />
      <path
        d="M108 164.63V184.27L43 146.75V131C43.0463 130.195 43.2596 129.409 43.6263 128.691C43.993 127.973 44.5051 127.339 45.13 126.83C44.13 127.66 44.34 128.77 45.6 129.5L105.38 164C106.185 164.432 107.087 164.649 108 164.63Z"
        fill="#455A64"
      />
      <path
        d="M45.5409 129.49L105.381 164C106.185 164.409 107.074 164.623 107.976 164.623C108.878 164.623 109.767 164.409 110.571 164L170.331 129.48C171.771 128.65 171.771 127.31 170.331 126.48L110.501 92.0002C109.694 91.5955 108.804 91.3848 107.901 91.3848C106.998 91.3848 106.108 91.5955 105.301 92.0002L45.5409 126.49C44.1009 127.32 44.1009 128.66 45.5409 129.49Z"
        fill="#263238"
      />
      <path d="M51.0703 156.129V151.439L107.94 184.269V188.959L51.0703 156.129Z" fill="#F38C28" />
      <path d="M168.871 149.09V153.78L107.941 188.96V184.27L168.871 149.09Z" fill="#F38C28" />
      <path
        opacity="0.2"
        d="M168.871 149.09V153.78L107.941 188.96V184.27L168.871 149.09Z"
        fill="black"
      />
      <path
        d="M47 135.519V137.649C47.011 137.799 47.0553 137.943 47.1298 138.073C47.2042 138.203 47.3068 138.314 47.43 138.399L47.92 138.679C48.15 138.819 48.35 138.679 48.35 138.429V136.309C48.339 136.16 48.2947 136.015 48.2202 135.885C48.1458 135.756 48.0432 135.644 47.92 135.559L47.43 135.269C47.2 135.139 47 135.249 47 135.519Z"
        fill="#263238"
      />
      <path
        d="M49.1914 136.789V138.909C49.2036 139.059 49.2494 139.205 49.3256 139.335C49.4018 139.464 49.5063 139.575 49.6314 139.659L50.1114 139.939C50.3514 140.079 50.5514 139.939 50.5514 139.689V137.569C50.5393 137.419 50.4934 137.274 50.4172 137.144C50.341 137.014 50.2365 136.903 50.1114 136.819L49.6314 136.539C49.3914 136.399 49.1914 136.509 49.1914 136.789Z"
        fill="#263238"
      />
      <path
        d="M51.3828 138.051V140.171C51.3938 140.32 51.4382 140.465 51.5126 140.595C51.587 140.725 51.6896 140.836 51.8128 140.921L52.3028 141.201C52.5428 141.341 52.7428 141.201 52.7428 140.951V138.831C52.7307 138.681 52.6848 138.535 52.6086 138.406C52.5324 138.276 52.4279 138.165 52.3028 138.081L51.8128 137.801C51.5828 137.661 51.3828 137.771 51.3828 138.051Z"
        fill="#263238"
      />
      <path
        d="M53.5703 139.311V141.431C53.5759 141.581 53.618 141.728 53.6929 141.859C53.7678 141.989 53.8733 142.1 54.0003 142.181L54.4903 142.471C54.7303 142.601 54.9203 142.471 54.9203 142.221V140.091C54.9093 139.941 54.865 139.797 54.7906 139.667C54.7161 139.537 54.6135 139.426 54.4903 139.341L54.0003 139.061C53.7603 138.921 53.5703 139.001 53.5703 139.311Z"
        fill="#F38C28"
      />
      <path
        d="M55.7617 140.57V142.7C55.7727 142.85 55.8171 142.995 55.8915 143.124C55.9659 143.254 56.0685 143.366 56.1917 143.45L56.6817 143.73C56.9217 143.87 57.1117 143.73 57.1117 143.48V141.35C57.1007 141.201 57.0564 141.056 56.982 140.927C56.9075 140.797 56.8049 140.685 56.6817 140.6L56.1917 140.32C56.0017 140.18 55.7617 140.29 55.7617 140.57Z"
        fill="#F38C28"
      />
      <path
        d="M58 141.831V144.001C58.011 144.15 58.0553 144.295 58.1298 144.425C58.2042 144.554 58.3068 144.666 58.43 144.751L58.92 145.031C59.16 145.171 59.35 145.031 59.35 144.781V142.651C59.339 142.502 59.2947 142.357 59.2202 142.227C59.1458 142.097 59.0432 141.986 58.92 141.901L58.43 141.621C58.14 141.441 58 141.561 58 141.831Z"
        fill="#263238"
      />
      <path
        d="M60.1406 143.09V145.22C60.1516 145.369 60.196 145.514 60.2704 145.644C60.3448 145.773 60.4474 145.885 60.5706 145.97L61.0606 146.25C61.2906 146.39 61.4906 146.25 61.4906 146V143.88C61.4796 143.73 61.4353 143.586 61.3609 143.456C61.2864 143.326 61.1838 143.215 61.0606 143.13L60.5706 142.84C60.3306 142.71 60.1406 142.82 60.1406 143.09Z"
        fill="#263238"
      />
      <path
        d="M62.3203 144.36V146.48C62.3325 146.63 62.3783 146.775 62.4545 146.905C62.5307 147.035 62.6352 147.146 62.7603 147.23L63.2403 147.51C63.4803 147.65 63.6803 147.51 63.6803 147.26V145.14C63.6728 144.989 63.6289 144.842 63.5522 144.711C63.4756 144.581 63.3686 144.47 63.2403 144.39L62.7603 144.11C62.5203 144 62.3203 144.08 62.3203 144.36Z"
        fill="#263238"
      />
      <path
        d="M64.5117 145.619V147.739C64.5227 147.889 64.5671 148.033 64.6415 148.163C64.7159 148.293 64.8185 148.404 64.9417 148.489L65.4317 148.769C65.6717 148.909 65.8717 148.769 65.8717 148.519V146.399C65.8596 146.249 65.8137 146.104 65.7375 145.974C65.6613 145.844 65.5568 145.733 65.4317 145.649L64.9417 145.369C64.7117 145.229 64.5117 145.339 64.5117 145.619Z"
        fill="#263238"
      />
      <path
        d="M66.7031 146.881V149.001C66.7087 149.151 66.7508 149.298 66.8257 149.429C66.9006 149.56 67.0061 149.67 67.1331 149.751L67.6231 150.031C67.8631 150.171 68.0531 150.031 68.0531 149.781V147.661C68.0421 147.512 67.9978 147.367 67.9234 147.237C67.8489 147.107 67.7463 146.996 67.6231 146.911L67.1331 146.631C66.8931 146.491 66.7031 146.601 66.7031 146.881Z"
        fill="#263238"
      />
      <path
        d="M68.8906 148.141V150.271C68.9016 150.42 68.946 150.565 69.0204 150.695C69.0948 150.824 69.1974 150.936 69.3206 151.021L69.8106 151.301C70.0506 151.431 70.2406 151.301 70.2406 151.051V148.921C70.2296 148.772 70.1853 148.627 70.1109 148.497C70.0364 148.367 69.9338 148.256 69.8106 148.171L69.3206 147.891C69.0806 147.751 68.8906 147.861 68.8906 148.141Z"
        fill="#F38C28"
      />
      <path
        d="M71.082 149.399V151.529C71.093 151.678 71.1374 151.823 71.2118 151.953C71.2862 152.083 71.3888 152.194 71.512 152.279L72.002 152.559C72.242 152.699 72.432 152.559 72.432 152.309V150.179C72.421 150.03 72.3767 149.885 72.3023 149.755C72.2278 149.626 72.1252 149.514 72.002 149.429L71.512 149.149C71.272 148.999 71.082 149.129 71.082 149.399Z"
        fill="#F38C28"
      />
      <path
        d="M73.2695 150.66V152.79C73.2805 152.939 73.3249 153.084 73.3993 153.214C73.4737 153.344 73.5763 153.455 73.6995 153.54L74.1895 153.82C74.4195 153.96 74.6195 153.82 74.6195 153.57V151.44C74.6085 151.291 74.5642 151.146 74.4898 151.016C74.4153 150.886 74.3128 150.775 74.1895 150.69L73.6995 150.41C73.4595 150.28 73.2695 150.39 73.2695 150.66Z"
        fill="#263238"
      />
      <path
        d="M75.4531 151.92V154.05C75.4653 154.2 75.5112 154.345 75.5873 154.475C75.6635 154.605 75.7681 154.716 75.8931 154.8L76.3731 155.08C76.6131 155.22 76.8131 155.08 76.8131 154.83V152.71C76.8056 152.559 76.7617 152.411 76.6851 152.281C76.6085 152.15 76.5014 152.04 76.3731 151.96L75.8931 151.67C75.6531 151.54 75.4531 151.65 75.4531 151.92Z"
        fill="#F38C28"
      />
      <path
        d="M77.6406 153.189V155.309C77.6528 155.46 77.6987 155.605 77.7748 155.735C77.851 155.865 77.9556 155.976 78.0806 156.059L78.5606 156.339C78.8006 156.479 79.0006 156.339 79.0006 156.089V153.999C78.9885 153.849 78.9426 153.704 78.8664 153.574C78.7902 153.444 78.6857 153.333 78.5606 153.249L78.0806 152.969C77.8406 152.799 77.6406 152.909 77.6406 153.189Z"
        fill="#263238"
      />
      <path
        d="M79.832 154.449V156.569C79.843 156.719 79.8874 156.863 79.9618 156.993C80.0362 157.123 80.1388 157.234 80.262 157.319L80.752 157.599C80.992 157.739 81.182 157.599 81.182 157.349V155.229C81.171 155.08 81.1267 154.935 81.0523 154.805C80.9778 154.676 80.8752 154.564 80.752 154.479L80.262 154.199C80.002 154.059 79.832 154.169 79.832 154.449Z"
        fill="#263238"
      />
      <path
        d="M82 155.711V157.831C82.0056 157.982 82.0477 158.128 82.1226 158.259C82.1975 158.39 82.303 158.5 82.43 158.581L82.92 158.871C83.16 159.001 83.35 158.871 83.35 158.621V156.491C83.339 156.342 83.2947 156.197 83.2202 156.067C83.1458 155.937 83.0432 155.826 82.92 155.741L82.43 155.461C82.21 155.321 82 155.431 82 155.711Z"
        fill="#263238"
      />
      <path
        d="M47 141.831V144.001C47.011 144.15 47.0553 144.295 47.1298 144.425C47.2042 144.554 47.3068 144.666 47.43 144.751L47.92 145.031C48.15 145.171 48.35 145.031 48.35 144.781V142.651C48.339 142.502 48.2947 142.357 48.2202 142.227C48.1458 142.097 48.0432 141.986 47.92 141.901L47.43 141.621C47.2 141.441 47 141.561 47 141.831Z"
        fill="#F38C28"
      />
      <path
        d="M49.1914 143.09V145.22C49.2036 145.37 49.2494 145.515 49.3256 145.645C49.4018 145.775 49.5063 145.886 49.6314 145.97L50.1114 146.25C50.3514 146.39 50.5514 146.25 50.5514 146V143.88C50.5439 143.728 50.5 143.581 50.4233 143.451C50.3467 143.32 50.2397 143.21 50.1114 143.13L49.6314 142.84C49.3914 142.71 49.1914 142.82 49.1914 143.09Z"
        fill="#263238"
      />
      <path
        d="M51.3828 144.36V146.48C51.3938 146.629 51.4382 146.774 51.5126 146.904C51.587 147.034 51.6896 147.145 51.8128 147.23L52.3028 147.51C52.5428 147.65 52.7428 147.51 52.7428 147.26V145.14C52.7353 144.989 52.6914 144.842 52.6147 144.711C52.5381 144.581 52.4311 144.47 52.3028 144.39L51.8128 144.11C51.5828 144 51.3828 144.08 51.3828 144.36Z"
        fill="#263238"
      />
      <path
        d="M53.5703 145.619V147.739C53.5813 147.889 53.6257 148.033 53.7001 148.163C53.7745 148.293 53.8771 148.404 54.0003 148.489L54.4903 148.769C54.7303 148.909 54.9203 148.769 54.9203 148.519V146.399C54.9093 146.25 54.865 146.105 54.7906 145.975C54.7161 145.846 54.6135 145.734 54.4903 145.649L54.0003 145.369C53.7603 145.229 53.5703 145.339 53.5703 145.619Z"
        fill="#263238"
      />
      <path
        d="M55.7617 146.881V149.001C55.7673 149.151 55.8094 149.298 55.8843 149.429C55.9592 149.56 56.0647 149.67 56.1917 149.751L56.6817 150.031C56.9217 150.171 57.1117 150.031 57.1117 149.781V147.661C57.1007 147.512 57.0564 147.367 56.982 147.237C56.9075 147.107 56.8049 146.996 56.6817 146.911L56.1917 146.631C56.0017 146.491 55.7617 146.601 55.7617 146.881Z"
        fill="#263238"
      />
      <path
        d="M58 148.141V150.271C58.011 150.42 58.0553 150.565 58.1298 150.695C58.2042 150.824 58.3068 150.936 58.43 151.021L58.92 151.301C59.16 151.431 59.35 151.301 59.35 151.051V148.921C59.339 148.772 59.2947 148.627 59.2202 148.497C59.1458 148.367 59.0432 148.256 58.92 148.171L58.43 147.891C58.14 147.751 58 147.861 58 148.141Z"
        fill="#F38C28"
      />
      <path
        d="M60.1406 149.399V151.529C60.1516 151.678 60.196 151.823 60.2704 151.953C60.3448 152.083 60.4474 152.194 60.5706 152.279L61.0606 152.559C61.2906 152.699 61.4906 152.559 61.4906 152.309V150.179C61.4796 150.03 61.4353 149.885 61.3609 149.755C61.2864 149.626 61.1838 149.514 61.0606 149.429L60.5706 149.149C60.3306 148.999 60.1406 149.129 60.1406 149.399Z"
        fill="#263238"
      />
      <path
        d="M62.3203 150.66V152.79C62.3325 152.94 62.3783 153.085 62.4545 153.215C62.5307 153.345 62.6352 153.456 62.7603 153.54L63.2403 153.82C63.4803 153.96 63.6803 153.82 63.6803 153.57V151.44C63.6682 151.29 63.6223 151.145 63.5461 151.015C63.4699 150.885 63.3654 150.774 63.2403 150.69L62.7603 150.41C62.5203 150.28 62.3203 150.39 62.3203 150.66Z"
        fill="#F38C28"
      />
      <path
        d="M64.51 151.919V154.049C64.521 154.199 64.5653 154.343 64.6397 154.473C64.7142 154.603 64.8168 154.714 64.94 154.799L65.43 155.079C65.67 155.219 65.87 155.079 65.87 154.829V152.709C65.8625 152.558 65.8185 152.411 65.7419 152.28C65.6653 152.15 65.5583 152.04 65.43 151.959L64.94 151.669C64.8975 151.637 64.8467 151.619 64.7937 151.616C64.7407 151.613 64.688 151.625 64.6421 151.652C64.5962 151.678 64.5592 151.718 64.5357 151.766C64.5122 151.813 64.5033 151.867 64.51 151.919Z"
        fill="#263238"
      />
      <path
        d="M66.7031 153.189V155.309C66.7141 155.459 66.7585 155.604 66.8329 155.733C66.9073 155.863 67.0099 155.975 67.1331 156.059L67.6231 156.339C67.8631 156.479 68.0531 156.339 68.0531 156.089V153.999C68.0421 153.85 67.9978 153.705 67.9234 153.576C67.8489 153.446 67.7463 153.334 67.6231 153.249L67.1331 152.969C66.8931 152.799 66.7031 152.909 66.7031 153.189Z"
        fill="#F38C28"
      />
      <path
        d="M68.8906 154.449V156.569C68.9016 156.719 68.946 156.863 69.0204 156.993C69.0948 157.123 69.1974 157.234 69.3206 157.319L69.8106 157.599C70.0506 157.739 70.2406 157.599 70.2406 157.349V155.229C70.2296 155.08 70.1853 154.935 70.1109 154.805C70.0364 154.676 69.9338 154.564 69.8106 154.479L69.3206 154.199C69.0806 154.059 68.8906 154.169 68.8906 154.449Z"
        fill="#263238"
      />
      <path
        d="M71.082 155.711V157.831C71.0876 157.982 71.1297 158.128 71.2046 158.259C71.2795 158.39 71.385 158.5 71.512 158.581L72.002 158.871C72.242 159.001 72.432 158.871 72.432 158.621V156.491C72.421 156.342 72.3767 156.197 72.3023 156.067C72.2278 155.937 72.1252 155.826 72.002 155.741L71.512 155.461C71.272 155.321 71.082 155.431 71.082 155.711Z"
        fill="#263238"
      />
      <path
        d="M73.2695 157V159.13C73.2805 159.279 73.3249 159.424 73.3993 159.554C73.4737 159.683 73.5763 159.795 73.6995 159.88L74.1895 160.16C74.4195 160.3 74.6195 160.16 74.6195 159.91V157.78C74.6085 157.631 74.5642 157.486 74.4898 157.356C74.4153 157.226 74.3128 157.115 74.1895 157.03L73.6995 156.75C73.4595 156.58 73.2695 156.69 73.2695 157Z"
        fill="#263238"
      />
      <path
        d="M75.451 158.229V160.359C75.4631 160.509 75.509 160.655 75.5852 160.785C75.6614 160.914 75.7659 161.025 75.891 161.109L76.371 161.389C76.4132 161.425 76.4652 161.446 76.52 161.451C76.5749 161.456 76.6299 161.444 76.6778 161.417C76.7257 161.39 76.7641 161.349 76.7879 161.299C76.8117 161.249 76.8198 161.194 76.811 161.139V158.999C76.7988 158.849 76.7529 158.704 76.6768 158.574C76.6006 158.444 76.496 158.333 76.371 158.249L75.891 157.969C75.8482 157.933 75.795 157.91 75.7389 157.905C75.6827 157.9 75.6265 157.913 75.578 157.942C75.5295 157.971 75.4911 158.014 75.4683 158.065C75.4456 158.117 75.4395 158.174 75.451 158.229Z"
        fill="#263238"
      />
      <path
        d="M77.6406 159.49V161.62C77.6528 161.77 77.6987 161.916 77.7748 162.045C77.851 162.175 77.9556 162.286 78.0806 162.37L78.5606 162.65C78.8006 162.79 79.0006 162.65 79.0006 162.4V160.28C78.9931 160.129 78.9492 159.982 78.8726 159.851C78.796 159.721 78.6889 159.61 78.5606 159.53L78.0806 159.24C77.8406 159.11 77.6406 159.22 77.6406 159.49Z"
        fill="#263238"
      />
      <path
        d="M79.832 160.76V162.88C79.843 163.029 79.8874 163.174 79.9618 163.304C80.0362 163.434 80.1388 163.545 80.262 163.63L80.752 163.91C80.992 164.05 81.182 163.91 81.182 163.66V161.54C81.1764 161.389 81.1344 161.243 81.0595 161.112C80.9846 160.981 80.8791 160.871 80.752 160.79L80.262 160.51C80.002 160.37 79.832 160.48 79.832 160.76Z"
        fill="#F38C28"
      />
      <path
        d="M82 162V164.12C82.011 164.269 82.0553 164.414 82.1298 164.544C82.2042 164.674 82.3068 164.785 82.43 164.87L82.92 165.15C83.16 165.29 83.35 165.15 83.35 164.9V162.8C83.339 162.651 83.2947 162.506 83.2202 162.376C83.1458 162.247 83.0432 162.135 82.92 162.05L82.43 161.77C82.21 161.63 82 161.74 82 162Z"
        fill="#263238"
      />
      <path
        d="M89.332 162.911L90.332 162.331C90.5444 162.236 90.7778 162.199 91.0092 162.221C91.2407 162.244 91.4622 162.327 91.652 162.461C92.1995 162.818 92.6551 163.3 92.9817 163.866C93.3084 164.433 93.4969 165.068 93.532 165.721C93.5563 165.955 93.5183 166.191 93.4217 166.405C93.325 166.62 93.1733 166.804 92.982 166.941L92.062 167.471L91.892 167.191C91.7025 167.149 91.5204 167.078 91.352 166.981C90.8045 166.624 90.349 166.142 90.0223 165.576C89.6957 165.009 89.5072 164.374 89.472 163.721C89.4711 163.559 89.4912 163.398 89.532 163.241L89.332 162.911Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M89.332 162.911L90.332 162.331C90.5444 162.236 90.7778 162.199 91.0092 162.221C91.2407 162.244 91.4622 162.327 91.652 162.461C92.1995 162.818 92.6551 163.3 92.9817 163.866C93.3084 164.433 93.4969 165.068 93.532 165.721C93.5563 165.955 93.5183 166.191 93.4217 166.405C93.325 166.62 93.1733 166.804 92.982 166.941L92.062 167.471L91.892 167.191C91.7025 167.149 91.5204 167.078 91.352 166.981C90.8045 166.624 90.349 166.142 90.0223 165.576C89.6957 165.009 89.5072 164.374 89.472 163.721C89.4711 163.559 89.4912 163.398 89.532 163.241L89.332 162.911Z"
        fill="black"
      />
      <path
        d="M90.7003 163C91.2478 163.358 91.7034 163.839 92.03 164.405C92.3567 164.972 92.5452 165.607 92.5803 166.26C92.5803 167.46 91.7403 167.95 90.7003 167.35C90.1528 166.993 89.6972 166.511 89.3706 165.945C89.044 165.378 88.8554 164.743 88.8203 164.09C88.8203 162.9 89.6603 162.41 90.7003 163Z"
        fill="#F38C28"
      />
      <path
        d="M97.5 167.621L98.5 167.051C98.7128 166.956 98.947 166.918 99.1789 166.943C99.4107 166.967 99.6319 167.053 99.82 167.191C100.368 167.548 100.823 168.03 101.15 168.596C101.476 169.163 101.665 169.798 101.7 170.451C101.724 170.685 101.686 170.921 101.59 171.135C101.493 171.349 101.341 171.534 101.15 171.671L100.23 172.201L100.06 171.921C99.8705 171.878 99.6884 171.808 99.52 171.711C98.9725 171.354 98.5169 170.872 98.1903 170.306C97.8637 169.739 97.6751 169.104 97.64 168.451C97.6377 168.289 97.6579 168.127 97.7 167.971L97.5 167.621Z"
        fill="#F38C28"
      />
      <path
        opacity="0.2"
        d="M97.5 167.621L98.5 167.051C98.7128 166.956 98.947 166.918 99.1789 166.943C99.4107 166.967 99.6319 167.053 99.82 167.191C100.368 167.548 100.823 168.03 101.15 168.596C101.476 169.163 101.665 169.798 101.7 170.451C101.724 170.685 101.686 170.921 101.59 171.135C101.493 171.349 101.341 171.534 101.15 171.671L100.23 172.201L100.06 171.921C99.8705 171.878 99.6884 171.808 99.52 171.711C98.9725 171.354 98.5169 170.872 98.1903 170.306C97.8637 169.739 97.6751 169.104 97.64 168.451C97.6377 168.289 97.6579 168.127 97.7 167.971L97.5 167.621Z"
        fill="black"
      />
      <path
        d="M98.87 167.731C99.4175 168.088 99.8731 168.57 100.2 169.136C100.526 169.703 100.715 170.338 100.75 170.991C100.75 172.191 99.91 172.671 98.87 172.071C98.3249 171.712 97.8717 171.23 97.5469 170.664C97.2221 170.097 97.0348 169.463 97 168.811C97 167.611 97.83 167.131 98.87 167.731Z"
        fill="#F38C28"
      />
      <path
        d="M134.91 338.601C135.006 339.924 135.413 341.206 136.097 342.342C136.782 343.479 137.725 344.437 138.85 345.141L249.14 408.821C250.362 409.437 251.712 409.758 253.08 409.758C254.449 409.758 255.798 409.437 257.02 408.821L407.93 321.691C409.119 321.061 410.114 320.12 410.807 318.967C411.501 317.815 411.868 316.496 411.868 315.15C411.868 313.805 411.501 312.486 410.807 311.334C410.114 310.181 409.119 309.24 407.93 308.61L297.63 244.941C296.411 244.32 295.063 243.996 293.695 243.996C292.327 243.996 290.979 244.32 289.76 244.941L138.85 332.071C137.726 332.772 136.783 333.729 136.098 334.864C135.414 335.999 135.007 337.279 134.91 338.601Z"
        fill="#143B88"
      />
      <path
        opacity="0.2"
        d="M253.08 401.24V409.76C251.708 409.79 250.351 409.466 249.14 408.82L138.85 345.14C137.696 344.533 136.723 343.631 136.032 342.525C135.34 341.42 134.954 340.15 134.914 338.847C134.873 337.543 135.179 336.252 135.8 335.106C136.422 333.959 137.336 332.998 138.45 332.32C136.68 333.58 136.82 335.44 138.85 336.61L249.14 400.29C250.35 400.94 251.707 401.267 253.08 401.24Z"
        fill="white"
      />
      <path
        d="M131.217 332.21C130.121 331.464 129.216 330.47 128.575 329.31C127.934 328.149 127.575 326.854 127.527 325.53V193.91C127.602 192.544 127.996 191.216 128.679 190.031C129.362 188.846 130.313 187.839 131.457 187.09L282.377 99.9996C283.517 99.2869 284.828 98.8978 286.172 98.8742C287.516 98.8506 288.84 99.1933 290.004 99.8655C291.168 100.538 292.126 101.514 292.777 102.69C293.428 103.866 293.746 105.197 293.697 106.54V238.12C293.623 239.486 293.228 240.816 292.543 242.001C291.859 243.186 290.904 244.193 289.757 244.94L138.847 332.07C137.675 332.688 136.374 333.022 135.049 333.046C133.724 333.071 132.412 332.784 131.217 332.21Z"
        fill="#143B88"
      />
      <path
        opacity="0.2"
        d="M138.379 332.301C137.235 332.915 135.95 333.216 134.653 333.173C133.356 333.131 132.093 332.747 130.992 332.06C129.891 331.373 128.991 330.408 128.383 329.261C127.775 328.115 127.48 326.828 127.529 325.531V193.911C127.573 192.541 127.969 191.205 128.679 190.031L136.069 194.291C135.357 195.461 134.958 196.793 134.909 198.161V329.791C134.909 332.121 136.429 333.171 138.379 332.301Z"
        fill="white"
      />
      <path
        opacity="0.4"
        d="M134.91 198.17V329.79C134.91 332.3 136.67 333.32 138.85 332.07L289.76 244.94C290.907 244.193 291.862 243.186 292.546 242.001C293.231 240.816 293.626 239.486 293.7 238.12V106.5C293.7 103.99 291.94 102.97 289.76 104.23L138.85 191.35C137.703 192.096 136.749 193.103 136.064 194.288C135.38 195.473 134.984 196.803 134.91 198.17Z"
        fill="white"
      />
      <path
        d="M138.85 336.61L249.14 400.291C250.362 400.907 251.711 401.228 253.08 401.228C254.448 401.228 255.798 400.907 257.02 400.291L407.93 313.161C410.1 311.901 410.1 309.87 407.93 308.61L297.63 244.941C296.411 244.32 295.063 243.996 293.695 243.996C292.327 243.996 290.979 244.32 289.76 244.941L138.85 332.071C136.67 333.321 136.67 335.36 138.85 336.61Z"
        fill="#143B88"
      />
      <path
        opacity="0.6"
        d="M138.85 336.61L249.14 400.291C250.362 400.907 251.711 401.228 253.08 401.228C254.448 401.228 255.798 400.907 257.02 400.291L407.93 313.161C410.1 311.901 410.1 309.87 407.93 308.61L297.63 244.941C296.411 244.32 295.063 243.996 293.695 243.996C292.327 243.996 290.979 244.32 289.76 244.941L138.85 332.071C136.67 333.321 136.67 335.36 138.85 336.61Z"
        fill="white"
      />
      <path
        d="M140.999 198.661L286.499 114.661C287.799 113.901 288.859 114.511 288.859 116.021V230.001C288.814 230.82 288.577 231.617 288.167 232.328C287.757 233.038 287.185 233.642 286.499 234.091L140.999 318.091C139.689 318.841 138.629 318.231 138.629 316.731V202.751C138.673 201.931 138.91 201.132 139.322 200.421C139.734 199.71 140.309 199.107 140.999 198.661Z"
        fill="#455A64"
      />
      <path
        d="M151.65 333.2L291.73 252.33C292.34 252.019 293.016 251.857 293.7 251.857C294.385 251.857 295.06 252.019 295.67 252.33L302.83 256.46C303.07 256.539 303.279 256.692 303.428 256.897C303.576 257.101 303.656 257.348 303.656 257.6C303.656 257.853 303.576 258.099 303.428 258.304C303.279 258.509 303.07 258.661 302.83 258.74L162.73 339.6C162.12 339.911 161.445 340.073 160.76 340.073C160.075 340.073 159.4 339.911 158.79 339.6L151.65 335.47C151.414 335.389 151.209 335.236 151.063 335.033C150.918 334.829 150.84 334.585 150.84 334.335C150.84 334.085 150.918 333.841 151.063 333.638C151.209 333.434 151.414 333.281 151.65 333.2Z"
        fill="#143B88"
      />
      <path
        opacity="0.4"
        d="M151.65 333.2L291.73 252.33C292.34 252.019 293.016 251.857 293.7 251.857C294.385 251.857 295.06 252.019 295.67 252.33L302.83 256.46C303.07 256.539 303.279 256.692 303.428 256.897C303.576 257.101 303.656 257.348 303.656 257.6C303.656 257.853 303.576 258.099 303.428 258.304C303.279 258.509 303.07 258.661 302.83 258.74L162.73 339.6C162.12 339.911 161.445 340.073 160.76 340.073C160.075 340.073 159.4 339.911 158.79 339.6L151.65 335.47C151.414 335.389 151.209 335.236 151.063 335.033C150.918 334.829 150.84 334.585 150.84 334.335C150.84 334.085 150.918 333.841 151.063 333.638C151.209 333.434 151.414 333.281 151.65 333.2Z"
        fill="white"
      />
      <path
        d="M170.119 343.86L310.189 263C310.799 262.689 311.474 262.527 312.159 262.527C312.844 262.527 313.519 262.689 314.129 263L358.199 288.44C358.436 288.521 358.641 288.674 358.786 288.878C358.931 289.081 359.009 289.325 359.009 289.575C359.009 289.825 358.931 290.069 358.786 290.273C358.641 290.476 358.436 290.629 358.199 290.71L218.279 371.47C217.668 371.779 216.993 371.939 216.309 371.939C215.625 371.939 214.95 371.779 214.339 371.47L170.119 346.13C169.883 346.049 169.677 345.896 169.532 345.693C169.387 345.489 169.309 345.245 169.309 344.995C169.309 344.745 169.387 344.501 169.532 344.298C169.677 344.094 169.883 343.941 170.119 343.86Z"
        fill="#143B88"
      />
      <path
        opacity="0.4"
        d="M170.119 343.86L310.189 263C310.799 262.689 311.474 262.527 312.159 262.527C312.844 262.527 313.519 262.689 314.129 263L358.199 288.44C358.436 288.521 358.641 288.674 358.786 288.878C358.931 289.081 359.009 289.325 359.009 289.575C359.009 289.825 358.931 290.069 358.786 290.273C358.641 290.476 358.436 290.629 358.199 290.71L218.279 371.47C217.668 371.779 216.993 371.939 216.309 371.939C215.625 371.939 214.95 371.779 214.339 371.47L170.119 346.13C169.883 346.049 169.677 345.896 169.532 345.693C169.387 345.489 169.309 345.245 169.309 344.995C169.309 344.745 169.387 344.501 169.532 344.298C169.677 344.094 169.883 343.941 170.119 343.86Z"
        fill="white"
      />
      <path
        d="M295.677 299.371L300.067 296.841C300.257 296.731 300.237 296.551 300.067 296.441L294.997 293.511C294.888 293.457 294.768 293.429 294.647 293.429C294.526 293.429 294.406 293.457 294.297 293.511L289.887 296.001C289.697 296.101 289.707 296.291 289.887 296.401L294.957 299.331C295.065 299.395 295.187 299.432 295.312 299.439C295.438 299.446 295.563 299.422 295.677 299.371ZM286.997 289.311L282.607 291.841C282.427 291.951 282.437 292.131 282.607 292.251L287.677 295.181C287.786 295.235 287.906 295.264 288.027 295.264C288.149 295.264 288.268 295.235 288.377 295.181L292.757 292.651C292.947 292.541 292.937 292.361 292.757 292.241L287.687 289.321C287.581 289.265 287.463 289.235 287.343 289.233C287.223 289.231 287.105 289.258 286.997 289.311ZM272.827 297.491L265.407 301.781C265.217 301.891 265.227 302.071 265.407 302.181L270.477 305.111C270.585 305.168 270.705 305.197 270.827 305.197C270.949 305.197 271.069 305.168 271.177 305.111L278.597 300.831C278.787 300.721 278.777 300.541 278.597 300.431L273.527 297.501C273.423 297.45 273.309 297.423 273.193 297.421C273.077 297.419 272.963 297.443 272.857 297.491H272.827ZM280.587 293.011L276.197 295.551C276.017 295.651 276.027 295.831 276.197 295.951L281.267 298.881C281.376 298.935 281.496 298.964 281.617 298.964C281.739 298.964 281.858 298.935 281.967 298.881L286.347 296.351C286.537 296.241 286.527 296.061 286.347 295.951L281.317 293.001C281.208 292.947 281.088 292.919 280.967 292.919C280.846 292.919 280.726 292.947 280.617 293.001L280.587 293.011ZM263.407 303.001L258.997 305.481C258.807 305.591 258.817 305.771 258.997 305.881L264.067 308.811C264.176 308.865 264.296 308.892 264.417 308.892C264.538 308.892 264.658 308.865 264.767 308.811L269.157 306.271C269.337 306.171 269.327 305.981 269.157 305.871L264.107 303.001C263.998 302.946 263.879 302.918 263.757 302.918C263.636 302.918 263.516 302.946 263.407 303.001ZM256.997 306.701L252.617 309.231C252.427 309.341 252.437 309.521 252.617 309.631L257.687 312.561C257.796 312.615 257.916 312.642 258.037 312.642C258.158 312.642 258.278 312.615 258.387 312.561L262.797 310.001C262.977 309.901 262.967 309.721 262.797 309.601L257.727 306.671C257.616 306.608 257.492 306.574 257.365 306.57C257.237 306.567 257.111 306.594 256.997 306.651V306.701ZM276.997 318.551L281.387 316.021C281.567 315.911 281.557 315.731 281.387 315.621L276.317 312.691C276.209 312.634 276.089 312.604 275.967 312.604C275.845 312.604 275.725 312.634 275.617 312.691L271.227 315.221C271.047 315.331 271.057 315.511 271.227 315.621L276.297 318.551C276.405 318.608 276.525 318.637 276.647 318.637C276.769 318.637 276.889 318.608 276.997 318.551ZM270.587 322.261L274.977 319.721C275.157 319.621 275.147 319.431 274.977 319.321L269.907 316.391C269.798 316.336 269.679 316.308 269.557 316.308C269.436 316.308 269.316 316.336 269.207 316.391L264.817 318.921C264.637 319.031 264.647 319.211 264.817 319.321L269.887 322.251C269.989 322.298 270.099 322.324 270.211 322.326C270.323 322.327 270.434 322.305 270.537 322.261H270.587ZM264.177 325.961L268.567 323.421C268.747 323.321 268.737 323.141 268.567 323.021L263.497 320.091C263.388 320.036 263.269 320.008 263.147 320.008C263.026 320.008 262.906 320.036 262.797 320.091L258.407 322.621C258.227 322.731 258.237 322.911 258.407 323.021L263.477 325.951C263.576 326.005 263.685 326.037 263.797 326.046C263.909 326.055 264.021 326.039 264.127 326.001L264.177 325.961ZM257.767 329.661L262.157 327.131C262.337 327.021 262.327 326.841 262.157 326.721L256.997 323.791C256.888 323.736 256.769 323.708 256.647 323.708C256.526 323.708 256.406 323.736 256.297 323.791L251.907 326.321C251.727 326.431 251.737 326.611 251.907 326.731L256.977 329.651C257.089 329.716 257.216 329.752 257.346 329.753C257.475 329.755 257.603 329.723 257.717 329.661H257.767ZM289.317 303.071L293.707 300.541C293.897 300.431 293.877 300.251 293.707 300.141L288.637 297.211C288.529 297.154 288.409 297.124 288.287 297.124C288.165 297.124 288.045 297.154 287.937 297.211L283.557 299.741C283.367 299.851 283.377 300.031 283.557 300.141L288.627 303.071C288.727 303.118 288.836 303.142 288.947 303.142C289.058 303.142 289.167 303.118 289.267 303.071H289.317ZM283.407 314.851L293.187 309.201C293.377 309.101 293.367 308.921 293.187 308.801L280.867 301.691C280.759 301.634 280.639 301.604 280.517 301.604C280.395 301.604 280.275 301.634 280.167 301.691L274.997 304.601C274.817 304.711 274.827 304.891 274.997 305.001L281.517 308.771C281.717 308.881 281.727 309.061 281.517 309.171L277.467 311.511C277.287 311.611 277.297 311.801 277.467 311.911L282.537 314.841C282.659 314.918 282.801 314.96 282.946 314.962C283.09 314.964 283.233 314.925 283.357 314.851H283.407ZM250.637 310.351L246.257 312.881C246.067 312.991 246.077 313.171 246.257 313.281L251.327 316.211C251.436 316.265 251.556 316.292 251.677 316.292C251.798 316.292 251.918 316.265 252.027 316.211L256.417 313.681C256.597 313.571 256.587 313.391 256.417 313.271L251.347 310.341C251.23 310.277 251.099 310.245 250.966 310.247C250.833 310.249 250.702 310.284 250.587 310.351H250.637ZM244.227 314.051L239.847 316.581C239.657 316.691 239.667 316.871 239.847 316.991L244.917 319.911C245.025 319.967 245.145 319.996 245.267 319.996C245.389 319.996 245.509 319.967 245.617 319.911L249.997 317.401C250.177 317.291 250.167 317.111 249.997 316.991L244.927 314.061C244.813 313.996 244.684 313.961 244.553 313.96C244.422 313.958 244.293 313.989 244.177 314.051H244.227ZM212.227 355.551C212.336 355.605 212.456 355.634 212.577 355.634C212.699 355.634 212.818 355.605 212.927 355.551L217.307 353.021C217.497 352.911 217.487 352.731 217.307 352.621L212.237 349.691C212.129 349.634 212.009 349.604 211.887 349.604C211.765 349.604 211.645 349.634 211.537 349.691L207.147 352.221C206.967 352.321 206.977 352.511 207.147 352.621L212.227 355.551ZM192.897 343.661L188.507 346.191C188.327 346.301 188.337 346.481 188.507 346.591L193.577 349.521C193.686 349.575 193.806 349.603 193.927 349.603C194.048 349.603 194.168 349.575 194.277 349.521L198.697 347.001C198.877 346.901 198.867 346.711 198.697 346.601L193.627 343.671C193.515 343.61 193.391 343.577 193.263 343.575C193.136 343.573 193.01 343.603 192.897 343.661ZM203.217 352.341C203.325 352.398 203.445 352.427 203.567 352.427C203.689 352.427 203.809 352.398 203.917 352.341L208.297 349.811C208.487 349.701 208.477 349.521 208.297 349.411L203.227 346.481C203.119 346.424 202.999 346.394 202.877 346.394C202.755 346.394 202.635 346.424 202.527 346.481L198.117 349.001C197.927 349.111 197.947 349.291 198.117 349.401L203.217 352.341ZM223.467 357.801L227.847 355.271C228.037 355.161 228.027 354.981 227.847 354.861L222.777 351.931C222.668 351.876 222.549 351.848 222.427 351.848C222.306 351.848 222.186 351.876 222.077 351.931L217.687 354.461C217.507 354.571 217.517 354.751 217.687 354.871L222.757 357.791C222.865 357.851 222.987 357.883 223.111 357.885C223.235 357.887 223.357 357.858 223.467 357.801ZM216.357 361.491C216.466 361.545 216.586 361.574 216.707 361.574C216.829 361.574 216.948 361.545 217.057 361.491L221.437 358.961C221.627 358.851 221.617 358.671 221.437 358.551L216.367 355.631C216.259 355.575 216.139 355.545 216.017 355.545C215.895 355.545 215.775 355.575 215.667 355.631L211.277 358.161C211.097 358.271 211.107 358.451 211.277 358.571L216.357 361.491ZM199.307 340.001L194.917 342.531C194.737 342.641 194.747 342.821 194.917 342.931L199.987 345.861C200.095 345.918 200.215 345.947 200.337 345.947C200.459 345.947 200.579 345.918 200.687 345.861L205.077 343.331C205.257 343.221 205.247 343.041 205.077 342.931L199.997 340.001C199.89 339.946 199.772 339.917 199.652 339.917C199.532 339.917 199.414 339.946 199.307 340.001ZM231.357 321.491L226.997 324.001C226.807 324.111 226.817 324.291 226.997 324.411L232.067 327.341C232.176 327.395 232.296 327.424 232.417 327.424C232.539 327.424 232.658 327.395 232.767 327.341L237.157 324.811C237.337 324.701 237.327 324.521 237.157 324.401L232.087 321.481C231.978 321.414 231.854 321.376 231.726 321.371C231.598 321.366 231.471 321.393 231.357 321.451V321.491ZM205.717 336.301L201.327 338.831C201.147 338.931 201.157 339.121 201.327 339.231L206.397 342.161C206.506 342.215 206.626 342.244 206.747 342.244C206.869 342.244 206.988 342.215 207.097 342.161L211.487 339.631C211.667 339.521 211.657 339.341 211.487 339.231L206.417 336.301C206.312 336.238 206.194 336.201 206.072 336.194C205.95 336.187 205.828 336.21 205.717 336.261V336.301ZM237.767 317.791L233.387 320.321C233.197 320.431 233.207 320.611 233.387 320.731L238.457 323.651C238.565 323.708 238.685 323.737 238.807 323.737C238.929 323.737 239.049 323.708 239.157 323.651L243.547 321.121C243.727 321.011 243.717 320.831 243.547 320.711L238.477 317.781C238.37 317.72 238.249 317.685 238.126 317.68C238.002 317.675 237.879 317.699 237.767 317.751V317.791ZM224.997 325.151L220.617 327.681C220.427 327.791 220.437 327.971 220.617 328.091L225.687 331.021C225.796 331.075 225.916 331.104 226.037 331.104C226.159 331.104 226.278 331.075 226.387 331.021L230.777 328.491C230.957 328.381 230.947 328.201 230.777 328.081L225.707 325.161C225.599 325.101 225.477 325.068 225.353 325.066C225.229 325.065 225.107 325.094 224.997 325.151ZM218.587 328.851L214.207 331.391C214.017 331.491 214.027 331.671 214.207 331.791L219.277 334.721C219.386 334.775 219.506 334.804 219.627 334.804C219.749 334.804 219.868 334.775 219.977 334.721L224.367 332.191C224.547 332.081 224.537 331.901 224.367 331.791L219.297 328.861C219.181 328.795 219.051 328.76 218.918 328.758C218.785 328.757 218.654 328.788 218.537 328.851H218.587ZM212.177 332.551L207.797 335.091C207.607 335.191 207.617 335.371 207.797 335.491L212.867 338.421C212.976 338.475 213.096 338.504 213.217 338.504C213.339 338.504 213.458 338.475 213.567 338.421L217.957 335.891C218.137 335.781 218.127 335.601 217.957 335.491L212.887 332.561C212.771 332.495 212.641 332.46 212.508 332.458C212.375 332.457 212.244 332.488 212.127 332.551H212.177ZM244.947 337.061L249.337 334.531C249.517 334.421 249.507 334.241 249.337 334.121L244.267 331.191C244.158 331.136 244.039 331.108 243.917 331.108C243.796 331.108 243.676 331.136 243.567 331.191L239.177 333.721C238.997 333.831 239.007 334.011 239.177 334.131L244.197 337.001C244.3 337.067 244.418 337.107 244.54 337.118C244.662 337.128 244.784 337.109 244.897 337.061H244.947ZM301.247 281.131L296.857 283.661C296.677 283.771 296.687 283.951 296.857 284.071L301.927 286.991C302.035 287.048 302.155 287.077 302.277 287.077C302.399 287.077 302.519 287.048 302.627 286.991L307.007 284.461C307.197 284.351 307.187 284.171 307.007 284.051L301.937 281.131C301.824 281.068 301.697 281.035 301.567 281.035C301.438 281.035 301.31 281.068 301.197 281.131H301.247ZM293.487 285.611L289.097 288.141C288.917 288.251 288.927 288.431 289.097 288.551L294.167 291.481C294.276 291.535 294.396 291.564 294.517 291.564C294.639 291.564 294.758 291.535 294.867 291.481L299.247 288.951C299.437 288.841 299.427 288.661 299.247 288.541L294.177 285.621C294.065 285.556 293.938 285.521 293.808 285.52C293.679 285.518 293.551 285.549 293.437 285.611H293.487ZM307.657 277.431L303.217 280.001C303.037 280.111 303.047 280.291 303.217 280.411L308.287 283.331C308.395 283.388 308.515 283.417 308.637 283.417C308.759 283.417 308.879 283.388 308.987 283.331L313.367 280.801C313.557 280.691 313.547 280.511 313.367 280.391L308.297 277.461C308.192 277.403 308.075 277.37 307.956 277.365C307.836 277.36 307.717 277.382 307.607 277.431H307.657ZM274.477 311.641L278.857 309.111C279.047 309.001 279.037 308.821 278.857 308.711L273.787 305.781C273.679 305.724 273.559 305.694 273.437 305.694C273.315 305.694 273.195 305.724 273.087 305.781L268.697 308.311C268.517 308.421 268.527 308.601 268.697 308.711L273.767 311.641C273.87 311.691 273.983 311.717 274.097 311.717C274.211 311.717 274.324 311.691 274.427 311.641H274.477ZM314.767 273.741C314.658 273.686 314.539 273.658 314.417 273.658C314.296 273.658 314.176 273.686 314.067 273.741L309.677 276.271C309.497 276.381 309.507 276.561 309.677 276.681L314.747 279.601C314.855 279.658 314.975 279.687 315.097 279.687C315.219 279.687 315.339 279.658 315.447 279.601L319.827 277.071C320.017 276.961 320.007 276.781 319.827 276.661L314.767 273.741ZM251.357 333.361L255.747 330.831C255.927 330.721 255.917 330.541 255.747 330.421L250.677 327.491C250.568 327.436 250.449 327.408 250.327 327.408C250.206 327.408 250.086 327.436 249.977 327.491L245.507 330.001C245.327 330.111 245.337 330.291 245.507 330.411L250.577 333.331C250.686 333.398 250.81 333.435 250.938 333.441C251.066 333.446 251.193 333.418 251.307 333.361H251.357ZM329.917 288.001L334.297 285.471C334.487 285.361 334.477 285.181 334.297 285.071L329.227 282.141C329.119 282.084 328.999 282.054 328.877 282.054C328.755 282.054 328.635 282.084 328.527 282.141L324.137 284.671C323.957 284.771 323.967 284.961 324.137 285.071L329.207 288.001C329.317 288.057 329.439 288.086 329.562 288.086C329.685 288.086 329.807 288.057 329.917 288.001ZM316.257 287.521L320.647 284.991C320.837 284.881 320.817 284.701 320.647 284.591L315.577 281.661C315.468 281.607 315.348 281.579 315.227 281.579C315.106 281.579 314.986 281.607 314.877 281.661L310.497 284.191C310.307 284.301 310.317 284.481 310.497 284.601L315.567 287.531C315.677 287.578 315.797 287.598 315.917 287.591C316.036 287.584 316.153 287.55 316.257 287.491V287.521ZM321.957 277.961C321.849 277.904 321.729 277.874 321.607 277.874C321.485 277.874 321.365 277.904 321.257 277.961L316.877 280.491C316.687 280.601 316.697 280.781 316.877 280.901L321.947 283.831C322.056 283.885 322.176 283.914 322.297 283.914C322.419 283.914 322.538 283.885 322.647 283.831L327.037 281.301C327.227 281.191 327.207 281.011 327.037 280.891L321.957 277.961ZM323.307 277.181L335.627 284.291C335.736 284.345 335.856 284.374 335.977 284.374C336.099 284.374 336.218 284.345 336.327 284.291L340.707 281.761C340.897 281.651 340.887 281.471 340.707 281.361L328.387 274.251C328.279 274.194 328.159 274.164 328.037 274.164C327.915 274.164 327.795 274.194 327.687 274.251L323.307 276.781C323.097 276.851 323.107 277.001 323.307 277.151V277.181ZM308.437 285.341L304.057 287.881C303.867 287.981 303.877 288.161 304.057 288.281L309.127 291.211C309.236 291.265 309.356 291.294 309.477 291.294C309.599 291.294 309.718 291.265 309.827 291.211L314.217 288.681C314.407 288.571 314.387 288.391 314.217 288.281L309.147 285.351C309.04 285.289 308.92 285.253 308.797 285.246C308.673 285.239 308.55 285.261 308.437 285.311V285.341ZM260.197 313.171L255.807 315.701C255.627 315.811 255.637 315.991 255.807 316.101L260.877 319.031C260.986 319.085 261.106 319.112 261.227 319.112C261.348 319.112 261.468 319.085 261.577 319.031L265.957 316.491C266.147 316.391 266.137 316.211 265.957 316.091L260.887 313.161C260.779 313.109 260.661 313.084 260.541 313.085C260.421 313.087 260.304 313.116 260.197 313.171ZM322.807 291.661C322.915 291.718 323.035 291.747 323.157 291.747C323.279 291.747 323.399 291.718 323.507 291.661L327.887 289.131C328.077 289.021 328.067 288.841 327.887 288.731L322.817 285.801C322.709 285.744 322.589 285.714 322.467 285.714C322.345 285.714 322.225 285.744 322.117 285.801L317.727 288.331C317.547 288.441 317.557 288.621 317.727 288.731L322.807 291.661ZM266.607 309.471L262.217 312.001C262.037 312.111 262.047 312.291 262.217 312.401L267.287 315.331C267.396 315.385 267.516 315.413 267.637 315.413C267.758 315.413 267.878 315.385 267.987 315.331L272.367 312.791C272.557 312.691 272.547 312.501 272.367 312.391L267.297 309.461C267.189 309.409 267.071 309.384 266.951 309.385C266.831 309.387 266.714 309.416 266.607 309.471ZM218.557 351.851C218.666 351.905 218.786 351.934 218.907 351.934C219.029 351.934 219.148 351.905 219.257 351.851L223.647 349.321C223.827 349.211 223.817 349.031 223.647 348.921L218.547 346.001C218.438 345.947 218.318 345.919 218.197 345.919C218.076 345.919 217.956 345.947 217.847 346.001L213.457 348.541C213.277 348.641 213.287 348.821 213.457 348.941L218.557 351.851ZM208.917 342.781L204.527 345.311C204.337 345.411 204.357 345.601 204.527 345.711L209.597 348.641C209.706 348.695 209.826 348.724 209.947 348.724C210.069 348.724 210.188 348.695 210.297 348.641L214.677 346.111C214.867 346.001 214.857 345.821 214.677 345.711L209.607 342.781C209.5 342.726 209.382 342.697 209.262 342.697C209.142 342.697 209.024 342.726 208.917 342.781ZM225.667 348.161L230.047 345.631C230.237 345.521 230.227 345.341 230.047 345.231L224.997 342.301C224.888 342.247 224.768 342.219 224.647 342.219C224.526 342.219 224.406 342.247 224.297 342.301L219.907 344.841C219.727 344.941 219.737 345.121 219.907 345.241L224.977 348.171C225.085 348.222 225.204 348.248 225.323 348.246C225.443 348.244 225.561 348.215 225.667 348.161ZM232.077 344.461L236.467 341.931C236.647 341.821 236.637 341.641 236.467 341.521L231.397 338.601C231.289 338.544 231.169 338.514 231.047 338.514C230.925 338.514 230.805 338.544 230.697 338.601L226.307 341.131C226.127 341.241 226.137 341.421 226.307 341.541L231.377 344.471C231.486 344.524 231.607 344.55 231.728 344.549C231.85 344.547 231.969 344.517 232.077 344.461ZM238.487 340.761L242.877 338.231C243.057 338.121 243.047 337.941 242.877 337.821L237.807 334.901C237.699 334.844 237.579 334.814 237.457 334.814C237.335 334.814 237.215 334.844 237.107 334.901L232.717 337.431C232.537 337.541 232.547 337.721 232.717 337.841L237.787 340.771C237.896 340.824 238.017 340.85 238.138 340.849C238.26 340.847 238.379 340.817 238.487 340.761ZM215.327 339.071L210.937 341.611C210.747 341.711 210.767 341.891 210.937 342.011L216.007 344.941C216.116 344.995 216.236 345.024 216.357 345.024C216.479 345.024 216.598 344.995 216.707 344.941L221.087 342.411C221.277 342.301 221.267 342.121 221.087 342.011L215.997 339.091C215.894 339.038 215.78 339.01 215.664 339.006C215.548 339.003 215.433 339.025 215.327 339.071ZM221.737 335.371L217.347 337.911C217.167 338.011 217.177 338.191 217.347 338.311L222.417 341.241C222.526 341.295 222.646 341.324 222.767 341.324C222.889 341.324 223.008 341.295 223.117 341.241L227.497 338.711C227.687 338.601 227.677 338.421 227.497 338.311L222.427 335.381C222.32 335.327 222.203 335.298 222.083 335.296C221.964 335.295 221.845 335.32 221.737 335.371ZM247.377 320.571L242.997 323.101C242.817 323.211 242.827 323.391 242.997 323.511L248.067 326.431C248.175 326.488 248.295 326.517 248.417 326.517C248.539 326.517 248.659 326.488 248.767 326.431L253.147 323.901C253.337 323.791 253.327 323.611 253.147 323.491L248.077 320.561C247.968 320.508 247.847 320.481 247.726 320.483C247.604 320.485 247.485 320.515 247.377 320.571ZM240.967 324.271L236.577 326.801C236.397 326.911 236.407 327.091 236.577 327.211L241.647 330.131C241.755 330.188 241.875 330.217 241.997 330.217C242.119 330.217 242.239 330.188 242.347 330.131L246.727 327.601C246.917 327.491 246.907 327.311 246.727 327.191L241.657 324.261C241.553 324.214 241.44 324.191 241.326 324.192C241.212 324.194 241.1 324.221 240.997 324.271H240.967ZM253.787 316.871L249.397 319.401C249.217 319.511 249.227 319.691 249.397 319.801L254.467 322.731C254.576 322.785 254.696 322.812 254.817 322.812C254.938 322.812 255.058 322.785 255.167 322.731L259.547 320.191C259.737 320.091 259.727 319.911 259.547 319.791L254.477 316.861C254.369 316.809 254.251 316.784 254.131 316.785C254.011 316.787 253.894 316.816 253.787 316.871ZM228.147 331.671L223.757 334.201C223.577 334.311 223.587 334.491 223.757 334.611L228.827 337.541C228.936 337.595 229.056 337.624 229.177 337.624C229.299 337.624 229.418 337.595 229.527 337.541L233.907 335.011C234.097 334.901 234.087 334.721 233.907 334.601L228.837 331.681C228.731 331.625 228.613 331.595 228.493 331.593C228.373 331.591 228.255 331.618 228.147 331.671ZM234.557 327.971L230.167 330.501C229.987 330.611 229.997 330.791 230.167 330.911L235.237 333.841C235.346 333.895 235.466 333.924 235.587 333.924C235.709 333.924 235.828 333.895 235.937 333.841L240.317 331.311C240.507 331.201 240.497 331.021 240.317 330.901L235.257 328.001C235.149 327.945 235.029 327.915 234.907 327.915C234.785 327.915 234.665 327.945 234.557 328.001V327.971ZM229.877 354.101L234.257 351.571C234.447 351.461 234.437 351.281 234.257 351.161L229.187 348.231C229.078 348.176 228.959 348.148 228.837 348.148C228.716 348.148 228.596 348.176 228.487 348.231L224.097 350.761C223.917 350.871 223.927 351.051 224.097 351.171L229.167 354.091C229.275 354.151 229.397 354.183 229.521 354.185C229.645 354.187 229.767 354.158 229.877 354.101ZM192.257 350.301L187.187 347.371C187.078 347.316 186.959 347.288 186.837 347.288C186.716 347.288 186.596 347.316 186.487 347.371L182.097 349.901C181.917 350.011 181.927 350.191 182.097 350.301L187.167 353.231C187.276 353.285 187.396 353.312 187.517 353.312C187.638 353.312 187.758 353.285 187.867 353.231L192.257 350.691C192.467 350.601 192.457 350.421 192.257 350.301ZM201.867 353.121L196.797 350.191C196.688 350.136 196.569 350.108 196.447 350.108C196.326 350.108 196.206 350.136 196.097 350.191L189.347 354.081C189.157 354.191 189.167 354.371 189.347 354.491L194.427 357.411C194.535 357.468 194.655 357.497 194.777 357.497C194.899 357.497 195.019 357.468 195.127 357.411L201.867 353.511C202.077 353.421 202.067 353.231 201.867 353.121ZM184.477 344.641L179.407 341.711C179.298 341.656 179.179 341.628 179.057 341.628C178.936 341.628 178.816 341.656 178.707 341.711L173.307 344.821C173.127 344.931 173.137 345.111 173.307 345.231L178.377 348.161C178.486 348.215 178.606 348.244 178.727 348.244C178.849 348.244 178.968 348.215 179.077 348.161L184.477 345.041C184.687 344.941 184.677 344.751 184.477 344.641ZM188.617 342.251C188.725 342.308 188.845 342.337 188.967 342.337C189.089 342.337 189.209 342.308 189.317 342.251L193.697 339.721C193.887 339.611 193.877 339.431 193.697 339.321L188.627 336.391C188.519 336.334 188.399 336.304 188.277 336.304C188.155 336.304 188.035 336.334 187.927 336.391L183.537 338.921C183.357 339.031 183.367 339.211 183.537 339.321L188.617 342.251ZM210.797 356.331L205.727 353.401C205.619 353.344 205.499 353.314 205.377 353.314C205.255 353.314 205.135 353.344 205.027 353.401L196.587 358.271C196.407 358.371 196.417 358.551 196.587 358.671L201.657 361.601C201.766 361.655 201.886 361.684 202.007 361.684C202.129 361.684 202.248 361.655 202.357 361.601L210.787 356.731C210.997 356.621 210.997 356.441 210.797 356.331ZM215.007 362.261L209.937 359.341C209.829 359.285 209.709 359.255 209.587 359.255C209.465 359.255 209.345 359.285 209.237 359.341L203.837 362.461C203.647 362.571 203.657 362.751 203.837 362.861L208.917 365.791C209.025 365.848 209.145 365.877 209.267 365.877C209.389 365.877 209.509 365.848 209.617 365.791L215.007 362.681C215.217 362.561 215.207 362.381 214.997 362.261H215.007ZM236.277 314.731C236.385 314.788 236.505 314.817 236.627 314.817C236.749 314.817 236.869 314.788 236.977 314.731L241.357 312.201C241.547 312.091 241.537 311.911 241.357 311.791L236.287 308.861C236.178 308.806 236.059 308.778 235.937 308.778C235.816 308.778 235.696 308.806 235.587 308.861L231.197 311.391C231.017 311.501 231.027 311.681 231.197 311.801L236.277 314.731ZM223.457 322.141C223.566 322.195 223.686 322.224 223.807 322.224C223.929 322.224 224.048 322.195 224.157 322.141L228.537 319.611C228.727 319.501 228.717 319.321 228.537 319.201L223.467 316.281C223.359 316.225 223.239 316.195 223.117 316.195C222.995 316.195 222.875 316.225 222.767 316.281L218.377 318.811C218.197 318.921 218.207 319.101 218.377 319.221L223.457 322.141ZM194.997 338.551C195.106 338.605 195.226 338.634 195.347 338.634C195.469 338.634 195.588 338.605 195.697 338.551L200.077 336.021C200.267 335.911 200.257 335.731 200.077 335.621L194.997 332.701C194.888 332.647 194.768 332.619 194.647 332.619C194.526 332.619 194.406 332.647 194.297 332.701L189.907 335.241C189.727 335.341 189.737 335.531 189.907 335.641L194.997 338.551ZM229.837 318.431C229.945 318.488 230.065 318.517 230.187 318.517C230.309 318.517 230.429 318.488 230.537 318.431L234.917 315.901C235.107 315.791 235.097 315.611 234.917 315.491L229.847 312.561C229.738 312.506 229.619 312.478 229.497 312.478C229.376 312.478 229.256 312.506 229.147 312.561L224.757 315.091C224.577 315.201 224.587 315.381 224.757 315.501L229.837 318.431ZM217.017 325.841C217.126 325.895 217.246 325.924 217.367 325.924C217.489 325.924 217.608 325.895 217.717 325.841L222.097 323.311C222.287 323.201 222.277 323.021 222.097 322.901L216.997 320.001C216.889 319.945 216.769 319.915 216.647 319.915C216.525 319.915 216.405 319.945 216.297 320.001L211.997 322.501C211.817 322.611 211.827 322.791 211.997 322.911L217.017 325.841ZM218.497 362.741C218.389 362.684 218.269 362.654 218.147 362.654C218.025 362.654 217.905 362.684 217.797 362.741L211.047 366.631C210.867 366.741 210.877 366.921 211.047 367.041L216.117 369.961C216.225 370.018 216.345 370.047 216.467 370.047C216.589 370.047 216.709 370.018 216.817 369.961L223.567 366.061C223.747 365.951 223.737 365.771 223.567 365.661L218.497 362.741ZM207.817 331.151C207.926 331.205 208.046 331.234 208.167 331.234C208.289 331.234 208.408 331.205 208.517 331.151L212.897 328.621C213.087 328.511 213.077 328.331 212.897 328.221L207.827 325.291C207.718 325.237 207.598 325.209 207.477 325.209C207.356 325.209 207.236 325.237 207.127 325.291L202.737 327.831C202.557 327.931 202.567 328.111 202.737 328.231L207.817 331.151ZM201.407 334.851C201.516 334.905 201.636 334.934 201.757 334.934C201.879 334.934 201.998 334.905 202.107 334.851L206.487 332.321C206.677 332.211 206.667 332.031 206.487 331.921L201.427 329.001C201.318 328.947 201.198 328.919 201.077 328.919C200.956 328.919 200.836 328.947 200.727 329.001L196.337 331.541C196.157 331.641 196.167 331.821 196.337 331.941L201.407 334.851ZM337.257 294.181C337.149 294.125 337.029 294.095 336.907 294.095C336.785 294.095 336.665 294.125 336.557 294.181L325.757 300.411C325.577 300.521 325.587 300.701 325.757 300.821L330.827 303.751C330.936 303.805 331.056 303.834 331.177 303.834C331.299 303.834 331.418 303.805 331.527 303.751L342.317 297.521C342.507 297.411 342.497 297.231 342.317 297.111L337.257 294.181ZM323.087 302.361C322.979 302.305 322.859 302.275 322.737 302.275C322.615 302.275 322.495 302.305 322.387 302.361L317.997 304.871C317.817 304.981 317.827 305.161 317.997 305.281L323.067 308.211C323.176 308.265 323.296 308.294 323.417 308.294C323.539 308.294 323.658 308.265 323.767 308.211L328.147 305.681C328.337 305.571 328.327 305.391 328.147 305.271L323.087 302.361ZM236.257 350.361L240.637 347.821C240.827 347.721 240.817 347.541 240.637 347.421L235.567 344.491C235.458 344.436 235.339 344.408 235.217 344.408C235.096 344.408 234.976 344.436 234.867 344.491L230.477 347.021C230.297 347.131 230.307 347.311 230.477 347.421L235.547 350.351C235.657 350.419 235.782 350.459 235.911 350.468C236.04 350.477 236.169 350.454 236.287 350.401L236.257 350.361ZM310.257 309.721C310.148 309.667 310.028 309.639 309.907 309.639C309.786 309.639 309.666 309.667 309.557 309.721L305.167 312.261C304.987 312.361 304.997 312.541 305.167 312.661L310.237 315.591C310.346 315.645 310.466 315.674 310.587 315.674C310.709 315.674 310.828 315.645 310.937 315.591L315.317 313.061C315.507 312.951 315.497 312.771 315.317 312.661L310.257 309.721ZM343.657 290.441C343.549 290.385 343.429 290.355 343.307 290.355C343.185 290.355 343.065 290.385 342.957 290.441L338.607 293.001C338.427 293.111 338.437 293.291 338.607 293.411L343.677 296.331C343.785 296.388 343.905 296.417 344.027 296.417C344.149 296.417 344.269 296.388 344.377 296.331L348.757 293.801C348.947 293.691 348.937 293.511 348.757 293.391L343.657 290.441ZM355.137 289.661L342.817 282.551C342.708 282.496 342.589 282.468 342.467 282.468C342.346 282.468 342.226 282.496 342.117 282.551L337.737 285.081C337.547 285.191 337.557 285.371 337.737 285.481L350.057 292.591C350.165 292.648 350.285 292.677 350.407 292.677C350.529 292.677 350.649 292.648 350.757 292.591L355.137 290.061C355.387 290.001 355.377 289.821 355.177 289.701L355.137 289.661ZM286.297 323.551C286.188 323.497 286.068 323.469 285.947 323.469C285.826 323.469 285.706 323.497 285.597 323.551L280.207 326.671C280.017 326.781 280.027 326.961 280.207 327.071L285.277 330.001C285.386 330.055 285.506 330.082 285.627 330.082C285.748 330.082 285.868 330.055 285.977 330.001L291.377 326.881C291.567 326.771 291.557 326.591 291.377 326.481L286.297 323.551ZM302.497 314.201C302.388 314.147 302.268 314.119 302.147 314.119C302.026 314.119 301.906 314.147 301.797 314.201L295.047 318.101C294.857 318.211 294.877 318.391 295.047 318.501L300.117 321.431C300.226 321.485 300.346 321.512 300.467 321.512C300.588 321.512 300.708 321.485 300.817 321.431L307.557 317.531C307.747 317.421 307.737 317.241 307.557 317.131L302.497 314.201ZM271.497 332.121C271.388 332.067 271.268 332.039 271.147 332.039C271.026 332.039 270.906 332.067 270.797 332.121L234.697 353.001C234.507 353.101 234.527 353.281 234.697 353.401L239.767 356.331C239.876 356.385 239.996 356.414 240.117 356.414C240.239 356.414 240.358 356.385 240.467 356.331L276.567 335.491C276.747 335.381 276.737 335.201 276.567 335.091L271.497 332.121ZM233.377 354.121C233.268 354.067 233.148 354.039 233.027 354.039C232.906 354.039 232.786 354.067 232.677 354.121L227.277 357.241C227.087 357.351 227.097 357.531 227.277 357.651L232.347 360.571C232.455 360.627 232.575 360.656 232.697 360.656C232.819 360.656 232.939 360.627 233.047 360.571L238.447 357.451C238.637 357.341 238.627 357.161 238.447 357.051L233.377 354.121ZM278.917 327.821C278.808 327.766 278.689 327.738 278.567 327.738C278.446 327.738 278.326 327.766 278.217 327.821L272.817 330.941C272.637 331.041 272.647 331.221 272.817 331.341L277.887 334.271C277.996 334.325 278.116 334.354 278.237 334.354C278.359 334.354 278.478 334.325 278.587 334.271L283.987 331.161C284.167 331.051 284.157 330.871 283.987 330.751L278.917 327.821ZM225.917 358.401C225.808 358.346 225.689 358.318 225.567 358.318C225.446 358.318 225.326 358.346 225.217 358.401L219.827 361.521C219.637 361.621 219.647 361.811 219.827 361.921L224.897 364.851C225.006 364.905 225.126 364.934 225.247 364.934C225.369 364.934 225.488 364.905 225.597 364.851L230.997 361.741C231.187 361.631 231.177 361.451 230.997 361.331L225.917 358.401ZM293.737 319.251C293.628 319.196 293.509 319.168 293.387 319.168C293.266 319.168 293.146 319.196 293.037 319.251L287.637 322.371C287.447 322.471 287.457 322.651 287.637 322.771L292.717 325.701C292.824 325.755 292.942 325.784 293.062 325.784C293.182 325.784 293.3 325.755 293.407 325.701L298.807 322.591C298.997 322.481 298.987 322.301 298.807 322.181L293.737 319.251ZM316.677 306.011C316.568 305.957 316.448 305.929 316.327 305.929C316.206 305.929 316.086 305.957 315.977 306.011L311.587 308.551C311.407 308.651 311.417 308.831 311.587 308.951L316.657 311.881C316.766 311.935 316.886 311.964 317.007 311.964C317.129 311.964 317.248 311.935 317.357 311.881L321.737 309.351C321.927 309.241 321.917 309.061 321.737 308.951L316.677 306.011ZM330.677 295.811L335.067 293.271C335.257 293.171 335.237 292.991 335.067 292.871L329.997 290.001C329.888 289.946 329.769 289.918 329.647 289.918C329.526 289.918 329.406 289.946 329.297 290.001L324.997 292.511C324.807 292.621 324.817 292.801 324.997 292.911L330.067 295.841C330.172 295.895 330.287 295.924 330.405 295.928C330.522 295.931 330.639 295.908 330.747 295.861L330.677 295.811ZM302.017 295.621L306.407 293.091C306.597 292.981 306.577 292.801 306.407 292.691L301.337 289.761C301.228 289.707 301.108 289.679 300.987 289.679C300.866 289.679 300.746 289.707 300.637 289.761L296.257 292.301C296.067 292.401 296.077 292.581 296.257 292.701L301.327 295.631C301.44 295.702 301.569 295.743 301.702 295.75C301.835 295.757 301.967 295.73 302.087 295.671L302.017 295.621ZM287.497 320.741L300.317 313.341C300.507 313.231 300.487 313.051 300.317 312.931L295.247 310.011C295.139 309.954 295.019 309.924 294.897 309.924C294.775 309.924 294.655 309.954 294.547 310.011L281.727 317.411C281.547 317.521 281.557 317.701 281.727 317.821L286.797 320.751C286.911 320.824 287.042 320.866 287.177 320.873C287.312 320.88 287.446 320.851 287.567 320.791L287.497 320.741ZM323.567 299.491C323.675 299.547 323.795 299.576 323.917 299.576C324.039 299.576 324.159 299.547 324.267 299.491L328.657 296.961C328.847 296.851 328.827 296.671 328.657 296.551L323.587 293.621C323.478 293.566 323.359 293.538 323.237 293.538C323.116 293.538 322.996 293.566 322.887 293.621L318.507 296.151C318.317 296.261 318.327 296.441 318.507 296.561L323.567 299.491ZM317.027 295.331L321.407 292.791C321.597 292.691 321.587 292.501 321.407 292.391L316.337 289.461C316.228 289.406 316.109 289.378 315.987 289.378C315.866 289.378 315.746 289.406 315.637 289.461L311.297 292.001C311.117 292.111 311.127 292.291 311.297 292.401L316.367 295.331C316.476 295.397 316.599 295.437 316.726 295.445C316.853 295.454 316.98 295.432 317.097 295.381L317.027 295.331ZM281.087 324.441L285.467 321.911C285.657 321.801 285.647 321.621 285.467 321.501L280.397 318.581C280.289 318.524 280.169 318.494 280.047 318.494C279.925 318.494 279.805 318.524 279.697 318.581L275.307 321.111C275.127 321.221 275.137 321.401 275.307 321.521L280.377 324.451C280.492 324.525 280.625 324.568 280.762 324.575C280.899 324.582 281.035 324.553 281.157 324.491L281.087 324.441ZM309.397 307.671C309.505 307.727 309.625 307.756 309.747 307.756C309.869 307.756 309.989 307.727 310.097 307.671L314.487 305.141C314.677 305.031 314.657 304.851 314.487 304.731L309.417 301.811C309.309 301.754 309.189 301.724 309.067 301.724C308.945 301.724 308.825 301.754 308.717 301.811L304.337 304.341C304.147 304.451 304.157 304.631 304.337 304.751L309.397 307.671ZM249.107 343.001L253.487 340.461C253.677 340.361 253.667 340.171 253.487 340.061L248.417 337.131C248.308 337.076 248.189 337.048 248.067 337.048C247.946 337.048 247.826 337.076 247.717 337.131L243.327 339.661C243.147 339.771 243.157 339.951 243.327 340.061L248.397 342.991C248.506 343.048 248.628 343.078 248.751 343.08C248.874 343.082 248.996 343.055 249.107 343.001ZM255.517 339.291L259.897 336.761C260.087 336.651 260.077 336.471 259.897 336.361L254.827 333.431C254.719 333.374 254.599 333.344 254.477 333.344C254.355 333.344 254.235 333.374 254.127 333.431L249.717 336.001C249.537 336.111 249.547 336.291 249.717 336.401L254.787 339.331C254.902 339.387 255.029 339.413 255.157 339.406C255.285 339.399 255.409 339.359 255.517 339.291ZM242.697 346.701L247.077 344.161C247.267 344.061 247.257 343.881 247.077 343.761L241.997 340.831C241.888 340.776 241.769 340.748 241.647 340.748C241.526 340.748 241.406 340.776 241.297 340.831L236.907 343.361C236.727 343.471 236.737 343.651 236.907 343.761L241.977 346.691C242.088 346.749 242.211 346.781 242.336 346.783C242.461 346.784 242.585 346.756 242.697 346.701ZM268.337 331.891L272.717 329.361C272.907 329.251 272.897 329.071 272.717 328.961L267.627 326.001C267.518 325.947 267.398 325.919 267.277 325.919C267.156 325.919 267.036 325.947 266.927 326.001L262.537 328.541C262.357 328.641 262.367 328.821 262.537 328.941L267.607 331.871C267.718 331.933 267.842 331.968 267.97 331.971C268.097 331.975 268.223 331.947 268.337 331.891ZM261.927 335.591L266.307 333.061C266.497 332.951 266.487 332.771 266.307 332.661L261.237 329.731C261.128 329.677 261.008 329.649 260.887 329.649C260.766 329.649 260.646 329.677 260.537 329.731L256.147 332.271C255.967 332.371 255.977 332.561 256.147 332.671L261.217 335.601C261.328 335.655 261.45 335.683 261.573 335.681C261.697 335.679 261.818 335.648 261.927 335.591ZM274.747 328.191L279.127 325.661C279.317 325.551 279.307 325.371 279.127 325.261L273.997 322.331C273.889 322.275 273.769 322.245 273.647 322.245C273.525 322.245 273.405 322.275 273.297 322.331L268.997 324.851C268.817 324.951 268.827 325.131 268.997 325.251L274.067 328.181C274.172 328.234 274.288 328.262 274.406 328.264C274.524 328.265 274.64 328.241 274.747 328.191ZM304.077 273.441C304.184 273.495 304.302 273.524 304.422 273.524C304.542 273.524 304.66 273.495 304.767 273.441L309.157 270.901C309.347 270.801 309.337 270.621 309.157 270.501L307.807 269.721C307.698 269.666 307.579 269.638 307.457 269.638C307.336 269.638 307.216 269.666 307.107 269.721L302.717 272.251C302.527 272.361 302.547 272.541 302.717 272.651L304.077 273.441ZM272.537 293.801C272.645 293.858 272.765 293.887 272.887 293.887C273.009 293.887 273.129 293.858 273.237 293.801L277.617 291.271C277.807 291.171 277.797 290.981 277.617 290.871L272.527 288.001C272.419 287.944 272.299 287.914 272.177 287.914C272.055 287.914 271.935 287.944 271.827 288.001L267.437 290.531C267.247 290.641 267.257 290.821 267.437 290.931L272.537 293.801ZM285.357 286.401C285.466 286.455 285.586 286.484 285.707 286.484C285.829 286.484 285.948 286.455 286.057 286.401L290.437 283.871C290.627 283.761 290.617 283.581 290.437 283.471L285.367 280.541C285.258 280.487 285.138 280.459 285.017 280.459C284.896 280.459 284.776 280.487 284.667 280.541L280.277 283.081C280.087 283.181 280.097 283.371 280.277 283.481L285.357 286.401ZM264.707 298.321C264.816 298.375 264.936 298.404 265.057 298.404C265.179 298.404 265.298 298.375 265.407 298.321L269.787 295.791C269.977 295.681 269.967 295.501 269.787 295.391L264.717 292.461C264.609 292.404 264.489 292.374 264.367 292.374C264.245 292.374 264.125 292.404 264.017 292.461L259.607 295.001C259.427 295.101 259.437 295.291 259.607 295.401L264.707 298.321ZM278.997 290.101C279.105 290.158 279.225 290.187 279.347 290.187C279.469 290.187 279.589 290.158 279.697 290.101L284.077 287.571C284.267 287.461 284.257 287.281 284.077 287.171L278.997 284.241C278.891 284.184 278.772 284.154 278.652 284.154C278.532 284.154 278.413 284.184 278.307 284.241L273.917 286.771C273.727 286.881 273.737 287.061 273.917 287.171L278.997 290.101ZM251.937 305.721C252.046 305.775 252.166 305.802 252.287 305.802C252.408 305.802 252.528 305.775 252.637 305.721L256.997 303.201C257.187 303.101 257.177 302.911 256.997 302.801L251.927 299.871C251.818 299.816 251.699 299.788 251.577 299.788C251.456 299.788 251.336 299.816 251.227 299.871L246.837 302.401C246.657 302.511 246.667 302.691 246.837 302.801L251.937 305.721ZM258.347 302.021C258.455 302.078 258.575 302.107 258.697 302.107C258.819 302.107 258.939 302.078 259.047 302.021L263.427 299.491C263.617 299.381 263.607 299.201 263.427 299.091L258.357 296.161C258.249 296.104 258.129 296.074 258.007 296.074C257.885 296.074 257.765 296.104 257.657 296.161L253.267 298.691C253.087 298.801 253.097 298.981 253.267 299.091L258.347 302.021ZM291.297 280.841C291.405 280.897 291.525 280.926 291.647 280.926C291.769 280.926 291.889 280.897 291.997 280.841L296.387 278.311C296.577 278.201 296.567 278.021 296.387 277.901L295.037 277.121C294.928 277.066 294.809 277.038 294.687 277.038C294.566 277.038 294.446 277.066 294.337 277.121L289.947 279.651C289.757 279.761 289.767 279.941 289.947 280.051L291.297 280.841ZM310.537 269.741C310.646 269.795 310.766 269.823 310.887 269.823C311.008 269.823 311.128 269.795 311.237 269.741L315.617 267.201C315.807 267.101 315.797 266.921 315.617 266.801L314.197 266.001C314.089 265.944 313.969 265.914 313.847 265.914C313.725 265.914 313.605 265.944 313.497 266.001L309.107 268.531C308.917 268.641 308.937 268.821 309.107 268.931L310.537 269.741ZM321.187 275.891C321.296 275.945 321.416 275.973 321.537 275.973C321.658 275.973 321.778 275.945 321.887 275.891L326.267 273.351C326.457 273.251 326.447 273.071 326.267 272.951L321.127 270.001C321.018 269.946 320.899 269.918 320.777 269.918C320.656 269.918 320.536 269.946 320.427 270.001L315.997 272.561C315.817 272.671 315.827 272.851 315.997 272.961L321.187 275.891ZM337.187 292.161L341.577 289.621C341.767 289.521 341.757 289.341 341.577 289.221L336.507 286.291C336.398 286.236 336.279 286.208 336.157 286.208C336.036 286.208 335.916 286.236 335.807 286.291L331.427 288.821C331.237 288.931 331.247 289.111 331.427 289.221L336.497 292.151C336.6 292.2 336.712 292.226 336.826 292.228C336.94 292.23 337.053 292.207 337.157 292.161H337.187ZM297.697 277.161C297.803 277.217 297.922 277.246 298.042 277.246C298.162 277.246 298.281 277.217 298.387 277.161L302.777 274.631C302.967 274.521 302.957 274.341 302.777 274.221L301.427 273.441C301.318 273.386 301.199 273.358 301.077 273.358C300.956 273.358 300.836 273.386 300.727 273.441L296.287 276.001C296.097 276.111 296.107 276.291 296.287 276.401L297.697 277.161ZM245.507 309.441C245.616 309.495 245.736 309.522 245.857 309.522C245.978 309.522 246.098 309.495 246.207 309.441L250.587 306.901C250.777 306.801 250.767 306.621 250.587 306.501L245.517 303.571C245.408 303.516 245.289 303.488 245.167 303.488C245.046 303.488 244.926 303.516 244.817 303.571L240.427 306.101C240.247 306.211 240.257 306.391 240.427 306.501L245.507 309.441Z"
        fill="#143B88"
      />
      <path
        opacity="0.8"
        d="M295.677 299.371L300.067 296.841C300.257 296.731 300.237 296.551 300.067 296.441L294.997 293.511C294.888 293.457 294.768 293.429 294.647 293.429C294.526 293.429 294.406 293.457 294.297 293.511L289.887 296.001C289.697 296.101 289.707 296.291 289.887 296.401L294.957 299.331C295.065 299.395 295.187 299.432 295.312 299.439C295.438 299.446 295.563 299.422 295.677 299.371ZM286.997 289.311L282.607 291.841C282.427 291.951 282.437 292.131 282.607 292.251L287.677 295.181C287.786 295.235 287.906 295.264 288.027 295.264C288.149 295.264 288.268 295.235 288.377 295.181L292.757 292.651C292.947 292.541 292.937 292.361 292.757 292.241L287.687 289.321C287.581 289.265 287.463 289.235 287.343 289.233C287.223 289.231 287.105 289.258 286.997 289.311ZM272.827 297.491L265.407 301.781C265.217 301.891 265.227 302.071 265.407 302.181L270.477 305.111C270.585 305.168 270.705 305.197 270.827 305.197C270.949 305.197 271.069 305.168 271.177 305.111L278.597 300.831C278.787 300.721 278.777 300.541 278.597 300.431L273.527 297.501C273.423 297.45 273.309 297.423 273.193 297.421C273.077 297.419 272.963 297.443 272.857 297.491H272.827ZM280.587 293.011L276.197 295.551C276.017 295.651 276.027 295.831 276.197 295.951L281.267 298.881C281.376 298.935 281.496 298.964 281.617 298.964C281.739 298.964 281.858 298.935 281.967 298.881L286.347 296.351C286.537 296.241 286.527 296.061 286.347 295.951L281.317 293.001C281.208 292.947 281.088 292.919 280.967 292.919C280.846 292.919 280.726 292.947 280.617 293.001L280.587 293.011ZM263.407 303.001L258.997 305.481C258.807 305.591 258.817 305.771 258.997 305.881L264.067 308.811C264.176 308.865 264.296 308.892 264.417 308.892C264.538 308.892 264.658 308.865 264.767 308.811L269.157 306.271C269.337 306.171 269.327 305.981 269.157 305.871L264.107 303.001C263.998 302.946 263.879 302.918 263.757 302.918C263.636 302.918 263.516 302.946 263.407 303.001ZM256.997 306.701L252.617 309.231C252.427 309.341 252.437 309.521 252.617 309.631L257.687 312.561C257.796 312.615 257.916 312.642 258.037 312.642C258.158 312.642 258.278 312.615 258.387 312.561L262.797 310.001C262.977 309.901 262.967 309.721 262.797 309.601L257.727 306.671C257.616 306.608 257.492 306.574 257.365 306.57C257.237 306.567 257.111 306.594 256.997 306.651V306.701ZM276.997 318.551L281.387 316.021C281.567 315.911 281.557 315.731 281.387 315.621L276.317 312.691C276.209 312.634 276.089 312.604 275.967 312.604C275.845 312.604 275.725 312.634 275.617 312.691L271.227 315.221C271.047 315.331 271.057 315.511 271.227 315.621L276.297 318.551C276.405 318.608 276.525 318.637 276.647 318.637C276.769 318.637 276.889 318.608 276.997 318.551ZM270.587 322.261L274.977 319.721C275.157 319.621 275.147 319.431 274.977 319.321L269.907 316.391C269.798 316.336 269.679 316.308 269.557 316.308C269.436 316.308 269.316 316.336 269.207 316.391L264.817 318.921C264.637 319.031 264.647 319.211 264.817 319.321L269.887 322.251C269.989 322.298 270.099 322.324 270.211 322.326C270.323 322.327 270.434 322.305 270.537 322.261H270.587ZM264.177 325.961L268.567 323.421C268.747 323.321 268.737 323.141 268.567 323.021L263.497 320.091C263.388 320.036 263.269 320.008 263.147 320.008C263.026 320.008 262.906 320.036 262.797 320.091L258.407 322.621C258.227 322.731 258.237 322.911 258.407 323.021L263.477 325.951C263.576 326.005 263.685 326.037 263.797 326.046C263.909 326.055 264.021 326.039 264.127 326.001L264.177 325.961ZM257.767 329.661L262.157 327.131C262.337 327.021 262.327 326.841 262.157 326.721L256.997 323.791C256.888 323.736 256.769 323.708 256.647 323.708C256.526 323.708 256.406 323.736 256.297 323.791L251.907 326.321C251.727 326.431 251.737 326.611 251.907 326.731L256.977 329.651C257.089 329.716 257.216 329.752 257.346 329.753C257.475 329.755 257.603 329.723 257.717 329.661H257.767ZM289.317 303.071L293.707 300.541C293.897 300.431 293.877 300.251 293.707 300.141L288.637 297.211C288.529 297.154 288.409 297.124 288.287 297.124C288.165 297.124 288.045 297.154 287.937 297.211L283.557 299.741C283.367 299.851 283.377 300.031 283.557 300.141L288.627 303.071C288.727 303.118 288.836 303.142 288.947 303.142C289.058 303.142 289.167 303.118 289.267 303.071H289.317ZM283.407 314.851L293.187 309.201C293.377 309.101 293.367 308.921 293.187 308.801L280.867 301.691C280.759 301.634 280.639 301.604 280.517 301.604C280.395 301.604 280.275 301.634 280.167 301.691L274.997 304.601C274.817 304.711 274.827 304.891 274.997 305.001L281.517 308.771C281.717 308.881 281.727 309.061 281.517 309.171L277.467 311.511C277.287 311.611 277.297 311.801 277.467 311.911L282.537 314.841C282.659 314.918 282.801 314.96 282.946 314.962C283.09 314.964 283.233 314.925 283.357 314.851H283.407ZM250.637 310.351L246.257 312.881C246.067 312.991 246.077 313.171 246.257 313.281L251.327 316.211C251.436 316.265 251.556 316.292 251.677 316.292C251.798 316.292 251.918 316.265 252.027 316.211L256.417 313.681C256.597 313.571 256.587 313.391 256.417 313.271L251.347 310.341C251.23 310.277 251.099 310.245 250.966 310.247C250.833 310.249 250.702 310.284 250.587 310.351H250.637ZM244.227 314.051L239.847 316.581C239.657 316.691 239.667 316.871 239.847 316.991L244.917 319.911C245.025 319.967 245.145 319.996 245.267 319.996C245.389 319.996 245.509 319.967 245.617 319.911L249.997 317.401C250.177 317.291 250.167 317.111 249.997 316.991L244.927 314.061C244.813 313.996 244.684 313.961 244.553 313.96C244.422 313.958 244.293 313.989 244.177 314.051H244.227ZM212.227 355.551C212.336 355.605 212.456 355.634 212.577 355.634C212.699 355.634 212.818 355.605 212.927 355.551L217.307 353.021C217.497 352.911 217.487 352.731 217.307 352.621L212.237 349.691C212.129 349.634 212.009 349.604 211.887 349.604C211.765 349.604 211.645 349.634 211.537 349.691L207.147 352.221C206.967 352.321 206.977 352.511 207.147 352.621L212.227 355.551ZM192.897 343.661L188.507 346.191C188.327 346.301 188.337 346.481 188.507 346.591L193.577 349.521C193.686 349.575 193.806 349.603 193.927 349.603C194.048 349.603 194.168 349.575 194.277 349.521L198.697 347.001C198.877 346.901 198.867 346.711 198.697 346.601L193.627 343.671C193.515 343.61 193.391 343.577 193.263 343.575C193.136 343.573 193.01 343.603 192.897 343.661ZM203.217 352.341C203.325 352.398 203.445 352.427 203.567 352.427C203.689 352.427 203.809 352.398 203.917 352.341L208.297 349.811C208.487 349.701 208.477 349.521 208.297 349.411L203.227 346.481C203.119 346.424 202.999 346.394 202.877 346.394C202.755 346.394 202.635 346.424 202.527 346.481L198.117 349.001C197.927 349.111 197.947 349.291 198.117 349.401L203.217 352.341ZM223.467 357.801L227.847 355.271C228.037 355.161 228.027 354.981 227.847 354.861L222.777 351.931C222.668 351.876 222.549 351.848 222.427 351.848C222.306 351.848 222.186 351.876 222.077 351.931L217.687 354.461C217.507 354.571 217.517 354.751 217.687 354.871L222.757 357.791C222.865 357.851 222.987 357.883 223.111 357.885C223.235 357.887 223.357 357.858 223.467 357.801ZM216.357 361.491C216.466 361.545 216.586 361.574 216.707 361.574C216.829 361.574 216.948 361.545 217.057 361.491L221.437 358.961C221.627 358.851 221.617 358.671 221.437 358.551L216.367 355.631C216.259 355.575 216.139 355.545 216.017 355.545C215.895 355.545 215.775 355.575 215.667 355.631L211.277 358.161C211.097 358.271 211.107 358.451 211.277 358.571L216.357 361.491ZM199.307 340.001L194.917 342.531C194.737 342.641 194.747 342.821 194.917 342.931L199.987 345.861C200.095 345.918 200.215 345.947 200.337 345.947C200.459 345.947 200.579 345.918 200.687 345.861L205.077 343.331C205.257 343.221 205.247 343.041 205.077 342.931L199.997 340.001C199.89 339.946 199.772 339.917 199.652 339.917C199.532 339.917 199.414 339.946 199.307 340.001ZM231.357 321.491L226.997 324.001C226.807 324.111 226.817 324.291 226.997 324.411L232.067 327.341C232.176 327.395 232.296 327.424 232.417 327.424C232.539 327.424 232.658 327.395 232.767 327.341L237.157 324.811C237.337 324.701 237.327 324.521 237.157 324.401L232.087 321.481C231.978 321.414 231.854 321.376 231.726 321.371C231.598 321.366 231.471 321.393 231.357 321.451V321.491ZM205.717 336.301L201.327 338.831C201.147 338.931 201.157 339.121 201.327 339.231L206.397 342.161C206.506 342.215 206.626 342.244 206.747 342.244C206.869 342.244 206.988 342.215 207.097 342.161L211.487 339.631C211.667 339.521 211.657 339.341 211.487 339.231L206.417 336.301C206.312 336.238 206.194 336.201 206.072 336.194C205.95 336.187 205.828 336.21 205.717 336.261V336.301ZM237.767 317.791L233.387 320.321C233.197 320.431 233.207 320.611 233.387 320.731L238.457 323.651C238.565 323.708 238.685 323.737 238.807 323.737C238.929 323.737 239.049 323.708 239.157 323.651L243.547 321.121C243.727 321.011 243.717 320.831 243.547 320.711L238.477 317.781C238.37 317.72 238.249 317.685 238.126 317.68C238.002 317.675 237.879 317.699 237.767 317.751V317.791ZM224.997 325.151L220.617 327.681C220.427 327.791 220.437 327.971 220.617 328.091L225.687 331.021C225.796 331.075 225.916 331.104 226.037 331.104C226.159 331.104 226.278 331.075 226.387 331.021L230.777 328.491C230.957 328.381 230.947 328.201 230.777 328.081L225.707 325.161C225.599 325.101 225.477 325.068 225.353 325.066C225.229 325.065 225.107 325.094 224.997 325.151ZM218.587 328.851L214.207 331.391C214.017 331.491 214.027 331.671 214.207 331.791L219.277 334.721C219.386 334.775 219.506 334.804 219.627 334.804C219.749 334.804 219.868 334.775 219.977 334.721L224.367 332.191C224.547 332.081 224.537 331.901 224.367 331.791L219.297 328.861C219.181 328.795 219.051 328.76 218.918 328.758C218.785 328.757 218.654 328.788 218.537 328.851H218.587ZM212.177 332.551L207.797 335.091C207.607 335.191 207.617 335.371 207.797 335.491L212.867 338.421C212.976 338.475 213.096 338.504 213.217 338.504C213.339 338.504 213.458 338.475 213.567 338.421L217.957 335.891C218.137 335.781 218.127 335.601 217.957 335.491L212.887 332.561C212.771 332.495 212.641 332.46 212.508 332.458C212.375 332.457 212.244 332.488 212.127 332.551H212.177ZM244.947 337.061L249.337 334.531C249.517 334.421 249.507 334.241 249.337 334.121L244.267 331.191C244.158 331.136 244.039 331.108 243.917 331.108C243.796 331.108 243.676 331.136 243.567 331.191L239.177 333.721C238.997 333.831 239.007 334.011 239.177 334.131L244.197 337.001C244.3 337.067 244.418 337.107 244.54 337.118C244.662 337.128 244.784 337.109 244.897 337.061H244.947ZM301.247 281.131L296.857 283.661C296.677 283.771 296.687 283.951 296.857 284.071L301.927 286.991C302.035 287.048 302.155 287.077 302.277 287.077C302.399 287.077 302.519 287.048 302.627 286.991L307.007 284.461C307.197 284.351 307.187 284.171 307.007 284.051L301.937 281.131C301.824 281.068 301.697 281.035 301.567 281.035C301.438 281.035 301.31 281.068 301.197 281.131H301.247ZM293.487 285.611L289.097 288.141C288.917 288.251 288.927 288.431 289.097 288.551L294.167 291.481C294.276 291.535 294.396 291.564 294.517 291.564C294.639 291.564 294.758 291.535 294.867 291.481L299.247 288.951C299.437 288.841 299.427 288.661 299.247 288.541L294.177 285.621C294.065 285.556 293.938 285.521 293.808 285.52C293.679 285.518 293.551 285.549 293.437 285.611H293.487ZM307.657 277.431L303.217 280.001C303.037 280.111 303.047 280.291 303.217 280.411L308.287 283.331C308.395 283.388 308.515 283.417 308.637 283.417C308.759 283.417 308.879 283.388 308.987 283.331L313.367 280.801C313.557 280.691 313.547 280.511 313.367 280.391L308.297 277.461C308.192 277.403 308.075 277.37 307.956 277.365C307.836 277.36 307.717 277.382 307.607 277.431H307.657ZM274.477 311.641L278.857 309.111C279.047 309.001 279.037 308.821 278.857 308.711L273.787 305.781C273.679 305.724 273.559 305.694 273.437 305.694C273.315 305.694 273.195 305.724 273.087 305.781L268.697 308.311C268.517 308.421 268.527 308.601 268.697 308.711L273.767 311.641C273.87 311.691 273.983 311.717 274.097 311.717C274.211 311.717 274.324 311.691 274.427 311.641H274.477ZM314.767 273.741C314.658 273.686 314.539 273.658 314.417 273.658C314.296 273.658 314.176 273.686 314.067 273.741L309.677 276.271C309.497 276.381 309.507 276.561 309.677 276.681L314.747 279.601C314.855 279.658 314.975 279.687 315.097 279.687C315.219 279.687 315.339 279.658 315.447 279.601L319.827 277.071C320.017 276.961 320.007 276.781 319.827 276.661L314.767 273.741ZM251.357 333.361L255.747 330.831C255.927 330.721 255.917 330.541 255.747 330.421L250.677 327.491C250.568 327.436 250.449 327.408 250.327 327.408C250.206 327.408 250.086 327.436 249.977 327.491L245.507 330.001C245.327 330.111 245.337 330.291 245.507 330.411L250.577 333.331C250.686 333.398 250.81 333.435 250.938 333.441C251.066 333.446 251.193 333.418 251.307 333.361H251.357ZM329.917 288.001L334.297 285.471C334.487 285.361 334.477 285.181 334.297 285.071L329.227 282.141C329.119 282.084 328.999 282.054 328.877 282.054C328.755 282.054 328.635 282.084 328.527 282.141L324.137 284.671C323.957 284.771 323.967 284.961 324.137 285.071L329.207 288.001C329.317 288.057 329.439 288.086 329.562 288.086C329.685 288.086 329.807 288.057 329.917 288.001ZM316.257 287.521L320.647 284.991C320.837 284.881 320.817 284.701 320.647 284.591L315.577 281.661C315.468 281.607 315.348 281.579 315.227 281.579C315.106 281.579 314.986 281.607 314.877 281.661L310.497 284.191C310.307 284.301 310.317 284.481 310.497 284.601L315.567 287.531C315.677 287.578 315.797 287.598 315.917 287.591C316.036 287.584 316.153 287.55 316.257 287.491V287.521ZM321.957 277.961C321.849 277.904 321.729 277.874 321.607 277.874C321.485 277.874 321.365 277.904 321.257 277.961L316.877 280.491C316.687 280.601 316.697 280.781 316.877 280.901L321.947 283.831C322.056 283.885 322.176 283.914 322.297 283.914C322.419 283.914 322.538 283.885 322.647 283.831L327.037 281.301C327.227 281.191 327.207 281.011 327.037 280.891L321.957 277.961ZM323.307 277.181L335.627 284.291C335.736 284.345 335.856 284.374 335.977 284.374C336.099 284.374 336.218 284.345 336.327 284.291L340.707 281.761C340.897 281.651 340.887 281.471 340.707 281.361L328.387 274.251C328.279 274.194 328.159 274.164 328.037 274.164C327.915 274.164 327.795 274.194 327.687 274.251L323.307 276.781C323.097 276.851 323.107 277.001 323.307 277.151V277.181ZM308.437 285.341L304.057 287.881C303.867 287.981 303.877 288.161 304.057 288.281L309.127 291.211C309.236 291.265 309.356 291.294 309.477 291.294C309.599 291.294 309.718 291.265 309.827 291.211L314.217 288.681C314.407 288.571 314.387 288.391 314.217 288.281L309.147 285.351C309.04 285.289 308.92 285.253 308.797 285.246C308.673 285.239 308.55 285.261 308.437 285.311V285.341ZM260.197 313.171L255.807 315.701C255.627 315.811 255.637 315.991 255.807 316.101L260.877 319.031C260.986 319.085 261.106 319.112 261.227 319.112C261.348 319.112 261.468 319.085 261.577 319.031L265.957 316.491C266.147 316.391 266.137 316.211 265.957 316.091L260.887 313.161C260.779 313.109 260.661 313.084 260.541 313.085C260.421 313.087 260.304 313.116 260.197 313.171ZM322.807 291.661C322.915 291.718 323.035 291.747 323.157 291.747C323.279 291.747 323.399 291.718 323.507 291.661L327.887 289.131C328.077 289.021 328.067 288.841 327.887 288.731L322.817 285.801C322.709 285.744 322.589 285.714 322.467 285.714C322.345 285.714 322.225 285.744 322.117 285.801L317.727 288.331C317.547 288.441 317.557 288.621 317.727 288.731L322.807 291.661ZM266.607 309.471L262.217 312.001C262.037 312.111 262.047 312.291 262.217 312.401L267.287 315.331C267.396 315.385 267.516 315.413 267.637 315.413C267.758 315.413 267.878 315.385 267.987 315.331L272.367 312.791C272.557 312.691 272.547 312.501 272.367 312.391L267.297 309.461C267.189 309.409 267.071 309.384 266.951 309.385C266.831 309.387 266.714 309.416 266.607 309.471ZM218.557 351.851C218.666 351.905 218.786 351.934 218.907 351.934C219.029 351.934 219.148 351.905 219.257 351.851L223.647 349.321C223.827 349.211 223.817 349.031 223.647 348.921L218.547 346.001C218.438 345.947 218.318 345.919 218.197 345.919C218.076 345.919 217.956 345.947 217.847 346.001L213.457 348.541C213.277 348.641 213.287 348.821 213.457 348.941L218.557 351.851ZM208.917 342.781L204.527 345.311C204.337 345.411 204.357 345.601 204.527 345.711L209.597 348.641C209.706 348.695 209.826 348.724 209.947 348.724C210.069 348.724 210.188 348.695 210.297 348.641L214.677 346.111C214.867 346.001 214.857 345.821 214.677 345.711L209.607 342.781C209.5 342.726 209.382 342.697 209.262 342.697C209.142 342.697 209.024 342.726 208.917 342.781ZM225.667 348.161L230.047 345.631C230.237 345.521 230.227 345.341 230.047 345.231L224.997 342.301C224.888 342.247 224.768 342.219 224.647 342.219C224.526 342.219 224.406 342.247 224.297 342.301L219.907 344.841C219.727 344.941 219.737 345.121 219.907 345.241L224.977 348.171C225.085 348.222 225.204 348.248 225.323 348.246C225.443 348.244 225.561 348.215 225.667 348.161ZM232.077 344.461L236.467 341.931C236.647 341.821 236.637 341.641 236.467 341.521L231.397 338.601C231.289 338.544 231.169 338.514 231.047 338.514C230.925 338.514 230.805 338.544 230.697 338.601L226.307 341.131C226.127 341.241 226.137 341.421 226.307 341.541L231.377 344.471C231.486 344.524 231.607 344.55 231.728 344.549C231.85 344.547 231.969 344.517 232.077 344.461ZM238.487 340.761L242.877 338.231C243.057 338.121 243.047 337.941 242.877 337.821L237.807 334.901C237.699 334.844 237.579 334.814 237.457 334.814C237.335 334.814 237.215 334.844 237.107 334.901L232.717 337.431C232.537 337.541 232.547 337.721 232.717 337.841L237.787 340.771C237.896 340.824 238.017 340.85 238.138 340.849C238.26 340.847 238.379 340.817 238.487 340.761ZM215.327 339.071L210.937 341.611C210.747 341.711 210.767 341.891 210.937 342.011L216.007 344.941C216.116 344.995 216.236 345.024 216.357 345.024C216.479 345.024 216.598 344.995 216.707 344.941L221.087 342.411C221.277 342.301 221.267 342.121 221.087 342.011L215.997 339.091C215.894 339.038 215.78 339.01 215.664 339.006C215.548 339.003 215.433 339.025 215.327 339.071ZM221.737 335.371L217.347 337.911C217.167 338.011 217.177 338.191 217.347 338.311L222.417 341.241C222.526 341.295 222.646 341.324 222.767 341.324C222.889 341.324 223.008 341.295 223.117 341.241L227.497 338.711C227.687 338.601 227.677 338.421 227.497 338.311L222.427 335.381C222.32 335.327 222.203 335.298 222.083 335.296C221.964 335.295 221.845 335.32 221.737 335.371ZM247.377 320.571L242.997 323.101C242.817 323.211 242.827 323.391 242.997 323.511L248.067 326.431C248.175 326.488 248.295 326.517 248.417 326.517C248.539 326.517 248.659 326.488 248.767 326.431L253.147 323.901C253.337 323.791 253.327 323.611 253.147 323.491L248.077 320.561C247.968 320.508 247.847 320.481 247.726 320.483C247.604 320.485 247.485 320.515 247.377 320.571ZM240.967 324.271L236.577 326.801C236.397 326.911 236.407 327.091 236.577 327.211L241.647 330.131C241.755 330.188 241.875 330.217 241.997 330.217C242.119 330.217 242.239 330.188 242.347 330.131L246.727 327.601C246.917 327.491 246.907 327.311 246.727 327.191L241.657 324.261C241.553 324.214 241.44 324.191 241.326 324.192C241.212 324.194 241.1 324.221 240.997 324.271H240.967ZM253.787 316.871L249.397 319.401C249.217 319.511 249.227 319.691 249.397 319.801L254.467 322.731C254.576 322.785 254.696 322.812 254.817 322.812C254.938 322.812 255.058 322.785 255.167 322.731L259.547 320.191C259.737 320.091 259.727 319.911 259.547 319.791L254.477 316.861C254.369 316.809 254.251 316.784 254.131 316.785C254.011 316.787 253.894 316.816 253.787 316.871ZM228.147 331.671L223.757 334.201C223.577 334.311 223.587 334.491 223.757 334.611L228.827 337.541C228.936 337.595 229.056 337.624 229.177 337.624C229.299 337.624 229.418 337.595 229.527 337.541L233.907 335.011C234.097 334.901 234.087 334.721 233.907 334.601L228.837 331.681C228.731 331.625 228.613 331.595 228.493 331.593C228.373 331.591 228.255 331.618 228.147 331.671ZM234.557 327.971L230.167 330.501C229.987 330.611 229.997 330.791 230.167 330.911L235.237 333.841C235.346 333.895 235.466 333.924 235.587 333.924C235.709 333.924 235.828 333.895 235.937 333.841L240.317 331.311C240.507 331.201 240.497 331.021 240.317 330.901L235.257 328.001C235.149 327.945 235.029 327.915 234.907 327.915C234.785 327.915 234.665 327.945 234.557 328.001V327.971ZM229.877 354.101L234.257 351.571C234.447 351.461 234.437 351.281 234.257 351.161L229.187 348.231C229.078 348.176 228.959 348.148 228.837 348.148C228.716 348.148 228.596 348.176 228.487 348.231L224.097 350.761C223.917 350.871 223.927 351.051 224.097 351.171L229.167 354.091C229.275 354.151 229.397 354.183 229.521 354.185C229.645 354.187 229.767 354.158 229.877 354.101ZM192.257 350.301L187.187 347.371C187.078 347.316 186.959 347.288 186.837 347.288C186.716 347.288 186.596 347.316 186.487 347.371L182.097 349.901C181.917 350.011 181.927 350.191 182.097 350.301L187.167 353.231C187.276 353.285 187.396 353.312 187.517 353.312C187.638 353.312 187.758 353.285 187.867 353.231L192.257 350.691C192.467 350.601 192.457 350.421 192.257 350.301ZM201.867 353.121L196.797 350.191C196.688 350.136 196.569 350.108 196.447 350.108C196.326 350.108 196.206 350.136 196.097 350.191L189.347 354.081C189.157 354.191 189.167 354.371 189.347 354.491L194.427 357.411C194.535 357.468 194.655 357.497 194.777 357.497C194.899 357.497 195.019 357.468 195.127 357.411L201.867 353.511C202.077 353.421 202.067 353.231 201.867 353.121ZM184.477 344.641L179.407 341.711C179.298 341.656 179.179 341.628 179.057 341.628C178.936 341.628 178.816 341.656 178.707 341.711L173.307 344.821C173.127 344.931 173.137 345.111 173.307 345.231L178.377 348.161C178.486 348.215 178.606 348.244 178.727 348.244C178.849 348.244 178.968 348.215 179.077 348.161L184.477 345.041C184.687 344.941 184.677 344.751 184.477 344.641ZM188.617 342.251C188.725 342.308 188.845 342.337 188.967 342.337C189.089 342.337 189.209 342.308 189.317 342.251L193.697 339.721C193.887 339.611 193.877 339.431 193.697 339.321L188.627 336.391C188.519 336.334 188.399 336.304 188.277 336.304C188.155 336.304 188.035 336.334 187.927 336.391L183.537 338.921C183.357 339.031 183.367 339.211 183.537 339.321L188.617 342.251ZM210.797 356.331L205.727 353.401C205.619 353.344 205.499 353.314 205.377 353.314C205.255 353.314 205.135 353.344 205.027 353.401L196.587 358.271C196.407 358.371 196.417 358.551 196.587 358.671L201.657 361.601C201.766 361.655 201.886 361.684 202.007 361.684C202.129 361.684 202.248 361.655 202.357 361.601L210.787 356.731C210.997 356.621 210.997 356.441 210.797 356.331ZM215.007 362.261L209.937 359.341C209.829 359.285 209.709 359.255 209.587 359.255C209.465 359.255 209.345 359.285 209.237 359.341L203.837 362.461C203.647 362.571 203.657 362.751 203.837 362.861L208.917 365.791C209.025 365.848 209.145 365.877 209.267 365.877C209.389 365.877 209.509 365.848 209.617 365.791L215.007 362.681C215.217 362.561 215.207 362.381 214.997 362.261H215.007ZM236.277 314.731C236.385 314.788 236.505 314.817 236.627 314.817C236.749 314.817 236.869 314.788 236.977 314.731L241.357 312.201C241.547 312.091 241.537 311.911 241.357 311.791L236.287 308.861C236.178 308.806 236.059 308.778 235.937 308.778C235.816 308.778 235.696 308.806 235.587 308.861L231.197 311.391C231.017 311.501 231.027 311.681 231.197 311.801L236.277 314.731ZM223.457 322.141C223.566 322.195 223.686 322.224 223.807 322.224C223.929 322.224 224.048 322.195 224.157 322.141L228.537 319.611C228.727 319.501 228.717 319.321 228.537 319.201L223.467 316.281C223.359 316.225 223.239 316.195 223.117 316.195C222.995 316.195 222.875 316.225 222.767 316.281L218.377 318.811C218.197 318.921 218.207 319.101 218.377 319.221L223.457 322.141ZM194.997 338.551C195.106 338.605 195.226 338.634 195.347 338.634C195.469 338.634 195.588 338.605 195.697 338.551L200.077 336.021C200.267 335.911 200.257 335.731 200.077 335.621L194.997 332.701C194.888 332.647 194.768 332.619 194.647 332.619C194.526 332.619 194.406 332.647 194.297 332.701L189.907 335.241C189.727 335.341 189.737 335.531 189.907 335.641L194.997 338.551ZM229.837 318.431C229.945 318.488 230.065 318.517 230.187 318.517C230.309 318.517 230.429 318.488 230.537 318.431L234.917 315.901C235.107 315.791 235.097 315.611 234.917 315.491L229.847 312.561C229.738 312.506 229.619 312.478 229.497 312.478C229.376 312.478 229.256 312.506 229.147 312.561L224.757 315.091C224.577 315.201 224.587 315.381 224.757 315.501L229.837 318.431ZM217.017 325.841C217.126 325.895 217.246 325.924 217.367 325.924C217.489 325.924 217.608 325.895 217.717 325.841L222.097 323.311C222.287 323.201 222.277 323.021 222.097 322.901L216.997 320.001C216.889 319.945 216.769 319.915 216.647 319.915C216.525 319.915 216.405 319.945 216.297 320.001L211.997 322.501C211.817 322.611 211.827 322.791 211.997 322.911L217.017 325.841ZM218.497 362.741C218.389 362.684 218.269 362.654 218.147 362.654C218.025 362.654 217.905 362.684 217.797 362.741L211.047 366.631C210.867 366.741 210.877 366.921 211.047 367.041L216.117 369.961C216.225 370.018 216.345 370.047 216.467 370.047C216.589 370.047 216.709 370.018 216.817 369.961L223.567 366.061C223.747 365.951 223.737 365.771 223.567 365.661L218.497 362.741ZM207.817 331.151C207.926 331.205 208.046 331.234 208.167 331.234C208.289 331.234 208.408 331.205 208.517 331.151L212.897 328.621C213.087 328.511 213.077 328.331 212.897 328.221L207.827 325.291C207.718 325.237 207.598 325.209 207.477 325.209C207.356 325.209 207.236 325.237 207.127 325.291L202.737 327.831C202.557 327.931 202.567 328.111 202.737 328.231L207.817 331.151ZM201.407 334.851C201.516 334.905 201.636 334.934 201.757 334.934C201.879 334.934 201.998 334.905 202.107 334.851L206.487 332.321C206.677 332.211 206.667 332.031 206.487 331.921L201.427 329.001C201.318 328.947 201.198 328.919 201.077 328.919C200.956 328.919 200.836 328.947 200.727 329.001L196.337 331.541C196.157 331.641 196.167 331.821 196.337 331.941L201.407 334.851ZM337.257 294.181C337.149 294.125 337.029 294.095 336.907 294.095C336.785 294.095 336.665 294.125 336.557 294.181L325.757 300.411C325.577 300.521 325.587 300.701 325.757 300.821L330.827 303.751C330.936 303.805 331.056 303.834 331.177 303.834C331.299 303.834 331.418 303.805 331.527 303.751L342.317 297.521C342.507 297.411 342.497 297.231 342.317 297.111L337.257 294.181ZM323.087 302.361C322.979 302.305 322.859 302.275 322.737 302.275C322.615 302.275 322.495 302.305 322.387 302.361L317.997 304.871C317.817 304.981 317.827 305.161 317.997 305.281L323.067 308.211C323.176 308.265 323.296 308.294 323.417 308.294C323.539 308.294 323.658 308.265 323.767 308.211L328.147 305.681C328.337 305.571 328.327 305.391 328.147 305.271L323.087 302.361ZM236.257 350.361L240.637 347.821C240.827 347.721 240.817 347.541 240.637 347.421L235.567 344.491C235.458 344.436 235.339 344.408 235.217 344.408C235.096 344.408 234.976 344.436 234.867 344.491L230.477 347.021C230.297 347.131 230.307 347.311 230.477 347.421L235.547 350.351C235.657 350.419 235.782 350.459 235.911 350.468C236.04 350.477 236.169 350.454 236.287 350.401L236.257 350.361ZM310.257 309.721C310.148 309.667 310.028 309.639 309.907 309.639C309.786 309.639 309.666 309.667 309.557 309.721L305.167 312.261C304.987 312.361 304.997 312.541 305.167 312.661L310.237 315.591C310.346 315.645 310.466 315.674 310.587 315.674C310.709 315.674 310.828 315.645 310.937 315.591L315.317 313.061C315.507 312.951 315.497 312.771 315.317 312.661L310.257 309.721ZM343.657 290.441C343.549 290.385 343.429 290.355 343.307 290.355C343.185 290.355 343.065 290.385 342.957 290.441L338.607 293.001C338.427 293.111 338.437 293.291 338.607 293.411L343.677 296.331C343.785 296.388 343.905 296.417 344.027 296.417C344.149 296.417 344.269 296.388 344.377 296.331L348.757 293.801C348.947 293.691 348.937 293.511 348.757 293.391L343.657 290.441ZM355.137 289.661L342.817 282.551C342.708 282.496 342.589 282.468 342.467 282.468C342.346 282.468 342.226 282.496 342.117 282.551L337.737 285.081C337.547 285.191 337.557 285.371 337.737 285.481L350.057 292.591C350.165 292.648 350.285 292.677 350.407 292.677C350.529 292.677 350.649 292.648 350.757 292.591L355.137 290.061C355.387 290.001 355.377 289.821 355.177 289.701L355.137 289.661ZM286.297 323.551C286.188 323.497 286.068 323.469 285.947 323.469C285.826 323.469 285.706 323.497 285.597 323.551L280.207 326.671C280.017 326.781 280.027 326.961 280.207 327.071L285.277 330.001C285.386 330.055 285.506 330.082 285.627 330.082C285.748 330.082 285.868 330.055 285.977 330.001L291.377 326.881C291.567 326.771 291.557 326.591 291.377 326.481L286.297 323.551ZM302.497 314.201C302.388 314.147 302.268 314.119 302.147 314.119C302.026 314.119 301.906 314.147 301.797 314.201L295.047 318.101C294.857 318.211 294.877 318.391 295.047 318.501L300.117 321.431C300.226 321.485 300.346 321.512 300.467 321.512C300.588 321.512 300.708 321.485 300.817 321.431L307.557 317.531C307.747 317.421 307.737 317.241 307.557 317.131L302.497 314.201ZM271.497 332.121C271.388 332.067 271.268 332.039 271.147 332.039C271.026 332.039 270.906 332.067 270.797 332.121L234.697 353.001C234.507 353.101 234.527 353.281 234.697 353.401L239.767 356.331C239.876 356.385 239.996 356.414 240.117 356.414C240.239 356.414 240.358 356.385 240.467 356.331L276.567 335.491C276.747 335.381 276.737 335.201 276.567 335.091L271.497 332.121ZM233.377 354.121C233.268 354.067 233.148 354.039 233.027 354.039C232.906 354.039 232.786 354.067 232.677 354.121L227.277 357.241C227.087 357.351 227.097 357.531 227.277 357.651L232.347 360.571C232.455 360.627 232.575 360.656 232.697 360.656C232.819 360.656 232.939 360.627 233.047 360.571L238.447 357.451C238.637 357.341 238.627 357.161 238.447 357.051L233.377 354.121ZM278.917 327.821C278.808 327.766 278.689 327.738 278.567 327.738C278.446 327.738 278.326 327.766 278.217 327.821L272.817 330.941C272.637 331.041 272.647 331.221 272.817 331.341L277.887 334.271C277.996 334.325 278.116 334.354 278.237 334.354C278.359 334.354 278.478 334.325 278.587 334.271L283.987 331.161C284.167 331.051 284.157 330.871 283.987 330.751L278.917 327.821ZM225.917 358.401C225.808 358.346 225.689 358.318 225.567 358.318C225.446 358.318 225.326 358.346 225.217 358.401L219.827 361.521C219.637 361.621 219.647 361.811 219.827 361.921L224.897 364.851C225.006 364.905 225.126 364.934 225.247 364.934C225.369 364.934 225.488 364.905 225.597 364.851L230.997 361.741C231.187 361.631 231.177 361.451 230.997 361.331L225.917 358.401ZM293.737 319.251C293.628 319.196 293.509 319.168 293.387 319.168C293.266 319.168 293.146 319.196 293.037 319.251L287.637 322.371C287.447 322.471 287.457 322.651 287.637 322.771L292.717 325.701C292.824 325.755 292.942 325.784 293.062 325.784C293.182 325.784 293.3 325.755 293.407 325.701L298.807 322.591C298.997 322.481 298.987 322.301 298.807 322.181L293.737 319.251ZM316.677 306.011C316.568 305.957 316.448 305.929 316.327 305.929C316.206 305.929 316.086 305.957 315.977 306.011L311.587 308.551C311.407 308.651 311.417 308.831 311.587 308.951L316.657 311.881C316.766 311.935 316.886 311.964 317.007 311.964C317.129 311.964 317.248 311.935 317.357 311.881L321.737 309.351C321.927 309.241 321.917 309.061 321.737 308.951L316.677 306.011ZM330.677 295.811L335.067 293.271C335.257 293.171 335.237 292.991 335.067 292.871L329.997 290.001C329.888 289.946 329.769 289.918 329.647 289.918C329.526 289.918 329.406 289.946 329.297 290.001L324.997 292.511C324.807 292.621 324.817 292.801 324.997 292.911L330.067 295.841C330.172 295.895 330.287 295.924 330.405 295.928C330.522 295.931 330.639 295.908 330.747 295.861L330.677 295.811ZM302.017 295.621L306.407 293.091C306.597 292.981 306.577 292.801 306.407 292.691L301.337 289.761C301.228 289.707 301.108 289.679 300.987 289.679C300.866 289.679 300.746 289.707 300.637 289.761L296.257 292.301C296.067 292.401 296.077 292.581 296.257 292.701L301.327 295.631C301.44 295.702 301.569 295.743 301.702 295.75C301.835 295.757 301.967 295.73 302.087 295.671L302.017 295.621ZM287.497 320.741L300.317 313.341C300.507 313.231 300.487 313.051 300.317 312.931L295.247 310.011C295.139 309.954 295.019 309.924 294.897 309.924C294.775 309.924 294.655 309.954 294.547 310.011L281.727 317.411C281.547 317.521 281.557 317.701 281.727 317.821L286.797 320.751C286.911 320.824 287.042 320.866 287.177 320.873C287.312 320.88 287.446 320.851 287.567 320.791L287.497 320.741ZM323.567 299.491C323.675 299.547 323.795 299.576 323.917 299.576C324.039 299.576 324.159 299.547 324.267 299.491L328.657 296.961C328.847 296.851 328.827 296.671 328.657 296.551L323.587 293.621C323.478 293.566 323.359 293.538 323.237 293.538C323.116 293.538 322.996 293.566 322.887 293.621L318.507 296.151C318.317 296.261 318.327 296.441 318.507 296.561L323.567 299.491ZM317.027 295.331L321.407 292.791C321.597 292.691 321.587 292.501 321.407 292.391L316.337 289.461C316.228 289.406 316.109 289.378 315.987 289.378C315.866 289.378 315.746 289.406 315.637 289.461L311.297 292.001C311.117 292.111 311.127 292.291 311.297 292.401L316.367 295.331C316.476 295.397 316.599 295.437 316.726 295.445C316.853 295.454 316.98 295.432 317.097 295.381L317.027 295.331ZM281.087 324.441L285.467 321.911C285.657 321.801 285.647 321.621 285.467 321.501L280.397 318.581C280.289 318.524 280.169 318.494 280.047 318.494C279.925 318.494 279.805 318.524 279.697 318.581L275.307 321.111C275.127 321.221 275.137 321.401 275.307 321.521L280.377 324.451C280.492 324.525 280.625 324.568 280.762 324.575C280.899 324.582 281.035 324.553 281.157 324.491L281.087 324.441ZM309.397 307.671C309.505 307.727 309.625 307.756 309.747 307.756C309.869 307.756 309.989 307.727 310.097 307.671L314.487 305.141C314.677 305.031 314.657 304.851 314.487 304.731L309.417 301.811C309.309 301.754 309.189 301.724 309.067 301.724C308.945 301.724 308.825 301.754 308.717 301.811L304.337 304.341C304.147 304.451 304.157 304.631 304.337 304.751L309.397 307.671ZM249.107 343.001L253.487 340.461C253.677 340.361 253.667 340.171 253.487 340.061L248.417 337.131C248.308 337.076 248.189 337.048 248.067 337.048C247.946 337.048 247.826 337.076 247.717 337.131L243.327 339.661C243.147 339.771 243.157 339.951 243.327 340.061L248.397 342.991C248.506 343.048 248.628 343.078 248.751 343.08C248.874 343.082 248.996 343.055 249.107 343.001ZM255.517 339.291L259.897 336.761C260.087 336.651 260.077 336.471 259.897 336.361L254.827 333.431C254.719 333.374 254.599 333.344 254.477 333.344C254.355 333.344 254.235 333.374 254.127 333.431L249.717 336.001C249.537 336.111 249.547 336.291 249.717 336.401L254.787 339.331C254.902 339.387 255.029 339.413 255.157 339.406C255.285 339.399 255.409 339.359 255.517 339.291ZM242.697 346.701L247.077 344.161C247.267 344.061 247.257 343.881 247.077 343.761L241.997 340.831C241.888 340.776 241.769 340.748 241.647 340.748C241.526 340.748 241.406 340.776 241.297 340.831L236.907 343.361C236.727 343.471 236.737 343.651 236.907 343.761L241.977 346.691C242.088 346.749 242.211 346.781 242.336 346.783C242.461 346.784 242.585 346.756 242.697 346.701ZM268.337 331.891L272.717 329.361C272.907 329.251 272.897 329.071 272.717 328.961L267.627 326.001C267.518 325.947 267.398 325.919 267.277 325.919C267.156 325.919 267.036 325.947 266.927 326.001L262.537 328.541C262.357 328.641 262.367 328.821 262.537 328.941L267.607 331.871C267.718 331.933 267.842 331.968 267.97 331.971C268.097 331.975 268.223 331.947 268.337 331.891ZM261.927 335.591L266.307 333.061C266.497 332.951 266.487 332.771 266.307 332.661L261.237 329.731C261.128 329.677 261.008 329.649 260.887 329.649C260.766 329.649 260.646 329.677 260.537 329.731L256.147 332.271C255.967 332.371 255.977 332.561 256.147 332.671L261.217 335.601C261.328 335.655 261.45 335.683 261.573 335.681C261.697 335.679 261.818 335.648 261.927 335.591ZM274.747 328.191L279.127 325.661C279.317 325.551 279.307 325.371 279.127 325.261L273.997 322.331C273.889 322.275 273.769 322.245 273.647 322.245C273.525 322.245 273.405 322.275 273.297 322.331L268.997 324.851C268.817 324.951 268.827 325.131 268.997 325.251L274.067 328.181C274.172 328.234 274.288 328.262 274.406 328.264C274.524 328.265 274.64 328.241 274.747 328.191ZM304.077 273.441C304.184 273.495 304.302 273.524 304.422 273.524C304.542 273.524 304.66 273.495 304.767 273.441L309.157 270.901C309.347 270.801 309.337 270.621 309.157 270.501L307.807 269.721C307.698 269.666 307.579 269.638 307.457 269.638C307.336 269.638 307.216 269.666 307.107 269.721L302.717 272.251C302.527 272.361 302.547 272.541 302.717 272.651L304.077 273.441ZM272.537 293.801C272.645 293.858 272.765 293.887 272.887 293.887C273.009 293.887 273.129 293.858 273.237 293.801L277.617 291.271C277.807 291.171 277.797 290.981 277.617 290.871L272.527 288.001C272.419 287.944 272.299 287.914 272.177 287.914C272.055 287.914 271.935 287.944 271.827 288.001L267.437 290.531C267.247 290.641 267.257 290.821 267.437 290.931L272.537 293.801ZM285.357 286.401C285.466 286.455 285.586 286.484 285.707 286.484C285.829 286.484 285.948 286.455 286.057 286.401L290.437 283.871C290.627 283.761 290.617 283.581 290.437 283.471L285.367 280.541C285.258 280.487 285.138 280.459 285.017 280.459C284.896 280.459 284.776 280.487 284.667 280.541L280.277 283.081C280.087 283.181 280.097 283.371 280.277 283.481L285.357 286.401ZM264.707 298.321C264.816 298.375 264.936 298.404 265.057 298.404C265.179 298.404 265.298 298.375 265.407 298.321L269.787 295.791C269.977 295.681 269.967 295.501 269.787 295.391L264.717 292.461C264.609 292.404 264.489 292.374 264.367 292.374C264.245 292.374 264.125 292.404 264.017 292.461L259.607 295.001C259.427 295.101 259.437 295.291 259.607 295.401L264.707 298.321ZM278.997 290.101C279.105 290.158 279.225 290.187 279.347 290.187C279.469 290.187 279.589 290.158 279.697 290.101L284.077 287.571C284.267 287.461 284.257 287.281 284.077 287.171L278.997 284.241C278.891 284.184 278.772 284.154 278.652 284.154C278.532 284.154 278.413 284.184 278.307 284.241L273.917 286.771C273.727 286.881 273.737 287.061 273.917 287.171L278.997 290.101ZM251.937 305.721C252.046 305.775 252.166 305.802 252.287 305.802C252.408 305.802 252.528 305.775 252.637 305.721L256.997 303.201C257.187 303.101 257.177 302.911 256.997 302.801L251.927 299.871C251.818 299.816 251.699 299.788 251.577 299.788C251.456 299.788 251.336 299.816 251.227 299.871L246.837 302.401C246.657 302.511 246.667 302.691 246.837 302.801L251.937 305.721ZM258.347 302.021C258.455 302.078 258.575 302.107 258.697 302.107C258.819 302.107 258.939 302.078 259.047 302.021L263.427 299.491C263.617 299.381 263.607 299.201 263.427 299.091L258.357 296.161C258.249 296.104 258.129 296.074 258.007 296.074C257.885 296.074 257.765 296.104 257.657 296.161L253.267 298.691C253.087 298.801 253.097 298.981 253.267 299.091L258.347 302.021ZM291.297 280.841C291.405 280.897 291.525 280.926 291.647 280.926C291.769 280.926 291.889 280.897 291.997 280.841L296.387 278.311C296.577 278.201 296.567 278.021 296.387 277.901L295.037 277.121C294.928 277.066 294.809 277.038 294.687 277.038C294.566 277.038 294.446 277.066 294.337 277.121L289.947 279.651C289.757 279.761 289.767 279.941 289.947 280.051L291.297 280.841ZM310.537 269.741C310.646 269.795 310.766 269.823 310.887 269.823C311.008 269.823 311.128 269.795 311.237 269.741L315.617 267.201C315.807 267.101 315.797 266.921 315.617 266.801L314.197 266.001C314.089 265.944 313.969 265.914 313.847 265.914C313.725 265.914 313.605 265.944 313.497 266.001L309.107 268.531C308.917 268.641 308.937 268.821 309.107 268.931L310.537 269.741ZM321.187 275.891C321.296 275.945 321.416 275.973 321.537 275.973C321.658 275.973 321.778 275.945 321.887 275.891L326.267 273.351C326.457 273.251 326.447 273.071 326.267 272.951L321.127 270.001C321.018 269.946 320.899 269.918 320.777 269.918C320.656 269.918 320.536 269.946 320.427 270.001L315.997 272.561C315.817 272.671 315.827 272.851 315.997 272.961L321.187 275.891ZM337.187 292.161L341.577 289.621C341.767 289.521 341.757 289.341 341.577 289.221L336.507 286.291C336.398 286.236 336.279 286.208 336.157 286.208C336.036 286.208 335.916 286.236 335.807 286.291L331.427 288.821C331.237 288.931 331.247 289.111 331.427 289.221L336.497 292.151C336.6 292.2 336.712 292.226 336.826 292.228C336.94 292.23 337.053 292.207 337.157 292.161H337.187ZM297.697 277.161C297.803 277.217 297.922 277.246 298.042 277.246C298.162 277.246 298.281 277.217 298.387 277.161L302.777 274.631C302.967 274.521 302.957 274.341 302.777 274.221L301.427 273.441C301.318 273.386 301.199 273.358 301.077 273.358C300.956 273.358 300.836 273.386 300.727 273.441L296.287 276.001C296.097 276.111 296.107 276.291 296.287 276.401L297.697 277.161ZM245.507 309.441C245.616 309.495 245.736 309.522 245.857 309.522C245.978 309.522 246.098 309.495 246.207 309.441L250.587 306.901C250.777 306.801 250.767 306.621 250.587 306.501L245.517 303.571C245.408 303.516 245.289 303.488 245.167 303.488C245.046 303.488 244.926 303.516 244.817 303.571L240.427 306.101C240.247 306.211 240.257 306.391 240.427 306.501L245.507 309.441Z"
        fill="white"
      />
      <path
        d="M273.897 347.901L317.187 322.901C317.919 322.531 318.727 322.338 319.547 322.338C320.367 322.338 321.175 322.531 321.907 322.901L346.727 337.231C348.027 337.981 348.027 339.231 346.727 339.961L303.447 364.961C302.715 365.335 301.904 365.531 301.082 365.531C300.26 365.531 299.449 365.335 298.717 364.961L273.897 350.631C272.597 349.871 272.597 348.651 273.897 347.901Z"
        fill="#143B88"
      />
      <path
        opacity="0.4"
        d="M273.897 347.901L317.187 322.901C317.919 322.531 318.727 322.338 319.547 322.338C320.367 322.338 321.175 322.531 321.907 322.901L346.727 337.231C348.027 337.981 348.027 339.231 346.727 339.961L303.447 364.961C302.715 365.335 301.904 365.531 301.082 365.531C300.26 365.531 299.449 365.335 298.717 364.961L273.897 350.631C272.597 349.871 272.597 348.651 273.897 347.901Z"
        fill="white"
      />
      <path
        d="M131.218 332.201C131.601 332.418 132.006 332.593 132.428 332.721C132.005 332.6 131.599 332.429 131.218 332.211C131.087 332.139 130.963 332.056 130.848 331.961C130.966 332.049 131.089 332.129 131.218 332.201Z"
        fill="#143B88"
      />
      <path
        opacity="0.6"
        d="M293.66 105.861C293.38 103.861 291.74 103.081 289.76 104.221L138.85 191.361C137.683 192.077 136.722 193.083 136.06 194.281L128.68 190.001C129.339 188.799 130.296 187.786 131.46 187.061L282.38 100.001C283.47 99.3128 284.721 98.9234 286.009 98.8713C287.297 98.8191 288.576 99.1061 289.718 99.7035C290.86 100.301 291.825 101.188 292.517 102.275C293.209 103.363 293.603 104.613 293.66 105.901V105.861Z"
        fill="white"
      />
      <path
        d="M138.109 332.572C138.109 332.572 138.109 332.571 138.169 332.521L138.109 332.572Z"
        fill="#143B88"
      />
      <path
        opacity="0.8"
        d="M411.869 315.151C411.771 316.474 411.364 317.755 410.679 318.891C409.995 320.028 409.053 320.987 407.929 321.691L256.999 408.821C255.784 409.455 254.428 409.771 253.059 409.741V401.231C254.431 401.261 255.788 400.937 256.999 400.291L407.909 313.161C409.909 311.981 410.069 310.161 408.309 308.871C409.326 309.593 410.171 310.53 410.787 311.615C411.402 312.701 411.771 313.908 411.869 315.151Z"
        fill="white"
      />
      <path
        d="M144.367 303.34C144.367 305.2 145.677 305.95 147.287 305.02L280.777 228C281.62 227.452 282.323 226.714 282.83 225.846C283.337 224.978 283.634 224.003 283.697 223V133L144.367 213.47V303.34Z"
        fill="#37474F"
      />
      <path
        d="M195.129 194.51V198.83C195.129 199.71 195.759 200.07 196.519 199.63L224.239 183.54V176L196.519 192.1C196.115 192.366 195.78 192.722 195.538 193.14C195.297 193.559 195.157 194.028 195.129 194.51Z"
        fill="#FAFAFA"
      />
      <path
        d="M231.548 171.789C232.318 171.349 232.938 171.709 232.938 172.589V176.909C232.914 177.392 232.775 177.863 232.533 178.281C232.291 178.7 231.954 179.056 231.548 179.319L224.238 183.539V175.999L231.548 171.789Z"
        fill="#143B88"
      />
      <path
        d="M230.996 177.719L230.176 177.459C230.264 177.116 230.308 176.763 230.306 176.409C230.343 176.08 230.294 175.747 230.165 175.442C230.035 175.137 229.829 174.871 229.566 174.669C229.381 174.571 229.172 174.524 228.962 174.535C228.753 174.545 228.55 174.612 228.376 174.729C227.858 175.127 227.44 175.641 227.157 176.23C226.874 176.819 226.733 177.466 226.746 178.119C226.71 178.449 226.76 178.783 226.891 179.088C227.023 179.393 227.231 179.659 227.496 179.859C227.65 179.951 227.826 179.999 228.006 179.999C228.243 179.993 228.474 179.924 228.676 179.799C229.305 179.364 229.77 178.73 229.996 177.999L230.816 178.249H230.906C230.971 178.246 231.033 178.224 231.085 178.184C231.137 178.145 231.176 178.091 231.196 178.029C231.204 177.962 231.188 177.895 231.151 177.838C231.115 177.782 231.06 177.74 230.996 177.719ZM228.376 179.279C228.294 179.342 228.196 179.38 228.093 179.389C227.99 179.398 227.887 179.377 227.796 179.329C227.631 179.177 227.505 178.988 227.428 178.778C227.352 178.567 227.327 178.341 227.356 178.119C227.348 177.573 227.463 177.031 227.691 176.535C227.92 176.038 228.256 175.599 228.676 175.249C228.789 175.185 228.916 175.147 229.046 175.139C229.122 175.14 229.197 175.157 229.266 175.189C229.429 175.344 229.554 175.535 229.631 175.747C229.707 175.959 229.733 176.186 229.706 176.409C229.715 176.956 229.601 177.498 229.372 177.994C229.144 178.491 228.807 178.93 228.386 179.279H228.376Z"
        fill="#FAFAFA"
      />
      <path
        d="M144.367 207.37C144.431 206.367 144.728 205.392 145.235 204.524C145.742 203.656 146.444 202.918 147.287 202.37L280.777 125.29C282.387 124.36 283.697 125.12 283.697 126.97V133L144.367 213.47V207.37Z"
        fill="#263238"
      />
      <path
        d="M267.307 136.18C266.907 136.438 266.575 136.787 266.336 137.199C266.098 137.611 265.961 138.074 265.938 138.55C265.938 139.42 266.547 139.77 267.307 139.34C267.706 139.081 268.037 138.731 268.273 138.319C268.509 137.907 268.645 137.444 268.668 136.97C268.668 136.1 268.057 135.75 267.307 136.18Z"
        fill="#143B88"
      />
      <path
        d="M272.089 133.43C271.69 133.687 271.358 134.035 271.12 134.445C270.882 134.855 270.744 135.316 270.719 135.79C270.719 136.67 271.329 137.02 272.089 136.58C272.486 136.322 272.816 135.973 273.052 135.563C273.288 135.153 273.424 134.693 273.449 134.22C273.449 133.35 272.839 133 272.089 133.43Z"
        fill="#143B88"
      />
      <path
        d="M276.866 130.679C276.473 130.932 276.144 131.274 275.906 131.677C275.668 132.08 275.528 132.533 275.496 132.999C275.496 133.869 276.106 134.229 276.866 133.789C277.264 133.53 277.595 133.18 277.832 132.768C278.068 132.356 278.203 131.894 278.226 131.419C278.226 130.589 277.616 130.239 276.866 130.679Z"
        fill="#143B88"
      />
      <path
        d="M147.287 305L280.777 228C281.62 227.451 282.323 226.714 282.83 225.846C283.337 224.978 283.634 224.003 283.697 223V157.85L144.367 238.28V303.34C144.367 305.2 145.677 306 147.287 305Z"
        fill="#FAFAFA"
      />
      <path
        opacity="0.4"
        d="M198.826 193.001L219.186 181.251C219.966 180.801 220.596 181.111 220.596 181.961C220.564 182.436 220.42 182.898 220.175 183.306C219.93 183.715 219.591 184.059 219.186 184.311L198.856 195.981C198.066 196.431 197.426 196.131 197.426 195.311C197.462 194.843 197.608 194.391 197.851 193.989C198.094 193.588 198.428 193.25 198.826 193.001Z"
        fill="#455A64"
      />
      <path
        d="M195.259 244.81C195.129 244.88 195.029 244.89 194.959 244.81L194.799 244.64L191.499 239V246.49C191.499 246.63 191.464 246.767 191.399 246.89C191.356 247.001 191.279 247.096 191.179 247.16L190.179 247.72C190.148 247.746 190.109 247.761 190.069 247.761C190.028 247.761 189.989 247.746 189.959 247.72C189.892 247.639 189.859 247.535 189.869 247.43V235.67C189.869 235.532 189.899 235.395 189.959 235.27C190.002 235.157 190.079 235.059 190.179 234.99L191.009 234.52C191.139 234.44 191.249 234.43 191.319 234.52L191.469 234.69L194.779 240.34V232.85C194.781 232.712 194.811 232.576 194.869 232.45C194.915 232.341 194.991 232.247 195.089 232.18L196.089 231.63C196.119 231.604 196.158 231.59 196.199 231.59C196.239 231.59 196.278 231.604 196.309 231.63C196.345 231.669 196.373 231.714 196.39 231.764C196.407 231.814 196.414 231.868 196.409 231.92V243.66C196.41 243.8 196.376 243.938 196.309 244.06C196.269 244.176 196.192 244.274 196.089 244.34L195.259 244.81Z"
        fill="#143B88"
      />
      <path
        d="M197.996 235.26C198.02 234.567 198.103 233.878 198.246 233.2C198.387 232.533 198.605 231.886 198.896 231.27C199.172 230.667 199.528 230.105 199.956 229.6C200.378 229.091 200.89 228.664 201.466 228.34C201.911 228.04 202.43 227.871 202.966 227.85C203.364 227.851 203.744 228.009 204.026 228.29C204.336 228.627 204.559 229.036 204.676 229.48C204.839 230.059 204.926 230.658 204.936 231.26C204.936 231.48 204.936 231.73 204.936 232.01V233.74C204.936 234.02 204.936 234.28 204.936 234.51C204.912 235.202 204.829 235.891 204.686 236.57C204.545 237.239 204.327 237.89 204.036 238.51C203.76 239.111 203.399 239.67 202.966 240.17C202.54 240.668 202.033 241.091 201.466 241.42C201.016 241.716 200.494 241.885 199.956 241.91C199.76 241.912 199.565 241.875 199.383 241.801C199.201 241.727 199.035 241.618 198.896 241.48C198.578 241.147 198.354 240.737 198.246 240.29C198.094 239.711 198.01 239.117 197.996 238.52C197.996 238.29 197.996 238.04 197.996 237.77C197.996 237.5 197.996 237.2 197.996 236.91C197.996 236.62 197.996 236.32 197.996 236.04C197.996 235.76 197.996 235.5 197.996 235.26ZM203.346 232.26C203.392 231.64 203.195 231.026 202.796 230.55C202.456 230.26 202.016 230.28 201.466 230.6C200.887 230.952 200.424 231.466 200.136 232.08C199.788 232.815 199.601 233.616 199.586 234.43C199.586 234.9 199.586 235.43 199.586 235.98C199.586 236.53 199.586 237.05 199.586 237.5C199.561 237.805 199.596 238.113 199.691 238.405C199.785 238.696 199.937 238.967 200.136 239.2C200.476 239.48 200.916 239.46 201.466 239.14C202.045 238.788 202.508 238.273 202.796 237.66C203.141 236.93 203.328 236.136 203.346 235.33C203.346 234.86 203.346 234.33 203.346 233.78C203.346 233.23 203.326 232.72 203.316 232.27L203.346 232.26Z"
        fill="#143B88"
      />
      <path
        d="M212.387 222.19C212.845 221.899 213.366 221.721 213.907 221.67C214.104 221.659 214.301 221.688 214.487 221.755C214.672 221.822 214.842 221.926 214.987 222.06C215.305 222.398 215.532 222.811 215.647 223.26C215.81 223.884 215.901 224.525 215.917 225.17C215.917 226.05 215.917 226.95 215.917 227.86C215.891 228.61 215.801 229.356 215.647 230.09C215.501 230.779 215.28 231.45 214.987 232.09C214.716 232.68 214.358 233.225 213.927 233.71C213.504 234.192 213.004 234.601 212.447 234.92L209.447 236.64C209.415 236.667 209.374 236.682 209.332 236.682C209.29 236.682 209.249 236.667 209.217 236.64C209.183 236.6 209.158 236.554 209.143 236.504C209.127 236.454 209.122 236.402 209.127 236.35V224.55C209.129 224.412 209.16 224.276 209.217 224.15C209.266 224.04 209.346 223.946 209.447 223.88L212.387 222.19ZM214.327 226.09C214.318 225.752 214.268 225.416 214.177 225.09C214.115 224.843 213.991 224.616 213.817 224.43C213.651 224.277 213.432 224.195 213.207 224.2C212.897 224.227 212.598 224.33 212.337 224.5L210.747 225.41V233.59L212.387 232.59C212.709 232.417 212.994 232.182 213.227 231.9C213.466 231.626 213.664 231.32 213.817 230.99C213.978 230.645 214.099 230.283 214.177 229.91C214.262 229.522 214.312 229.127 214.327 228.73C214.357 227.87 214.357 227 214.327 226.09Z"
        fill="#143B88"
      />
      <path
        d="M221.176 217.121C221.296 217.051 221.396 217.051 221.456 217.121C221.537 217.231 221.595 217.357 221.626 217.491L224.516 227.311C224.522 227.351 224.522 227.391 224.516 227.431C224.514 227.569 224.483 227.705 224.426 227.831C224.376 227.941 224.297 228.035 224.196 228.101L223.346 228.591C223.186 228.681 223.076 228.701 223.016 228.591C222.956 228.529 222.912 228.453 222.886 228.371L222.376 226.641L218.646 228.791L218.146 231.111C218.112 231.239 218.065 231.363 218.006 231.481C217.935 231.629 217.819 231.751 217.676 231.831L216.826 232.321C216.795 232.347 216.756 232.361 216.716 232.361C216.675 232.361 216.636 232.347 216.606 232.321C216.539 232.24 216.506 232.136 216.516 232.031C216.51 231.988 216.51 231.944 216.516 231.901L219.406 218.741C219.442 218.55 219.496 218.362 219.566 218.181C219.626 218.046 219.728 217.934 219.856 217.861L221.176 217.121ZM221.826 224.731L220.526 220.301L219.226 226.231L221.826 224.731Z"
        fill="#143B88"
      />
      <path
        d="M230.269 211.87C230.299 211.844 230.338 211.83 230.379 211.83C230.419 211.83 230.458 211.844 230.489 211.87C230.524 211.91 230.55 211.956 230.568 212.005C230.585 212.055 230.592 212.108 230.589 212.16V213.45C230.583 213.589 230.549 213.726 230.489 213.85C230.443 213.962 230.367 214.059 230.269 214.13L228.139 215.35V225.35C228.139 225.489 228.108 225.625 228.049 225.75C228.002 225.865 227.922 225.963 227.819 226.03L226.869 226.58C226.836 226.607 226.796 226.622 226.754 226.622C226.712 226.622 226.671 226.607 226.639 226.58C226.605 226.541 226.58 226.494 226.564 226.445C226.549 226.395 226.544 226.342 226.549 226.29V216.29L224.419 217.52C224.388 217.547 224.349 217.561 224.309 217.561C224.268 217.561 224.229 217.547 224.199 217.52C224.163 217.481 224.136 217.436 224.119 217.386C224.102 217.336 224.095 217.283 224.099 217.23V215.94C224.104 215.802 224.138 215.665 224.199 215.54C224.245 215.431 224.321 215.338 224.419 215.27L230.269 211.87Z"
        fill="#143B88"
      />
      <path
        d="M234.806 209.25C234.936 209.18 235.026 209.17 235.086 209.25C235.172 209.357 235.231 209.484 235.256 209.62L238.146 219.44C238.153 219.479 238.153 219.52 238.146 219.56C238.141 219.699 238.107 219.835 238.046 219.96C238 220.069 237.924 220.163 237.826 220.23L236.976 220.72C236.816 220.81 236.706 220.82 236.646 220.72C236.581 220.658 236.536 220.578 236.516 220.49L235.996 218.8L232.296 221L231.786 223.31C231.757 223.441 231.713 223.568 231.656 223.69C231.588 223.837 231.472 223.957 231.326 224.03L230.476 224.52C230.446 224.546 230.407 224.56 230.366 224.56C230.326 224.56 230.287 224.546 230.256 224.52C230.22 224.481 230.192 224.436 230.175 224.386C230.158 224.335 230.151 224.282 230.156 224.23C230.151 224.183 230.151 224.136 230.156 224.09L233.046 210.94C233.084 210.748 233.141 210.56 233.216 210.38C233.273 210.246 233.371 210.134 233.496 210.06L234.806 209.25ZM235.456 216.85L234.156 212.42L232.856 218.35L235.456 216.85Z"
        fill="#143B88"
      />
      <path
        d="M458.409 276.919C459.829 248.119 457.679 241.159 450.119 235.709L446.779 252.339C446.779 252.339 449.829 272.089 449.299 278.639C448.849 284.389 448.119 291.579 446.659 296.199C446.388 297.014 445.83 297.704 445.089 298.139C443.089 299.319 442.289 300.549 440.779 302.059C439.599 303.239 438.619 303.519 438.779 303.909C438.993 304.336 439.36 304.666 439.806 304.835C440.253 305.003 440.746 304.998 441.189 304.819C442.177 304.453 443.117 303.97 443.989 303.379C443.273 305.13 442.281 306.754 441.049 308.189C438.229 311.489 438.049 313.549 443.589 313.719C447.059 313.829 449.869 311.719 452.649 304.179C453.73 301.406 454.609 298.559 455.279 295.659C456.749 288.129 458.179 281.549 458.409 276.919Z"
        fill="#FFA2A0"
      />
      <path
        d="M443.719 233.378C447.389 232.928 452.349 233.808 455.439 239.628C458.529 245.448 459.089 255.358 459.229 265.208C459.229 265.208 452.729 270.398 445.119 267.598L443.719 233.378Z"
        fill="#143B88"
      />
      <path
        opacity="0.5"
        d="M443.719 233.378C447.389 232.928 452.349 233.808 455.439 239.628C458.529 245.448 459.089 255.358 459.229 265.208C459.229 265.208 452.729 270.398 445.119 267.598L443.719 233.378Z"
        fill="black"
      />
      <path
        d="M450.79 384.23C451.33 384.45 451.45 385.51 451.49 387.6C451.49 389.19 451.79 391.96 449.92 392.47C448.05 392.98 445.34 392.64 444.19 391.12C442.796 389.086 441.301 387.123 439.71 385.24C437.92 383.24 435.97 381.34 435.29 378.55C434.68 376.04 435.29 374.97 436.98 374.28C439.35 373.33 442.98 376.68 444.79 377.28C446.36 377.71 450.24 384 450.79 384.23Z"
        fill="#263238"
      />
      <path
        d="M450.83 382.29L450.77 384.86C449.788 385.45 448.665 385.761 447.52 385.761C446.375 385.761 445.251 385.45 444.27 384.86C444.17 384.61 443.68 381.17 443.68 381.17L450.83 382.29Z"
        fill="#FFA2A0"
      />
      <path
        d="M429.641 398.569C429.641 398.569 430.321 400.819 430.641 402.789C430.921 404.349 431.311 406.959 430.741 408.109C430.171 409.259 428.031 409.979 424.741 409.879C422.611 409.809 419.261 411.189 416.951 412.399C414.641 413.609 409.681 414.069 407.201 413.729C404.281 413.319 401.281 411.549 400.841 410.329C400.401 409.109 401.051 407.859 408.021 405.069C408.081 405.069 417.681 402.159 421.101 398.549L429.641 398.569Z"
        fill="#263238"
      />
      <path
        d="M429.702 395.789C429.702 395.789 429.652 397.699 429.632 398.789C429.612 399.879 428.292 401.479 424.962 401.279C422.622 401.149 420.962 400.479 421.142 398.549L421.202 395.779L429.702 395.789Z"
        fill="#FFA2A0"
      />
      <path
        d="M453.271 348.22C452.802 343.655 451.888 339.147 450.541 334.76C450.541 334.76 451.711 323.23 452.401 312.29C453.141 300.47 452.981 285.59 453.271 282.65C453.271 282.65 415.271 274.07 414.271 287.72C413.271 301.37 414.681 336.24 415.001 342.26C415.321 348.28 416.231 353.61 417.251 363.37C418.271 373.13 421.181 395.78 421.181 395.78C422.488 396.48 423.948 396.847 425.431 396.847C426.914 396.847 428.374 396.48 429.681 395.78C429.681 395.78 432.981 368.5 432.861 361.57C432.757 356.429 431.987 351.323 430.571 346.38C430.571 346.38 431.571 335.12 432.401 325.33C433.231 315.54 434.051 310.84 434.291 306.58L435.121 306.19C435.121 306.19 435.581 323.13 435.891 329.14C436.201 335.15 437.041 340.94 438.521 352.14C439.811 361.85 443.841 382.43 443.841 382.43C448.151 384.89 450.841 382.28 450.841 382.28C450.841 382.28 454.261 356.64 453.271 348.22Z"
        fill="#143B88"
      />
      <path
        opacity="0.7"
        d="M453.271 348.22C452.802 343.655 451.888 339.147 450.541 334.76C450.541 334.76 451.711 323.23 452.401 312.29C453.141 300.47 452.981 285.59 453.271 282.65C453.271 282.65 415.271 274.07 414.271 287.72C413.271 301.37 414.681 336.24 415.001 342.26C415.321 348.28 416.231 353.61 417.251 363.37C418.271 373.13 421.181 395.78 421.181 395.78C422.488 396.48 423.948 396.847 425.431 396.847C426.914 396.847 428.374 396.48 429.681 395.78C429.681 395.78 432.981 368.5 432.861 361.57C432.757 356.429 431.987 351.323 430.571 346.38C430.571 346.38 431.571 335.12 432.401 325.33C433.231 315.54 434.051 310.84 434.291 306.58L435.121 306.19C435.121 306.19 435.581 323.13 435.891 329.14C436.201 335.15 437.041 340.94 438.521 352.14C439.811 361.85 443.841 382.43 443.841 382.43C448.151 384.89 450.841 382.28 450.841 382.28C450.841 382.28 454.261 356.64 453.271 348.22Z"
        fill="black"
      />
      <path
        opacity="0.4"
        d="M434.309 306.589C434.309 306.589 443.669 302.229 448.399 298.219C448.399 298.219 443.959 304.219 438.249 306.749C438.249 306.749 435.769 327.749 435.789 327.309L435.099 306.569L434.309 306.589Z"
        fill="black"
      />
      <path
        d="M427.82 228.639L429.8 241.119L441.05 240.549L439.74 225.949L427.82 228.639Z"
        fill="#FFA2A0"
      />
      <path
        d="M452.932 239.908C451.932 236.508 447.692 232.728 443.382 233.428C442.382 233.588 441.382 233.758 440.452 233.928C439.942 236.028 434.562 237.648 429.052 236.358C427.392 236.788 425.862 237.238 424.482 237.698C420.482 239.008 416.872 242.328 416.252 255.238C416.252 255.238 414.252 285.338 414.102 291.158C423.882 295.288 434.102 295.398 439.842 294.288C451.702 291.978 453.242 287.108 453.242 287.108C453.242 287.108 453.882 265.448 453.732 256.108C453.612 248.128 453.642 242.248 452.932 239.908Z"
        fill="#263238"
      />
      <path
        d="M419.501 213.318C419.501 213.318 416.551 217.798 416.891 218.238C417.231 218.678 419.391 219.068 419.391 219.068L419.501 213.318Z"
        fill="#8C3F3E"
      />
      <path
        d="M420.882 216.2C420.185 216.202 419.503 215.997 418.923 215.612C418.343 215.226 417.89 214.677 417.622 214.034C417.354 213.391 417.283 212.683 417.418 212C417.553 211.316 417.887 210.688 418.379 210.195C418.871 209.701 419.498 209.365 420.181 209.229C420.864 209.092 421.573 209.161 422.216 209.427C422.86 209.693 423.41 210.144 423.798 210.724C424.185 211.303 424.392 211.984 424.392 212.68C424.392 213.612 424.022 214.506 423.364 215.166C422.706 215.825 421.813 216.197 420.882 216.2ZM420.882 209.95C420.339 209.948 419.808 210.107 419.356 210.408C418.903 210.708 418.551 211.136 418.342 211.637C418.133 212.138 418.078 212.69 418.184 213.222C418.289 213.755 418.55 214.244 418.934 214.628C419.318 215.011 419.807 215.273 420.339 215.378C420.872 215.483 421.424 215.428 421.925 215.22C422.426 215.011 422.854 214.658 423.154 214.206C423.454 213.754 423.614 213.223 423.612 212.68C423.598 211.965 423.305 211.283 422.795 210.782C422.284 210.281 421.597 210 420.882 210V209.95Z"
        fill="#263238"
      />
      <path
        d="M427.692 200.939C421.692 202.199 420.002 204.819 419.442 214.309C418.852 224.209 419.862 227.309 421.162 228.659C422.042 229.559 426.922 229.719 429.392 229.049C432.472 228.199 439.442 225.729 442.702 220.739C446.542 214.879 447.552 206.929 443.442 203.669C437.652 199.089 430.122 200.429 427.692 200.939Z"
        fill="#FFA2A0"
      />
      <path
        d="M422.27 229.149C424.152 229.509 426.08 229.563 427.98 229.309C428.834 228.799 429.505 228.033 429.9 227.119C429.9 227.119 428.77 228.699 422.27 229.149Z"
        fill="#8C3F3E"
      />
      <path
        d="M417.691 211.949L428.311 213.319L427.881 214.069L417.691 212.749V211.949Z"
        fill="#263238"
      />
      <path
        d="M416.639 205.609C417.461 206.973 418.631 208.095 420.029 208.859C421.519 209.639 423.029 209.679 424.669 211.279C425.272 211.886 425.766 212.594 426.129 213.369C426.199 213.539 427.459 215.239 427.529 214.979C427.529 214.979 428.469 211.319 431.529 211.779C434.589 212.239 435.059 216.199 433.099 218.609C431.139 221.019 429.309 220.089 429.309 220.089C429.309 220.089 429.409 225.329 431.729 228.289C431.729 228.289 434.369 229.149 439.219 228.109C442.219 227.469 446.429 223.739 448.219 219.799C451.969 211.439 452.219 203.919 446.899 201.669C446.319 197.819 443.289 196.089 439.839 195.299C437.998 194.971 436.117 194.947 434.269 195.229C432.184 195.458 430.075 195.261 428.069 194.649C427.018 194.203 425.89 193.966 424.749 193.949C423.619 194.059 422.459 195.009 422.619 196.129C421.723 195.543 420.671 195.241 419.6 195.262C418.53 195.284 417.491 195.628 416.619 196.249C414.499 197.829 414.459 200.199 415.239 202.559C415.584 203.627 416.054 204.651 416.639 205.609Z"
        fill="#263238"
      />
      <path
        d="M446.999 202.999L450.579 200.889C450.286 200.441 449.832 200.124 449.311 200.002C448.79 199.88 448.243 199.964 447.782 200.235C447.321 200.507 446.982 200.946 446.837 201.461C446.691 201.975 446.749 202.526 446.999 202.999Z"
        fill="#263238"
      />
      <path
        d="M427.471 217.069L427.581 212.919C427.297 212.893 427.012 212.926 426.742 213.015C426.472 213.103 426.223 213.247 426.01 213.436C425.798 213.625 425.626 213.855 425.506 214.113C425.387 214.371 425.321 214.651 425.313 214.935C425.306 215.219 425.357 215.502 425.463 215.766C425.569 216.03 425.728 216.269 425.93 216.469C426.132 216.669 426.373 216.825 426.638 216.929C426.903 217.032 427.186 217.079 427.471 217.069Z"
        fill="#263238"
      />
      <path
        d="M423.88 240.139C416.35 235.059 401.5 224.139 399.7 222.999C397.2 221.469 393.37 221.119 391.02 222.369C388.84 223.539 390.07 226.459 394.29 231.439C398.38 236.259 416.15 254.439 416.15 254.439L423.88 240.139Z"
        fill="#FFA2A0"
      />
      <path
        d="M424.291 238.359C419.051 235.039 408.291 228.359 408.291 228.359C408.291 228.359 400.871 233.689 402.591 242.639C402.591 242.639 413.371 252.969 416.591 255.639C418.771 257.399 425.061 254.639 425.951 248.319C427.121 240.509 424.291 238.359 424.291 238.359Z"
        fill="#143B88"
      />
      <path
        opacity="0.5"
        d="M424.291 238.359C419.051 235.039 408.291 228.359 408.291 228.359C408.291 228.359 400.871 233.689 402.591 242.639C402.591 242.639 413.371 252.969 416.591 255.639C418.771 257.399 425.061 254.639 425.951 248.319C427.121 240.509 424.291 238.359 424.291 238.359Z"
        fill="black"
      />
      <path
        d="M390.121 224.05C390.691 219.92 403.381 211.18 407.721 208.49C409.68 207.297 411.507 205.899 413.171 204.32C413.831 203.68 414.411 202.97 415.061 202.32C415.711 201.67 416.271 200.78 417.061 200.1C417.999 199.186 419.063 198.411 420.221 197.8C422.433 196.855 424.897 196.679 427.221 197.3C427.761 197.42 428.301 197.57 428.861 197.64C430.031 197.79 431.361 197.64 432.271 198.36C432.372 198.427 432.456 198.516 432.518 198.619C432.581 198.723 432.619 198.839 432.631 198.96C432.631 199.34 432.261 199.58 431.921 199.75C429.251 201.05 426.101 201.49 423.871 203.46C423.701 203.61 422.661 204.98 423.231 205.13C423.801 205.28 425.741 204.48 427.841 204.54C430.371 204.61 428.701 206.07 427.841 206.54C426.477 207.325 424.999 207.895 423.461 208.23C421.101 208.8 419.041 209.06 417.461 210.11C415.881 211.16 401.821 225.38 401.821 225.38L390.121 224.05Z"
        fill="#FFA2A0"
      />
    </svg>
    <Typography variant="body2" className="font-bold">
      Tidak ada data yang ditampilkan
    </Typography>
  </div>
);

export default CustomNoRowsOverlay;
