import React, { useMemo } from 'react';
import DialogConfirm from 'src/shared/components/dialog/DialogConfirm';
import type { GridRowSelectionModel } from '@mui/x-data-grid-premium';
import { useNavigate } from 'react-router';

interface ModalReturFakturProps {
  dataSelected?: GridRowSelectionModel;
  setSelectionModel?: React.Dispatch<React.SetStateAction<GridRowSelectionModel | undefined>>;
  tableApiRef?: React.MutableRefObject<any>;
  isOpenDialogCancel: boolean;
  setIsOpenDialogCancel: (v: boolean) => void;
  type?: 'retur' | 'ubah';
}

/**
 * Ambil single ID dari berbagai bentuk rowSelectionModel
 */
const getSingleId = (sel?: any): string | null => {
  if (!sel) return null;
  if (Array.isArray(sel)) return sel[0]?.toString() ?? null;
  if (sel instanceof Set) return Array.from(sel)[0]?.toString() ?? null;
  if (sel?.ids instanceof Set) return Array.from(sel.ids)[0]?.toString() ?? null;
  return null;
};

const ModalReturFakturPM: React.FC<ModalReturFakturProps> = ({
  dataSelected,
  setSelectionModel,
  tableApiRef,
  isOpenDialogCancel,
  setIsOpenDialogCancel,
  type = 'retur',
}) => {
  const navigate = useNavigate();

  const selectedId = useMemo(() => getSingleId(dataSelected), [dataSelected]);

  const handleCloseModal = () => {
    setIsOpenDialogCancel(false);
  };

  const clearSelection = () => {
    tableApiRef?.current?.setRowSelectionModel?.([]);
    setSelectionModel?.(undefined);
  };

  const handleSubmit = () => {
    if (!selectedId) return;

    handleCloseModal();
    clearSelection();

    navigate(`/faktur/retur-pm/${selectedId}/${type}`);
  };

  return (
    <DialogConfirm
      fullWidth
      maxWidth="xs"
      title="Apakah Anda yakin akan melakukan Retur Pajak Masukan?"
      description=""
      actionTitle="Iya"
      isOpen={isOpenDialogCancel}
      isLoadingBtnSubmit={false}
      handleClose={handleCloseModal}
      handleSubmit={handleSubmit}
    />
  );
};

export default ModalReturFakturPM;
