import { useMutation } from '@tanstack/react-query';
import dayjs from 'dayjs';
import { enqueueSnackbar } from 'notistack';
import fakturApi from '../utils/api';
import type { TReturDokumenMasukanRequest } from '../types/types';
// import type { TReturDokumenMasukanRequest } from '../types';

interface UseReturProps {
  dlkData: any;
  onSuccess?: () => void;
}

export const useReturDokumenLainMasukan = ({ dlkData, onSuccess }: UseReturProps) =>
  useMutation({
    mutationFn: async (values: any) => {
      const num = (v: any) => Number(String(v ?? 0).replace(/,/g, '')) || 0;

      const payload: TReturDokumenMasukanRequest = {
        kdTransaksi: values.kdTransaksi ?? dlkData.kdtransaksi,
        kdJenisTransaksi: values.kdJenisTransaksi ?? dlkData.detailtransaksi,
        jnsDok: values.jnsDok ?? dlkData.dokumentransaksi,

        nomorRetur: values.nomorRetur ?? '',
        nomorDokumenRetur: values.nomorDokumenRetur ?? dlkData.nomordokumen,

        tanggalRetur: dayjs(values.tanggalRetur).format('DDMMYYYY'),

        masaPajak: values.masaPajak ?? dlkData.masapajak,
        tahunPajak: values.tahunPajak ?? dlkData.tahunpajak,

        npwpPenjual: values.npwpPenjual ?? dlkData.npwppenjual,
        namaPenjual: values.namaPenjual ?? dlkData.namapenjual,

        jumlahDppRetur: num(values.jumlahDpp),
        jumlahPpnRetur: num(values.jumlahPpn),
        jumlahPpnbmRetur: num(values.jumlahPpnbm),
      };

      return fakturApi.returDokumenLainMasukan(payload);
    },

    onSuccess: () => {
      enqueueSnackbar('Retur berhasil dikirim', {
        variant: 'success',
      });
      onSuccess?.();
    },

    onError: (err: any) => {
      enqueueSnackbar(err.message || 'Gagal mengirim retur', {
        variant: 'error',
      });
    },
  });
