import { useMutation } from '@tanstack/react-query';
import { enqueueSnackbar } from 'notistack';
import fakturApi from '../utils/api';
import type { TPostCreditUncreditedRequest } from '../types/types';

interface UsePostCreditUncreditedProps {
  onSuccess?: () => void;
  onError?: () => void;
}

export const usePostCreditUncredited = (props?: UsePostCreditUncreditedProps) =>
  useMutation({
    mutationKey: ['post-credit-uncredited'],
    mutationFn: async (payload: TPostCreditUncreditedRequest) =>
      fakturApi.postCreditUncredited(payload),

    onSuccess: () => {
      enqueueSnackbar('Status dokumen berhasil diperbarui', {
        variant: 'success',
      });
      props?.onSuccess?.();
    },

    onError: (err: any) => {
      enqueueSnackbar(err?.message || 'Gagal mengubah status credit / uncredited', {
        variant: 'error',
      });
    },
  });
