import { useMutation } from '@tanstack/react-query';
import type { TBaseResponseAPI, TDeleteRequest } from '../types/types';
import fakturApi from '../utils/api';

const useDeleteDokumenLainMasukan = (props?: any) =>
  useMutation<TBaseResponseAPI<null>, Error, TDeleteRequest>({
    mutationKey: ['delete-dokumen-lain-masukan'],
    mutationFn: (payload) => fakturApi.deleteDokumenLainMasukan(payload),
    ...props,
  });

export default useDeleteDokumenLainMasukan;
