export const DETAIL_TRANSAKSI = {
  PENYERAHAN_NON_PEMUNGUT: 'TD.00301',
  PENYERAHAN_PEMUNGUT_PEMERINTAH: 'TD.00302',
  PENYERAHAN_PEMUNGUT_NON_PEMERINTAH: 'TD.00303',
  DPP_LAIN: 'TD.00304',
  PERSENTASE_TERTENTU: 'TD.00305',
  TURIS_RESTITUSI: 'TD.00306',
  PPN_TIDAK_DIPUNGUT: 'TD.00307',
  PPN_DIBEBASKAN: 'TD.00308',
  PENJUALAN_ASET: 'TD.00309',
  TARIF_TIDAK_NORMAL: 'TD.00310',
  EKSPOR_BERWUJUD: 'TD.00311',
  EKSPOR_TIDAK_BERWUJUD: 'TD.00312',
  EKSPOR_JASA: 'TD.00313',
  IMPOR_BERWUJUD: 'TD.00314',
  IMPOR_TIDAK_BERWUJUD: 'TD.00315',
};

export const DETAIL_TRANSAKSI_TEXT = {
  [DETAIL_TRANSAKSI.PENYERAHAN_NON_PEMUNGUT]: 'Kepada PKP Penjual selain Pemungut PPN',
  [DETAIL_TRANSAKSI.PENYERAHAN_PEMUNGUT_PEMERINTAH]: 'Kepada Pemungut PPN Instansi Pemerintah',
  [DETAIL_TRANSAKSI.PENYERAHAN_PEMUNGUT_NON_PEMERINTAH]:
    'Kepada Pemungut PPN selain Instansi Pemerintah',
  [DETAIL_TRANSAKSI.DPP_LAIN]: 'Penyerahan yang menggunakan Dasar Pengenaan Pajak (DPP) Nilai Lain',
  [DETAIL_TRANSAKSI.PERSENTASE_TERTENTU]:
    'Penyerahan yang PPN-nya dipungut dengan besaran tertentu',
  [DETAIL_TRANSAKSI.TURIS_RESTITUSI]:
    'Kepada pemegang paspor luar negeri dalam rangka VAT Refund for Tourist',
  [DETAIL_TRANSAKSI.PPN_TIDAK_DIPUNGUT]:
    'Penyerahan yang mendapat fasilitas PPN dan/atau PPnBM Tidak Dipungut atau Ditanggung Pemerintah',
  [DETAIL_TRANSAKSI.PPN_DIBEBASKAN]:
    'Penyerahan yang mendapat fasilitas dibebaskan dari pengenaan PPN dan/atau PPnBM',
  [DETAIL_TRANSAKSI.PENJUALAN_ASET]:
    'Penyerahan aktiva yang menurut tujuan semula tidak untuk diperjualbelikan',
  [DETAIL_TRANSAKSI.TARIF_TIDAK_NORMAL]: 'Untuk penyerahan lainnya',
  [DETAIL_TRANSAKSI.EKSPOR_BERWUJUD]: 'Ekspor BKP Berwujud',
  [DETAIL_TRANSAKSI.EKSPOR_TIDAK_BERWUJUD]: 'Ekspor BKP Tidak Berwujud',
  [DETAIL_TRANSAKSI.EKSPOR_JASA]: 'Ekspor JKP',
  [DETAIL_TRANSAKSI.IMPOR_BERWUJUD]: 'Impor BKP',
  [DETAIL_TRANSAKSI.IMPOR_TIDAK_BERWUJUD]: 'Pemanfaatan BKP Tidak Berwujud dan JKP',
};

export const JENIS_INVOICE = {
  UANG_MUKA: 'uang-muka',
  PELUNASAN: 'pelunasan',
  FULL_PAYMENT: 'full-payment',
};

export const JENIS_INVOICE_TEXT = {
  [JENIS_INVOICE.UANG_MUKA]: 'Uang Muka',
  [JENIS_INVOICE.PELUNASAN]: 'Pelunasan',
  [JENIS_INVOICE.FULL_PAYMENT]: 'Full Payment',
};

// Transaction Types (short names)
export const KD_TRANSAKSI = {
  DELIVERY_SPECIAL: 'DELIVERY_SPECIAL',
  EXPORT: 'EXPORT',
  DELIVERY: 'DELIVERY',
  IMPORT: 'IMPORT',
  PURCHASE: 'PURCHASE',
  UNCREDIT: 'UNCREDIT',
};

// Transaction Type Codes
export const KD_TRANSAKSI_CODE = {
  [KD_TRANSAKSI.DELIVERY]: 'OSD.00101',
  [KD_TRANSAKSI.DELIVERY_SPECIAL]: 'OSD.00102',
  [KD_TRANSAKSI.EXPORT]: 'OSD.00103',
  [KD_TRANSAKSI.IMPORT]: 'OSD.00104',
  [KD_TRANSAKSI.PURCHASE]: 'OSD.00105',
  [KD_TRANSAKSI.UNCREDIT]: 'OSD.00106',
};

// Transaction Type Descriptions
export const KD_TRANSAKSI_TEXT = {
  [KD_TRANSAKSI.DELIVERY]: 'Penyerahan dengan Menggunakan Dokumen Tertentu',
  [KD_TRANSAKSI.DELIVERY_SPECIAL]: 'Pengiriman dengan dokumen khusus',
  [KD_TRANSAKSI.EXPORT]: 'Ekspor',
  [KD_TRANSAKSI.IMPORT]: 'Impor barang/pemanfaatan barang/jasa tidak berwujud',
  [KD_TRANSAKSI.PURCHASE]: 'Pembelian lokal',
  [KD_TRANSAKSI.UNCREDIT]: 'Pajak masukan tidak dikreditkan atau pajak masukan dengan fasilitas',
};

// Transaction Document Codes
export const DOKUMEN_TRANSAKSI = {
  DOKUMEN_DIPERSAMAKAN: 'OSD.00601',
  CUKAI_ROKOK: 'OSD.00602',
  DOKUMEN_KAWASAN_BERIKAT: 'OSD.00603',
  PEMBERITAHUAN_EKSPOR_BARANG: 'OSD.00604',
  PEMBERITAHUAN_EKSPOR_JASA: 'OSD.00605',
  PEMBERITAHUAN_IMPOR_BAYAR: 'OSD.00606',
  PEMBAYARAN: 'OSD.00607',
  DOKUMEN_TERTENTU: 'OSD.00608',
  SKPKB_SKPKBT: 'OSD.00609',
  PEMBERITAHUAN_IMPOR: 'OSD.00610',
};

// Transaction Document Descriptions
export const DOKUMEN_TRANSAKSI_TEXT = {
  [DOKUMEN_TRANSAKSI.DOKUMEN_DIPERSAMAKAN]: 'Dokumen yang Dipersamakan dengan Faktur Pajak',
  [DOKUMEN_TRANSAKSI.CUKAI_ROKOK]: 'Cukai Rokok',
  [DOKUMEN_TRANSAKSI.DOKUMEN_KAWASAN_BERIKAT]: 'Dokumen Kawasan Berikat',
  [DOKUMEN_TRANSAKSI.PEMBERITAHUAN_EKSPOR_BARANG]: 'Pemberitahuan Ekspor Barang (PEB)',
  [DOKUMEN_TRANSAKSI.PEMBERITAHUAN_EKSPOR_JASA]:
    'Pemberitahuan Ekspor BKP Tidak Berwujud/Pemberitahuan Ekspor JKP',
  [DOKUMEN_TRANSAKSI.PEMBERITAHUAN_IMPOR_BAYAR]: 'PIB dan SSP',
  [DOKUMEN_TRANSAKSI.PEMBAYARAN]: 'SSP',
  [DOKUMEN_TRANSAKSI.DOKUMEN_TERTENTU]: 'Dokumen Tertentu',
  [DOKUMEN_TRANSAKSI.SKPKB_SKPKBT]: 'SKPKB/SKPKBT atas JLN',
  [DOKUMEN_TRANSAKSI.PEMBERITAHUAN_IMPOR]: 'Pemberitahuan Impor',
};

// Additional Information Document Codes
export const KETERANGAN_TAMBAHAN = {
  KAWASAN_PERDAGANGAN_BEBAS: 'TD.00501',
  KAWASAN_BERIKAT: 'TD.00502',
  BANTUAN_LUAR_NEGERI: 'TD.00503',
  AVTUR: 'TD.00504',
  LAINNYA: 'TD.00505',
  KONTRAKTOR_BATUBARA: 'TD.00506',
  BBM_TRANSPORTASI_LAUT: 'TD.00507',
  JASA_TRANSPORTASI_TERTENTU: 'TD.00508',
  BARANG_TERTENTU_KEK: 'TD.00509',
  BARANG_TERTENTU_STRATEGIS_SLIME_ANODE: 'TD.00510',
  SARANA_TRANSPORTASI_TERTENTU: 'TD.00511',
  KONTRAKTOR_MIGAS: 'TD.00512',
  RUMAH_DAN_RUSUN: 'TD.00513',
};

// Additional Information Document Descriptions in Indonesian
export const KETERANGAN_TAMBAHAN_TEXT = {
  [KETERANGAN_TAMBAHAN.KAWASAN_PERDAGANGAN_BEBAS]: 'Kawasan Perdagangan Bebas',
  [KETERANGAN_TAMBAHAN.KAWASAN_BERIKAT]: 'Kawasan Berikat',
  [KETERANGAN_TAMBAHAN.BANTUAN_LUAR_NEGERI]: 'Hibah dan Bantuan Luar Negeri',
  [KETERANGAN_TAMBAHAN.AVTUR]: 'Avtur',
  [KETERANGAN_TAMBAHAN.LAINNYA]: 'Lainnya',
  [KETERANGAN_TAMBAHAN.KONTRAKTOR_BATUBARA]: 'Kontraktor PKP2B Generasi I',
  [KETERANGAN_TAMBAHAN.BBM_TRANSPORTASI_LAUT]:
    'Penyerahan BBM untuk Kapal Laut Angkutan Luar Negeri',
  [KETERANGAN_TAMBAHAN.JASA_TRANSPORTASI_TERTENTU]:
    'Penyerahan Jasa Kena Pajak Terkait Sarana Transportasi Tertentu',
  [KETERANGAN_TAMBAHAN.BARANG_TERTENTU_KEK]: 'Penyerahan Barang Kena Pajak Tertentu di KEK',
  [KETERANGAN_TAMBAHAN.BARANG_TERTENTU_STRATEGIS_SLIME_ANODE]:
    'Barang Kena Pajak Tertentu Strategis berupa Slime Anode',
  [KETERANGAN_TAMBAHAN.SARANA_TRANSPORTASI_TERTENTU]:
    'Penyerahan Sarana Transportasi Tertentu dan/atau Jasa Terkait Sarana Transportasi Tertentu',
  [KETERANGAN_TAMBAHAN.KONTRAKTOR_MIGAS]:
    'Penyerahan kepada Kontraktor Migas yang Sesuai PP No. 27 Tahun 2017',
  [KETERANGAN_TAMBAHAN.RUMAH_DAN_RUSUN]:
    'Penyerahan Rumah Tapak dan Unit Hunian Rusun Ditanggung Pemerintah untuk Tahun Anggaran 2021',
};

// Kode Dokumen Informasi Tambahan yang Disingkat
export const SHORT_KETERANGAN_TAMBAHAN = {
  BARANG_KENA_PAJAK_TERTENTU: 'TD.00501',
  BARANG_KENA_PAJAK_STRATEGIS: 'TD.00502',
  JASA_BANDARA: 'TD.00503',
  LAINNYA: 'TD.00504',
  BKP_STRATEGIS_PP_81_2015: 'TD.00505',
  JASA_PELABUHAN_TRANSPORTASI_LAUT: 'TD.00506',
  PENGIRIMAN_AIR_BERSIH: 'TD.00507',
};

// Deskripsi Dokumen Informasi Tambahan dalam Bahasa Indonesia
export const SHORT_KETERANGAN_TAMBAHAN_TEXT = {
  [SHORT_KETERANGAN_TAMBAHAN.BARANG_KENA_PAJAK_TERTENTU]: 'Barang Kena Pajak Tertentu dan Jasa',
  [SHORT_KETERANGAN_TAMBAHAN.BARANG_KENA_PAJAK_STRATEGIS]:
    'Barang Kena Pajak yang Bersifat Strategis',
  [SHORT_KETERANGAN_TAMBAHAN.JASA_BANDARA]: 'Jasa Bandara',
  [SHORT_KETERANGAN_TAMBAHAN.LAINNYA]: 'Lainnya',
  [SHORT_KETERANGAN_TAMBAHAN.BKP_STRATEGIS_PP_81_2015]:
    'BKP Tertentu yang Strategis Sesuai PP Nomor 81 Tahun 2015',
  [SHORT_KETERANGAN_TAMBAHAN.JASA_PELABUHAN_TRANSPORTASI_LAUT]:
    'Pengiriman Jasa Pelabuhan Tertentu untuk Kegiatan Transportasi Laut Lintas Negara',
  [SHORT_KETERANGAN_TAMBAHAN.PENGIRIMAN_AIR_BERSIH]: 'Pengiriman Air Bersih',
};

// Pengganti Constants
export const FG_PENGGANTI_DOKUMEN_LAIN = {
  NORMAL: 'TD.00400',
  PENGGANTI: 'TD.00401',
};

// Pengganti Constants
export const FG_PENGGANTI = {
  YES: '1',
  NO: '0',
};

// Document Code Constants
export const KODE_DOKUMEN = {
  EBKPTB: 'OSD.00702',
  EJKP: 'OSD.00701',
};

// Document Code Descriptions
export const KODE_DOKUMEN_TEXT = {
  [KODE_DOKUMEN.EBKPTB]: 'EBKPTB untuk Ekspor BKP Tidak Berwujud',
  [KODE_DOKUMEN.EJKP]: 'Pemberitahuan Ekspor Jasa',
};

export const MIN_THN_PAJAK = 2022;

export const getKdTransaksiText = (value?: string) => {
  if (!value) return '-';

  // ✅ CASE 1: value = 'DELIVERY'
  if (KD_TRANSAKSI_TEXT[value as keyof typeof KD_TRANSAKSI_TEXT]) {
    return KD_TRANSAKSI_TEXT[value as keyof typeof KD_TRANSAKSI_TEXT];
  }

  // ✅ CASE 2: value = 'OSD.00101'
  const key = Object.keys(KD_TRANSAKSI_CODE).find(
    (k) => KD_TRANSAKSI_CODE[k as keyof typeof KD_TRANSAKSI_CODE] === value
  );

  return key ? KD_TRANSAKSI_TEXT[key as keyof typeof KD_TRANSAKSI_TEXT] : value;
};

export const getDetailTransaksiText = (code?: string) =>
  DETAIL_TRANSAKSI_TEXT[code as keyof typeof DETAIL_TRANSAKSI_TEXT] ?? code ?? '-';

export const getDokumenTransaksiText = (code?: string) =>
  DOKUMEN_TRANSAKSI_TEXT[code as keyof typeof DOKUMEN_TRANSAKSI_TEXT] ?? code ?? '-';

export const getKeteranganTambahanText = (code?: string) =>
  KETERANGAN_TAMBAHAN_TEXT[code as keyof typeof KETERANGAN_TAMBAHAN_TEXT] ??
  SHORT_KETERANGAN_TAMBAHAN_TEXT[code as keyof typeof SHORT_KETERANGAN_TAMBAHAN_TEXT] ??
  code ??
  '-';
