export default {
  /**
   * @set Solar icons
   */
  'solar:pen-bold': {
    body: '<path fill="currentColor" d="m11.4 18.161l7.396-7.396a10.3 10.3 0 0 1-3.326-2.234a10.3 10.3 0 0 1-2.235-3.327L5.839 12.6c-.577.577-.866.866-1.114 1.184a6.6 6.6 0 0 0-.749 1.211c-.173.364-.302.752-.56 1.526l-1.362 4.083a1.06 1.06 0 0 0 1.342 1.342l4.083-1.362c.775-.258 1.162-.387 1.526-.56q.647-.308 1.211-.749c.318-.248.607-.537 1.184-1.114m9.448-9.448a3.932 3.932 0 0 0-5.561-5.561l-.887.887l.038.111a8.75 8.75 0 0 0 2.092 3.32a8.75 8.75 0 0 0 3.431 2.13z"/>',
  },
  'solar:bed-bold': {
    body: '<path fill="currentColor" d="M11.25 10.5V7.25H9.5c-.964 0-1.612.002-2.095.067c-.461.062-.659.169-.789.3s-.237.327-.3.788c-.064.483-.066 1.131-.066 2.095zm6.5 0c0-.964-.002-1.612-.067-2.095c-.061-.461-.169-.659-.3-.789s-.327-.237-.788-.3c-.483-.064-1.131-.066-2.095-.066h-1.75v3.25z"/><path fill="currentColor" fill-rule="evenodd" d="M13 4h-2C7.229 4 5.343 4 4.172 5.172c-1.023 1.022-1.153 2.588-1.17 5.477v1.618a2 2 0 0 0-.85.968C2 13.602 2 14.068 2 15s0 1.398.152 1.765a2 2 0 0 0 1.083 1.083c.252.104.55.137 1.015.147V20a.75.75 0 0 0 1.5 0v-2h12.5v2a.75.75 0 0 0 1.5 0v-2.005c.464-.01.763-.043 1.015-.147a2 2 0 0 0 1.083-1.083C22 16.398 22 15.932 22 15s0-1.398-.152-1.765a2 2 0 0 0-.85-.968v-1.618c-.017-2.889-.147-4.455-1.17-5.477C18.658 4 16.772 4 13 4m6.25 8v-1.552c0-.898 0-1.648-.08-2.242c-.084-.628-.27-1.195-.725-1.65c-.456-.456-1.023-.642-1.65-.726c-.595-.08-1.345-.08-2.243-.08H9.448c-.898 0-1.648 0-2.242.08c-.628.084-1.195.27-1.65.725c-.456.456-.642 1.023-.726 1.65c-.08.595-.08 1.345-.08 2.243V12z" clip-rule="evenodd"/>',
  },
  'solar:eye-bold': {
    body: '<path fill="currentColor" d="M9.75 12a2.25 2.25 0 1 1 4.5 0a2.25 2.25 0 0 1-4.5 0"/><path fill="currentColor" fill-rule="evenodd" d="M2 12c0 1.64.425 2.191 1.275 3.296C4.972 17.5 7.818 20 12 20s7.028-2.5 8.725-4.704C21.575 14.192 22 13.639 22 12c0-1.64-.425-2.191-1.275-3.296C19.028 6.5 16.182 4 12 4S4.972 6.5 3.275 8.704C2.425 9.81 2 10.361 2 12m10-3.75a3.75 3.75 0 1 0 0 7.5a3.75 3.75 0 0 0 0-7.5" clip-rule="evenodd"/>',
  },
  'solar:copy-bold': {
    body: '<path fill="currentColor" d="M15.24 2h-3.894c-1.764 0-3.162 0-4.255.148c-1.126.152-2.037.472-2.755 1.193c-.719.721-1.038 1.636-1.189 2.766C3 7.205 3 8.608 3 10.379v5.838c0 1.508.92 2.8 2.227 3.342c-.067-.91-.067-2.185-.067-3.247v-5.01c0-1.281 0-2.386.118-3.27c.127-.948.413-1.856 1.147-2.593s1.639-1.024 2.583-1.152c.88-.118 1.98-.118 3.257-.118h3.07c1.276 0 2.374 0 3.255.118A3.6 3.6 0 0 0 15.24 2"/><path fill="currentColor" d="M6.6 11.397c0-2.726 0-4.089.844-4.936c.843-.847 2.2-.847 4.916-.847h2.88c2.715 0 4.073 0 4.917.847S21 8.671 21 11.397v4.82c0 2.726 0 4.089-.843 4.936c-.844.847-2.202.847-4.917.847h-2.88c-2.715 0-4.073 0-4.916-.847c-.844-.847-.844-2.21-.844-4.936z"/>',
  },
  'solar:flag-bold': {
    body: '<path fill="currentColor" d="M5.75 1a.75.75 0 0 1 .75.75V3.6l1.72-.344a8.7 8.7 0 0 1 4.925.452l.204.081a8 8 0 0 0 4.91.334a1.2 1.2 0 0 1 1.491 1.164v7.367c0 .644-.439 1.206-1.064 1.362l-.214.053a8.68 8.68 0 0 1-5.327-.361a8.7 8.7 0 0 0-4.924-.452L6.5 13.6v8.15a.75.75 0 0 1-1.5 0v-20A.75.75 0 0 1 5.75 1"/>',
  },
  'solar:list-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M3.25 7A.75.75 0 0 1 4 6.25h16a.75.75 0 0 1 0 1.5H4A.75.75 0 0 1 3.25 7m0 5a.75.75 0 0 1 .75-.75h11a.75.75 0 0 1 0 1.5H4a.75.75 0 0 1-.75-.75m0 5a.75.75 0 0 1 .75-.75h5a.75.75 0 0 1 0 1.5H4a.75.75 0 0 1-.75-.75" clip-rule="evenodd"/>',
  },
  'solar:heart-bold': {
    body: '<path fill="currentColor" d="M2 9.137C2 14 6.02 16.591 8.962 18.911C10 19.729 11 20.5 12 20.5s2-.77 3.038-1.59C17.981 16.592 22 14 22 9.138S16.5.825 12 5.501C7.5.825 2 4.274 2 9.137"/>',
  },
  'solar:phone-bold': {
    body: '<path fill="currentColor" d="m16.556 12.906l-.455.453s-1.083 1.076-4.038-1.862s-1.872-4.014-1.872-4.014l.286-.286c.707-.702.774-1.83.157-2.654L9.374 2.86C8.61 1.84 7.135 1.705 6.26 2.575l-1.57 1.56c-.433.432-.723.99-.688 1.61c.09 1.587.808 5 4.812 8.982c4.247 4.222 8.232 4.39 9.861 4.238c.516-.048.964-.31 1.325-.67l1.42-1.412c.96-.953.69-2.588-.538-3.255l-1.91-1.039c-.806-.437-1.787-.309-2.417.317"/>',
  },
  'solar:share-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M13.803 5.333c0-1.84 1.5-3.333 3.348-3.333A3.34 3.34 0 0 1 20.5 5.333c0 1.841-1.5 3.334-3.349 3.334a3.35 3.35 0 0 1-2.384-.994l-4.635 3.156a3.34 3.34 0 0 1-.182 1.917l5.082 3.34a3.35 3.35 0 0 1 2.12-.753a3.34 3.34 0 0 1 3.348 3.334C20.5 20.507 19 22 17.151 22a3.34 3.34 0 0 1-3.348-3.333a3.3 3.3 0 0 1 .289-1.356L9.05 14a3.35 3.35 0 0 1-2.202.821A3.34 3.34 0 0 1 3.5 11.487a3.34 3.34 0 0 1 3.348-3.333c1.064 0 2.01.493 2.623 1.261l4.493-3.059a3.3 3.3 0 0 1-.161-1.023" clip-rule="evenodd"/>',
  },
  'solar:inbox-bold': {
    body: '<path fill="currentColor" d="M3.464 20.536C4.93 22 7.286 22 12 22s7.071 0 8.535-1.465c1.271-1.27 1.44-3.213 1.462-6.785H18.84c-.974 0-1.229.016-1.442.114c-.214.099-.392.282-1.026 1.02l-.605.707l-.088.102c-.502.587-.9 1.052-1.45 1.305s-1.162.253-1.934.252h-.589c-.773 0-1.385.002-1.935-.252c-.55-.253-.948-.718-1.45-1.305l-.088-.102l-.605-.706c-.634-.74-.812-.922-1.026-1.02c-.213-.099-.468-.115-1.442-.115H2.003c.023 3.572.19 5.515 1.461 6.785"/><path fill="currentColor" d="M20.536 3.464C19.07 2 16.714 2 12 2S4.929 2 3.464 3.464C2 4.93 2 7.286 2 12v.25h3.295c.772 0 1.384-.002 1.934.252c.55.253.948.718 1.45 1.305l.088.102l.605.706c.634.74.812.922 1.026 1.02c.213.099.468.115 1.442.115h.32c.974 0 1.229-.016 1.442-.114c.214-.099.392-.282 1.026-1.02l.605-.707l.088-.102c.502-.587.9-1.052 1.45-1.305c.55-.254 1.162-.253 1.935-.252H22V12c0-4.714 0-7.071-1.465-8.536"/>',
  },
  'solar:reply-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M10.03 6.47a.75.75 0 0 1 0 1.06l-3.72 3.72h8.19c.953 0 2.367.28 3.563 1.141c1.235.89 2.187 2.365 2.187 4.609a.75.75 0 0 1-1.5 0c0-1.756-.715-2.78-1.563-3.391c-.887-.639-1.974-.859-2.687-.859H6.31l3.72 3.72a.75.75 0 1 1-1.06 1.06l-5-5a.75.75 0 0 1 0-1.06l5-5a.75.75 0 0 1 1.06 0" clip-rule="evenodd"/>',
  },
  'solar:danger-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M7.843 3.802C9.872 2.601 10.886 2 12 2s2.128.6 4.157 1.802l.686.406c2.029 1.202 3.043 1.803 3.6 2.792c.557.99.557 2.19.557 4.594v.812c0 2.403 0 3.605-.557 4.594s-1.571 1.59-3.6 2.791l-.686.407C14.128 21.399 13.114 22 12 22s-2.128-.6-4.157-1.802l-.686-.407c-2.029-1.2-3.043-1.802-3.6-2.791C3 16.01 3 14.81 3 12.406v-.812C3 9.19 3 7.989 3.557 7s1.571-1.59 3.6-2.792zM13 16a1 1 0 1 1-2 0a1 1 0 0 1 2 0m-1-9.75a.75.75 0 0 1 .75.75v6a.75.75 0 0 1-1.5 0V7a.75.75 0 0 1 .75-.75" clip-rule="evenodd"/>',
  },
  'solar:cart-3-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M10 2.25a1.75 1.75 0 0 0-1.582 1c-.684.006-1.216.037-1.692.223A3.25 3.25 0 0 0 5.3 4.563c-.367.493-.54 1.127-.776 1.998l-.047.17l-.513 2.964q-.277.191-.486.459c-.901 1.153-.472 2.87.386 6.301c.545 2.183.818 3.274 1.632 3.91C6.31 21 7.435 21 9.685 21h4.63c2.25 0 3.375 0 4.189-.635c.814-.636 1.086-1.727 1.632-3.91c.858-3.432 1.287-5.147.386-6.301a2.2 2.2 0 0 0-.487-.46l-.513-2.962l-.046-.17c-.237-.872-.41-1.506-.776-2a3.25 3.25 0 0 0-1.426-1.089c-.476-.186-1.009-.217-1.692-.222A1.75 1.75 0 0 0 14 2.25zm8.418 6.896l-.362-2.088c-.283-1.04-.386-1.367-.56-1.601a1.75 1.75 0 0 0-.768-.587c-.22-.086-.486-.111-1.148-.118A1.75 1.75 0 0 1 14 5.75h-4a1.75 1.75 0 0 1-1.58-.998c-.663.007-.928.032-1.148.118a1.75 1.75 0 0 0-.768.587c-.174.234-.277.56-.56 1.6l-.362 2.089C6.58 9 7.91 9 9.685 9h4.63c1.775 0 3.105 0 4.103.146M8 12.25a.75.75 0 0 1 .75.75v4a.75.75 0 0 1-1.5 0v-4a.75.75 0 0 1 .75-.75m8.75.75a.75.75 0 0 0-1.5 0v4a.75.75 0 0 0 1.5 0zM12 12.25a.75.75 0 0 1 .75.75v4a.75.75 0 0 1-1.5 0v-4a.75.75 0 0 1 .75-.75" clip-rule="evenodd"/>',
  },
  'solar:import-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M15.53 10.47a.75.75 0 0 0-1.06 0l-1.72 1.72V4a.75.75 0 0 0-1.5 0v8.19l-1.72-1.72a.75.75 0 0 0-1.06 1.06l3 3a.75.75 0 0 0 1.06 0l3-3a.75.75 0 0 0 0-1.06" clip-rule="evenodd"/><path fill="currentColor" d="M17.748 12c-.448 0-.84.274-1.157.591l-3 3a2.25 2.25 0 0 1-3.182 0l-3-3C7.092 12.274 6.7 12 6.252 12H4a8 8 0 1 0 16 0z"/>',
  },
  'solar:export-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M8.845 7.905a.75.75 0 0 0 1.06 0l1.72-1.72v8.19a.75.75 0 0 0 1.5 0v-8.19l1.72 1.72a.75.75 0 1 0 1.06-1.06l-3-3a.75.75 0 0 0-1.06 0l-3 3a.75.75 0 0 0 0 1.06" clip-rule="evenodd"/><path fill="currentColor" d="M12.375 20.375a8 8 0 0 0 8-8h-3.75c-.943 0-1.414 0-1.707.293s-.293.764-.293 1.707a2.25 2.25 0 0 1-4.5 0c0-.943 0-1.414-.293-1.707s-.764-.293-1.707-.293h-3.75a8 8 0 0 0 8 8"/>',
  },
  'solar:eraser-bold': {
    body: '<path fill="currentColor" d="M11.41 5.505C13.08 3.835 13.915 3 14.952 3c1.038 0 1.873.835 3.543 2.505S21 8.01 21 9.048c0 1.037-.835 1.872-2.505 3.542l-4.193 4.194l-7.086-7.086z"/><path fill="currentColor" d="m6.156 10.759l7.085 7.085l-.65.65c-.378.379-.713.714-1.018 1.006H21a.75.75 0 0 1 0 1.5H9c-1.016-.025-1.85-.86-3.495-2.505C3.835 16.825 3 15.99 3 14.952c0-1.037.835-1.872 2.505-3.542z"/>',
  },
  'solar:user-id-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M10 4h4c3.771 0 5.657 0 6.828 1.172S22 8.229 22 12s0 5.657-1.172 6.828S17.771 20 14 20h-4c-3.771 0-5.657 0-6.828-1.172S2 15.771 2 12s0-5.657 1.172-6.828S6.229 4 10 4m3.25 5a.75.75 0 0 1 .75-.75h5a.75.75 0 0 1 0 1.5h-5a.75.75 0 0 1-.75-.75m1 3a.75.75 0 0 1 .75-.75h4a.75.75 0 0 1 0 1.5h-4a.75.75 0 0 1-.75-.75m1 3a.75.75 0 0 1 .75-.75h3a.75.75 0 0 1 0 1.5h-3a.75.75 0 0 1-.75-.75M11 9a2 2 0 1 1-4 0a2 2 0 0 1 4 0m-2 8c4 0 4-.895 4-2s-1.79-2-4-2s-4 .895-4 2s0 2 4 2" clip-rule="evenodd"/>',
  },
  'solar:restart-bold': {
    body: '<path fill="currentColor" d="M18.258 3.508a.75.75 0 0 1 .463.693v4.243a.75.75 0 0 1-.75.75h-4.243a.75.75 0 0 1-.53-1.28L14.8 6.31a7.25 7.25 0 1 0 4.393 5.783a.75.75 0 0 1 1.488-.187A8.75 8.75 0 1 1 15.93 5.18l1.51-1.51a.75.75 0 0 1 .817-.162"/>',
  },
  'solar:forward-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M13.97 6.47a.75.75 0 0 1 1.06 0l5 5a.75.75 0 0 1 0 1.06l-5 5a.75.75 0 1 1-1.06-1.06l3.72-3.72H9.5c-.713 0-1.8.22-2.687.859c-.848.61-1.563 1.635-1.563 3.391a.75.75 0 0 1-1.5 0c0-2.244.952-3.72 2.187-4.609c1.196-.861 2.61-1.141 3.563-1.141h8.19l-3.72-3.72a.75.75 0 0 1 0-1.06" clip-rule="evenodd"/>',
  },
  'solar:inbox-in-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M12 10.75a.75.75 0 0 0 .53-.22l3-3a.75.75 0 0 0-1.06-1.06l-1.72 1.72V2a.75.75 0 0 0-1.5 0v6.19L9.53 6.47a.75.75 0 0 0-1.06 1.06l3 3c.14.141.331.22.53.22" clip-rule="evenodd"/><path fill="currentColor" d="M3.464 20.536C4.93 22 7.286 22 12 22s7.071 0 8.535-1.465c1.271-1.27 1.44-3.213 1.462-6.785H18.84c-.974 0-1.229.016-1.442.114c-.214.099-.392.282-1.026 1.02l-.693.81c-.502.586-.9 1.051-1.45 1.304s-1.162.253-1.934.252h-.59c-.772 0-1.384.002-1.934-.252c-.55-.253-.948-.718-1.45-1.305l-.693-.808c-.634-.74-.812-.922-1.026-1.02c-.213-.099-.468-.115-1.442-.115H2.003c.023 3.572.19 5.515 1.461 6.785"/><path fill="currentColor" d="M22 12c0-4.714 0-7.071-1.465-8.536c-1.21-1.21-3.03-1.42-6.285-1.456v2.87a2.25 2.25 0 0 1 2.341 3.713l-3 3a2.25 2.25 0 0 1-3.182 0l-3-3A2.25 2.25 0 0 1 9.75 4.878v-2.87c-3.256.036-5.075.246-6.286 1.456C2 4.93 2 7.286 2 12v.25h3.295c.772 0 1.384-.002 1.934.252c.55.253.948.718 1.45 1.305l.693.808c.634.74.812.922 1.026 1.02c.213.099.468.115 1.442.115h.32c.974 0 1.229-.016 1.442-.114c.214-.099.392-.282 1.026-1.02l.693-.81c.502-.586.9-1.051 1.45-1.304s1.162-.253 1.935-.252H22z"/>',
  },
  'solar:download-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M12 1.25a.75.75 0 0 0-.75.75v10.973l-1.68-1.961a.75.75 0 1 0-1.14.976l3 3.5a.75.75 0 0 0 1.14 0l3-3.5a.75.75 0 1 0-1.14-.976l-1.68 1.96V2a.75.75 0 0 0-.75-.75" clip-rule="evenodd"/><path fill="currentColor" d="M14.25 9v.378a2.249 2.249 0 0 1 2.458 3.586l-3 3.5a2.25 2.25 0 0 1-3.416 0l-3-3.5A2.25 2.25 0 0 1 9.75 9.378V9H8c-2.828 0-4.243 0-5.121.879C2 10.757 2 12.172 2 15v1c0 2.828 0 4.243.879 5.121C3.757 22 5.172 22 8 22h8c2.828 0 4.243 0 5.121-.879C22 20.243 22 18.828 22 16v-1c0-2.828 0-4.243-.879-5.121C20.243 9 18.828 9 16 9z"/>',
  },
  'solar:cup-star-bold': {
    body: '<path fill="currentColor" d="M22 8.162v.073c0 .86 0 1.291-.207 1.643s-.584.561-1.336.98l-.793.44c.546-1.848.729-3.834.796-5.532l.01-.221l.002-.052c.651.226 1.017.395 1.245.711c.283.393.283.915.283 1.958m-20 0v.073c0 .86 0 1.291.207 1.643s.584.561 1.336.98l.794.44c-.547-1.848-.73-3.834-.797-5.532l-.01-.221l-.001-.052c-.652.226-1.018.395-1.246.711C2 6.597 2 7.12 2 8.162"/><path fill="currentColor" fill-rule="evenodd" d="M12 2c1.784 0 3.253.157 4.377.347c1.139.192 1.708.288 2.184.874s.45 1.219.4 2.485c-.172 4.349-1.11 9.78-6.211 10.26V19.5h1.43a1 1 0 0 1 .98.804l.19.946H18a.75.75 0 0 1 0 1.5H6a.75.75 0 0 1 0-1.5h2.65l.19-.946a1 1 0 0 1 .98-.804h1.43v-3.534c-5.1-.48-6.038-5.912-6.21-10.26c-.051-1.266-.076-1.9.4-2.485c.475-.586 1.044-.682 2.183-.874A26.4 26.4 0 0 1 12 2m.952 4.199l-.098-.176C12.474 5.34 12.284 5 12 5s-.474.34-.854 1.023l-.098.176c-.108.194-.162.29-.246.354c-.085.064-.19.088-.4.135l-.19.044c-.738.167-1.107.25-1.195.532s.164.577.667 1.165l.13.152c.143.167.215.25.247.354s.021.215 0 .438l-.02.203c-.076.785-.114 1.178.115 1.352c.23.174.576.015 1.267-.303l.178-.082c.197-.09.295-.135.399-.135s.202.045.399.135l.178.082c.691.319 1.037.477 1.267.303s.191-.567.115-1.352l-.02-.203c-.021-.223-.032-.334 0-.438s.104-.187.247-.354l.13-.152c.503-.588.755-.882.667-1.165c-.088-.282-.457-.365-1.195-.532l-.19-.044c-.21-.047-.315-.07-.4-.135c-.084-.064-.138-.16-.246-.354" clip-rule="evenodd"/>',
  },
  'solar:bell-off-bold': {
    body: '<path fill="currentColor" d="M8.352 20.242A4.63 4.63 0 0 0 12 22a4.63 4.63 0 0 0 3.648-1.758a27.2 27.2 0 0 1-7.296 0"/><path fill="currentColor" fill-rule="evenodd" d="M18.75 9v.704c0 .845.24 1.671.692 2.374l1.108 1.723c1.011 1.574.239 3.713-1.52 4.21a25.8 25.8 0 0 1-14.06 0c-1.759-.497-2.531-2.636-1.52-4.21l1.108-1.723a4.4 4.4 0 0 0 .693-2.374V9c0-3.866 3.022-7 6.749-7s6.75 3.134 6.75 7m-8.678.75A.737.737 0 0 1 9.349 9c0-.414.323-.75.723-.75h3.856c.293 0 .556.183.668.463a.77.77 0 0 1-.156.817l-2.622 2.72h2.11c.4 0 .723.336.723.75s-.323.75-.723.75h-3.856a.72.72 0 0 1-.668-.463a.77.77 0 0 1 .156-.817l2.623-2.72z" clip-rule="evenodd"/>',
  },
  'solar:cart-plus-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M3.04 2.292a.75.75 0 0 0-.497 1.416l.261.091c.668.235 1.107.39 1.43.549c.303.149.436.27.524.398c.09.132.16.314.2.677c.04.38.042.875.042 1.615V9.64c0 2.942.063 3.912.93 4.826c.866.914 2.26.914 5.05.914h5.302c1.561 0 2.342 0 2.893-.45c.552-.45.71-1.214 1.025-2.742l.5-2.425c.347-1.74.52-2.609.076-3.186S18.816 6 17.131 6H6.492a9 9 0 0 0-.043-.738c-.054-.497-.17-.95-.452-1.362c-.284-.416-.662-.682-1.103-.899c-.412-.202-.936-.386-1.552-.603zM13 8.25a.75.75 0 0 1 .75.75v1.25H15a.75.75 0 0 1 0 1.5h-1.25V13a.75.75 0 0 1-1.5 0v-1.25H11a.75.75 0 0 1 0-1.5h1.25V9a.75.75 0 0 1 .75-.75" clip-rule="evenodd"/><path fill="currentColor" d="M7.5 18a1.5 1.5 0 1 1 0 3a1.5 1.5 0 0 1 0-3m9 0a1.5 1.5 0 1 1 0 3a1.5 1.5 0 0 1 0-3"/>',
  },
  'solar:bill-list-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M7.245 2h9.51c1.159 0 1.738 0 2.206.163a3.05 3.05 0 0 1 1.881 1.936C21 4.581 21 5.177 21 6.37v14.004c0 .858-.985 1.314-1.608.744a.946.946 0 0 0-1.284 0l-.483.442a1.657 1.657 0 0 1-2.25 0a1.657 1.657 0 0 0-2.25 0a1.657 1.657 0 0 1-2.25 0a1.657 1.657 0 0 0-2.25 0a1.657 1.657 0 0 1-2.25 0l-.483-.442a.946.946 0 0 0-1.284 0c-.623.57-1.608.114-1.608-.744V6.37c0-1.193 0-1.79.158-2.27c.3-.913.995-1.629 1.881-1.937C5.507 2 6.086 2 7.245 2M7 6.75a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5zm3.5 0a.75.75 0 0 0 0 1.5H17a.75.75 0 0 0 0-1.5zM7 10.25a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5zm3.5 0a.75.75 0 0 0 0 1.5H17a.75.75 0 0 0 0-1.5zM7 13.75a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5zm3.5 0a.75.75 0 0 0 0 1.5H17a.75.75 0 0 0 0-1.5z" clip-rule="evenodd"/>',
  },
  'solar:bell-bing-bold': {
    body: '<path fill="currentColor" d="M8.352 20.242A4.63 4.63 0 0 0 12 22a4.63 4.63 0 0 0 3.648-1.758a27.2 27.2 0 0 1-7.296 0"/><path fill="currentColor" fill-rule="evenodd" d="M18.75 9.704V9c0-3.866-3.023-7-6.75-7S5.25 5.134 5.25 9v.704c0 .845-.24 1.671-.692 2.374L3.45 13.801c-1.011 1.574-.239 3.713 1.52 4.21a25.8 25.8 0 0 0 14.06 0c1.759-.497 2.531-2.636 1.52-4.21l-1.108-1.723a4.4 4.4 0 0 1-.693-2.374M12 5.25a.75.75 0 0 1 .75.75v4a.75.75 0 0 1-1.5 0V6a.75.75 0 0 1 .75-.75" clip-rule="evenodd"/>',
  },
  'solar:file-text-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M14 22h-4c-3.771 0-5.657 0-6.828-1.172S2 17.771 2 14v-4c0-3.771 0-5.657 1.172-6.828S6.239 2 10.03 2c.606 0 1.091 0 1.5.017q-.02.12-.02.244l-.01 2.834c0 1.097 0 2.067.105 2.848c.114.847.375 1.694 1.067 2.386c.69.69 1.538.952 2.385 1.066c.781.105 1.751.105 2.848.105h4.052c.043.534.043 1.19.043 2.063V14c0 3.771 0 5.657-1.172 6.828S17.771 22 14 22m-8.75-7.5a.75.75 0 0 1 .75-.75h8a.75.75 0 0 1 0 1.5H6a.75.75 0 0 1-.75-.75m0 3.5a.75.75 0 0 1 .75-.75h5.5a.75.75 0 0 1 0 1.5H6a.75.75 0 0 1-.75-.75" clip-rule="evenodd"/><path fill="currentColor" d="m19.352 7.617l-3.96-3.563c-1.127-1.015-1.69-1.523-2.383-1.788L13 5c0 2.357 0 3.536.732 4.268S15.643 10 18 10h3.58c-.362-.704-1.012-1.288-2.228-2.383"/>',
  },
  'solar:user-plus-bold': {
    body: '<circle cx="12" cy="6" r="4" fill="currentColor"/><path fill="currentColor" fill-rule="evenodd" d="M16.5 22c-1.65 0-2.475 0-2.987-.513C13 20.975 13 20.15 13 18.5s0-2.475.513-2.987C14.025 15 14.85 15 16.5 15s2.475 0 2.987.513C20 16.025 20 16.85 20 18.5s0 2.475-.513 2.987C18.975 22 18.15 22 16.5 22m.583-5.056a.583.583 0 1 0-1.166 0v.973h-.973a.583.583 0 1 0 0 1.166h.973v.973a.583.583 0 1 0 1.166 0v-.973h.973a.583.583 0 1 0 0-1.166h-.973z" clip-rule="evenodd"/><path fill="currentColor" d="M15.678 13.503c-.473.005-.914.023-1.298.074c-.643.087-1.347.293-1.928.875c-.582.581-.788 1.285-.874 1.928c-.078.578-.078 1.284-.078 2.034v.172c0 .75 0 1.456.078 2.034c.06.451.18.932.447 1.38H12c-8 0-8-2.015-8-4.5S7.582 13 12 13c1.326 0 2.577.181 3.678.503"/>',
  },
  'solar:eye-closed-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M1.606 6.08a1 1 0 0 1 1.313.526L2 7l.92-.394v-.001l.003.009l.021.045l.094.194c.086.172.219.424.4.729a13.4 13.4 0 0 0 1.67 2.237a12 12 0 0 0 .59.592C7.18 11.8 9.251 13 12 13a8.7 8.7 0 0 0 3.22-.602c1.227-.483 2.254-1.21 3.096-1.998a13 13 0 0 0 2.733-3.725l.027-.058l.005-.011a1 1 0 0 1 1.838.788L22 7l.92.394l-.003.005l-.004.008l-.011.026l-.04.087a14 14 0 0 1-.741 1.348a15.4 15.4 0 0 1-1.711 2.256l.797.797a1 1 0 0 1-1.414 1.415l-.84-.84a12 12 0 0 1-1.897 1.256l.782 1.202a1 1 0 1 1-1.676 1.091l-.986-1.514c-.679.208-1.404.355-2.176.424V16.5a1 1 0 0 1-2 0v-1.544c-.775-.07-1.5-.217-2.177-.425l-.985 1.514a1 1 0 0 1-1.676-1.09l.782-1.203c-.7-.37-1.332-.8-1.897-1.257l-.84.84a1 1 0 0 1-1.414-1.414l.797-.797a15.4 15.4 0 0 1-1.87-2.519a14 14 0 0 1-.591-1.107l-.033-.072l-.01-.021l-.002-.007l-.001-.002v-.001C1.08 7.395 1.08 7.394 2 7l-.919.395a1 1 0 0 1 .525-1.314" clip-rule="evenodd"/>',
  },
  'solar:camera-add-bold': {
    body: '<g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd"><path d="M12 10.25a.75.75 0 0 1 .75.75v1.25H14a.75.75 0 0 1 0 1.5h-1.25V15a.75.75 0 0 1-1.5 0v-1.25H10a.75.75 0 0 1 0-1.5h1.25V11a.75.75 0 0 1 .75-.75"/><path d="M9.778 21h4.444c3.121 0 4.682 0 5.803-.735a4.4 4.4 0 0 0 1.226-1.204c.749-1.1.749-2.633.749-5.697s0-4.597-.749-5.697a4.4 4.4 0 0 0-1.226-1.204c-.72-.473-1.622-.642-3.003-.702c-.659 0-1.226-.49-1.355-1.125A2.064 2.064 0 0 0 13.634 3h-3.268c-.988 0-1.839.685-2.033 1.636c-.129.635-.696 1.125-1.355 1.125c-1.38.06-2.282.23-3.003.702A4.4 4.4 0 0 0 2.75 7.667C2 8.767 2 10.299 2 13.364s0 4.596.749 5.697c.324.476.74.885 1.226 1.204C5.096 21 6.657 21 9.778 21M16 13a4 4 0 1 1-8 0a4 4 0 0 1 8 0m2-3.75a.75.75 0 0 0 0 1.5h1a.75.75 0 0 0 0-1.5z"/></g>',
  },
  'solar:microphone-bold': {
    body: '<path fill="currentColor" d="M12 2a5.75 5.75 0 0 0-5.75 5.75v3a5.75 5.75 0 0 0 11.452.75H13a.75.75 0 0 1 0-1.5h4.75V8.5H13A.75.75 0 0 1 13 7h4.701A5.75 5.75 0 0 0 12 2"/><path fill="currentColor" fill-rule="evenodd" d="M4 9a.75.75 0 0 1 .75.75v1a7.25 7.25 0 1 0 14.5 0v-1a.75.75 0 0 1 1.5 0v1a8.75 8.75 0 0 1-8 8.718v2.282a.75.75 0 0 1-1.5 0v-2.282a8.75 8.75 0 0 1-8-8.718v-1A.75.75 0 0 1 4 9" clip-rule="evenodd"/>',
  },
  'solar:add-circle-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2S2 6.477 2 12s4.477 10 10 10m.75-13a.75.75 0 0 0-1.5 0v2.25H9a.75.75 0 0 0 0 1.5h2.25V15a.75.75 0 0 0 1.5 0v-2.25H15a.75.75 0 0 0 0-1.5h-2.25z" clip-rule="evenodd"/>',
  },
  'solar:play-circle-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2S2 6.477 2 12s4.477 10 10 10m-1.306-6.154l4.72-2.787c.781-.462.781-1.656 0-2.118l-4.72-2.787C9.934 7.706 9 8.29 9 9.214v5.573c0 .923.934 1.507 1.694 1.059" clip-rule="evenodd"/>',
  },
  'solar:info-circle-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M22 12c0 5.523-4.477 10-10 10S2 17.523 2 12S6.477 2 12 2s10 4.477 10 10m-10 5.75a.75.75 0 0 0 .75-.75v-6a.75.75 0 0 0-1.5 0v6c0 .414.336.75.75.75M12 7a1 1 0 1 1 0 2a1 1 0 0 1 0-2" clip-rule="evenodd"/>',
  },
  'solar:medical-kit-bold': {
    body: '<g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd"><path d="M12 11.75a.75.75 0 0 1 .75.75v.75h.75a.75.75 0 0 1 0 1.5h-.75v.75a.75.75 0 0 1-1.5 0v-.75h-.75a.75.75 0 0 1 0-1.5h.75v-.75a.75.75 0 0 1 .75-.75"/><path d="M11.948 1.25c-.899 0-1.648 0-2.242.08c-.628.084-1.195.27-1.65.725c-.456.456-.642 1.023-.726 1.65c-.08.595-.08 1.345-.08 2.243v.078c-2.021.066-3.235.302-4.078 1.146C2 8.343 2 10.229 2 14s0 5.657 1.172 6.828S6.229 22 10 22h4c3.771 0 5.657 0 6.828-1.172S22 17.771 22 14s0-5.657-1.172-6.828c-.843-.844-2.057-1.08-4.078-1.146v-.078c0-.898 0-1.648-.08-2.242c-.084-.628-.27-1.195-.726-1.65c-.455-.456-1.022-.642-1.65-.726c-.594-.08-1.344-.08-2.242-.08zm3.302 4.752V6c0-.964-.002-1.612-.066-2.095c-.063-.461-.17-.659-.3-.789s-.328-.237-.79-.3c-.482-.064-1.13-.066-2.094-.066s-1.612.002-2.095.067c-.461.062-.659.169-.789.3s-.237.327-.3.788C8.753 4.388 8.75 5.036 8.75 6v.002Q9.337 6 10 6h4q.662 0 1.25.002M16 14a4 4 0 1 1-8 0a4 4 0 0 1 8 0"/></g>',
  },
  'solar:gallery-add-bold': {
    body: '<path fill="currentColor" d="M22 12.698c-.002 1.47-.013 2.718-.096 3.743c-.097 1.19-.296 2.184-.74 3.009a4.2 4.2 0 0 1-.73.983c-.833.833-1.893 1.21-3.237 1.39C15.884 22 14.2 22 12.053 22h-.106c-2.148 0-3.83 0-5.144-.177c-1.343-.18-2.404-.557-3.236-1.39c-.738-.738-1.12-1.656-1.322-2.795c-.2-1.12-.236-2.512-.243-4.241Q1.999 12.737 2 12v-.054c0-2.148 0-3.83.177-5.144c.18-1.343.557-2.404 1.39-3.236s1.893-1.21 3.236-1.39c1.168-.157 2.67-.175 4.499-.177a.697.697 0 1 1 0 1.396c-1.855.002-3.234.018-4.313.163c-1.189.16-1.906.464-2.436.994S3.72 5.8 3.56 6.99C3.397 8.2 3.395 9.788 3.395 12v.784l.932-.814a2.14 2.14 0 0 1 2.922.097l3.99 3.99a1.86 1.86 0 0 0 2.385.207l.278-.195a2.79 2.79 0 0 1 3.471.209l2.633 2.37c.265-.557.423-1.288.507-2.32c.079-.972.09-2.152.091-3.63a.698.698 0 0 1 1.396 0"/><path fill="currentColor" fill-rule="evenodd" d="M17.5 11c-2.121 0-3.182 0-3.841-.659S13 8.621 13 6.5s0-3.182.659-3.841S15.379 2 17.5 2s3.182 0 3.841.659S22 4.379 22 6.5s0 3.182-.659 3.841S19.621 11 17.5 11m.75-6.5a.75.75 0 0 0-1.5 0v1.25H15.5a.75.75 0 0 0 0 1.5h1.25V8.5a.75.75 0 0 0 1.5 0V7.25h1.25a.75.75 0 0 0 0-1.5h-1.25z" clip-rule="evenodd"/>',
  },
  'solar:dumbbell-large-minimalistic-bold': {
    body: '<path fill="currentColor" d="M8.38 20.568L3.433 15.62c-.905-.904-1.357-1.356-1.421-1.908a1.6 1.6 0 0 1 0-.371c.064-.552.516-1.005 1.42-1.909c.905-.904 1.357-1.356 1.909-1.42q.186-.023.37 0c.553.064 1.005.516 1.91 1.42l.733.734l3.812-3.813l-.733-.733c-.905-.904-1.357-1.356-1.421-1.908a1.6 1.6 0 0 1 0-.371c.064-.552.516-1.004 1.42-1.909c.905-.904 1.357-1.356 1.909-1.42a1.6 1.6 0 0 1 .37 0c.553.064 1.005.516 1.91 1.42l4.948 4.95c.905.904 1.357 1.356 1.421 1.908q.023.186 0 .37c-.064.553-.516 1.005-1.42 1.91c-.905.903-1.357 1.355-1.909 1.42a1.6 1.6 0 0 1-.37 0c-.553-.065-1.005-.517-1.91-1.42l-1.111-1.113l-3.812 3.813l1.111 1.112c.905.904 1.357 1.356 1.421 1.908q.023.186 0 .37c-.064.553-.516 1.005-1.42 1.91c-.905.903-1.357 1.355-1.909 1.42a1.6 1.6 0 0 1-.37 0c-.553-.065-1.005-.517-1.91-1.42" /><path fill="currentColor" fill-rule="evenodd" d="M17.489 1.968a.75.75 0 0 1 1.06 0l3.104 3.104a.75.75 0 0 1-1.06 1.06l-3.105-3.104a.75.75 0 0 1 0-1.06M1.966 17.488a.75.75 0 0 1 1.06 0l3.105 3.104a.75.75 0 0 1-1.06 1.06l-3.105-3.104a.75.75 0 0 1 0-1.06" clip-rule="evenodd" />',
  },
  'solar:user-rounded-bold': {
    body: '<circle cx="12" cy="6" r="4" fill="currentColor"/><ellipse cx="12" cy="17" fill="currentColor" rx="7" ry="4"/>',
  },
  'solar:close-circle-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M22 12c0 5.523-4.477 10-10 10S2 17.523 2 12S6.477 2 12 2s10 4.477 10 10M8.97 8.97a.75.75 0 0 1 1.06 0L12 10.94l1.97-1.97a.75.75 0 0 1 1.06 1.06L13.06 12l1.97 1.97a.75.75 0 0 1-1.06 1.06L12 13.06l-1.97 1.97a.75.75 0 0 1-1.06-1.06L10.94 12l-1.97-1.97a.75.75 0 0 1 0-1.06" clip-rule="evenodd"/>',
  },
  'solar:check-circle-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M22 12c0 5.523-4.477 10-10 10S2 17.523 2 12S6.477 2 12 2s10 4.477 10 10m-5.97-3.03a.75.75 0 0 1 0 1.06l-5 5a.75.75 0 0 1-1.06 0l-2-2a.75.75 0 1 1 1.06-1.06l1.47 1.47l2.235-2.235L14.97 8.97a.75.75 0 0 1 1.06 0" clip-rule="evenodd"/>',
  },
  'solar:wad-of-money-bold': {
    body: '<path fill="currentColor" d="M8.25 5c-2.317.006-3.557.063-4.472.674a4 4 0 0 0-1.104 1.104C2 7.787 2 9.19 2 12s0 4.213.674 5.222a4 4 0 0 0 1.104 1.104c.915.611 2.155.668 4.472.674v-4.094a3.001 3.001 0 0 1 0-5.811zm1.5 14h4.5V5h-4.5zm6-14v4.095a3.001 3.001 0 0 1 0 5.81V19c2.317-.006 3.558-.063 4.472-.674a4 4 0 0 0 1.104-1.104C22 16.213 22 14.81 22 12s0-4.213-.674-5.222a4 4 0 0 0-1.104-1.104c-.915-.611-2.155-.668-4.472-.673"/>',
  },
  'solar:shield-check-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M3.378 5.082C3 5.62 3 7.22 3 10.417v1.574c0 5.638 4.239 8.375 6.899 9.536c.721.315 1.082.473 2.101.473c1.02 0 1.38-.158 2.101-.473C16.761 20.365 21 17.63 21 11.991v-1.574c0-3.198 0-4.797-.378-5.335c-.377-.537-1.88-1.052-4.887-2.081l-.573-.196C13.595 2.268 12.812 2 12 2s-1.595.268-3.162.805L8.265 3c-3.007 1.03-4.51 1.545-4.887 2.082M15.06 10.5a.75.75 0 0 0-1.12-.999l-3.011 3.374l-.87-.974a.75.75 0 0 0-1.118 1l1.428 1.6a.75.75 0 0 0 1.119 0z" clip-rule="evenodd"/>',
  },
  'solar:clock-circle-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" clip-rule="evenodd" d="M12 22C17.523 22 22 17.523 22 12C22 6.477 17.523 2 12 2C6.477 2 2 6.477 2 12C2 17.523 6.477 22 12 22ZM12.5303 7.46967C12.3897 7.32902 12.1989 7.25 12 7.25C11.8011 7.25 11.6103 7.32902 11.4697 7.46967C11.329 7.61032 11.25 7.80109 11.25 8V12C11.2502 12.1988 11.3293 12.3895 11.47 12.53L13.97 15.03C14.0387 15.1037 14.1215 15.1628 14.2135 15.2038C14.3055 15.2448 14.4048 15.2668 14.5055 15.2686C14.6062 15.2704 14.7062 15.2518 14.7996 15.2141C14.893 15.1764 14.9778 15.1203 15.049 15.049C15.1203 14.9778 15.1764 14.893 15.2141 14.7996C15.2518 14.7062 15.2704 14.6062 15.2686 14.5055C15.2668 14.4048 15.2448 14.3055 15.2038 14.2135C15.1628 14.1215 15.1037 14.0387 15.03 13.97L12.75 11.69V8C12.75 7.80109 12.671 7.61032 12.5303 7.46967Z"/>',
  },
  'solar:smartphone-2-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M5.172 3.172C4 4.343 4 6.229 4 10v4c0 3.771 0 5.657 1.172 6.828S8.229 22 12 22s5.657 0 6.828-1.172S20 17.771 20 14v-4c0-3.771 0-5.657-1.172-6.828S15.771 2 12 2S6.343 2 5.172 3.172M9 4.25a.75.75 0 0 0 0 1.5h6a.75.75 0 0 0 0-1.5zM12 19a2 2 0 1 0 0-4a2 2 0 0 0 0 4" clip-rule="evenodd"/>',
  },
  'solar:gallery-wide-bold': {
    body: '<path fill="currentColor" d="M18.512 10.077c0 .739-.625 1.338-1.396 1.338s-1.395-.6-1.395-1.338s.625-1.337 1.395-1.337s1.396.598 1.396 1.337"/><path fill="currentColor" fill-rule="evenodd" d="M18.036 5.532c-1.06-.136-2.414-.136-4.123-.136h-3.826c-1.71 0-3.064 0-4.123.136c-1.09.141-1.974.437-2.67 1.104c-.696.668-1.005 1.514-1.152 2.56C2 10.21 2 11.508 2 13.147v.1c0 1.639 0 2.937.142 3.953c.147 1.045.456 1.891 1.152 2.558c.696.668 1.58.964 2.67 1.104C7.024 21 8.378 21 10.087 21h3.826c1.71 0 3.064 0 4.123-.137c1.09-.14 1.974-.436 2.67-1.104c.696-.667 1.005-1.513 1.152-2.558c.142-1.016.142-2.314.142-3.953v-.1c0-1.64 0-2.937-.142-3.953c-.147-1.045-.456-1.891-1.152-2.559c-.696-.667-1.58-.963-2.67-1.104M6.15 6.858c-.936.12-1.475.347-1.87.724c-.393.378-.629.894-.755 1.791c-.1.72-.123 1.62-.128 2.796l.47-.395c1.125-.943 2.819-.889 3.875.123l3.99 3.825a1.2 1.2 0 0 0 1.491.124l.278-.187a3.606 3.606 0 0 1 4.34.25l2.407 2.078c.098-.264.173-.58.227-.965c.128-.916.13-2.124.13-3.824s-.002-2.908-.13-3.825c-.126-.897-.362-1.413-.756-1.79c-.393-.378-.933-.604-1.869-.725c-.956-.123-2.216-.125-3.99-.125h-3.72c-1.774 0-3.034.002-3.99.125" clip-rule="evenodd"/><path fill="currentColor" d="M17.086 2.61c-.86-.11-1.954-.11-3.319-.11h-3.09c-1.364 0-2.459 0-3.319.11c-.89.115-1.632.358-2.221.92a2.9 2.9 0 0 0-.724 1.12c.504-.23 1.074-.366 1.714-.45c1.084-.14 2.47-.14 4.22-.14h3.914c1.75 0 3.135 0 4.22.14c.558.073 1.064.186 1.519.366a2.9 2.9 0 0 0-.692-1.035c-.589-.563-1.331-.806-2.222-.92"/>',
  },
  'solar:calendar-date-bold': {
    body: '<path fill="currentColor" d="M7.75 2.5a.75.75 0 0 0-1.5 0v1.58c-1.44.115-2.384.397-3.078 1.092c-.695.694-.977 1.639-1.093 3.078h19.842c-.116-1.44-.398-2.384-1.093-3.078c-.694-.695-1.639-.977-3.078-1.093V2.5a.75.75 0 0 0-1.5 0v1.513C15.585 4 14.839 4 14 4h-4c-.839 0-1.585 0-2.25.013z"/><path fill="currentColor" fill-rule="evenodd" d="M22 12c0-.839 0-1.585-.013-2.25H2.013C2 10.415 2 11.161 2 12v2c0 3.771 0 5.657 1.172 6.828S6.229 22 10 22h4c3.771 0 5.657 0 6.828-1.172S22 17.771 22 14zm-8 .25A1.75 1.75 0 0 0 12.25 14v2a1.75 1.75 0 1 0 3.5 0v-2A1.75 1.75 0 0 0 14 12.25m0 1.5a.25.25 0 0 0-.25.25v2a.25.25 0 1 0 .5 0v-2a.25.25 0 0 0-.25-.25m-3.213-1.443a.75.75 0 0 1 .463.693v4a.75.75 0 0 1-1.5 0v-2.19l-.22.22a.75.75 0 0 1-1.06-1.06l1.5-1.5a.75.75 0 0 1 .817-.163" clip-rule="evenodd"/>',
  },
  'solar:verified-check-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M9.592 3.2a6 6 0 0 1-.495.399c-.298.2-.633.338-.985.408c-.153.03-.313.043-.632.068c-.801.064-1.202.096-1.536.214a2.71 2.71 0 0 0-1.655 1.655c-.118.334-.15.735-.214 1.536a6 6 0 0 1-.068.632c-.07.352-.208.687-.408.985c-.087.13-.191.252-.399.495c-.521.612-.782.918-.935 1.238c-.353.74-.353 1.6 0 2.34c.153.32.414.626.935 1.238c.208.243.312.365.399.495c.2.298.338.633.408.985c.03.153.043.313.068.632c.064.801.096 1.202.214 1.536a2.71 2.71 0 0 0 1.655 1.655c.334.118.735.15 1.536.214c.319.025.479.038.632.068c.352.07.687.209.985.408c.13.087.252.191.495.399c.612.521.918.782 1.238.935c.74.353 1.6.353 2.34 0c.32-.153.626-.414 1.238-.935c.243-.208.365-.312.495-.399c.298-.2.633-.338.985-.408c.153-.03.313-.043.632-.068c.801-.064 1.202-.096 1.536-.214a2.71 2.71 0 0 0 1.655-1.655c.118-.334.15-.735.214-1.536c.025-.319.038-.479.068-.632c.07-.352.209-.687.408-.985c.087-.13.191-.252.399-.495c.521-.612.782-.918.935-1.238c.353-.74.353-1.6 0-2.34c-.153-.32-.414-.626-.935-1.238a6 6 0 0 1-.399-.495a2.7 2.7 0 0 1-.408-.985a6 6 0 0 1-.068-.632c-.064-.801-.096-1.202-.214-1.536a2.71 2.71 0 0 0-1.655-1.655c-.334-.118-.735-.15-1.536-.214a6 6 0 0 1-.632-.068a2.7 2.7 0 0 1-.985-.408a6 6 0 0 1-.495-.399c-.612-.521-.918-.782-1.238-.935a2.71 2.71 0 0 0-2.34 0c-.32.153-.626.414-1.238.935m6.781 6.663a.814.814 0 0 0-1.15-1.15l-4.85 4.85l-1.596-1.595a.814.814 0 0 0-1.15 1.15l2.17 2.17a.814.814 0 0 0 1.15 0z" clip-rule="evenodd"/>',
  },
  'solar:trash-bin-trash-bold': {
    body: '<path fill="currentColor" d="M3 6.386c0-.484.345-.877.771-.877h2.665c.529-.016.996-.399 1.176-.965l.03-.1l.115-.391c.07-.24.131-.45.217-.637c.338-.739.964-1.252 1.687-1.383c.184-.033.378-.033.6-.033h3.478c.223 0 .417 0 .6.033c.723.131 1.35.644 1.687 1.383c.086.187.147.396.218.637l.114.391l.03.1c.18.566.74.95 1.27.965h2.57c.427 0 .772.393.772.877s-.345.877-.771.877H3.77c-.425 0-.77-.393-.77-.877"/><path fill="currentColor" fill-rule="evenodd" d="M11.596 22h.808c2.783 0 4.174 0 5.08-.886c.904-.886.996-2.339 1.181-5.245l.267-4.188c.1-1.577.15-2.366-.303-2.865c-.454-.5-1.22-.5-2.753-.5H8.124c-1.533 0-2.3 0-2.753.5s-.404 1.288-.303 2.865l.267 4.188c.185 2.906.277 4.36 1.182 5.245c.905.886 2.296.886 5.079.886m-1.35-9.811c-.04-.434-.408-.75-.82-.707c-.413.043-.713.43-.672.864l.5 5.263c.04.434.408.75.82.707c.413-.043.713-.43.672-.864zm4.329-.707c.412.043.713.43.671.864l-.5 5.263c-.04.434-.409.75-.82.707c-.413-.043-.713-.43-.672-.864l.5-5.263c.04-.434.409-.75.82-.707" clip-rule="evenodd"/>',
  },
  'solar:danger-triangle-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M5.312 10.762C8.23 5.587 9.689 3 12 3s3.77 2.587 6.688 7.762l.364.644c2.425 4.3 3.638 6.45 2.542 8.022S17.786 21 12.364 21h-.728c-5.422 0-8.134 0-9.23-1.572s.117-3.722 2.542-8.022zM12 7.25a.75.75 0 0 1 .75.75v5a.75.75 0 0 1-1.5 0V8a.75.75 0 0 1 .75-.75M12 17a1 1 0 1 0 0-2a1 1 0 0 0 0 2" clip-rule="evenodd"/>',
  },
  'solar:forbidden-circle-bold': {
    body: '<path fill="currentColor" d="M12 22c5.523 0 10-4.477 10-10a9.96 9.96 0 0 0-2.418-6.52L5.479 19.581A9.96 9.96 0 0 0 12 22m0-20C6.477 2 2 6.477 2 12a9.96 9.96 0 0 0 2.418 6.52L18.521 4.419A9.96 9.96 0 0 0 12 2"/>',
  },
  'solar:videocamera-record-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M2 12.5v-1c0-3.287 0-4.931.908-6.038a4 4 0 0 1 .554-.554C4.57 4 6.212 4 9.5 4c3.287 0 4.931 0 6.038.908a4 4 0 0 1 .554.554c.702.855.861 2.031.897 4.038l.67-.33c1.945-.972 2.918-1.459 3.63-1.019S22 9.68 22 11.854v.292c0 2.175 0 3.263-.711 3.703c-.712.44-1.685-.047-3.63-1.02l-.67-.329c-.036 2.007-.195 3.183-.897 4.038a4 4 0 0 1-.554.554C14.43 20 12.788 20 9.5 20c-3.287 0-4.931 0-6.038-.908a4 4 0 0 1-.554-.554C2 17.43 2 15.788 2 12.5m11.56-2.94a1.5 1.5 0 1 0-2.121-2.12a1.5 1.5 0 0 0 2.122 2.12" clip-rule="evenodd"/>',
  },
  'solar:users-group-rounded-bold': {
    body: '<circle cx="9.001" cy="6" r="4" fill="currentColor"/><ellipse cx="9.001" cy="17.001" fill="currentColor" rx="7" ry="4"/><path fill="currentColor" d="M21 17c0 1.657-2.036 3-4.521 3c.732-.8 1.236-1.805 1.236-2.998c0-1.195-.505-2.2-1.239-3.001C18.962 14 21 15.344 21 17M18 6a3 3 0 0 1-4.029 2.82A5.7 5.7 0 0 0 14.714 6c0-1.025-.27-1.987-.742-2.819A3 3 0 0 1 18 6.001"/>',
  },
  'solar:printer-minimalistic-bold': {
    body: '<path fill="currentColor" d="M17.121 21.121C18 20.243 18 18.828 18 16v-3.34c-1.477-.502-3.458-.91-6-.91s-4.523.408-6 .91V16c0 2.828 0 4.243.879 5.121C7.757 22 9.172 22 12 22s4.243 0 5.121-.879"/><path fill="currentColor" d="M16 6H8c-2.828 0-4.243 0-5.121.879C2 7.757 2 9.172 2 12s0 4.243.879 5.121c.492.493 1.153.71 2.136.804C5 17.366 5 16.748 5 16.071v-3.029l-.193.085a.75.75 0 0 1-.614-1.368c1.722-.773 4.288-1.51 7.807-1.51s6.085.737 7.807 1.51a.75.75 0 1 1-.614 1.368L19 13.042v3.029c0 .677 0 1.295-.015 1.854c.983-.095 1.644-.311 2.136-.804C22 16.243 22 14.828 22 12s0-4.243-.879-5.121C20.243 6 18.828 6 16 6m1.12-3.121C16.243 2 14.829 2 12 2s-4.243 0-5.122.879c-.492.492-.709 1.153-.804 2.136C6.634 5 7.252 5 7.93 5h8.141c.678 0 1.296 0 1.855.015c-.095-.983-.312-1.644-.804-2.136"/>',
  },
  'solar:stop-circle-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M12 22c5.523 0 10-4.477 10-10S17.523 2 12 2S2 6.477 2 12s4.477 10 10 10M8.586 8.586C8 9.172 8 10.114 8 12s0 2.828.586 3.414S10.114 16 12 16s2.828 0 3.414-.586S16 13.886 16 12s0-2.828-.586-3.414S13.886 8 12 8s-2.828 0-3.414.586" clip-rule="evenodd" />',
  },
  'solar:settings-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M14.279 2.152C13.909 2 13.439 2 12.5 2s-1.408 0-1.779.152a2 2 0 0 0-1.09 1.083c-.094.223-.13.484-.145.863a1.62 1.62 0 0 1-.796 1.353a1.64 1.64 0 0 1-1.579.008c-.338-.178-.583-.276-.825-.308a2.03 2.03 0 0 0-1.49.396c-.318.242-.553.646-1.022 1.453c-.47.807-.704 1.21-.757 1.605c-.07.526.074 1.058.4 1.479c.148.192.357.353.68.555c.477.297.783.803.783 1.361s-.306 1.064-.782 1.36c-.324.203-.533.364-.682.556a2 2 0 0 0-.399 1.479c.053.394.287.798.757 1.605s.704 1.21 1.022 1.453c.424.323.96.465 1.49.396c.242-.032.487-.13.825-.308a1.64 1.64 0 0 1 1.58.008c.486.28.774.795.795 1.353c.015.38.051.64.145.863c.204.49.596.88 1.09 1.083c.37.152.84.152 1.779.152s1.409 0 1.779-.152a2 2 0 0 0 1.09-1.083c.094-.223.13-.483.145-.863c.02-.558.309-1.074.796-1.353a1.64 1.64 0 0 1 1.579-.008c.338.178.583.276.825.308c.53.07 1.066-.073 1.49-.396c.318-.242.553-.646 1.022-1.453c.47-.807.704-1.21.757-1.605a2 2 0 0 0-.4-1.479c-.148-.192-.357-.353-.68-.555c-.477-.297-.783-.803-.783-1.361s.306-1.064.782-1.36c.324-.203.533-.364.682-.556a2 2 0 0 0 .399-1.479c-.053-.394-.287-.798-.757-1.605s-.704-1.21-1.022-1.453a2.03 2.03 0 0 0-1.49-.396c-.242.032-.487.13-.825.308a1.64 1.64 0 0 1-1.58-.008a1.62 1.62 0 0 1-.795-1.353c-.015-.38-.051-.64-.145-.863a2 2 0 0 0-1.09-1.083M12.5 15c1.67 0 3.023-1.343 3.023-3S14.169 9 12.5 9s-3.023 1.343-3.023 3s1.354 3 3.023 3" clip-rule="evenodd" />',
  },
  'solar:volume-bold': {
    body: '<path fill="currentColor" d="M5.003 11.716c.038-1.843.057-2.764.678-3.552c.113-.144.28-.315.42-.431c.763-.636 1.771-.636 3.788-.636c.72 0 1.081 0 1.425-.092q.107-.03.211-.067c.336-.121.637-.33 1.238-.746c2.374-1.645 3.56-2.467 4.557-2.11c.191.069.376.168.541.29c.861.635.927 2.115 1.058 5.073C18.967 10.541 19 11.48 19 12s-.033 1.46-.081 2.555c-.131 2.958-.197 4.438-1.058 5.073a2.2 2.2 0 0 1-.54.29c-.997.357-2.184-.465-4.558-2.11c-.601-.416-.902-.625-1.238-.746a3 3 0 0 0-.211-.067c-.344-.092-.704-.092-1.425-.092c-2.017 0-3.025 0-3.789-.636a3 3 0 0 1-.419-.43c-.621-.79-.64-1.71-.678-3.552a14 14 0 0 1 0-.57" />',
  },
  'solar:volume-loud-bold': {
    body: '<path fill="currentColor" d="M2.003 11.716c.037-1.843.056-2.764.668-3.552a3 3 0 0 1 .413-.431c.752-.636 1.746-.636 3.733-.636c.71 0 1.065 0 1.403-.092q.105-.03.209-.067c.33-.121.627-.33 1.22-.746c2.338-1.645 3.508-2.467 4.489-2.11c.188.069.37.168.533.29c.848.635.913 2.115 1.042 5.073c.048 1.096.08 2.034.08 2.555s-.032 1.46-.08 2.555c-.13 2.958-.194 4.438-1.042 5.073a2.1 2.1 0 0 1-.533.29c-.982.357-2.15-.465-4.49-2.11c-.592-.416-.889-.625-1.22-.746a3 3 0 0 0-.208-.067c-.338-.092-.693-.092-1.403-.092c-1.987 0-2.98 0-3.733-.636a3 3 0 0 1-.413-.43c-.612-.79-.63-1.71-.668-3.552a14 14 0 0 1 0-.57" /><path fill="currentColor" fill-rule="evenodd" d="M19.49 5.552a.66.66 0 0 1 .97.094l-.529.471l.53-.47l.002.002l.003.004l.007.009l.079.112q.072.107.186.305c.149.264.339.652.526 1.171C21.64 8.291 22 9.851 22 12s-.36 3.71-.736 4.75c-.187.52-.377.907-.526 1.172a5 5 0 0 1-.265.417l-.007.009l-.003.003l-.001.002s-.001.001-.531-.47l.53.471a.66.66 0 0 1-.971.094a.77.77 0 0 1-.09-1.035l.03-.041q.04-.06.125-.207a6 6 0 0 0 .422-.943c.314-.871.644-2.253.644-4.222s-.33-3.35-.644-4.222a6 6 0 0 0-.422-.942a3 3 0 0 0-.157-.253m-1.641 1.833c.333-.197.753-.07.938.286l-.603.357l.603-.357l.001.002l.002.003l.003.007l.01.018l.024.053q.028.063.07.17c.053.145.12.35.185.62c.13.54.252 1.337.252 2.425c0 1.089-.122 1.886-.252 2.426c-.065.27-.132.475-.186.619a3 3 0 0 1-.094.223l-.009.018l-.003.007l-.002.003v.002s-.001.001-.604-.356l.603.357c-.185.355-.605.483-.938.286c-.33-.196-.45-.638-.272-.991l.004-.01l.035-.085c.032-.086.08-.23.13-.438c.1-.416.208-1.09.208-2.06c0-.971-.108-1.645-.208-2.06a4 4 0 0 0-.165-.524l-.004-.01a.76.76 0 0 1 .272-.991" clip-rule="evenodd" />',
  },
  'solar:monitor-bold': {
    body: '<path fill="currentColor" d="M8 17c-2.828 0-4.243 0-5.121-.879c-.57-.569-.77-1.363-.84-2.621h19.923c-.07 1.258-.271 2.052-.84 2.621C20.241 17 18.827 17 16 17h-3.25v4H16a.75.75 0 0 1 0 1.5H8A.75.75 0 0 1 8 21h3.25v-4zm2-15h4c3.771 0 5.657 0 6.828 1.172S22 6.229 22 10v1q.002.827-.006 1.5H2.007Q1.998 11.827 2 11v-1c0-3.771 0-5.657 1.172-6.828S6.229 2 10 2" />',
  },
  'solar:add-folder-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M2.07 5.008C2 5.376 2 5.818 2 6.7v7.05c0 3.771 0 5.657 1.172 6.828S6.229 21.75 10 21.75h4c3.771 0 5.657 0 6.828-1.172S22 17.521 22 13.75v-2.202c0-2.632 0-3.949-.77-4.804a3 3 0 0 0-.224-.225c-.855-.769-2.172-.769-4.804-.769h-.374c-1.153 0-1.73 0-2.268-.153a4 4 0 0 1-.848-.352c-.488-.271-.896-.68-1.712-1.495l-.55-.55c-.274-.274-.41-.41-.554-.53a4 4 0 0 0-2.18-.903c-.186-.017-.38-.017-.766-.017c-.883 0-1.324 0-1.692.07A4 4 0 0 0 2.07 5.007M12 11a.75.75 0 0 1 .75.75V13H14a.75.75 0 0 1 0 1.5h-1.25v1.25a.75.75 0 0 1-1.5 0V14.5H10a.75.75 0 0 1 0-1.5h1.25v-1.25A.75.75 0 0 1 12 11" clip-rule="evenodd" />',
  },
  'solar:tv-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M22 16v-4c0-2.828 0-4.243-.879-5.121c-.825-.826-2.123-.876-4.621-.879v16c2.498-.003 3.796-.053 4.621-.879c.879-.878.879-2.293.879-5.12m-3-5a1 1 0 1 1 0 2a1 1 0 0 1 0-2m0 4a1 1 0 1 1 0 2a1 1 0 0 1 0-2" clip-rule="evenodd" /><path fill="currentColor" d="M15.57 3.488L13.415 6H15v16H8c-2.828 0-4.243 0-5.121-.879C2 20.243 2 18.828 2 16.001v-4c0-2.83 0-4.244.879-5.122C3.757 6 5.172 6 8 6h2.584L8.43 3.488a.75.75 0 0 1 1.138-.976L12 5.348l2.43-2.836a.75.75 0 0 1 1.14.976" />',
  },
  'solar:box-minimalistic-bold': {
    body: '<path fill="currentColor" d="m17.578 4.432l-2-1.05C13.822 2.461 12.944 2 12 2s-1.822.46-3.578 1.382l-2 1.05c-1.773.93-2.816 1.478-3.462 2.21l9.04 4.52l9.04-4.52c-.646-.732-1.688-1.28-3.462-2.21m4.17 3.532l-8.998 4.5v9.44c.718-.179 1.535-.607 2.828-1.286l2-1.05c2.151-1.129 3.227-1.693 3.825-2.708c.597-1.014.597-2.277.597-4.8v-.117c0-1.893 0-3.076-.252-3.978M11.25 21.904v-9.44l-8.998-4.5C2 8.866 2 10.05 2 11.941v.117c0 2.525 0 3.788.597 4.802c.598 1.015 1.674 1.58 3.825 2.709l2 1.049c1.293.679 2.11 1.107 2.828 1.286" />',
  },
  'solar:video-frame-play-horizontal-bold': {
    body: '<path fill="currentColor" d="M11.25 2c-1.366.001-2.519.01-3.5.068V6.25h3.5zm-5 .221c-1.223.195-2.101.56-2.786 1.243c-.684.684-1.048 1.563-1.242 2.786H6.25z" /><path fill="currentColor" fill-rule="evenodd" d="M2 12c0-1.7 0-3.094.069-4.25H21.93C22 8.906 22 10.3 22 12s0 3.094-.069 4.25H2.07C2 15.094 2 13.7 2 12m10.411-1.596C13.471 11.116 14 11.472 14 12s-.53.884-1.589 1.596c-1.073.721-1.61 1.082-2.01.817C10 14.148 10 13.433 10 12s0-2.148.4-2.413s.938.096 2.011.817" clip-rule="evenodd" /><path fill="currentColor" d="M21.778 6.25c-.194-1.223-.558-2.102-1.242-2.786s-1.563-1.048-2.786-1.243V6.25zM12.75 2c1.366.001 2.519.01 3.5.068V6.25h-3.5zm9.028 15.75H17.75v4.028c1.223-.194 2.102-.559 2.785-1.243c.685-.684 1.05-1.562 1.243-2.785m-5.528 0v4.181c-.981.058-2.134.067-3.5.069v-4.25zm-5 4.25v-4.25h-3.5v4.181c.981.058 2.134.067 3.5.069m-5-4.25v4.028c-1.223-.194-2.101-.559-2.786-1.243c-.684-.684-1.048-1.562-1.242-2.785z" />',
  },
  'solar:palette-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M10 6v12c0 1.4 0 2.1-.272 2.635a2.5 2.5 0 0 1-1.093 1.092C8.1 22 7.4 22 6 22s-2.1 0-2.635-.273a2.5 2.5 0 0 1-1.093-1.092C2 20.1 2 19.4 2 18V6c0-1.4 0-2.1.272-2.635a2.5 2.5 0 0 1 1.093-1.093C3.9 2 4.6 2 6 2s2.1 0 2.635.272a2.5 2.5 0 0 1 1.093 1.093C10 3.9 10 4.6 10 6M7 19.75a.75.75 0 0 0 0-1.5H5a.75.75 0 0 0 0 1.5z" clip-rule="evenodd" /><path fill="currentColor" d="m19.06 10.614l-5.838 6.09c-.73.761-1.095 1.142-1.408 1.016c-.314-.126-.314-.653-.314-1.708V7.774a2.5 2.5 0 0 1 .73-1.76l1.054-1.055l.43-.33c1.004-.767 1.506-1.15 2.053-1.269a2.5 2.5 0 0 1 1.353.085c.528.184.979.628 1.88 1.514c1 1 1.5 1.5 1.685 2.072a2.5 2.5 0 0 1 .011 1.503c-.176.575-.663 1.077-1.636 2.08M12.79 22h5.11c1.4 0 2.1 0 2.634-.273a2.5 2.5 0 0 0 1.093-1.092c.272-.535.272-1.235.272-2.635s0-2.1-.272-2.635a2.5 2.5 0 0 0-1.093-1.092C20 14 19.3 14 17.9 14h-.22l-5.801 5.798a1.22 1.22 0 0 0-.378.883c0 .713.577 1.319 1.29 1.319" />',
  },
  'solar:headphones-round-bold': {
    body: '<path fill="currentColor" d="M2 12.124C2 6.533 6.477 2 12 2s10 4.533 10 10.124v5.243c0 .817 0 1.378-.143 1.87a3.52 3.52 0 0 1-1.847 2.188c-.458.22-1.004.307-1.801.434l-.13.02a13 13 0 0 1-.727.105c-.209.02-.422.027-.64-.016a2.1 2.1 0 0 1-1.561-1.35a2.2 2.2 0 0 1-.116-.639c-.012-.204-.012-.452-.012-.742v-4.173c0-.425 0-.791.097-1.105a2.1 2.1 0 0 1 1.528-1.43c.316-.073.677-.044 1.096-.01l.093.007l.11.01c.783.062 1.32.104 1.775.275q.481.181.883.487v-1.174c0-4.811-3.853-8.711-8.605-8.711s-8.605 3.9-8.605 8.711v1.174c.267-.203.563-.368.883-.487c.455-.17.992-.213 1.775-.276l.11-.009l.093-.007c.42-.034.78-.063 1.096.01a2.1 2.1 0 0 1 1.528 1.43c.098.314.097.68.097 1.105v4.172c0 .291 0 .54-.012.743c-.012.213-.04.427-.116.638a2.1 2.1 0 0 1-1.56 1.35a2.2 2.2 0 0 1-.641.017c-.201-.02-.444-.059-.727-.104l-.13-.02c-.797-.128-1.344-.215-1.801-.436a3.52 3.52 0 0 1-1.847-2.188c-.118-.405-.139-.857-.142-1.461L2 17.58z" />',
  },
  'solar:like-bold': {
    body: '<path fill="currentColor" d="m20.27 16.265l.705-4.08a1.666 1.666 0 0 0-1.64-1.95h-5.181a.833.833 0 0 1-.822-.969l.663-4.045a4.8 4.8 0 0 0-.09-1.973a1.64 1.64 0 0 0-1.092-1.137l-.145-.047a1.35 1.35 0 0 0-.994.068c-.34.164-.588.463-.68.818l-.476 1.834a7.6 7.6 0 0 1-.656 1.679c-.415.777-1.057 1.4-1.725 1.975l-1.439 1.24a1.67 1.67 0 0 0-.572 1.406l.812 9.393A1.666 1.666 0 0 0 8.597 22h4.648c3.482 0 6.453-2.426 7.025-5.735" /><path fill="currentColor" fill-rule="evenodd" d="M2.968 9.485a.75.75 0 0 1 .78.685l.97 11.236a1.237 1.237 0 1 1-2.468.107V10.234a.75.75 0 0 1 .718-.749" clip-rule="evenodd" />',
  },
  'solar:ssd-round-bold': {
    body: '<path fill="currentColor" d="M18.842 13.376c1.126 0 2.14.453 2.891 1.181l-2.365-9.379C18.842 3.545 17.9 3 16.737 3H7.263C6.1 3 5.158 3.545 4.632 5.178l-2.365 9.38a4.14 4.14 0 0 1 2.89-1.182z" /><path fill="currentColor" fill-rule="evenodd" d="M5.158 14.405c-1.167 0-2.2.663-2.75 1.674A3.4 3.4 0 0 0 2 17.703C2 19.552 3.442 21 5.158 21h13.684C20.558 21 22 19.552 22 17.703c0-.593-.15-1.146-.409-1.624c-.549-1.01-1.582-1.674-2.749-1.674zM11.21 17.4a.78.78 0 0 0-.789-.771a.78.78 0 0 0-.79.771v1.029a.78.78 0 0 0 .79.771a.78.78 0 0 0 .79-.771zm1.843-.771a.78.78 0 0 1 .79.771v1.029a.78.78 0 0 1-.79.771a.78.78 0 0 1-.79-.771V17.4a.78.78 0 0 1 .79-.771m3.42.771a.78.78 0 0 0-.789-.771a.78.78 0 0 0-.79.771v1.029a.78.78 0 0 0 .79.771a.78.78 0 0 0 .79-.771zm2.632 0a.78.78 0 0 0-.79-.771a.78.78 0 0 0-.789.771v1.029a.78.78 0 0 0 .79.771a.78.78 0 0 0 .79-.771z" clip-rule="evenodd" />',
  },
  'solar:tea-cup-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M2.25 11.88c-.01.177.015.39.065.818l.401 3.428A5.515 5.515 0 0 0 8.193 21h3.614a5.52 5.52 0 0 0 5.028-3.25H19a3.75 3.75 0 1 0 0-7.5h-2.279a2 2 0 0 0-.618-.22c-.174-.03-.39-.03-.82-.03H4.717c-.43 0-.645 0-.819.03a2 2 0 0 0-1.646 1.85m15.487-.13q.008.065.012.13c.01.177-.014.39-.064.818l-.401 3.428l-.016.124H19a2.25 2.25 0 0 0 0-4.5zM10.53 1.47a.75.75 0 0 1 0 1.06a.666.666 0 0 0 0 .94a2.164 2.164 0 0 1 0 3.06a.75.75 0 0 1-1.06-1.06c.26-.26.26-.68 0-.94a2.164 2.164 0 0 1 0-3.06a.75.75 0 0 1 1.06 0m-4.5 1.5a.75.75 0 0 1 0 1.06l-.116.116a.69.69 0 0 0-.064.904a2.19 2.19 0 0 1-.204 2.864l-.116.116a.75.75 0 0 1-1.06-1.06l.116-.116a.69.69 0 0 0 .064-.904a2.19 2.19 0 0 1 .204-2.864l.116-.116a.75.75 0 0 1 1.06 0m9.5 0a.75.75 0 0 1 0 1.06l-.116.116a.69.69 0 0 0-.064.904a2.19 2.19 0 0 1-.204 2.864l-.116.116a.75.75 0 1 1-1.06-1.06l.116-.116a.69.69 0 0 0 .064-.904a2.19 2.19 0 0 1 .204-2.864l.116-.116a.75.75 0 0 1 1.06 0" clip-rule="evenodd" />',
  },
  'solar:electric-refueling-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M10 2H9c-2.828 0-4.243 0-5.121.879C3 3.757 3 5.172 3 8v13.25H2a.75.75 0 0 0 0 1.5h15.25a.75.75 0 0 0 0-1.5H16v-3.5h1.571c.375 0 .679.304.679.679v.071a2.25 2.25 0 1 0 4.5 0V7.602c0-.157 0-.265-.006-.37a3.75 3.75 0 0 0-1.24-2.582a9 9 0 0 0-.286-.236l-1.25-1a.75.75 0 1 0-.936 1.172l1.233.986c.144.116.194.156.237.195c.443.397.711.954.745 1.549a6 6 0 0 1 .003.306V8h-.75A1.5 1.5 0 0 0 19 9.5v2.419a1.5 1.5 0 0 0 1.026 1.423l1.224.408v4.75a.75.75 0 0 1-1.5 0v-.071a2.18 2.18 0 0 0-2.179-2.179H16V8c0-2.828 0-4.243-.879-5.121C14.243 2 12.828 2 10 2m-.114 7.357a.75.75 0 0 1 .257 1.029l-.818 1.364H11a.75.75 0 0 1 .643 1.136l-1.5 2.5a.75.75 0 1 1-1.286-.772l.818-1.364H8a.75.75 0 0 1-.643-1.136l1.5-2.5a.75.75 0 0 1 1.029-.257" clip-rule="evenodd" />',
  },
  'solar:gamepad-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="m10.667 6.134l-.502-.355A4.24 4.24 0 0 0 7.715 5h-.612c-.405 0-.813.025-1.194.16c-2.383.846-4.022 3.935-3.903 10.943c.024 1.412.354 2.972 1.628 3.581A3.2 3.2 0 0 0 5.027 20a2.74 2.74 0 0 0 1.53-.437c.41-.268.77-.616 1.13-.964c.444-.43.888-.86 1.424-1.138a4.1 4.1 0 0 1 1.89-.461H13c.658 0 1.306.158 1.89.46c.536.279.98.709 1.425 1.139c.36.348.72.696 1.128.964c.39.256.895.437 1.531.437a3.2 3.2 0 0 0 1.393-.316c1.274-.609 1.604-2.17 1.628-3.581c.119-7.008-1.52-10.097-3.903-10.942C17.71 5.025 17.3 5 16.897 5h-.612a4.24 4.24 0 0 0-2.45.78l-.502.354a2.31 2.31 0 0 1-2.666 0M16.75 9a.75.75 0 1 1 0 1.5a.75.75 0 0 1 0-1.5m-9.25.25a.75.75 0 0 1 .75.75v.75H9a.75.75 0 0 1 0 1.5h-.75V13a.75.75 0 0 1-1.5 0v-.75H6a.75.75 0 0 1 0-1.5h.75V10a.75.75 0 0 1 .75-.75m11.5 2a.75.75 0 1 1-1.5 0a.75.75 0 0 1 1.5 0m-3.75.75a.75.75 0 1 0 0-1.5a.75.75 0 0 0 0 1.5m2.25.75a.75.75 0 1 0-1.5 0a.75.75 0 0 0 1.5 0" clip-rule="evenodd" />',
  },
  'solar:suitcase-tag-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M12.052 1.25h-.104c-.899 0-1.648 0-2.242.08c-.628.084-1.195.27-1.65.725c-.456.456-.642 1.023-.726 1.65c-.08.595-.08 1.345-.08 2.243v.078a26 26 0 0 0-.5.02v8.204h3.284c.206 0 .427 0 .615.025c.219.03.5.105.735.341c.236.236.311.516.341.735c.025.188.025.41.025.615v1.069c0 .205 0 .426-.025.614c-.03.219-.105.5-.341.735a1.24 1.24 0 0 1-.735.341a5 5 0 0 1-.614.025H6.75v3.203C7.645 22 8.712 22 10 22h4c1.288 0 2.355 0 3.25-.047V6.047a26 26 0 0 0-.5-.021v-.078c0-.898 0-1.648-.08-2.242c-.084-.628-.27-1.195-.726-1.65c-.455-.456-1.022-.642-1.65-.726c-.594-.08-1.344-.08-2.242-.08m3.198 4.752V6c0-.964-.002-1.612-.066-2.095c-.063-.461-.17-.659-.3-.789s-.328-.237-.79-.3c-.482-.064-1.13-.066-2.094-.066s-1.612.002-2.095.067c-.461.062-.659.169-.789.3s-.237.327-.3.788C8.753 4.388 8.75 5.036 8.75 6v.002Q9.337 6 10 6h4q.662 0 1.25.002" clip-rule="evenodd" /><path fill="currentColor" d="M20.828 20.828c-.518.52-1.177.808-2.078.97V6.202c.9.16 1.56.45 2.078.969C22 8.343 22 10.229 22 14s0 5.657-1.172 6.828M3.172 7.172c.518-.52 1.177-.808 2.078-.97v8.09c-.2.039-.433.123-.634.324a1.24 1.24 0 0 0-.341.735c-.025.188-.025.41-.025.615v1.069c0 .205 0 .426.025.614c.03.219.105.5.341.735c.2.2.434.285.634.324v3.09c-.9-.162-1.56-.45-2.078-.97C2 19.657 2 17.771 2 14s0-5.657 1.172-6.828m2.579 8.579L5.75 16v1l.001.249l.249.001h4l.249-.001l.001-.249v-1l-.001-.249L10 15.75H6z" />',
  },
  'solar:case-minimalistic-bold': {
    body: '<path fill="currentColor" d="M2.162 8.5C2 9.603 2 11.05 2 13c0 3.771 0 5.657 1.172 6.828S6.229 21 10 21h4c3.771 0 5.657 0 6.828-1.172S22 16.771 22 13c0-1.95 0-3.396-.162-4.5c-2.277 1.48-3.736 2.424-5.088 3.005V12a.75.75 0 0 1-1.5.017a12.75 12.75 0 0 1-6.5 0A.75.75 0 0 1 7.25 12v-.495C5.898 10.923 4.44 9.98 2.162 8.5" /><path fill="currentColor" fill-rule="evenodd" d="M10.581 2.25h-.02c-.114 0-.202 0-.286.005a2.75 2.75 0 0 0-2.385 1.72a8 8 0 0 0-.12.343l-.004.012a1.63 1.63 0 0 1-.504.695q-.341.011-.653.03c-1.644.096-2.687.366-3.437 1.117a3 3 0 0 0-.592.838q.087.03.167.081c2.1 1.365 3.42 2.22 4.517 2.767A.75.75 0 0 1 8.75 10v.458c2.12.64 4.38.64 6.5 0V10a.75.75 0 0 1 1.487-.142c1.096-.548 2.416-1.402 4.516-2.767a.8.8 0 0 1 .167-.081a3 3 0 0 0-.592-.838c-.75-.75-1.793-1.02-3.437-1.118q-.296-.016-.618-.028l-.04-.034a1.9 1.9 0 0 1-.525-.74l-.003-.009c-.036-.107-.063-.191-.095-.269a2.75 2.75 0 0 0-2.385-1.719a5 5 0 0 0-.285-.005zm4.237 2.566l-.005-.011l-.005-.012l-.004-.012l-.004-.01l-.002-.005l-.004-.012l-.004-.012l-.002-.006l-.003-.008l-.002-.007l-.002-.006a4 4 0 0 0-.062-.181a1.25 1.25 0 0 0-1.085-.782a4 4 0 0 0-.215-.002h-2.838c-.143 0-.183 0-.215.002a1.25 1.25 0 0 0-1.084.782l-.003.007l-.008.021a6 6 0 0 0-.077.23l-.002.006l-.003.007l-.002.008l-.002.006l-.004.012l-.004.012l-.002.005l-.004.01l-.004.012l-.005.012l-.004.01l-.001.001l-.044.108L10 5h4.896a3 3 0 0 1-.078-.184" clip-rule="evenodd" />',
  },
  'solar:archive-down-minimlistic-bold': {
    body: '<path fill="currentColor" d="M20.535 3.464C19.07 2 16.713 2 11.999 2S4.93 2 3.464 3.464c-.758.758-1.123 1.754-1.3 3.192a6.5 6.5 0 0 1 1.884-1.448c.782-.398 1.619-.56 2.545-.635C7.488 4.5 8.59 4.5 9.936 4.5h4.126c1.347 0 2.448 0 3.343.073c.927.076 1.764.237 2.545.635a6.5 6.5 0 0 1 1.884 1.448c-.176-1.438-.542-2.434-1.3-3.192"/><path fill="currentColor" fill-rule="evenodd" d="M2 14c0-2.8 0-4.2.545-5.27A5 5 0 0 1 4.73 6.545C5.8 6 7.2 6 10 6h4c2.8 0 4.2 0 5.27.545a5 5 0 0 1 2.185 2.185C22 9.8 22 11.2 22 14s0 4.2-.545 5.27a5 5 0 0 1-2.185 2.185C18.2 22 16.8 22 14 22h-4c-2.8 0-4.2 0-5.27-.545a5 5 0 0 1-2.185-2.185C2 18.2 2 16.8 2 14m10.53 3.53a.75.75 0 0 1-1.06 0l-2.5-2.5a.75.75 0 1 1 1.06-1.06l1.22 1.22V11a.75.75 0 0 1 1.5 0v4.19l1.22-1.22a.75.75 0 1 1 1.06 1.06z" clip-rule="evenodd"/>',
  },
  'solar:chat-round-dots-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" clip-rule="evenodd" d="M22 12C22 17.523 17.523 22 12 22C10.4551 22.002 8.93095 21.6446 7.548 20.956C7.19414 20.7727 6.78538 20.7254 6.399 20.823L4.173 21.419C3.95267 21.4778 3.72075 21.4776 3.50053 21.4184C3.2803 21.3593 3.07951 21.2432 2.91831 21.0819C2.75712 20.9206 2.64119 20.7197 2.58216 20.4995C2.52312 20.2792 2.52307 20.0473 2.582 19.827L3.177 17.601C3.28 17.216 3.221 16.809 3.043 16.453C2.376 15.112 2 13.6 2 12C2 6.477 6.477 2 12 2C17.523 2 22 6.477 22 12ZM15.2929 12.7071C15.1054 12.5196 15 12.2652 15 12C15 11.7348 15.1054 11.4804 15.2929 11.2929C15.4804 11.1054 15.7348 11 16 11C16.2652 11 16.5196 11.1054 16.7071 11.2929C16.8946 11.4804 17 11.7348 17 12C17 12.2652 16.8946 12.5196 16.7071 12.7071C16.5196 12.8946 16.2652 13 16 13C15.7348 13 15.4804 12.8946 15.2929 12.7071ZM11.2929 12.7071C11.1054 12.5196 11 12.2652 11 12C11 11.7348 11.1054 11.4804 11.2929 11.2929C11.4804 11.1054 11.7348 11 12 11C12.2652 11 12.5196 11.1054 12.7071 11.2929C12.8946 11.4804 13 11.7348 13 12C13 12.2652 12.8946 12.5196 12.7071 12.7071C12.5196 12.8946 12.2652 13 12 13C11.7348 13 11.4804 12.8946 11.2929 12.7071ZM7.29289 12.7071C7.10536 12.5196 7 12.2652 7 12C7 11.7348 7.10536 11.4804 7.29289 11.2929C7.48043 11.1054 7.73478 11 8 11C8.26522 11 8.51957 11.1054 8.70711 11.2929C8.89464 11.4804 9 11.7348 9 12C9 12.2652 8.89464 12.5196 8.70711 12.7071C8.51957 12.8946 8.26522 13 8 13C7.73478 13 7.48043 12.8946 7.29289 12.7071Z" />',
  },
  'solar:letter-bold': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M3.172 5.172C2 6.343 2 8.229 2 12s0 5.657 1.172 6.828S6.229 20 10 20h4c3.771 0 5.657 0 6.828-1.172S22 15.771 22 12s0-5.657-1.172-6.828S17.771 4 14 4h-4C6.229 4 4.343 4 3.172 5.172M18.576 7.52a.75.75 0 0 1-.096 1.056l-2.196 1.83c-.887.74-1.605 1.338-2.24 1.746c-.66.425-1.303.693-2.044.693s-1.384-.269-2.045-.693c-.634-.408-1.352-1.007-2.239-1.745L5.52 8.577a.75.75 0 0 1 .96-1.153l2.16 1.799c.933.777 1.58 1.315 2.128 1.667c.529.34.888.455 1.233.455s.704-.114 1.233-.455c.547-.352 1.195-.89 2.128-1.667l2.159-1.8a.75.75 0 0 1 1.056.097" clip-rule="evenodd" />',
  },
  'solar:letter-unread-bold': {
    body: '<path fill="currentColor" d="M22 6a3 3 0 1 1-6 0a3 3 0 0 1 6 0" /><path fill="currentColor" fill-rule="evenodd" d="M14 5h-4C6.229 5 4.343 5 3.172 6.172S2 9.229 2 13s0 5.657 1.172 6.828S6.229 21 10 21h4c3.771 0 5.657 0 6.828-1.172S22 16.771 22 13c0-1.453 0-2.627-.067-3.587A4.48 4.48 0 0 1 19 10.5c-.479 0-.94-.075-1.373-.213l-1.343 1.12c-.887.738-1.605 1.337-2.24 1.745c-.66.425-1.303.693-2.044.693s-1.384-.269-2.045-.693c-.634-.408-1.352-1.007-2.239-1.745L5.52 9.577a.75.75 0 0 1 .96-1.153l2.159 1.799c.933.777 1.58 1.315 2.128 1.667c.529.34.888.455 1.233.455s.704-.114 1.233-.455c.547-.352 1.195-.89 2.128-1.667l.84-.7A4.49 4.49 0 0 1 14.61 5z" clip-rule="evenodd" />',
  },
  'solar:play-broken': {
    body: '<path fill="none" stroke="currentColor" stroke-linecap="round" stroke-width="1.5" d="M3 12v6.967c0 2.31 2.534 3.769 4.597 2.648l3.203-1.742M3 8V5.033c0-2.31 2.534-3.769 4.597-2.648l12.812 6.968a2.998 2.998 0 0 1 0 5.294l-6.406 3.484"/>',
  },
  'solar:multiple-forward-left-broken': {
    body: '<g fill="none" stroke="currentColor" stroke-linecap="round" stroke-width="1.5"><path stroke-linejoin="round" d="M18 10.13c-1.613-1.153-3.455-1.56-5-1.56V6.227c0-.958 0-1.437-.295-1.57c-.295-.132-.653.186-1.37.823L7.363 9.01C5.795 10.405 5.011 11.102 5.011 12s.784 1.596 2.352 2.99l3.973 3.53c.716.637 1.074.956 1.369.823s.295-.611.295-1.57v-2.344c3.6 0 7.5 1.714 9 4.571c0-2.431-.377-4.378-1-5.925"/><path d="M8.461 4.5L3.245 9.344a3.897 3.897 0 0 0 .126 5.823L8.46 19.5"/></g>',
  },
  'solar:dislike-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M12.438 21.222a.6.6 0 0 1-.438-.03a.52.52 0 0 1-.28-.33l-.476-1.834a8.4 8.4 0 0 0-.72-1.844c-.485-.907-1.218-1.604-1.898-2.19l-1.438-1.24a.92.92 0 0 1-.315-.774l.812-9.392a.916.916 0 0 1 .911-.838h4.649c3.136 0 5.779 2.182 6.286 5.113l.705 4.08a.916.916 0 0 1-.901 1.073h-5.181c-.977 0-1.72.876-1.562 1.84l.663 4.044c.09.554.065 1.12-.076 1.664a.89.89 0 0 1-.596.611zl.23.714zm-1.09 1.321a2.1 2.1 0 0 0 1.549.107l.145-.047l-.23-.714l.23.714a2.38 2.38 0 0 0 1.589-1.662a5.5 5.5 0 0 0 .104-2.284l-.663-4.044a.083.083 0 0 1 .082-.097h5.18c1.5 0 2.636-1.352 2.38-2.829l-.705-4.08C20.37 3.92 17.07 1.25 13.245 1.25H8.596c-1.253 0-2.297.96-2.405 2.208l-.813 9.393a2.42 2.42 0 0 0 .83 2.04l1.44 1.24c.655.564 1.206 1.111 1.552 1.76c.257.48.456.988.592 1.514l.476 1.833a2.01 2.01 0 0 0 1.08 1.305m-8.38-8.028a.75.75 0 0 0 .78-.685l.97-11.236a1.237 1.237 0 1 0-2.468-.107v11.279a.75.75 0 0 0 .718.75" clip-rule="evenodd"/>',
  },
  'solar:clock-circle-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M12 2.75a9.25 9.25 0 1 0 0 18.5a9.25 9.25 0 0 0 0-18.5M1.25 12C1.25 6.063 6.063 1.25 12 1.25S22.75 6.063 22.75 12S17.937 22.75 12 22.75S1.25 17.937 1.25 12M12 7.25a.75.75 0 0 1 .75.75v3.69l2.28 2.28a.75.75 0 1 1-1.06 1.06l-2.5-2.5a.75.75 0 0 1-.22-.53V8a.75.75 0 0 1 .75-.75" clip-rule="evenodd"/>',
  },
  'solar:chart-square-outline': {
    body: '<path fill="currentColor" d="M7.75 9a.75.75 0 0 0-1.5 0v9a.75.75 0 0 0 1.5 0zM12 5.25a.75.75 0 0 1 .75.75v12a.75.75 0 0 1-1.5 0V6a.75.75 0 0 1 .75-.75M17.75 13a.75.75 0 0 0-1.5 0v5a.75.75 0 0 0 1.5 0z"/><path fill="currentColor" fill-rule="evenodd" d="M11.943 1.25c-2.309 0-4.118 0-5.53.19c-1.444.194-2.584.6-3.479 1.494c-.895.895-1.3 2.035-1.494 3.48c-.19 1.411-.19 3.22-.19 5.529v.114c0 2.309 0 4.118.19 5.53c.194 1.444.6 2.584 1.494 3.479c.895.895 2.035 1.3 3.48 1.494c1.411.19 3.22.19 5.529.19h.114c2.309 0 4.118 0 5.53-.19c1.444-.194 2.584-.6 3.479-1.494c.895-.895 1.3-2.035 1.494-3.48c.19-1.411.19-3.22.19-5.529v-.114c0-2.309 0-4.118-.19-5.53c-.194-1.444-.6-2.584-1.494-3.479c-.895-.895-2.035-1.3-3.48-1.494c-1.411-.19-3.22-.19-5.529-.19zM3.995 3.995c.57-.57 1.34-.897 2.619-1.069c1.3-.174 3.008-.176 5.386-.176s4.086.002 5.386.176c1.279.172 2.05.5 2.62 1.069c.569.57.896 1.34 1.068 2.619c.174 1.3.176 3.008.176 5.386s-.002 4.086-.176 5.386c-.172 1.279-.5 2.05-1.069 2.62c-.57.569-1.34.896-2.619 1.068c-1.3.174-3.008.176-5.386.176s-4.086-.002-5.386-.176c-1.279-.172-2.05-.5-2.62-1.069c-.569-.57-.896-1.34-1.068-2.619c-.174-1.3-.176-3.008-.176-5.386s.002-4.086.176-5.386c.172-1.279.5-2.05 1.069-2.62" clip-rule="evenodd"/>',
  },
  'solar:hanger-2-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M10.286 3.91c0-.568.538-1.16 1.374-1.16s1.374.592 1.374 1.16c0 .311-.112.581-.294.78a11 11 0 0 1-.38.385l-.08.08a9 9 0 0 0-.529.558c-.265.312-.553.723-.658 1.23a4.3 4.3 0 0 0-1.774.722l-7.095 4.992c-.927.652-1.166 1.702-.828 2.582c.332.866 1.194 1.511 2.306 1.511H5.26c-.01.364-.01.764-.01 1.198v.104c0 .899 0 1.648.08 2.242c.085.628.27 1.195.726 1.65c.456.456 1.023.642 1.65.726c.595.08 1.344.08 2.243.08h4.104c.898 0 1.648 0 2.242-.08c.628-.084 1.195-.27 1.65-.726c.456-.455.642-1.022.726-1.65c.08-.594.08-1.343.08-2.242v-.104c0-.434 0-.834-.01-1.198h1.557c1.125 0 1.99-.657 2.316-1.533c.33-.891.073-1.948-.877-2.588l-7.433-5.01a4.3 4.3 0 0 0-1.614-.66q.075-.121.205-.274c.126-.149.274-.298.44-.464l.075-.072c.14-.14.295-.292.435-.445c.443-.48.69-1.115.69-1.795c0-1.542-1.364-2.659-2.874-2.659S8.786 2.367 8.786 3.91a.75.75 0 0 0 1.5 0m8.3 11.34h1.711c.509 0 .806-.277.91-.555c.097-.264.047-.582-.31-.822l-7.432-5.01a2.9 2.9 0 0 0-1.655-.483a2.9 2.9 0 0 0-1.628.512l-7.095 4.991c-.346.243-.391.558-.29.819c.105.275.403.548.905.548h1.712c.109-.447.299-.852.641-1.194c.456-.456 1.023-.642 1.65-.726c.595-.08 1.344-.08 2.243-.08h4.104c.898 0 1.648 0 2.242.08c.628.084 1.195.27 1.65.726c.343.342.533.747.642 1.194m-11.47-.134c.13-.13.328-.237.79-.3c.482-.064 1.13-.066 2.094-.066h4c.964 0 1.611.002 2.094.066c.462.063.66.17.79.3s.237.328.3.79c.064.482.066 1.13.066 2.094s-.002 1.612-.067 2.095c-.062.461-.169.659-.3.789s-.327.237-.789.3c-.483.064-1.13.066-2.094.066h-4c-.964 0-1.612-.002-2.095-.067c-.461-.062-.659-.169-.79-.3c-.13-.13-.237-.327-.299-.788c-.065-.483-.066-1.131-.066-2.095s.001-1.612.066-2.095c.062-.461.17-.659.3-.789" clip-rule="evenodd"/>',
  },
  'solar:home-2-outline': {
    body: '<path fill="currentColor" d="M11.25 18a.75.75 0 0 0 1.5 0v-3a.75.75 0 0 0-1.5 0z"/><path fill="currentColor" fill-rule="evenodd" d="M12 1.25c-.708 0-1.351.203-2.05.542c-.674.328-1.454.812-2.427 1.416L5.456 4.491c-.92.572-1.659 1.03-2.227 1.465c-.589.45-1.041.91-1.368 1.507c-.326.595-.472 1.229-.543 1.978c-.068.725-.068 1.613-.068 2.726v1.613c0 1.904 0 3.407.153 4.582c.156 1.205.486 2.178 1.23 2.947c.747.773 1.697 1.119 2.875 1.282c1.14.159 2.598.159 4.434.159h4.116c1.836 0 3.294 0 4.434-.159c1.177-.163 2.128-.509 2.876-1.282c.743-.769 1.073-1.742 1.23-2.947c.152-1.175.152-2.678.152-4.582v-1.613c0-1.113 0-2-.068-2.726c-.07-.75-.217-1.383-.543-1.978c-.327-.597-.78-1.056-1.368-1.507c-.568-.436-1.306-.893-2.227-1.465l-2.067-1.283c-.973-.604-1.753-1.088-2.428-1.416c-.697-.34-1.34-.542-2.049-.542M8.28 4.504c1.015-.63 1.73-1.072 2.327-1.363c.581-.283.993-.391 1.393-.391s.812.108 1.393.391c.598.29 1.312.733 2.327 1.363l2 1.241c.961.597 1.636 1.016 2.14 1.402c.489.375.77.684.963 1.036c.193.353.306.766.365 1.398c.061.648.062 1.465.062 2.623v1.521c0 1.97-.002 3.376-.14 4.443c-.136 1.048-.393 1.656-.82 2.099c-.425.439-1.003.7-2.004.839c-1.026.142-2.379.144-4.286.144h-4c-1.908 0-3.26-.002-4.286-.144c-1.001-.14-1.579-.4-2.003-.84c-.428-.442-.685-1.05-.82-2.098c-.14-1.067-.141-2.472-.141-4.443v-1.521c0-1.158 0-1.975.062-2.623c.059-.632.172-1.045.365-1.398c.193-.352.474-.661.964-1.036c.503-.386 1.178-.805 2.139-1.402z" clip-rule="evenodd"/>',
  },
  'solar:letter-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M9.944 3.25h4.112c1.838 0 3.294 0 4.433.153c1.172.158 2.121.49 2.87 1.238c.748.749 1.08 1.698 1.238 2.87c.153 1.14.153 2.595.153 4.433v.112c0 1.838 0 3.294-.153 4.433c-.158 1.172-.49 2.121-1.238 2.87c-.749.748-1.698 1.08-2.87 1.238c-1.14.153-2.595.153-4.433.153H9.944c-1.838 0-3.294 0-4.433-.153c-1.172-.158-2.121-.49-2.87-1.238c-.748-.749-1.08-1.698-1.238-2.87c-.153-1.14-.153-2.595-.153-4.433v-.112c0-1.838 0-3.294.153-4.433c.158-1.172.49-2.121 1.238-2.87c.749-.748 1.698-1.08 2.87-1.238c1.14-.153 2.595-.153 4.433-.153M5.71 4.89c-1.006.135-1.586.389-2.01.812c-.422.423-.676 1.003-.811 2.009c-.138 1.028-.14 2.382-.14 4.289s.002 3.262.14 4.29c.135 1.005.389 1.585.812 2.008s1.003.677 2.009.812c1.028.138 2.382.14 4.289.14h4c1.907 0 3.262-.002 4.29-.14c1.005-.135 1.585-.389 2.008-.812s.677-1.003.812-2.009c.138-1.028.14-2.382.14-4.289s-.002-3.261-.14-4.29c-.135-1.005-.389-1.585-.812-2.008s-1.003-.677-2.009-.812c-1.027-.138-2.382-.14-4.289-.14h-4c-1.907 0-3.261.002-4.29.14m-.287 2.63a.75.75 0 0 1 1.056-.096L8.64 9.223c.933.777 1.58 1.315 2.128 1.667c.529.34.888.455 1.233.455s.704-.114 1.233-.455c.547-.352 1.195-.89 2.128-1.667l2.159-1.8a.75.75 0 1 1 .96 1.153l-2.196 1.83c-.887.74-1.605 1.338-2.24 1.746c-.66.425-1.303.693-2.044.693s-1.384-.269-2.045-.693c-.634-.408-1.352-1.007-2.239-1.745L5.52 8.577a.75.75 0 0 1-.096-1.057" clip-rule="evenodd"/>',
  },
  'solar:figma-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M8.667 1.25a4.083 4.083 0 0 0-2.36 7.417A4.08 4.08 0 0 0 4.584 12c0 1.376.681 2.594 1.725 3.333a4.083 4.083 0 1 0 6.442 3.333v-3.504a4.083 4.083 0 1 0 4.942-6.496a4.083 4.083 0 0 0-2.36-7.417zm2.583 13.333H8.667a2.583 2.583 0 1 1 0-5.166h2.583zM8.667 7.917h2.583V2.75H8.667a2.583 2.583 0 1 0 0 5.167m9.25-2.584a2.583 2.583 0 0 1-2.58 2.584H12.75V2.75h2.584a2.583 2.583 0 0 1 2.583 2.583m-5.167 6.664a2.583 2.583 0 0 1 2.58-2.58h.006a2.583 2.583 0 1 1-2.586 2.586zm-4.083 4.086a2.583 2.583 0 1 0 2.583 2.584v-2.584z" clip-rule="evenodd"/>',
  },
  'solar:like-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M12.438 2.778a.6.6 0 0 0-.438.03a.52.52 0 0 0-.28.33l-.476 1.834a8.4 8.4 0 0 1-.72 1.844c-.485.907-1.218 1.604-1.898 2.19l-1.438 1.24a.92.92 0 0 0-.315.774l.812 9.393a.916.916 0 0 0 .911.837h4.649c3.136 0 5.779-2.182 6.286-5.113l.705-4.08a.916.916 0 0 0-.901-1.073h-5.181c-.977 0-1.72-.876-1.562-1.84l.663-4.044a4 4 0 0 0-.076-1.664a.89.89 0 0 0-.596-.611zl.23-.714zm-1.09-1.321a2.1 2.1 0 0 1 1.549-.107l.145.047l-.23.714l.23-.714c.777.25 1.383.87 1.589 1.662c.193.746.229 1.524.104 2.284l-.663 4.044a.083.083 0 0 0 .082.097h5.18c1.5 0 2.636 1.352 2.38 2.829l-.705 4.08c-.638 3.688-3.938 6.357-7.764 6.357H8.596a2.416 2.416 0 0 1-2.405-2.208l-.813-9.393a2.42 2.42 0 0 1 .83-2.04l1.44-1.24c.655-.564 1.206-1.111 1.552-1.76a6.8 6.8 0 0 0 .592-1.514l.476-1.833a2.01 2.01 0 0 1 1.08-1.305m-8.38 8.028a.75.75 0 0 1 .78.685l.97 11.236a1.237 1.237 0 1 1-2.468.107V10.234a.75.75 0 0 1 .718-.75" clip-rule="evenodd"/>',
  },
  'solar:atom-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M13.462 4.047c1.203.822 2.4 1.812 3.54 2.951a25 25 0 0 1 2.951 3.54c.701-1.377 1.123-2.682 1.253-3.813c.165-1.427-.138-2.482-.794-3.137c-.655-.656-1.71-.96-3.137-.794c-1.131.13-2.436.552-3.813 1.253M20.869 12c1.005-1.765 1.645-3.524 1.828-5.103c.195-1.69-.13-3.275-1.224-4.37c-1.095-1.095-2.68-1.419-4.37-1.224c-1.58.183-3.338.823-5.103 1.828c-1.765-1.005-3.523-1.645-5.103-1.827c-1.69-.195-3.275.128-4.37 1.223c-1.094 1.095-1.418 2.68-1.223 4.37c.182 1.58.822 3.338 1.828 5.103c-1.006 1.765-1.646 3.523-1.828 5.103c-.195 1.69.129 3.274 1.224 4.37c1.095 1.094 2.679 1.418 4.37 1.223c1.579-.182 3.337-.822 5.102-1.828c1.765 1.006 3.523 1.646 5.103 1.828c1.69.195 3.275-.129 4.37-1.224s1.418-2.679 1.223-4.37c-.182-1.579-.822-3.337-1.827-5.102m-1.75 0a23 23 0 0 0-3.178-3.941A23 23 0 0 0 12 4.88a23 23 0 0 0-3.94 3.18A23 23 0 0 0 4.88 12a23 23 0 0 0 3.18 3.942A23 23 0 0 0 12 19.119a23 23 0 0 0 3.941-3.179A23 23 0 0 0 19.12 12m-5.657 7.953a25 25 0 0 0 3.54-2.952a25 25 0 0 0 2.951-3.54c.701 1.378 1.123 2.682 1.253 3.814c.165 1.427-.138 2.481-.794 3.137c-.656.655-1.71.959-3.137.794c-1.131-.13-2.436-.552-3.813-1.253m-2.924 0A25 25 0 0 1 6.998 17a25 25 0 0 1-2.951-3.54c-.7 1.378-1.122 2.682-1.253 3.814c-.164 1.427.139 2.481.794 3.137c.656.655 1.71.958 3.137.794c1.132-.13 2.436-.552 3.813-1.253m-6.491-9.415a25 25 0 0 1 2.952-3.54a25 25 0 0 1 3.54-2.951c-1.379-.7-2.683-1.122-3.815-1.252c-1.427-.165-2.481.138-3.137.794c-.655.655-.959 1.71-.794 3.137c.13 1.131.552 2.436 1.253 3.813M12 10.25a1.75 1.75 0 1 0 0 3.5a1.75 1.75 0 0 0 0-3.5M8.75 12a3.25 3.25 0 1 1 6.5 0a3.25 3.25 0 0 1-6.5 0" clip-rule="evenodd"/>',
  },
  'solar:gallery-circle-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="m2.83 10.777l.428-.374a3.05 3.05 0 0 1 4.165.139l4.29 4.29a1.25 1.25 0 0 0 1.602.138l.298-.21a3.75 3.75 0 0 1 4.665.281l1.743 1.57A9.25 9.25 0 1 0 2.83 10.777m16.332 7.078l-1.887-1.699a2.25 2.25 0 0 0-2.8-.168l-.297.21a2.75 2.75 0 0 1-3.526-.306l-4.29-4.29a1.55 1.55 0 0 0-2.117-.07l-1.46 1.278A9.25 9.25 0 0 0 12 21.25a9.23 9.23 0 0 0 7.162-3.395M1.25 12C1.25 6.063 6.063 1.25 12 1.25S22.75 6.063 22.75 12S17.937 22.75 12 22.75S1.25 17.937 1.25 12M15 7.75a1.25 1.25 0 1 0 0 2.5a1.25 1.25 0 0 0 0-2.5M12.25 9a2.75 2.75 0 1 1 5.5 0a2.75 2.75 0 0 1-5.5 0" clip-rule="evenodd"/>',
  },
  'solar:airbuds-case-open-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M6.125 2.75c-1.036 0-1.875.84-1.875 1.875v1.316c0 .95.77 1.721 1.72 1.721c.87 0 1.574.705 1.574 1.574v1.014H9.75V6.375A3.625 3.625 0 0 0 6.125 2.75m5.125 7.5V6.375A5.125 5.125 0 0 0 6.125 1.25A3.375 3.375 0 0 0 2.75 4.625v1.316a3.22 3.22 0 0 0 3.22 3.221c.041 0 .074.033.074.074v1.014H4.796c-.359 0-.688 0-.96.03c-.296.034-.614.111-.901.332q-.183.14-.323.323c-.22.287-.298.605-.331.901c-.031.272-.031.601-.031.96v.25c0 1.836 0 3.275.124 4.418c.126 1.165.388 2.11.974 2.916a5.8 5.8 0 0 0 1.272 1.272c.807.586 1.75.848 2.916.974c1.143.124 2.582.124 4.419.124h.09c1.837 0 3.276 0 4.419-.124c1.165-.126 2.11-.388 2.916-.974a5.8 5.8 0 0 0 1.272-1.272c.586-.807.848-1.75.974-2.916c.124-1.143.124-2.582.124-4.419v-.249c0-.359 0-.688-.03-.96c-.034-.296-.111-.614-.332-.901a1.8 1.8 0 0 0-.323-.323c-.287-.22-.605-.298-.901-.331c-.272-.031-.601-.031-.96-.031h-1.248V9.236c0-.041.033-.074.073-.074a3.22 3.22 0 0 0 3.221-3.22V4.624a3.375 3.375 0 0 0-3.375-3.375a5.125 5.125 0 0 0-5.125 5.125v3.875zM9 11.75c.228.304.591.5 1 .5h4c.409 0 .772-.196 1-.5zm7.647 0a2.75 2.75 0 0 1-2.647 2h-4a2.75 2.75 0 0 1-2.646-2h-2.52c-.409 0-.653.001-.83.021a.6.6 0 0 0-.158.032a.3.3 0 0 0-.043.043a.6.6 0 0 0-.032.158a9 9 0 0 0-.021.83V13c0 1.892.001 3.25.115 4.302c.112 1.038.328 1.688.697 2.196c.262.36.58.678.94.94c.508.37 1.158.585 2.196.697c1.052.114 2.41.115 4.302.115s3.25-.001 4.302-.115c1.038-.113 1.688-.328 2.196-.697c.36-.262.678-.58.94-.94c.37-.508.585-1.158.697-2.196c.114-1.052.115-2.41.115-4.302v-.167a9 9 0 0 0-.021-.829a.6.6 0 0 0-.032-.158a.3.3 0 0 0-.043-.043a.6.6 0 0 0-.158-.032a9 9 0 0 0-.83-.021zm-.191-1.5H14.25V6.375a3.625 3.625 0 0 1 3.625-3.625c1.035 0 1.875.84 1.875 1.875v1.316c0 .95-.77 1.721-1.72 1.721c-.87 0-1.574.705-1.574 1.574z" clip-rule="evenodd"/>',
  },
  'solar:confetti-minimalistic-outline': {
    body: '<path fill="currentColor" d="M10.927 2.36a.75.75 0 0 1 .248 1.031a.65.65 0 0 0 .095.8l.098.098c.589.588.806 1.453.565 2.25a.75.75 0 1 1-1.436-.434a.76.76 0 0 0-.19-.756l-.097-.098a2.15 2.15 0 0 1-.315-2.642a.75.75 0 0 1 1.032-.249m6.763 2.362a.75.75 0 0 1 .588.882l-.144.72a2.82 2.82 0 0 1-1.871 2.12a1.31 1.31 0 0 0-.874.99l-.144.72a.75.75 0 0 1-1.471-.295l.144-.72c.198-.99.912-1.8 1.87-2.119c.448-.15.782-.527.875-.99l.144-.72a.75.75 0 0 1 .882-.588"/><path fill="currentColor" fill-rule="evenodd" d="M11.719 8.813c-.82-.819-1.494-1.493-2.08-1.928c-.606-.45-1.279-.766-2.054-.583c-.776.183-1.236.768-1.577 1.44c-.33.651-.632 1.556-.998 2.655l-1.73 5.19c-.443 1.33-.803 2.409-.952 3.246c-.15.844-.135 1.701.501 2.337s1.493.651 2.337.501c.837-.149 1.916-.508 3.246-.952l5.19-1.73c1.099-.366 2.004-.668 2.655-.998c.673-.34 1.257-.801 1.44-1.576c.183-.776-.134-1.449-.583-2.055c-.434-.586-1.11-1.26-1.928-2.08zm-3.025-.76l.052.037c.486.36 1.082.954 1.956 1.828l.76.76l-.05.133c-.077.211-.178.512-.279.88a11 11 0 0 0-.406 2.864c0 1.063.206 2.08.405 2.82c.083.308.166.573.235.778l-2.635.879a44 44 0 0 1-.265-1.29c-.174-.907-.356-2.007-.411-2.857c-.092-1.403.087-3.235.3-4.75a50 50 0 0 1 .338-2.082m-1.74 1.3c-.158.431-.332.95-.54 1.578l-1.69 5.068c-.47 1.407-.792 2.381-.92 3.097c-.127.72-.008.92.086 1.014c.093.093.293.213 1.014.085c.59-.106 1.357-.344 2.398-.687l-.072-.324c-.062-.29-.147-.697-.236-1.16c-.176-.918-.373-2.093-.435-3.04c-.103-1.566.096-3.525.312-5.058q.04-.296.083-.572m5.836 8.326l.279-.093c1.172-.39 1.97-.659 2.51-.932c.53-.269.627-.453.658-.584c.03-.131.026-.34-.328-.816c-.36-.486-.954-1.083-1.828-1.957l-1.436-1.437q-.033.108-.066.228a9.5 9.5 0 0 0-.352 2.468c0 .618.085 1.235.198 1.778a12 12 0 0 0 .365 1.345" clip-rule="evenodd"/><path fill="currentColor" d="M20.33 12.73a1.01 1.01 0 0 1 1.078-.17l.292.127a.75.75 0 1 0 .6-1.374l-.29-.128a2.51 2.51 0 0 0-2.675.423c-.326.289-.8.337-1.178.119l-.213-.123a.75.75 0 1 0-.75 1.3l.213.122c.937.54 2.114.422 2.924-.296m-6.352-8.672c-.116.037-.217.137-.418.338s-.302.302-.338.418a.5.5 0 0 0 0 .302c.036.117.137.217.338.418s.302.302.418.339a.5.5 0 0 0 .302 0c.116-.037.217-.138.418-.339c.201-.2.302-.301.338-.418a.5.5 0 0 0 0-.302c-.037-.116-.137-.217-.338-.418s-.302-.301-.418-.338a.5.5 0 0 0-.302 0m5.489 3.41c.246-.245.368-.368.507-.421a.7.7 0 0 1 .503 0c.139.053.261.176.507.421c.245.246.368.368.421.507a.7.7 0 0 1 0 .503c-.053.139-.176.261-.421.507c-.246.245-.368.368-.507.421a.7.7 0 0 1-.503 0c-.139-.053-.261-.176-.507-.421c-.245-.246-.368-.368-.421-.507a.7.7 0 0 1 0-.503c.053-.139.176-.261.421-.507M7.686 3.94a.536.536 0 1 0-.759.76a.536.536 0 0 0 .759-.76m11.372 11.374a.536.536 0 1 1 .759.758a.536.536 0 0 1-.759-.758m-.799-5.572a.536.536 0 1 0-.759.758a.536.536 0 0 0 .759-.758"/>',
  },
  'solar:quit-full-screen-square-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M11.943 1.25h.114c2.309 0 4.118 0 5.53.19c1.444.194 2.584.6 3.479 1.494c.895.895 1.3 2.035 1.494 3.48c.19 1.411.19 3.22.19 5.529v.114c0 2.309 0 4.118-.19 5.53c-.194 1.444-.6 2.584-1.494 3.479c-.895.895-2.035 1.3-3.48 1.494c-1.411.19-3.22.19-5.529.19h-.114c-2.309 0-4.118 0-5.53-.19c-1.444-.194-2.584-.6-3.479-1.494c-.895-.895-1.3-2.035-1.494-3.48c-.19-1.411-.19-3.22-.19-5.529v-.114c0-2.309 0-4.118.19-5.53c.194-1.444.6-2.584 1.494-3.479c.895-.895 2.035-1.3 3.48-1.494c1.411-.19 3.22-.19 5.529-.19m-5.33 1.676c-1.278.172-2.049.5-2.618 1.069c-.57.57-.897 1.34-1.069 2.619c-.174 1.3-.176 3.008-.176 5.386s.002 4.086.176 5.386c.172 1.279.5 2.05 1.069 2.62c.57.569 1.34.896 2.619 1.068c1.3.174 3.008.176 5.386.176s4.086-.002 5.386-.176c1.279-.172 2.05-.5 2.62-1.069c.569-.57.896-1.34 1.068-2.619c.174-1.3.176-3.008.176-5.386s-.002-4.086-.176-5.386c-.172-1.279-.5-2.05-1.069-2.62c-.57-.569-1.34-.896-2.619-1.068c-1.3-.174-3.008-.176-5.386-.176s-4.086.002-5.386.176m3.39 2.324a.75.75 0 0 1 .745.757c-.008.85-.034 1.576-.152 2.179c-.122.623-.352 1.166-.798 1.612s-.99.676-1.612.798c-.603.118-1.329.144-2.18.152a.75.75 0 1 1-.012-1.5c.856-.008 1.453-.036 1.903-.124c.429-.084.666-.212.84-.386c.175-.175.303-.412.387-.84c.088-.45.116-1.048.124-1.904a.75.75 0 0 1 .756-.744m3.99 0a.75.75 0 0 1 .757.744c.007.856.036 1.453.124 1.903c.084.429.212.666.386.84c.174.175.412.303.84.387c.45.088 1.048.116 1.904.124a.75.75 0 0 1-.013 1.5c-.85-.008-1.577-.034-2.179-.152c-.623-.122-1.167-.352-1.613-.798s-.675-.99-.797-1.612c-.118-.603-.145-1.329-.152-2.18a.75.75 0 0 1 .744-.756M5.25 13.994a.75.75 0 0 1 .757-.744c.85.007 1.576.034 2.179.152c.623.122 1.166.351 1.612.797s.676.99.798 1.613c.118.602.144 1.328.152 2.179a.75.75 0 0 1-1.5.013c-.008-.856-.036-1.454-.124-1.904c-.084-.428-.212-.666-.386-.84s-.412-.302-.84-.386c-.45-.088-1.048-.117-1.904-.124a.75.75 0 0 1-.744-.756m13.497 0a.75.75 0 0 1-.743.756c-.856.007-1.454.036-1.904.124c-.428.084-.666.212-.84.386s-.302.412-.386.84c-.088.45-.117 1.048-.124 1.904a.75.75 0 0 1-1.5-.013c.007-.85.034-1.577.152-2.179c.122-.623.351-1.167.797-1.613s.99-.675 1.613-.797c.602-.118 1.328-.145 2.179-.152a.75.75 0 0 1 .756.744" clip-rule="evenodd" />',
  },
  'solar:lock-password-outline': {
    body: '<path fill="currentColor" d="M9 16a1 1 0 1 1-2 0a1 1 0 0 1 2 0m4 0a1 1 0 1 1-2 0a1 1 0 0 1 2 0m3 1a1 1 0 1 0 0-2a1 1 0 0 0 0 2" /><path fill="currentColor" fill-rule="evenodd" d="M5.25 8v1.303q-.34.023-.642.064c-.9.12-1.658.38-2.26.981c-.602.602-.86 1.36-.981 2.26c-.117.867-.117 1.97-.117 3.337v.11c0 1.367 0 2.47.117 3.337c.12.9.38 1.658.981 2.26c.602.602 1.36.86 2.26.982c.867.116 1.97.116 3.337.116h8.11c1.367 0 2.47 0 3.337-.116c.9-.122 1.658-.38 2.26-.982s.86-1.36.982-2.26c.116-.867.116-1.97.116-3.337v-.11c0-1.367 0-2.47-.116-3.337c-.122-.9-.38-1.658-.982-2.26s-1.36-.86-2.26-.981a10 10 0 0 0-.642-.064V8a6.75 6.75 0 0 0-13.5 0M12 2.75A5.25 5.25 0 0 0 6.75 8v1.253q.56-.004 1.195-.003h8.11q.635 0 1.195.003V8c0-2.9-2.35-5.25-5.25-5.25m-7.192 8.103c-.734.099-1.122.28-1.399.556c-.277.277-.457.665-.556 1.4c-.101.755-.103 1.756-.103 3.191s.002 2.436.103 3.192c.099.734.28 1.122.556 1.399c.277.277.665.457 1.4.556c.754.101 1.756.103 3.191.103h8c1.435 0 2.436-.002 3.192-.103c.734-.099 1.122-.28 1.399-.556c.277-.277.457-.665.556-1.4c.101-.755.103-1.756.103-3.191s-.002-2.437-.103-3.192c-.099-.734-.28-1.122-.556-1.399c-.277-.277-.665-.457-1.4-.556c-.755-.101-1.756-.103-3.191-.103H8c-1.435 0-2.437.002-3.192.103" clip-rule="evenodd" />',
  },
  'solar:full-screen-square-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M11.943 1.25h.114c2.309 0 4.118 0 5.53.19c1.444.194 2.584.6 3.479 1.494c.895.895 1.3 2.035 1.494 3.48c.19 1.411.19 3.22.19 5.529v.114c0 2.309 0 4.118-.19 5.53c-.194 1.444-.6 2.584-1.494 3.479c-.895.895-2.035 1.3-3.48 1.494c-1.411.19-3.22.19-5.529.19h-.114c-2.309 0-4.118 0-5.53-.19c-1.444-.194-2.584-.6-3.479-1.494c-.895-.895-1.3-2.035-1.494-3.48c-.19-1.411-.19-3.22-.19-5.529v-.114c0-2.309 0-4.118.19-5.53c.194-1.444.6-2.584 1.494-3.479c.895-.895 2.035-1.3 3.48-1.494c1.411-.19 3.22-.19 5.529-.19m-5.33 1.676c-1.278.172-2.049.5-2.618 1.069c-.57.57-.897 1.34-1.069 2.619c-.174 1.3-.176 3.008-.176 5.386s.002 4.086.176 5.386c.172 1.279.5 2.05 1.069 2.62c.57.569 1.34.896 2.619 1.068c1.3.174 3.008.176 5.386.176s4.086-.002 5.386-.176c1.279-.172 2.05-.5 2.62-1.069c.569-.57.896-1.34 1.068-2.619c.174-1.3.176-3.008.176-5.386s-.002-4.086-.176-5.386c-.172-1.279-.5-2.05-1.069-2.62c-.57-.569-1.34-.896-2.619-1.068c-1.3-.174-3.008-.176-5.386-.176s-4.086.002-5.386.176m4.134 3.068a.75.75 0 0 1-.743.756c-.856.007-1.454.035-1.904.124c-.428.084-.666.212-.84.386s-.302.412-.386.84c-.088.45-.117 1.048-.124 1.904a.75.75 0 0 1-1.5-.013c.007-.85.034-1.577.152-2.179c.122-.623.351-1.167.797-1.613s.99-.675 1.613-.797c.602-.118 1.328-.145 2.179-.152a.75.75 0 0 1 .756.744m2.503 0a.75.75 0 0 1 .757-.744c.85.007 1.576.034 2.179.152c.623.122 1.166.351 1.612.797s.676.99.798 1.613c.118.602.144 1.328.151 2.179a.75.75 0 0 1-1.5.013c-.007-.856-.035-1.454-.123-1.904c-.084-.428-.212-.666-.386-.84s-.412-.302-.84-.386c-.45-.088-1.048-.117-1.904-.124a.75.75 0 0 1-.744-.756M5.994 13.25a.75.75 0 0 1 .756.744c.007.856.035 1.454.124 1.903c.084.429.212.666.386.84c.174.175.412.303.84.387c.45.088 1.048.116 1.904.124a.75.75 0 0 1-.013 1.5c-.85-.008-1.577-.034-2.179-.152c-.623-.122-1.167-.352-1.613-.798s-.675-.99-.797-1.612c-.118-.603-.145-1.329-.152-2.18a.75.75 0 0 1 .744-.756m12.01 0a.75.75 0 0 1 .743.757c-.007.85-.033 1.576-.151 2.179c-.122.623-.352 1.166-.798 1.612s-.99.676-1.612.798c-.603.118-1.329.144-2.18.151a.75.75 0 1 1-.012-1.5c.856-.007 1.454-.035 1.903-.123c.429-.084.666-.212.84-.386c.175-.175.303-.412.387-.84c.088-.45.116-1.048.124-1.904a.75.75 0 0 1 .756-.744" clip-rule="evenodd"/>',
  },
  'solar:add-folder-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M6.86 1.25h.127c.351 0 .577 0 .798.02a4.75 4.75 0 0 1 2.59 1.073c.17.142.33.302.579.55l.576.577c.846.845 1.171 1.161 1.547 1.37q.328.182.689.286c.413.117.866.124 2.062.124h.425c1.273 0 2.3 0 3.111.102c.841.106 1.556.332 2.144.86q.147.133.28.28c.529.588.754 1.303.86 2.144c.102.812.102 1.838.102 3.111v2.31c0 1.837 0 3.293-.153 4.432c-.158 1.172-.49 2.121-1.238 2.87c-.749.748-1.698 1.08-2.87 1.238c-1.14.153-2.595.153-4.433.153H9.944c-1.838 0-3.294 0-4.433-.153c-1.172-.158-2.121-.49-2.87-1.238c-.748-.749-1.08-1.698-1.238-2.87c-.153-1.14-.153-2.595-.153-4.433V6.86c0-.797 0-1.303.082-1.74A4.75 4.75 0 0 1 5.12 1.331c.438-.082.944-.082 1.74-.082m.09 1.5c-.917 0-1.271.003-1.553.056a3.25 3.25 0 0 0-2.59 2.591c-.054.282-.057.636-.057 1.553V14c0 1.907.002 3.262.14 4.29c.135 1.005.389 1.585.812 2.008s1.003.677 2.009.812c1.028.138 2.382.14 4.289.14h4c1.907 0 3.262-.002 4.29-.14c1.005-.135 1.585-.389 2.008-.812s.677-1.003.812-2.009c.138-1.027.14-2.382.14-4.289v-2.202c0-1.336-.001-2.267-.09-2.975c-.087-.689-.246-1.06-.487-1.328a2 2 0 0 0-.168-.168c-.268-.241-.64-.4-1.328-.487c-.707-.089-1.639-.09-2.975-.09h-.484c-1.048 0-1.724 0-2.363-.182c-.35-.1-.689-.24-1.008-.417c-.58-.324-1.058-.801-1.8-1.543l-.077-.078l-.55-.55a8 8 0 0 0-.503-.482a3.25 3.25 0 0 0-1.771-.734a8 8 0 0 0-.696-.014m5.05 8.5a.75.75 0 0 1 .75.75v1.25H14a.75.75 0 0 1 0 1.5h-1.25V16a.75.75 0 0 1-1.5 0v-1.25H10a.75.75 0 0 1 0-1.5h1.25V12a.75.75 0 0 1 .75-.75" clip-rule="evenodd" />',
  },
  'solar:heart-outline': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M5.624 4.424C3.965 5.182 2.75 6.986 2.75 9.137c0 2.197.9 3.891 2.188 5.343c1.063 1.196 2.349 2.188 3.603 3.154q.448.345.885.688c.526.415.995.778 1.448 1.043s.816.385 1.126.385s.674-.12 1.126-.385c.453-.265.922-.628 1.448-1.043q.437-.344.885-.687c1.254-.968 2.54-1.959 3.603-3.155c1.289-1.452 2.188-3.146 2.188-5.343c0-2.15-1.215-3.955-2.874-4.713c-1.612-.737-3.778-.542-5.836 1.597a.75.75 0 0 1-1.08 0C9.402 3.882 7.236 3.687 5.624 4.424M12 4.46C9.688 2.39 7.099 2.1 5 3.059C2.786 4.074 1.25 6.426 1.25 9.138c0 2.665 1.11 4.699 2.567 6.339c1.166 1.313 2.593 2.412 3.854 3.382q.43.33.826.642c.513.404 1.063.834 1.62 1.16s1.193.59 1.883.59s1.326-.265 1.883-.59c.558-.326 1.107-.756 1.62-1.16q.396-.312.826-.642c1.26-.97 2.688-2.07 3.854-3.382c1.457-1.64 2.567-3.674 2.567-6.339c0-2.712-1.535-5.064-3.75-6.077c-2.099-.96-4.688-.67-7 1.399" clip-rule="evenodd"/>',
  },
  'solar:bill-list-bold-duotone': {
    body: '<path fill="currentColor" d="M7.245 2h9.51c1.159 0 1.738 0 2.206.163a3.05 3.05 0 0 1 1.881 1.936C21 4.581 21 5.177 21 6.37v14.004c0 .858-.985 1.314-1.608.744a.946.946 0 0 0-1.284 0l-.483.442a1.657 1.657 0 0 1-2.25 0a1.657 1.657 0 0 0-2.25 0a1.657 1.657 0 0 1-2.25 0a1.657 1.657 0 0 0-2.25 0a1.657 1.657 0 0 1-2.25 0l-.483-.442a.946.946 0 0 0-1.284 0c-.623.57-1.608.114-1.608-.744V6.37c0-1.193 0-1.79.158-2.27c.3-.913.995-1.629 1.881-1.937C5.507 2 6.086 2 7.245 2" opacity="0.4"/><path fill="currentColor" d="M7 6.75a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5zm3.5 0a.75.75 0 0 0 0 1.5H17a.75.75 0 0 0 0-1.5zM7 10.25a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5zm3.5 0a.75.75 0 0 0 0 1.5H17a.75.75 0 0 0 0-1.5zM7 13.75a.75.75 0 0 0 0 1.5h.5a.75.75 0 0 0 0-1.5zm3.5 0a.75.75 0 0 0 0 1.5H17a.75.75 0 0 0 0-1.5z"/>',
  },
  'solar:pallete-2-bold-duotone': {
    body: '<path fill="currentColor" d="M10.847 21.934C5.867 21.362 2 17.133 2 12C2 6.477 6.477 2 12 2s10 4.477 10 10c0 5.157-3.283 4.733-6.086 4.37c-1.618-.209-3.075-.397-3.652.518c-.395.626.032 1.406.555 1.929a1.673 1.673 0 0 1 0 2.366c-.523.523-1.235.836-1.97.751" opacity="0.4"/><path fill="currentColor" d="M11.085 7a1.5 1.5 0 1 1-3 0a1.5 1.5 0 0 1 3 0M6.5 13a1.5 1.5 0 1 0 0-3a1.5 1.5 0 0 0 0 3m11 0a1.5 1.5 0 1 0 0-3a1.5 1.5 0 0 0 0 3m-3-4.5a1.5 1.5 0 1 0 0-3a1.5 1.5 0 0 0 0 3"/>',
  },
  'solar:bell-bing-bold-duotone': {
    body: '<path fill="currentColor" d="M18.75 9v.704c0 .845.24 1.671.692 2.374l1.108 1.723c1.011 1.574.239 3.713-1.52 4.21a25.8 25.8 0 0 1-14.06 0c-1.759-.497-2.531-2.636-1.52-4.21l1.108-1.723a4.4 4.4 0 0 0 .693-2.374V9c0-3.866 3.022-7 6.749-7s6.75 3.134 6.75 7" opacity="0.4"/><path fill="currentColor" d="M12.75 6a.75.75 0 0 0-1.5 0v4a.75.75 0 0 0 1.5 0zM7.243 18.545a5.002 5.002 0 0 0 9.513 0c-3.145.59-6.367.59-9.513 0"/>',
  },
  'solar:menu-dots-bold-duotone': {
    body: '<path fill="currentColor" d="M7 12a2 2 0 1 1-4 0a2 2 0 0 1 4 0m14 0a2 2 0 1 1-4 0a2 2 0 0 1 4 0"/><path fill="currentColor" d="M14 12a2 2 0 1 1-4 0a2 2 0 0 1 4 0" opacity="0.4"/>',
  },
  'solar:home-angle-bold-duotone': {
    body: '<path fill="currentColor" d="M13.106 22h-2.212c-3.447 0-5.17 0-6.345-1.012s-1.419-2.705-1.906-6.093l-.279-1.937c-.38-2.637-.57-3.956-.029-5.083s1.691-1.813 3.992-3.183l1.385-.825C9.8 2.622 10.846 2 12 2s2.199.622 4.288 1.867l1.385.825c2.3 1.37 3.451 2.056 3.992 3.183s.35 2.446-.03 5.083l-.278 1.937c-.487 3.388-.731 5.081-1.906 6.093S16.553 22 13.106 22" opacity="0.4"/><path fill="currentColor" d="M8.25 18a.75.75 0 0 1 .75-.75h6a.75.75 0 0 1 0 1.5H9a.75.75 0 0 1-.75-.75"/>',
  },
  'solar:settings-bold-duotone': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M14.279 2.152C13.909 2 13.439 2 12.5 2s-1.408 0-1.779.152a2 2 0 0 0-1.09 1.083c-.094.223-.13.484-.145.863a1.62 1.62 0 0 1-.796 1.353a1.64 1.64 0 0 1-1.579.008c-.338-.178-.583-.276-.825-.308a2.03 2.03 0 0 0-1.49.396c-.318.242-.553.646-1.022 1.453c-.47.807-.704 1.21-.757 1.605c-.07.526.074 1.058.4 1.479c.148.192.357.353.68.555c.477.297.783.803.783 1.361s-.306 1.064-.782 1.36c-.324.203-.533.364-.682.556a2 2 0 0 0-.399 1.479c.053.394.287.798.757 1.605s.704 1.21 1.022 1.453c.424.323.96.465 1.49.396c.242-.032.487-.13.825-.308a1.64 1.64 0 0 1 1.58.008c.486.28.774.795.795 1.353c.015.38.051.64.145.863c.204.49.596.88 1.09 1.083c.37.152.84.152 1.779.152s1.409 0 1.779-.152a2 2 0 0 0 1.09-1.083c.094-.223.13-.483.145-.863c.02-.558.309-1.074.796-1.353a1.64 1.64 0 0 1 1.579-.008c.338.178.583.276.825.308c.53.07 1.066-.073 1.49-.396c.318-.242.553-.646 1.022-1.453c.47-.807.704-1.21.757-1.605a2 2 0 0 0-.4-1.479c-.148-.192-.357-.353-.68-.555c-.477-.297-.783-.803-.783-1.361s.306-1.064.782-1.36c.324-.203.533-.364.682-.556a2 2 0 0 0 .399-1.479c-.053-.394-.287-.798-.757-1.605s-.704-1.21-1.022-1.453a2.03 2.03 0 0 0-1.49-.396c-.242.032-.487.13-.825.308a1.64 1.64 0 0 1-1.58-.008a1.62 1.62 0 0 1-.795-1.353c-.015-.38-.051-.64-.145-.863a2 2 0 0 0-1.09-1.083" clip-rule="evenodd" opacity="0.4"/><path fill="currentColor" d="M15.523 12c0 1.657-1.354 3-3.023 3s-3.023-1.343-3.023-3S10.83 9 12.5 9s3.023 1.343 3.023 3"/>',
  },
  'solar:notes-bold-duotone': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="m20.83 10.715l-.518 1.932c-.605 2.255-.907 3.383-1.592 4.114a4 4 0 0 1-2.01 1.161q-.145.034-.295.052c-.915.113-2.032-.186-4.064-.73c-2.255-.605-3.383-.907-4.114-1.592a4 4 0 0 1-1.161-2.011c-.228-.976.074-2.103.679-4.358l.517-1.932l.244-.905c.455-1.666.761-2.583 1.348-3.21a4 4 0 0 1 2.01-1.16c.976-.228 2.104.074 4.36.679c2.254.604 3.382.906 4.113 1.59a4 4 0 0 1 1.161 2.012c.228.976-.075 2.103-.679 4.358m-9.778-.91a.75.75 0 0 1 .919-.53l4.83 1.295a.75.75 0 1 1-.389 1.448l-4.83-1.294a.75.75 0 0 1-.53-.918m-.776 2.898a.75.75 0 0 1 .918-.53l2.898.777a.75.75 0 1 1-.388 1.448l-2.898-.776a.75.75 0 0 1-.53-.919" clip-rule="evenodd"/><path fill="currentColor" d="M16.415 17.975a4 4 0 0 1-1.068 1.677c-.731.685-1.859.987-4.114 1.591s-3.383.907-4.358.679a4 4 0 0 1-2.011-1.161c-.685-.731-.988-1.859-1.592-4.114l-.517-1.932c-.605-2.255-.907-3.383-.68-4.358a4 4 0 0 1 1.162-2.011c.731-.685 1.859-.987 4.114-1.592q.638-.172 1.165-.309l-.244.906l-.517 1.932c-.605 2.255-.907 3.382-.68 4.358a4 4 0 0 0 1.162 2.011c.731.685 1.859.987 4.114 1.592c2.032.544 3.149.843 4.064.73" opacity="0.4"/>',
  },
  'solar:inbox-in-bold-duotone': {
    body: '<path fill="currentColor" d="M2 12c0-4.714 0-7.071 1.464-8.536C4.93 2 7.286 2 12 2s7.071 0 8.535 1.464C22 4.93 22 7.286 22 12s0 7.071-1.465 8.535C19.072 22 16.714 22 12 22s-7.071 0-8.536-1.465C2 19.072 2 16.714 2 12" opacity="0.4"/><path fill="currentColor" d="M3.465 20.536C4.929 22 7.286 22 12 22s7.072 0 8.536-1.465C21.893 19.179 21.993 17.056 22 13h-3.16c-.905 0-1.358 0-1.755.183c-.398.183-.693.527-1.282 1.214l-.605.706c-.59.687-.884 1.031-1.282 1.214s-.85.183-1.755.183h-.321c-.905 0-1.358 0-1.756-.183s-.692-.527-1.281-1.214l-.606-.706c-.589-.687-.883-1.031-1.281-1.214S6.066 13 5.16 13H2c.007 4.055.107 6.179 1.465 7.535m9.065-9.205a.75.75 0 0 1-1.06 0l-3.3-3.3a.75.75 0 1 1 1.06-1.06l2.02 2.02V2h1.5v6.99l2.02-2.02a.75.75 0 1 1 1.06 1.06z"/>',
  },
  'solar:file-check-bold-duotone': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M14 22h-4c-3.771 0-5.657 0-6.828-1.172S2 17.771 2 14v-4c0-3.771 0-5.657 1.172-6.828S6.239 2 10.03 2c.606 0 1.091 0 1.5.017q-.02.12-.02.244l-.01 2.834c0 1.097 0 2.067.105 2.848c.114.847.375 1.694 1.067 2.386c.69.69 1.538.952 2.385 1.066c.781.105 1.751.105 2.848.105h4.052c.043.534.043 1.19.043 2.063V14c0 3.771 0 5.657-1.172 6.828S17.771 22 14 22" clip-rule="evenodd" opacity="0.4"/><path fill="currentColor" d="M10.56 15.498a.75.75 0 1 0-1.12-.996l-2.107 2.37l-.772-.87a.75.75 0 0 0-1.122.996l1.334 1.5a.75.75 0 0 0 1.12 0zm.95-13.238l-.01 2.835c0 1.097 0 2.066.105 2.848c.114.847.375 1.694 1.067 2.385c.69.691 1.538.953 2.385 1.067c.781.105 1.751.105 2.848.105h4.052q.02.232.028.5H22c0-.268 0-.402-.01-.56a5.3 5.3 0 0 0-.958-2.641c-.094-.128-.158-.204-.285-.357C19.954 7.494 18.91 6.312 18 5.5c-.81-.724-1.921-1.515-2.89-2.161c-.832-.556-1.248-.834-1.819-1.04a6 6 0 0 0-.506-.154c-.384-.095-.758-.128-1.285-.14z"/>',
  },
  'solar:file-corrupted-bold-duotone': {
    body: '<path fill="currentColor" d="m11.51 2.26l-.01 2.835c0 1.097 0 2.066.105 2.848c.114.847.375 1.694 1.067 2.385c.69.691 1.538.953 2.385 1.067c.781.105 1.751.105 2.848.105h4.052q.02.232.028.5H22c0-.268 0-.402-.01-.56a5.3 5.3 0 0 0-.958-2.641c-.094-.128-.158-.204-.285-.357C19.954 7.494 18.91 6.312 18 5.5c-.81-.724-1.921-1.515-2.89-2.161c-.832-.556-1.248-.834-1.819-1.04a6 6 0 0 0-.506-.154c-.384-.095-.758-.128-1.285-.14z"/><path fill="currentColor" d="M2 13.662V9.775C2 6.11 2 4.277 3.172 3.139C4.343 2 6.239 2 10.03 2c.591 0 1.068 0 1.47.015l.01.244l-.01 2.749v.18c0 1.059.003 1.995.105 2.755c.114.847.375 1.694 1.067 2.385c.69.691 1.538.953 2.385 1.067c.781.105 1.751.105 2.848.105h4.052q.02.232.028.5h.008c.007.357.007.765.007 1.238v1.106l-.012.006a5 5 0 0 0-.267.146a3.17 3.17 0 0 1-3.43 0a2.38 2.38 0 0 0-2.572 0a3.17 3.17 0 0 1-3.43 0a2.38 2.38 0 0 0-2.572 0a3.17 3.17 0 0 1-3.43 0a2.38 2.38 0 0 0-2.572 0c-.138.088-.206.133-.256.158c-.386.194-1.017.027-1.459-.29z" opacity="0.4"/><path fill="currentColor" d="M10 22h4c3.771 0 5.657 0 6.829-.933c1.096-.874 1.166-2.246 1.171-4.881l-.012.005a5 5 0 0 0-.267.12c-1.039.55-2.392.55-3.43 0a2.82 2.82 0 0 0-2.572 0c-1.039.55-2.392.55-3.43 0a2.82 2.82 0 0 0-2.573 0c-1.038.55-2.39.55-3.43 0a2.82 2.82 0 0 0-2.572 0a4 4 0 0 1-.255.129c-.386.159-1.017.022-1.459-.238c.005 2.625.077 3.993 1.171 4.865C4.343 22 6.23 22 10 22"/>',
  },
  'solar:file-bold-duotone': {
    body: '<path fill="currentColor" fill-rule="evenodd" d="M14 22h-4c-3.771 0-5.657 0-6.828-1.172S2 17.771 2 14v-4c0-3.771 0-5.657 1.172-6.828S6.239 2 10.03 2c.606 0 1.091 0 1.5.017q-.02.12-.02.244l-.01 2.834c0 1.097 0 2.067.105 2.848c.114.847.375 1.694 1.067 2.386c.69.69 1.538.952 2.385 1.066c.781.105 1.751.105 2.848.105h4.052c.043.534.043 1.19.043 2.063V14c0 3.771 0 5.657-1.172 6.828S17.771 22 14 22" clip-rule="evenodd" opacity="0.4" /><path fill="currentColor" d="m11.51 2.26l-.01 2.835c0 1.097 0 2.066.105 2.848c.114.847.375 1.694 1.067 2.385c.69.691 1.538.953 2.385 1.067c.781.105 1.751.105 2.848.105h4.052q.02.232.028.5H22c0-.268 0-.402-.01-.56a5.3 5.3 0 0 0-.958-2.641c-.094-.128-.158-.204-.285-.357C19.954 7.494 18.91 6.312 18 5.5c-.81-.724-1.921-1.515-2.89-2.161c-.832-.556-1.248-.834-1.819-1.04a6 6 0 0 0-.506-.154c-.384-.095-.758-.128-1.285-.14z" />',
  },
  'solar:cloudy-moon-bold-duotone': {
    body: '<path fill="currentColor" d="M12 22c5.523 0 10-4.477 10-10c0-.463-.694-.54-.933-.143a6.5 6.5 0 1 1-8.924-8.924C12.54 2.693 12.463 2 12 2C6.477 2 2 6.477 2 12s4.477 10 10 10" opacity="0.4"/><path fill="currentColor" d="M11.286 22C13.337 22 15 20.42 15 18.47c0-1.544-1.045-2.857-2.5-3.336C12.295 13.371 10.72 12 8.81 12c-2.052 0-3.715 1.58-3.715 3.53c0 .43.082.844.23 1.226a3 3 0 0 0-.54-.05C3.248 16.706 2 17.89 2 19.353S3.247 22 4.786 22z"/>',
  },
  'solar:align-right-bold-duotone': {
    body: '<path fill="currentColor" d="M16.625 7.875c0-.935 0-1.402-.201-1.75a1.5 1.5 0 0 0-.549-.549c-.348-.201-.815-.201-1.75-.201h-9c-.935 0-1.402 0-1.75.201a1.5 1.5 0 0 0-.549.549c-.201.348-.201.815-.201 1.75s0 1.402.201 1.75a1.5 1.5 0 0 0 .549.549c.348.201.815.201 1.75.201h9c.935 0 1.402 0 1.75-.201a1.5 1.5 0 0 0 .549-.549c.201-.348.201-.815.201-1.75m0 9c0-.935 0-1.402-.201-1.75a1.5 1.5 0 0 0-.549-.549c-.348-.201-.815-.201-1.75-.201h-6c-.935 0-1.402 0-1.75.201a1.5 1.5 0 0 0-.549.549c-.201.348-.201.815-.201 1.75s0 1.402.201 1.75a1.5 1.5 0 0 0 .549.549c.348.201.815.201 1.75.201h6c.935 0 1.402 0 1.75-.201a1.5 1.5 0 0 0 .549-.549c.201-.348.201-.815.201-1.75"/><path fill="currentColor" fill-rule="evenodd" d="M20.625 23.125a.75.75 0 0 1-.75-.75v-20a.75.75 0 0 1 1.5 0v20a.75.75 0 0 1-.75.75" clip-rule="evenodd" opacity="0.4"/>',
  },
  'solar:sort-by-time-bold-duotone': {
    body: '<g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd"><path d="M17 17a5 5 0 1 0 0-10a5 5 0 0 0 0 10m.75-7a.75.75 0 0 0-1.5 0v1.846c0 .18.065.355.183.491l1 1.154a.75.75 0 0 0 1.134-.982l-.817-.943z"/><path d="M1.25 7A.75.75 0 0 1 2 6.25h8a.75.75 0 0 1 0 1.5H2A.75.75 0 0 1 1.25 7m0 5a.75.75 0 0 1 .75-.75h6a.75.75 0 0 1 0 1.5H2a.75.75 0 0 1-.75-.75m0 5a.75.75 0 0 1 .75-.75h8a.75.75 0 0 1 0 1.5H2a.75.75 0 0 1-.75-.75" opacity="0.4"/></g>',
  },
  'solar:shield-keyhole-bold-duotone': {
    body: '<path fill="currentColor" d="M3 10.417c0-3.198 0-4.797.378-5.335c.377-.537 1.88-1.052 4.887-2.081l.573-.196C10.405 2.268 11.188 2 12 2s1.595.268 3.162.805l.573.196c3.007 1.029 4.51 1.544 4.887 2.081C21 5.62 21 7.22 21 10.417v1.574c0 5.638-4.239 8.375-6.899 9.536C13.38 21.842 13.02 22 12 22s-1.38-.158-2.101-.473C7.239 20.365 3 17.63 3 11.991z" opacity="0.4"/><path fill="currentColor" d="M13.5 15a1 1 0 0 1-1 1h-1a1 1 0 0 1-1-1v-1.401A2.999 2.999 0 0 1 12 8a3 3 0 0 1 1.5 5.599z"/>',
  },
  'solar:tag-horizontal-bold-duotone': {
    body: '<path fill="currentColor" d="M10.221 20h2.637c2.227 0 3.341 0 4.27-.501c.93-.502 1.52-1.42 2.701-3.259l.681-1.06C21.503 13.634 22 12.86 22 12s-.497-1.634-1.49-3.18l-.68-1.06c-1.181-1.838-1.771-2.757-2.701-3.259S15.085 4 12.858 4h-2.637C6.346 4 4.408 4 3.204 5.172S2 8.229 2 12s0 5.657 1.204 6.828S6.346 20 10.22 20" opacity="0.4"/><path fill="currentColor" d="M7 7.055c.414 0 .75.316.75.706v8.475c0 .39-.336.706-.75.706s-.75-.316-.75-.706V7.76c0-.39.336-.706.75-.706"/>',
  },
  'solar:transfer-horizontal-bold-duotone': {
    body: '<path fill="currentColor" d="M10.25 4a.75.75 0 0 0-1.303-.507l-5.5 6A.75.75 0 0 0 4 10.75h16a.75.75 0 0 0 0-1.5h-9.75z"/><path fill="currentColor" d="M13.75 20v-5.25H4a.75.75 0 0 1 0-1.5h16a.75.75 0 0 1 .553 1.257l-5.5 6A.75.75 0 0 1 13.75 20" opacity="0.4"/>',
  },
  'solar:double-alt-arrow-up-bold-duotone': {
    body: '<path fill="currentColor" d="M5 17.75a.75.75 0 0 1-.488-1.32l7-6a.75.75 0 0 1 .976 0l7 6A.75.75 0 0 1 19 17.75z" opacity="0.4"/><path fill="currentColor" fill-rule="evenodd" d="M4.43 13.488a.75.75 0 0 0 1.058.081L12 7.988l6.512 5.581a.75.75 0 1 0 .976-1.138l-7-6a.75.75 0 0 0-.976 0l-7 6a.75.75 0 0 0-.081 1.057" clip-rule="evenodd"/>',
  },
  'solar:double-alt-arrow-down-bold-duotone': {
    body: '<path fill="currentColor" d="M5 6.25a.75.75 0 0 0-.488 1.32l7 6c.28.24.695.24.976 0l7-6A.75.75 0 0 0 19 6.25z" opacity="0.4"/><path fill="currentColor" fill-rule="evenodd" d="M4.43 10.512a.75.75 0 0 1 1.058-.081L12 16.012l6.512-5.581a.75.75 0 1 1 .976 1.139l-7 6a.75.75 0 0 1-.976 0l-7-6a.75.75 0 0 1-.081-1.058" clip-rule="evenodd"/>',
  },
  'solar:double-alt-arrow-right-bold-duotone': {
    body: '<path fill="currentColor" d="M6.25 19a.75.75 0 0 0 1.32.488l6-7a.75.75 0 0 0 0-.976l-6-7A.75.75 0 0 0 6.25 5z" opacity="0.4"/><path fill="currentColor" fill-rule="evenodd" d="M10.512 19.57a.75.75 0 0 1-.081-1.058L16.012 12l-5.581-6.512a.75.75 0 1 1 1.139-.976l6 7a.75.75 0 0 1 0 .976l-6 7a.75.75 0 0 1-1.058.082" clip-rule="evenodd"/>',
  },
  'solar:notebook-bold-duotone': {
    body: '<path fill="currentColor" d="M3 8c0-2.828 0-4.243.879-5.121C4.757 2 6.172 2 9 2h6c2.828 0 4.243 0 5.121.879C21 3.757 21 5.172 21 8v8c0 2.828 0 4.243-.879 5.121C19.243 22 17.828 22 15 22H9c-2.828 0-4.243 0-5.121-.879C3 20.243 3 18.828 3 16z" opacity="0.4" /><path fill="currentColor" fill-rule="evenodd" d="M8.75 2.012v20h-1.5v-20zM1.25 8A.75.75 0 0 1 2 7.25h2a.75.75 0 0 1 0 1.5H2A.75.75 0 0 1 1.25 8m0 4a.75.75 0 0 1 .75-.75h2a.75.75 0 0 1 0 1.5H2a.75.75 0 0 1-.75-.75m0 4a.75.75 0 0 1 .75-.75h2a.75.75 0 0 1 0 1.5H2a.75.75 0 0 1-.75-.75" clip-rule="evenodd" /><path fill="currentColor" d="M10.75 6.5a.75.75 0 0 1 .75-.75h5a.75.75 0 0 1 0 1.5h-5a.75.75 0 0 1-.75-.75m0 3.5a.75.75 0 0 1 .75-.75h5a.75.75 0 0 1 0 1.5h-5a.75.75 0 0 1-.75-.75" />',
  },
  'solar:palette-bold-duotone': {
    body: '<path fill="currentColor" d="M7.75 19a.75.75 0 0 1-.75.75H5a.75.75 0 0 1 0-1.5h2a.75.75 0 0 1 .75.75" /><path fill="currentColor" d="M10 18V6c0-1.4 0-2.1-.272-2.635a2.5 2.5 0 0 0-1.093-1.093C8.1 2 7.4 2 6 2s-2.1 0-2.635.272a2.5 2.5 0 0 0-1.093 1.093C2 3.9 2 4.6 2 6v12c0 1.4 0 2.1.272 2.635a2.5 2.5 0 0 0 1.093 1.092C3.9 22 4.6 22 6 22s2.1 0 2.635-.273a2.5 2.5 0 0 0 1.093-1.092C10 20.1 10 19.4 10 18" opacity="0.4" /><path fill="currentColor" d="M10 8.243V18c0 .919 0 1.536-.077 2.003l3.299-3.299l5.838-6.09c.973-1.003 1.46-1.505 1.636-2.08a2.5 2.5 0 0 0-.011-1.503C20.5 6.458 20 5.958 19 4.959c-.9-.886-1.352-1.33-1.88-1.514a2.5 2.5 0 0 0-1.353-.085c-.547.118-1.049.502-2.053 1.27L13 5.243zm-1.997 13.68H8v.003z" opacity="0.7" /><path fill="currentColor" d="M15.814 14H17.9c1.4 0 2.1 0 2.635.273a2.5 2.5 0 0 1 1.093 1.092C21.9 15.9 21.9 16.6 21.9 18s0 2.1-.272 2.635a2.5 2.5 0 0 1-1.093 1.092C20 22 19.3 22 17.9 22H6c.917 0 1.534 0 2-.077v.003l.003-.003c.245-.04.448-.102.632-.195a2.5 2.5 0 0 0 1.093-1.093c.093-.184.155-.387.195-.632l3.299-3.299z" />',
  },
  'solar:atom-bold-duotone': {
    body: '<path fill="currentColor" d="M16.471 16.471c4.939-4.939 6.94-10.944 4.471-13.413c-2.469-2.47-8.474-.468-13.413 4.47c-4.939 4.94-6.94 10.945-4.471 13.414c2.47 2.47 8.475.468 13.413-4.47" opacity=".3"/><path fill="currentColor" d="M7.529 16.471C2.59 11.533.589 5.527 3.058 3.058c2.469-2.47 8.474-.468 13.413 4.47c4.939 4.94 6.94 10.945 4.471 13.414c-2.47 2.47-8.475.468-13.413-4.47" opacity=".3"/><path fill="currentColor" d="M14.5 12a2.5 2.5 0 1 1-5 0a2.5 2.5 0 0 1 5 0"/>',
  },
  'solar:users-group-rounded-bold-duotone': {
    body: '<circle cx="15" cy="6" r="3" fill="currentColor" opacity="0.4" /><ellipse cx="16" cy="17" fill="currentColor" opacity="0.4" rx="5" ry="3" /><circle cx="9.001" cy="6" r="4" fill="currentColor" /><ellipse cx="9.001" cy="17.001" fill="currentColor" rx="7" ry="4" />',
  },
  /**
   * @set Eva icons
   */
  'eva:attach-2-fill': {
    body: '<path fill="currentColor" d="M12 22a5.86 5.86 0 0 1-6-5.7V6.13A4.24 4.24 0 0 1 10.33 2a4.24 4.24 0 0 1 4.34 4.13v10.18a2.67 2.67 0 0 1-5.33 0V6.92a1 1 0 0 1 1-1a1 1 0 0 1 1 1v9.39a.67.67 0 0 0 1.33 0V6.13A2.25 2.25 0 0 0 10.33 4A2.25 2.25 0 0 0 8 6.13V16.3a3.86 3.86 0 0 0 4 3.7a3.86 3.86 0 0 0 4-3.7V6.13a1 1 0 1 1 2 0V16.3a5.86 5.86 0 0 1-6 5.7"/>',
  },
  'eva:link-2-fill': {
    body: '<path fill="currentColor" d="m13.29 9.29l-4 4a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l4-4a1 1 0 0 0-1.42-1.42"/><path fill="currentColor" d="M12.28 17.4L11 18.67a4.2 4.2 0 0 1-5.58.4a4 4 0 0 1-.27-5.93l1.42-1.43a1 1 0 0 0 0-1.42a1 1 0 0 0-1.42 0l-1.27 1.28a6.15 6.15 0 0 0-.67 8.07a6.06 6.06 0 0 0 9.07.6l1.42-1.42a1 1 0 0 0-1.42-1.42m7.38-14.18a6.18 6.18 0 0 0-8.13.68L10.45 5a1.09 1.09 0 0 0-.17 1.61a1 1 0 0 0 1.42 0L13 5.3a4.17 4.17 0 0 1 5.57-.4a4 4 0 0 1 .27 5.95l-1.42 1.43a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l1.42-1.42a6.06 6.06 0 0 0-.6-9.06"/>',
  },
  'eva:star-fill': {
    body: '<path fill="currentColor" d="M17.56 21a1 1 0 0 1-.46-.11L12 18.22l-5.1 2.67a1 1 0 0 1-1.45-1.06l1-5.63l-4.12-4a1 1 0 0 1-.25-1a1 1 0 0 1 .81-.68l5.7-.83l2.51-5.13a1 1 0 0 1 1.8 0l2.54 5.12l5.7.83a1 1 0 0 1 .81.68a1 1 0 0 1-.25 1l-4.12 4l1 5.63a1 1 0 0 1-.4 1a1 1 0 0 1-.62.18"/>',
  },
  'eva:star-outline': {
    body: '<path fill="currentColor" d="M17.56 21a1 1 0 0 1-.46-.11L12 18.22l-5.1 2.67a1 1 0 0 1-1.45-1.06l1-5.63l-4.12-4a1 1 0 0 1-.25-1a1 1 0 0 1 .81-.68l5.7-.83l2.51-5.13a1 1 0 0 1 1.8 0l2.54 5.12l5.7.83a1 1 0 0 1 .81.68a1 1 0 0 1-.25 1l-4.12 4l1 5.63a1 1 0 0 1-.4 1a1 1 0 0 1-.62.18M12 16.1a.9.9 0 0 1 .46.11l3.77 2l-.72-4.21a1 1 0 0 1 .29-.89l3-2.93l-4.2-.62a1 1 0 0 1-.71-.56L12 5.25L10.11 9a1 1 0 0 1-.75.54l-4.2.62l3 2.93a1 1 0 0 1 .29.89l-.72 4.16l3.77-2a.9.9 0 0 1 .5-.04"/>',
  },
  'eva:expand-fill': {
    body: '<path fill="currentColor" d="M20 5a1 1 0 0 0-1-1h-5a1 1 0 0 0 0 2h2.57l-3.28 3.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0L18 7.42V10a1 1 0 0 0 1 1a1 1 0 0 0 1-1Zm-9.29 8.29a1 1 0 0 0-1.42 0L6 16.57V14a1 1 0 0 0-1-1a1 1 0 0 0-1 1v5a1 1 0 0 0 1 1h5a1 1 0 0 0 0-2H7.42l3.29-3.29a1 1 0 0 0 0-1.42"/>',
  },
  'eva:collapse-fill': {
    body: '<path fill="currentColor" d="M19 9h-2.58l3.29-3.29a1 1 0 1 0-1.42-1.42L15 7.57V5a1 1 0 0 0-1-1a1 1 0 0 0-1 1v5a1 1 0 0 0 1 1h5a1 1 0 0 0 0-2m-9 4H5a1 1 0 0 0 0 2h2.57l-3.28 3.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0L9 16.42V19a1 1 0 0 0 1 1a1 1 0 0 0 1-1v-5a1 1 0 0 0-1-1"/>',
  },
  'eva:more-vertical-fill': {
    body: '<circle cx="12" cy="12" r="2" fill="currentColor"/><circle cx="12" cy="5" r="2" fill="currentColor"/><circle cx="12" cy="19" r="2" fill="currentColor"/>',
  },
  'eva:more-horizontal-fill': {
    body: '<circle cx="12" cy="12" r="2" fill="currentColor"/><circle cx="19" cy="12" r="2" fill="currentColor"/><circle cx="5" cy="12" r="2" fill="currentColor"/>',
  },
  'eva:award-fill': {
    body: '<path fill="currentColor" d="m19 20.75l-2.31-9A5.94 5.94 0 0 0 18 8A6 6 0 0 0 6 8a5.94 5.94 0 0 0 1.34 3.77L5 20.75a1 1 0 0 0 1.48 1.11l5.33-3.13l5.68 3.14A.9.9 0 0 0 18 22a1 1 0 0 0 1-1.25M12 4a4 4 0 1 1-4 4a4 4 0 0 1 4-4"/>',
  },
  'eva:search-fill': {
    body: '<path fill="currentColor" d="m20.71 19.29l-3.4-3.39A7.92 7.92 0 0 0 19 11a8 8 0 1 0-8 8a7.92 7.92 0 0 0 4.9-1.69l3.39 3.4a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.42M5 11a6 6 0 1 1 6 6a6 6 0 0 1-6-6"/>',
  },
  'eva:info-outline': {
    body: '<path fill="currentColor" d="M12 2a10 10 0 1 0 10 10A10 10 0 0 0 12 2m0 18a8 8 0 1 1 8-8a8 8 0 0 1-8 8"/><circle cx="12" cy="8" r="1" fill="currentColor"/><path fill="currentColor" d="M12 10a1 1 0 0 0-1 1v5a1 1 0 0 0 2 0v-5a1 1 0 0 0-1-1"/>',
  },
  'eva:activity-fill': {
    body: '<path fill="currentColor" d="M14.33 20h-.21a2 2 0 0 1-1.76-1.58L9.68 6l-2.76 6.4A1 1 0 0 1 6 13H3a1 1 0 0 1 0-2h2.34l2.51-5.79a2 2 0 0 1 3.79.38L14.32 18l2.76-6.38A1 1 0 0 1 18 11h3a1 1 0 0 1 0 2h-2.34l-2.51 5.79A2 2 0 0 1 14.33 20"/>',
  },
  'eva:done-all-fill': {
    body: '<path fill="currentColor" d="M16.62 6.21a1 1 0 0 0-1.41.17l-7 9l-3.43-4.18a1 1 0 1 0-1.56 1.25l4.17 5.18a1 1 0 0 0 .78.37a1 1 0 0 0 .83-.38l7.83-10a1 1 0 0 0-.21-1.41m5 0a1 1 0 0 0-1.41.17l-7 9l-.61-.75l-1.26 1.62l1.1 1.37a1 1 0 0 0 .78.37a1 1 0 0 0 .78-.38l7.83-10a1 1 0 0 0-.21-1.4"/><path fill="currentColor" d="M8.71 13.06L10 11.44l-.2-.24a1 1 0 0 0-1.43-.2a1 1 0 0 0-.15 1.41Z"/>',
  },
  'eva:checkmark-fill': {
    body: '<path fill="currentColor" d="M9.86 18a1 1 0 0 1-.73-.32l-4.86-5.17a1 1 0 1 1 1.46-1.37l4.12 4.39l8.41-9.2a1 1 0 1 1 1.48 1.34l-9.14 10a1 1 0 0 1-.73.33Z"/>',
  },
  'eva:smiling-face-fill': {
    body: '<path fill="currentColor" d="M12 2c5.523 0 10 4.477 10 10s-4.477 10-10 10S2 17.523 2 12S6.477 2 12 2m0 2a8 8 0 1 0 0 16a8 8 0 0 0 0-16m5 9a5 5 0 0 1-10 0Z"/>',
  },
  'eva:external-link-fill': {
    body: '<path fill="currentColor" d="M20 11a1 1 0 0 0-1 1v6a1 1 0 0 1-1 1H6a1 1 0 0 1-1-1V6a1 1 0 0 1 1-1h6a1 1 0 0 0 0-2H6a3 3 0 0 0-3 3v12a3 3 0 0 0 3 3h12a3 3 0 0 0 3-3v-6a1 1 0 0 0-1-1"/><path fill="currentColor" d="M16 5h1.58l-6.29 6.28a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0L19 6.42V8a1 1 0 0 0 1 1a1 1 0 0 0 1-1V4a1 1 0 0 0-1-1h-4a1 1 0 0 0 0 2"/>',
  },
  'eva:trending-down-fill': {
    body: '<path fill="currentColor" d="M21 12a1 1 0 0 0-2 0v2.3l-4.24-5a1 1 0 0 0-1.27-.21L9.22 11.7L4.77 6.36a1 1 0 1 0-1.54 1.28l5 6a1 1 0 0 0 1.28.22l4.28-2.57l4 4.71H15a1 1 0 0 0 0 2h5a1.1 1.1 0 0 0 .36-.07l.14-.08a1 1 0 0 0 .15-.09a.8.8 0 0 0 .14-.17a1 1 0 0 0 .09-.14a.6.6 0 0 0 .05-.17A.8.8 0 0 0 21 17Z"/>',
  },
  'eva:trending-up-fill': {
    body: '<path fill="currentColor" d="M21 7a.8.8 0 0 0 0-.21a.6.6 0 0 0-.05-.17a1 1 0 0 0-.09-.14a.8.8 0 0 0-.14-.17l-.12-.07a.7.7 0 0 0-.19-.1h-.2A.7.7 0 0 0 20 6h-5a1 1 0 0 0 0 2h2.83l-4 4.71l-4.32-2.57a1 1 0 0 0-1.28.22l-5 6a1 1 0 0 0 .13 1.41A1 1 0 0 0 4 18a1 1 0 0 0 .77-.36l4.45-5.34l4.27 2.56a1 1 0 0 0 1.27-.21L19 9.7V12a1 1 0 0 0 2 0z"/>',
  },
  'eva:chevron-down-fill': {
    body: '<path fill="currentColor" d="M12 15.5a1 1 0 0 1-.71-.29l-4-4a1 1 0 1 1 1.42-1.42L12 13.1l3.3-3.18a1 1 0 1 1 1.38 1.44l-4 3.86a1 1 0 0 1-.68.28"/>',
  },
  'eva:arrowhead-left-fill': {
    body: '<path fill="currentColor" d="M11.64 5.23a1 1 0 0 0-1.41.13l-5 6a1 1 0 0 0 0 1.27l4.83 6a1 1 0 0 0 .78.37a1 1 0 0 0 .78-1.63L7.29 12l4.48-5.37a1 1 0 0 0-.13-1.4"/><path fill="currentColor" d="m14.29 12l4.48-5.37a1 1 0 0 0-1.54-1.28l-5 6a1 1 0 0 0 0 1.27l4.83 6a1 1 0 0 0 .78.37a1 1 0 0 0 .78-1.63Z"/>',
  },
  'eva:arrowhead-right-fill': {
    body: '<path fill="currentColor" d="m18.78 11.37l-4.78-6a1 1 0 0 0-1.41-.15a1 1 0 0 0-.15 1.41L16.71 12l-4.48 5.37a1 1 0 0 0 .13 1.41A1 1 0 0 0 13 19a1 1 0 0 0 .77-.36l5-6a1 1 0 0 0 .01-1.27"/><path fill="currentColor" d="M7 5.37a1 1 0 0 0-1.61 1.26L9.71 12l-4.48 5.36a1 1 0 0 0 .13 1.41A1 1 0 0 0 6 19a1 1 0 0 0 .77-.36l5-6a1 1 0 0 0 0-1.27Z"/>',
  },
  'eva:arrow-upward-fill': {
    body: '<path fill="currentColor" d="M5.23 10.64a1 1 0 0 0 1.41.13L11 7.14V19a1 1 0 0 0 2 0V7.14l4.36 3.63a1 1 0 1 0 1.28-1.54l-6-5l-.15-.09l-.13-.07a1 1 0 0 0-.72 0l-.13.07l-.15.09l-6 5a1 1 0 0 0-.13 1.41"/>',
  },
  'eva:arrow-downward-fill': {
    body: '<path fill="currentColor" d="M18.77 13.36a1 1 0 0 0-1.41-.13L13 16.86V5a1 1 0 0 0-2 0v11.86l-4.36-3.63a1 1 0 1 0-1.28 1.54l6 5l.15.09l.13.07a1 1 0 0 0 .72 0l.13-.07l.15-.09l6-5a1 1 0 0 0 .13-1.41"/>',
  },
  'eva:arrow-forward-fill': {
    body: '<path fill="currentColor" d="M5 13h11.86l-3.63 4.36a1 1 0 0 0 1.54 1.28l5-6a1 1 0 0 0 .09-.15c0-.05.05-.08.07-.13A1 1 0 0 0 20 12a1 1 0 0 0-.07-.36c0-.05-.05-.08-.07-.13a1 1 0 0 0-.09-.15l-5-6A1 1 0 0 0 14 5a1 1 0 0 0-.64.23a1 1 0 0 0-.13 1.41L16.86 11H5a1 1 0 0 0 0 2"/>',
  },
  'eva:arrow-ios-back-fill': {
    body: '<path fill="currentColor" d="M13.83 19a1 1 0 0 1-.78-.37l-4.83-6a1 1 0 0 1 0-1.27l5-6a1 1 0 0 1 1.54 1.28L10.29 12l4.32 5.36a1 1 0 0 1-.78 1.64"/>',
  },
  'eva:arrow-ios-forward-fill': {
    body: '<path fill="currentColor" d="M10 19a1 1 0 0 1-.64-.23a1 1 0 0 1-.13-1.41L13.71 12L9.39 6.63a1 1 0 0 1 .15-1.41a1 1 0 0 1 1.46.15l4.83 6a1 1 0 0 1 0 1.27l-5 6A1 1 0 0 1 10 19"/>',
  },
  'eva:arrow-ios-downward-fill': {
    body: '<path fill="currentColor" d="M12 16a1 1 0 0 1-.64-.23l-6-5a1 1 0 1 1 1.28-1.54L12 13.71l5.36-4.32a1 1 0 0 1 1.41.15a1 1 0 0 1-.14 1.46l-6 4.83A1 1 0 0 1 12 16"/>',
  },
  'eva:arrow-ios-upward-fill': {
    body: '<path fill="currentColor" d="M18 15a1 1 0 0 1-.64-.23L12 10.29l-5.37 4.32a1 1 0 0 1-1.41-.15a1 1 0 0 1 .15-1.41l6-4.83a1 1 0 0 1 1.27 0l6 5a1 1 0 0 1 .13 1.41A1 1 0 0 1 18 15"/>',
  },
  'eva:diagonal-arrow-right-up-fill': {
    body: '<path fill="currentColor" d="M18 7.05a1 1 0 0 0-1-1L9 6a1 1 0 0 0 0 2h5.56l-8.27 8.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0L16 9.42V15a1 1 0 0 0 1 1a1 1 0 0 0 1-1Z"/>',
  },
  'eva:diagonal-arrow-left-down-fill': {
    body: '<path fill="currentColor" d="M17.71 6.29a1 1 0 0 0-1.42 0L8 14.59V9a1 1 0 0 0-2 0v8a1 1 0 0 0 1 1h8a1 1 0 0 0 0-2H9.41l8.3-8.29a1 1 0 0 0 0-1.42"/>',
  },
  'eva:radio-button-off-fill': {
    body: '<path fill="currentColor" d="M12 22a10 10 0 1 1 10-10a10 10 0 0 1-10 10m0-18a8 8 0 1 0 8 8a8 8 0 0 0-8-8"/>',
  },
  'eva:checkmark-circle-2-outline': {
    body: '<path fill="currentColor" d="M12 2a10 10 0 1 0 10 10A10 10 0 0 0 12 2m0 18a8 8 0 1 1 8-8a8 8 0 0 1-8 8"/><path fill="currentColor" d="m14.7 8.39l-3.78 5l-1.63-2.11a1 1 0 0 0-1.58 1.23l2.43 3.11a1 1 0 0 0 .79.38a1 1 0 0 0 .79-.39l4.57-6a1 1 0 1 0-1.6-1.22Z"/>',
  },
  'eva:minus-circle-fill': {
    body: '<path fill="currentColor" d="M12 2a10 10 0 1 0 10 10A10 10 0 0 0 12 2m3 11H9a1 1 0 0 1 0-2h6a1 1 0 0 1 0 2"/>',
  },
  'eva:cloud-upload-fill': {
    body: '<path fill="currentColor" d="M21.9 12.0005C21.9 11.8905 21.84 11.7805 21.81 11.6705C21.7643 11.4762 21.7041 11.2857 21.63 11.1005C21.58 10.9805 21.51 10.8605 21.45 10.7305C21.39 10.6005 21.3 10.4305 21.21 10.2905C21.12 10.1505 21 10.0805 21 10.0005C21 9.92047 20.8 9.75047 20.69 9.63047C20.58 9.51047 20.48 9.43047 20.37 9.33047L20 9.00047L19.64 8.76047C19.4982 8.67477 19.3513 8.59795 19.2 8.53047L18.81 8.35047C18.6468 8.28964 18.4798 8.23953 18.31 8.20047C18.1756 8.16093 18.0386 8.13086 17.9 8.11047L17.67 8.00047C17.262 6.82152 16.4966 5.79909 15.4803 5.07543C14.4641 4.35177 13.2476 3.96289 12 3.96289C10.7524 3.96289 9.5359 4.35177 8.51966 5.07543C7.50343 5.79909 6.73804 6.82152 6.33 8.00047L6.15 8.05047C6.0114 8.07086 5.8744 8.10093 5.74 8.14047C5.57024 8.17953 5.40322 8.22964 5.24 8.29047L4.85 8.47047C4.69871 8.53795 4.55176 8.61476 4.41 8.70047L4.05 9.00047L3.68 9.31047C3.57 9.41047 3.46 9.50047 3.36 9.61047C3.26 9.72047 3.15 9.86047 3.05 9.98047C2.95 10.1005 2.87 10.2105 2.79 10.3405C2.71 10.4705 2.63 10.6305 2.55 10.7805C2.47 10.9305 2.42 11.0305 2.37 11.1505C2.29587 11.3357 2.2357 11.5262 2.19 11.7205C2.19 11.8305 2.12 11.9405 2.1 12.0505C2.03642 12.3632 2.00294 12.6813 2 13.0005C2.00469 13.3058 2.03479 13.6102 2.09 13.9105C2.09 14.0105 2.14 14.1005 2.16 14.2005C2.21017 14.3967 2.27025 14.5903 2.34 14.7805L2.46 15.0705C2.54803 15.2633 2.64823 15.4503 2.76 15.6305L2.9 15.8505C2.9154 15.8779 2.93208 15.9046 2.95 15.9305L3 16.0005C3.46574 16.6214 4.06966 17.1255 4.76393 17.4726C5.45821 17.8197 6.22377 18.0005 7 18.0005H10V16.6305C9.69616 16.8067 9.35126 16.8998 9 16.9005C8.45825 16.8954 7.94054 16.6761 7.56 16.2905C7.37729 16.1015 7.23364 15.8783 7.13726 15.6337C7.04087 15.3891 6.99365 15.1279 6.9983 14.8651C7.00294 14.6023 7.05936 14.3429 7.16432 14.1019C7.26928 13.8609 7.42073 13.6429 7.61 13.4605L10.61 10.5605C10.9832 10.2007 11.4816 9.99994 12 10.0005C12.5296 10.0027 13.0366 10.2149 13.41 10.5905L16.41 13.5905C16.7825 13.9652 16.9916 14.4721 16.9916 15.0005C16.9916 15.5288 16.7825 16.0357 16.41 16.4105C16.0366 16.7861 15.5296 16.9982 15 17.0005C14.6481 17.0048 14.3019 16.9113 14 16.7305V18.0005H17C17.7762 18.0005 18.5418 17.8197 19.2361 17.4726C19.9303 17.1255 20.5343 16.6214 21 16.0005L21.05 15.9505C21.0679 15.9246 21.0846 15.8979 21.1 15.8705L21.24 15.6505C21.3518 15.4704 21.452 15.2833 21.54 15.0905L21.66 14.8005C21.7298 14.6103 21.7898 14.4167 21.84 14.2205C21.84 14.1205 21.89 14.0305 21.91 13.9305C21.9663 13.6236 21.9964 13.3125 22 13.0005C22.0003 12.6646 21.9668 12.3296 21.9 12.0005Z" /> <path fill="currentColor" d="M12.71 11.2898C12.5231 11.1065 12.2718 11.0039 12.01 11.0039C11.7483 11.0039 11.4969 11.1065 11.31 11.2898L8.31002 14.1898C8.20391 14.2773 8.117 14.3858 8.05474 14.5085C7.99248 14.6312 7.9562 14.7654 7.94818 14.9027C7.94015 15.0401 7.96054 15.1776 8.00809 15.3067C8.05563 15.4358 8.1293 15.5537 8.22448 15.653C8.31967 15.7523 8.43433 15.8309 8.56128 15.8839C8.68824 15.9369 8.82476 15.9631 8.96231 15.961C9.09987 15.9588 9.23549 15.9282 9.3607 15.8712C9.48592 15.8143 9.59802 15.7321 9.69002 15.6298L11 14.3598V19.9998C11 20.265 11.1054 20.5193 11.2929 20.7069C11.4804 20.8944 11.7348 20.9998 12 20.9998C12.2652 20.9998 12.5196 20.8944 12.7071 20.7069C12.8947 20.5193 13 20.265 13 19.9998V14.4098L14.29 15.7098C14.383 15.8035 14.4936 15.8779 14.6154 15.9287C14.7373 15.9794 14.868 16.0056 15 16.0056C15.132 16.0056 15.2627 15.9794 15.3846 15.9287C15.5065 15.8779 15.6171 15.8035 15.71 15.7098C15.8037 15.6168 15.8781 15.5062 15.9289 15.3843C15.9797 15.2625 16.0058 15.1318 16.0058 14.9998C16.0058 14.8678 15.9797 14.737 15.9289 14.6152C15.8781 14.4933 15.8037 14.3827 15.71 14.2898L12.71 11.2898Z" />',
  },
  'eva:cloud-download-fill': {
    body: '<path fill="currentColor" d="M21.9 10.9996C21.9 10.8896 21.84 10.7796 21.81 10.6696C21.7643 10.4754 21.7041 10.2849 21.63 10.0996C21.58 9.97963 21.51 9.85963 21.45 9.72963C21.39 9.59963 21.3 9.42963 21.21 9.28963C21.12 9.14963 21 9.07963 21 8.99963C21 8.91963 20.8 8.74963 20.69 8.62963C20.58 8.50963 20.48 8.42963 20.37 8.32963L20 7.99963L19.64 7.75963C19.4982 7.67393 19.3513 7.59711 19.2 7.52963L18.81 7.34963C18.6468 7.28879 18.4798 7.23869 18.31 7.19963C18.1756 7.16009 18.0386 7.13002 17.9 7.10963H17.72C17.3348 5.90889 16.5811 4.86003 15.5659 4.11201C14.5507 3.36399 13.3257 2.95484 12.0647 2.94266C10.8038 2.93049 9.57103 3.3159 8.54158 4.04417C7.51213 4.77245 6.73831 5.80655 6.33 6.99963H6.15C6.0114 7.02002 5.8744 7.05009 5.74 7.08963C5.57024 7.12869 5.40322 7.17879 5.24 7.23963L4.85 7.41963C4.69871 7.48711 4.55176 7.56392 4.41 7.64963L4.05 7.99963L3.68 8.30963C3.57 8.40963 3.46 8.49963 3.36 8.60963C3.26 8.71963 3.15 8.85963 3.05 8.97963C2.95 9.09963 2.87 9.20963 2.79 9.33963C2.71 9.46963 2.63 9.62963 2.55 9.77963C2.47 9.92963 2.42 10.0296 2.37 10.1496C2.29587 10.3349 2.2357 10.5254 2.19 10.7196C2.19 10.8296 2.12 10.9396 2.1 11.0496C2.03642 11.3624 2.00294 11.6805 2 11.9996C2.00469 12.3049 2.03479 12.6093 2.09 12.9096C2.09 13.0096 2.14 13.0996 2.16 13.1996C2.21017 13.3959 2.27025 13.5895 2.34 13.7796L2.46 14.0696C2.54803 14.2625 2.64823 14.4495 2.76 14.6296L2.9 14.8496C2.9154 14.8771 2.93208 14.9038 2.95 14.9296L3 14.9996C3.46574 15.6206 4.06966 16.1246 4.76393 16.4718C5.45821 16.8189 6.22377 16.9996 7 16.9996C7.00223 16.4701 7.21441 15.963 7.59 15.5896C7.96335 15.214 8.47042 15.0019 9 14.9996C9.35191 14.9953 9.69811 15.0888 10 15.2696V11.9996C10 11.4692 10.2107 10.9605 10.5858 10.5854C10.9609 10.2103 11.4696 9.99963 12 9.99963C12.5304 9.99963 13.0391 10.2103 13.4142 10.5854C13.7893 10.9605 14 11.4692 14 11.9996V15.3696C14.3038 15.1934 14.6487 15.1003 15 15.0996C15.5417 15.1047 16.0595 15.324 16.44 15.7096C16.7767 16.0577 16.9757 16.516 17 16.9996C17.7762 16.9996 18.5418 16.8189 19.2361 16.4718C19.9303 16.1246 20.5343 15.6206 21 14.9996L21.05 14.9496C21.0679 14.9238 21.0846 14.8971 21.1 14.8696L21.24 14.6496C21.3518 14.4695 21.452 14.2825 21.54 14.0896L21.66 13.7996C21.7298 13.6095 21.7898 13.4159 21.84 13.2196C21.84 13.1196 21.89 13.0296 21.91 12.9296C21.9663 12.6227 21.9964 12.3116 22 11.9996C22.0003 11.6638 21.9668 11.3288 21.9 10.9996Z" /> <path fill="currentColor" d="M14.31 16.3796L13 17.6396V11.9996C13 11.7344 12.8946 11.4801 12.7071 11.2925C12.5196 11.105 12.2652 10.9996 12 10.9996C11.7348 10.9996 11.4804 11.105 11.2929 11.2925C11.1054 11.4801 11 11.7344 11 11.9996V17.5896L9.71 16.2896C9.61676 16.1964 9.50607 16.1224 9.38425 16.072C9.26243 16.0215 9.13186 15.9955 9 15.9955C8.86814 15.9955 8.73757 16.0215 8.61575 16.072C8.49393 16.1224 8.38324 16.1964 8.29 16.2896C8.19676 16.3829 8.1228 16.4936 8.07234 16.6154C8.02188 16.7372 7.99591 16.8678 7.99591 16.9996C7.99591 17.1315 8.02188 17.2621 8.07234 17.3839C8.1228 17.5057 8.19676 17.6164 8.29 17.7096L11.29 20.7096C11.3834 20.8023 11.4943 20.8756 11.6161 20.9254C11.7379 20.9752 11.8684 21.0004 12 20.9996C12.2575 20.9986 12.5046 20.8983 12.69 20.7196L15.69 17.8196C15.7961 17.7321 15.883 17.6236 15.9453 17.5009C16.0075 17.3782 16.0438 17.244 16.0518 17.1067C16.0599 16.9693 16.0395 16.8318 15.9919 16.7027C15.9444 16.5736 15.8707 16.4557 15.7755 16.3564C15.6803 16.2571 15.5657 16.1785 15.4387 16.1255C15.3118 16.0725 15.1753 16.0463 15.0377 16.0484C14.9002 16.0506 14.7645 16.0812 14.6393 16.1381C14.5141 16.1951 14.402 16.2773 14.31 16.3796Z" />',
  },
  /**
   * @set Ic icons
   */
  'ic:round-sentiment-neutral': {
    body: '<path fill="currentColor" d="M9.75 15.5h4.5c.41 0 .75-.34.75-.75s-.34-.75-.75-.75h-4.5c-.41 0-.75.34-.75.75s.34.75.75.75"/><circle cx="15.5" cy="9.5" r="1.5" fill="currentColor"/><circle cx="8.5" cy="9.5" r="1.5" fill="currentColor"/><path fill="currentColor" d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2M12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8s8 3.58 8 8s-3.58 8-8 8"/>',
  },
  'ic:round-sentiment-satisfied': {
    body: '<circle cx="15.5" cy="9.5" r="1.5" fill="currentColor"/><circle cx="8.5" cy="9.5" r="1.5" fill="currentColor"/><path fill="currentColor" d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2M12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8s8 3.58 8 8s-3.58 8-8 8m4.41-6.11a.745.745 0 0 0-1.03.24C14.64 15.3 13.38 16 12 16s-2.64-.7-3.38-1.88a.747.747 0 1 0-1.27.79C8.37 16.54 10.1 17.5 12 17.5s3.63-.97 4.65-2.58c.22-.35.11-.81-.24-1.03"/>',
  },
  'ic:round-sentiment-dissatisfied': {
    body: '<circle cx="15.5" cy="9.5" r="1.5" fill="currentColor"/><circle cx="8.5" cy="9.5" r="1.5" fill="currentColor"/><path fill="currentColor" d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2M12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8s8 3.58 8 8s-3.58 8-8 8m0-6c-1.9 0-3.63.97-4.65 2.58a.747.747 0 1 0 1.27.79c.74-1.18 2-1.88 3.38-1.88s2.64.7 3.38 1.88c.14.23.39.35.64.35c.14 0 .27-.04.4-.11c.35-.22.46-.68.24-1.03C15.63 14.96 13.9 14 12 14"/>',
  },
  'ic:round-sentiment-very-satisfied': {
    body: '<path fill="currentColor" d="m8.88 9.94l.53.53c.29.29.77.29 1.06 0s.29-.77 0-1.06l-.88-.88a.996.996 0 0 0-1.41 0l-.89.88c-.29.29-.29.77 0 1.06s.77.29 1.06 0zM12 17.5c2.03 0 3.8-1.11 4.75-2.75a.503.503 0 0 0-.44-.75H7.69c-.38 0-.63.42-.44.75A5.49 5.49 0 0 0 12 17.5m1.53-7.03c.29.29.77.29 1.06 0l.53-.53l.53.53c.29.29.77.29 1.06 0s.29-.77 0-1.06l-.88-.88a.996.996 0 0 0-1.41 0l-.88.88c-.3.29-.3.77-.01 1.06M11.99 2C6.47 2 2 6.47 2 12s4.47 10 9.99 10S22 17.53 22 12S17.52 2 11.99 2M12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8s8 3.58 8 8s-3.58 8-8 8"/>',
  },
  'ic:round-sentiment-very-dissatisfied': {
    body: '<path fill="currentColor" d="M12 13.5c-2.03 0-3.8 1.11-4.75 2.75c-.19.33.06.75.44.75h8.62c.38 0 .63-.42.44-.75A5.49 5.49 0 0 0 12 13.5m-3.65-2.03l.53-.53l.53.53c.29.29.77.29 1.06 0s.29-.77 0-1.06l-.53-.53l.53-.53c.29-.29.29-.77 0-1.06a.754.754 0 0 0-1.06 0l-.53.53l-.53-.53a.754.754 0 0 0-1.06 0c-.29.29-.29.77 0 1.06l.53.53l-.53.53c-.29.29-.29.77 0 1.06s.77.29 1.06 0M11.99 2C6.47 2 2 6.47 2 12s4.47 10 9.99 10S22 17.53 22 12S17.52 2 11.99 2M12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8s8 3.58 8 8s-3.58 8-8 8m3.65-11.71l-.53.53l-.53-.53a.754.754 0 0 0-1.06 0c-.29.29-.29.77 0 1.06l.53.53l-.53.53c-.29.29-.29.77 0 1.06s.77.29 1.06 0l.53-.53l.53.53c.29.29.77.29 1.06 0s.29-.77 0-1.06l-.53-.53l.53-.53c.29-.29.29-.77 0-1.06a.754.754 0 0 0-1.06 0"/>',
  },
  'ic:round-format-align-left': {
    body: '<path fill="currentColor" d="M14 15H4c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1m0-8H4c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1M4 13h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1m0 8h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1M3 4c0 .55.45 1 1 1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1"/>',
  },
  'ic:round-format-align-center': {
    body: '<path fill="currentColor" d="M7 16c0 .55.45 1 1 1h8c.55 0 1-.45 1-1s-.45-1-1-1H8c-.55 0-1 .45-1 1m-3 5h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1m0-8h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1m3-5c0 .55.45 1 1 1h8c.55 0 1-.45 1-1s-.45-1-1-1H8c-.55 0-1 .45-1 1M3 4c0 .55.45 1 1 1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1"/>',
  },
  'ic:round-format-align-right': {
    body: '<path fill="currentColor" d="M4 21h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1m6-4h10c.55 0 1-.45 1-1s-.45-1-1-1H10c-.55 0-1 .45-1 1s.45 1 1 1m-6-4h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1m6-4h10c.55 0 1-.45 1-1s-.45-1-1-1H10c-.55 0-1 .45-1 1s.45 1 1 1M3 4c0 .55.45 1 1 1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1"/>',
  },
  'ic:round-format-align-justify': {
    body: '<path fill="currentColor" d="M4 21h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1m0-4h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1m0-4h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1m0-4h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1M3 4c0 .55.45 1 1 1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1"/>',
  },
  'ic:round-view-list': {
    body: '<path fill="currentColor" d="M4 14h2c.55 0 1-.45 1-1v-2c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v2c0 .55.45 1 1 1m0 5h2c.55 0 1-.45 1-1v-2c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v2c0 .55.45 1 1 1M4 9h2c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v2c0 .55.45 1 1 1m5 5h11c.55 0 1-.45 1-1v-2c0-.55-.45-1-1-1H9c-.55 0-1 .45-1 1v2c0 .55.45 1 1 1m0 5h11c.55 0 1-.45 1-1v-2c0-.55-.45-1-1-1H9c-.55 0-1 .45-1 1v2c0 .55.45 1 1 1M8 6v2c0 .55.45 1 1 1h11c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1H9c-.55 0-1 .45-1 1"/>',
  },
  'ic:round-view-quilt': {
    body: '<path fill="currentColor" d="M21 6v4.5c0 .55-.45 1-1 1h-9.67c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1H20c.55 0 1 .45 1 1m-6.33 12v-4.5c0-.55-.45-1-1-1h-3.33c-.55 0-1 .45-1 1V18c0 .55.45 1 1 1h3.33c.55 0 1-.45 1-1m1-4.5V18c0 .55.45 1 1 1H20c.55 0 1-.45 1-1v-4.5c0-.55-.45-1-1-1h-3.33c-.56 0-1 .45-1 1M8.33 18V6c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h3.33c.56 0 1-.45 1-1"/>',
  },
  'ic:round-view-module': {
    body: '<path fill="currentColor" d="M14.67 6v4.5c0 .55-.45 1-1 1h-3.33c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h3.33c.55 0 1 .45 1 1m2 5.5H20c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1h-3.33c-.55 0-1 .45-1 1v4.5c0 .55.44 1 1 1m-2 6.5v-4.5c0-.55-.45-1-1-1h-3.33c-.55 0-1 .45-1 1V18c0 .55.45 1 1 1h3.33c.55 0 1-.45 1-1m1-4.5V18c0 .55.45 1 1 1H20c.55 0 1-.45 1-1v-4.5c0-.55-.45-1-1-1h-3.33c-.56 0-1 .45-1 1m-8.34-1H4c-.55 0-1 .45-1 1V18c0 .55.45 1 1 1h3.33c.55 0 1-.45 1-1v-4.5c0-.55-.44-1-1-1m1-2V6c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v4.5c0 .55.45 1 1 1h3.33c.56 0 1-.45 1-1"/>',
  },
  'ic:baseline-wifi': {
    body: '<path fill="currentColor" d="m1 9l2 2c4.97-4.97 13.03-4.97 18 0l2-2C16.93 2.93 7.08 2.93 1 9m8 8l3 3l3-3a4.237 4.237 0 0 0-6 0m-4-4l2 2a7.074 7.074 0 0 1 10 0l2-2C15.14 9.14 8.87 9.14 5 13"/>',
  },
  'ic:round-vpn-key': {
    body: '<path fill="currentColor" d="M12.65 10a6 6 0 0 0-6.88-3.88c-2.29.46-4.15 2.29-4.63 4.58A6.006 6.006 0 0 0 7 18a5.99 5.99 0 0 0 5.65-4H17v2c0 1.1.9 2 2 2s2-.9 2-2v-2c1.1 0 2-.9 2-2s-.9-2-2-2zM7 14c-1.1 0-2-.9-2-2s.9-2 2-2s2 .9 2 2s-.9 2-2 2"/>',
  },
  'ic:round-filter-list': {
    body: '<path fill="currentColor" d="M11 18h2c.55 0 1-.45 1-1s-.45-1-1-1h-2c-.55 0-1 .45-1 1s.45 1 1 1M3 7c0 .55.45 1 1 1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1m4 6h10c.55 0 1-.45 1-1s-.45-1-1-1H7c-.55 0-1 .45-1 1s.45 1 1 1"/>',
  },
  'ic:round-format-bold': {
    body: '<path fill="currentColor" d="M15.6 10.79c.97-.67 1.65-1.77 1.65-2.79c0-2.26-1.75-4-4-4H8c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h5.78c2.07 0 3.96-1.69 3.97-3.77c.01-1.53-.85-2.84-2.15-3.44M10 6.5h3c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5h-3zm3.5 9H10v-3h3.5c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5"/>',
  },
  'ic:round-beach-access': {
    body: '<path fill="currentColor" d="m13.13 14.56l1.43-1.43l5.73 5.73c.39.39.39 1.03 0 1.43c-.39.39-1.03.39-1.43 0zm4.29-5.73l1.27-1.27c.89-.89.77-2.43-.31-3.08a10.1 10.1 0 0 0-12.4 1.47c3.93-1.3 8.31-.25 11.44 2.88M5.95 5.98c-3.36 3.37-3.85 8.51-1.48 12.4c.66 1.08 2.19 1.21 3.08.31l1.27-1.27C5.7 14.29 4.65 9.91 5.95 5.98m.02-.02l-.01.01c-.38 3.01 1.17 6.88 4.3 10.02l5.73-5.73c-3.13-3.13-7.01-4.68-10.02-4.3"/>',
  },
  'ic:baseline-bluetooth': {
    body: '<path fill="currentColor" d="M17.71 7.71L12 2h-1v7.59L6.41 5L5 6.41L10.59 12L5 17.59L6.41 19L11 14.41V22h1l5.71-5.71l-4.3-4.29zM13 5.83l1.88 1.88L13 9.59zm1.88 10.46L13 18.17v-3.76z"/>',
  },
  'ic:round-format-italic': {
    body: '<path fill="currentColor" d="M10 5.5c0 .83.67 1.5 1.5 1.5h.71l-3.42 8H7.5c-.83 0-1.5.67-1.5 1.5S6.67 18 7.5 18h5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5h-.71l3.42-8h1.29c.83 0 1.5-.67 1.5-1.5S17.33 4 16.5 4h-5c-.83 0-1.5.67-1.5 1.5"/>',
  },
  'ic:round-format-underlined': {
    body: '<path fill="currentColor" d="M12.79 16.95c3.03-.39 5.21-3.11 5.21-6.16V4.25a1.25 1.25 0 0 0-2.5 0v6.65c0 1.67-1.13 3.19-2.77 3.52A3.494 3.494 0 0 1 8.5 11V4.25a1.25 1.25 0 0 0-2.5 0V11c0 3.57 3.13 6.42 6.79 5.95M5 20c0 .55.45 1 1 1h12c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1 .45-1 1"/>',
  },
  'ic:baseline-arrow-drop-down': {
    body: '<path fill="currentColor" d="m7 10l5 5l5-5z"/>',
  },
  'ic:baseline-format-color-fill': {
    body: '<path fill="currentColor" d="M16.56 8.94L7.62 0L6.21 1.41l2.38 2.38l-5.15 5.15a1.49 1.49 0 0 0 0 2.12l5.5 5.5c.29.29.68.44 1.06.44s.77-.15 1.06-.44l5.5-5.5c.59-.58.59-1.53 0-2.12M5.21 10L10 5.21L14.79 10zM19 11.5s-2 2.17-2 3.5c0 1.1.9 2 2 2s2-.9 2-2c0-1.33-2-3.5-2-3.5M2 20h20v4H2z"/>',
  },
  'ic:round-power-settings-new': {
    body: '<path fill="currentColor" d="M12 3c-.55 0-1 .45-1 1v8c0 .55.45 1 1 1s1-.45 1-1V4c0-.55-.45-1-1-1m5.14 2.86a.99.99 0 0 0-.01 1.39c1.13 1.2 1.83 2.8 1.87 4.57c.09 3.83-3.08 7.13-6.91 7.17A6.98 6.98 0 0 1 5 12c0-1.84.71-3.51 1.87-4.76c.37-.39.37-1-.01-1.38a.993.993 0 0 0-1.43.02A8.92 8.92 0 0 0 3 11.74c-.14 4.88 3.83 9.1 8.71 9.25c5.1.16 9.29-3.93 9.29-9c0-2.37-.92-4.51-2.42-6.11c-.38-.41-1.04-.42-1.44-.02"/>',
  },
  'ic:round-label-important': {
    body: '<path fill="currentColor" d="M4.58554 19.5H14.2996C14.9965 19.5 15.6505 19.1676 16.0472 18.5994L20.2824 12.6273C20.4132 12.4463 20.4836 12.2287 20.4836 12.0054C20.4836 11.7821 20.4132 11.5645 20.2824 11.3835L16.0365 5.40072C15.8424 5.12032 15.5826 4.89166 15.2799 4.73468C14.9771 4.5777 14.6406 4.49716 14.2996 4.50008H4.58554C3.71707 4.50008 3.21314 5.49721 3.71707 6.20486L7.86644 12.0054L3.71707 17.8059C3.21314 18.5136 3.71707 19.5 4.58554 19.5Z"/>',
  },
  /**
   * @set Mingcute icons
   */
  'mingcute:calendar-day-line': {
    body: '<g fill="none" fill-rule="evenodd"><path d="m12.594 23.258l-.012.002l-.071.035l-.02.004l-.014-.004l-.071-.036q-.016-.004-.024.006l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.016-.018m.264-.113l-.014.002l-.184.093l-.01.01l-.003.011l.018.43l.005.012l.008.008l.201.092q.019.005.029-.008l.004-.014l-.034-.614q-.005-.019-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.003-.011l.018-.43l-.003-.012l-.01-.01z" /><path fill="currentColor" d="M19 3a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2zm0 2H5v14h14zm-3 6a1 1 0 0 1 1 1v4a1 1 0 0 1-1 1H8a1 1 0 0 1-1-1v-4a1 1 0 0 1 1-1zm-1 2H9v2h6zm1-6a1 1 0 0 1 .117 1.993L16 9H8a1 1 0 0 1-.117-1.993L8 7z" /></g>',
  },
  'mingcute:calendar-week-line': {
    body: '<g fill="none"><path d="m12.594 23.258l-.012.002l-.071.035l-.02.004l-.014-.004l-.071-.036q-.016-.004-.024.006l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.016-.018m.264-.113l-.014.002l-.184.093l-.01.01l-.003.011l.018.43l.005.012l.008.008l.201.092q.019.005.029-.008l.004-.014l-.034-.614q-.005-.019-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.003-.011l.018-.43l-.003-.012l-.01-.01z" /><path fill="currentColor" d="M19 3a2 2 0 0 1 1.995 1.85L21 5v14a2 2 0 0 1-1.85 1.995L19 21H5a2 2 0 0 1-1.995-1.85L3 19V5a2 2 0 0 1 1.85-1.995L5 3zm0 2H5v14h14zM8 7a1 1 0 0 1 .993.883L9 8v8a1 1 0 0 1-1.993.117L7 16V8a1 1 0 0 1 1-1m4 0a1 1 0 0 1 1 1v8a1 1 0 1 1-2 0V8a1 1 0 0 1 1-1m4 0a1 1 0 0 1 .993.883L17 8v8a1 1 0 0 1-1.993.117L15 16V8a1 1 0 0 1 1-1" /></g>',
  },
  'mingcute:calendar-month-line': {
    body: '<g fill="none"><path d="m12.594 23.258l-.012.002l-.071.035l-.02.004l-.014-.004l-.071-.036q-.016-.004-.024.006l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.016-.018m.264-.113l-.014.002l-.184.093l-.01.01l-.003.011l.018.43l.005.012l.008.008l.201.092q.019.005.029-.008l.004-.014l-.034-.614q-.005-.019-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.003-.011l.018-.43l-.003-.012l-.01-.01z"/><path fill="currentColor" d="M19 3a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2zm0 6H5v10h14zM8.5 15a1 1 0 1 1 0 2h-1a1 1 0 1 1 0-2zm4 0a1 1 0 0 1 .117 1.993L12.5 17h-1a1 1 0 0 1-.117-1.993L11.5 15zm-4-4a1 1 0 0 1 .117 1.993L8.5 13h-1a1 1 0 0 1-.117-1.993L7.5 11zm4 0a1 1 0 1 1 0 2h-1a1 1 0 1 1 0-2zm4 0a1 1 0 0 1 .117 1.993L16.5 13h-1a1 1 0 0 1-.117-1.993L15.5 11zM19 5H5v2h14z"/></g>',
  },
  'mingcute:add-line': {
    body: '<g fill="none"><path d="m12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.018-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z"/><path fill="currentColor" d="M11 20a1 1 0 1 0 2 0v-7h7a1 1 0 1 0 0-2h-7V4a1 1 0 1 0-2 0v7H4a1 1 0 1 0 0 2h7z"/></g>',
  },
  'mingcute:minimize-line': {
    body: '<g fill="none" fill-rule="evenodd"><path d="m12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.018-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z"/><path fill="currentColor" d="M3 12a1 1 0 0 1 1-1h16a1 1 0 1 1 0 2H4a1 1 0 0 1-1-1"/></g>',
  },
  'mingcute:close-line': {
    body: '<g fill="none" fill-rule="evenodd"><path d="m12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.018-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z"/><path fill="currentColor" d="m12 13.414l5.657 5.657a1 1 0 0 0 1.414-1.414L13.414 12l5.657-5.657a1 1 0 0 0-1.414-1.414L12 10.586L6.343 4.929A1 1 0 0 0 4.93 6.343L10.586 12l-5.657 5.657a1 1 0 1 0 1.414 1.414z"/></g>',
  },
  'mingcute:apple-fill': {
    body: '<g fill="none"><path d="m12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.018-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z"/><path fill="currentColor" d="m13.064 6.685l.745-.306c.605-.24 1.387-.485 2.31-.33c1.891.318 3.195 1.339 3.972 2.693c.3.522.058 1.21-.502 1.429a2.501 2.501 0 0 0 .133 4.706c.518.17.81.745.64 1.263c-.442 1.342-1.078 2.581-1.831 3.581c-.744.988-1.652 1.808-2.663 2.209c-.66.26-1.368.163-2.045-.005l-.402-.107l-.597-.173c-.271-.079-.55-.147-.824-.147c-.275 0-.553.068-.824.147l-.597.173l-.402.107c-.677.168-1.386.266-2.045.005c-1.273-.504-2.396-1.68-3.245-3.067a13.5 13.5 0 0 1-1.784-4.986c-.227-1.554-.104-3.299.615-4.775c.74-1.521 2.096-2.705 4.163-3.053c.84-.141 1.562.048 2.14.265l.331.13l.584.241c.4.157.715.249 1.064.249c.348 0 .664-.092 1.064-.249m-1.296-3.917c.976-.977 2.475-1.061 2.828-.707c.354.353.27 1.852-.707 2.828c-.976.976-2.475 1.06-2.828.707c-.354-.353-.27-1.852.707-2.828"/></g>',
  },
  'mingcute:windows-fill': {
    body: '<g fill="none"><path d="m12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.018-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z"/><path fill="currentColor" d="M21 13v7.434a1.5 1.5 0 0 1-1.553 1.499l-.133-.011L12 21.008V13zm-11 0v7.758l-5.248-.656A2 2 0 0 1 3 18.117V13zm9.314-10.922a1.5 1.5 0 0 1 1.68 1.355l.006.133V11h-9V2.992zM10 3.242V11H3V5.883a2 2 0 0 1 1.752-1.985z"/></g>',
  },
  'mingcute:location-fill': {
    body: '<g fill="none"><path d="m12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.018-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z"/><path fill="currentColor" d="M12 2a9 9 0 0 1 9 9c0 3.074-1.676 5.59-3.442 7.395a20.4 20.4 0 0 1-2.876 2.416l-.426.29l-.2.133l-.377.24l-.336.205l-.416.242a1.87 1.87 0 0 1-1.854 0l-.416-.242l-.52-.32l-.192-.125l-.41-.273a20.6 20.6 0 0 1-3.093-2.566C4.676 16.589 3 14.074 3 11a9 9 0 0 1 9-9m0 6a3 3 0 1 0 0 6a3 3 0 0 0 0-6"/></g>',
  },
  'mingcute:dot-grid-fill': {
    body: '<g fill="none"><path d="m12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.018-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z"/><path fill="currentColor" d="M5.5 16.5a2 2 0 1 1 0 4a2 2 0 0 1 0-4m6.5 0a2 2 0 1 1 0 4a2 2 0 0 1 0-4m6.5 0a2 2 0 1 1 0 4a2 2 0 0 1 0-4M5.5 10a2 2 0 1 1 0 4a2 2 0 0 1 0-4m6.5 0a2 2 0 1 1 0 4a2 2 0 0 1 0-4m6.5 0a2 2 0 1 1 0 4a2 2 0 0 1 0-4m-13-6.5a2 2 0 1 1 0 4a2 2 0 0 1 0-4m6.5 0a2 2 0 1 1 0 4a2 2 0 0 1 0-4m6.5 0a2 2 0 1 1 0 4a2 2 0 0 1 0-4"/></g>',
  },
  'mingcute:quote-left-fill': {
    body: '<g fill="none"><path d="m12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.018-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z"/><path fill="currentColor" d="M8.4 6.2a1 1 0 0 1 1.2 1.6c-1.564 1.173-2.46 2.314-2.973 3.31A3.5 3.5 0 1 1 4 14.558a7.6 7.6 0 0 1 .508-3.614C5.105 9.438 6.272 7.796 8.4 6.2m9 0a1 1 0 0 1 1.2 1.6c-1.564 1.173-2.46 2.314-2.973 3.31A3.5 3.5 0 1 1 13 14.558a7.6 7.6 0 0 1 .508-3.614c.598-1.506 1.764-3.148 3.892-4.744"/></g>',
  },
  'mingcute:android-2-fill': {
    body: '<path fill="currentColor" fill-rule="evenodd" clip-rule="evenodd" d="M18.447 4.10605C18.684 4.2247 18.8642 4.43259 18.948 4.68404C19.0319 4.93549 19.0124 5.20993 18.894 5.44705L17.72 7.79705C19.042 8.71791 20.1216 9.94483 20.8669 11.3732C21.6122 12.8015 22.0009 14.389 22 16.0001V17.0001C22 17.5305 21.7893 18.0392 21.4142 18.4143C21.0391 18.7893 20.5304 19.0001 20 19.0001H4C3.46957 19.0001 2.96086 18.7893 2.58579 18.4143C2.21072 18.0392 2 17.5305 2 17.0001V16.0001C1.99892 14.3888 2.3876 12.8012 3.13286 11.3726C3.87813 9.94409 4.95788 8.717 6.28 7.79605L5.106 5.44705C5.04244 5.32918 5.0032 5.19973 4.99061 5.0664C4.97802 4.93307 4.99234 4.79857 5.03273 4.67088C5.07311 4.54319 5.13873 4.42492 5.22569 4.32307C5.31265 4.22122 5.41918 4.13788 5.53897 4.07799C5.65875 4.01809 5.78935 3.98287 5.923 3.97441C6.05666 3.96595 6.19065 3.98442 6.31703 4.02873C6.44341 4.07304 6.55961 4.14228 6.65872 4.23235C6.75783 4.32242 6.83784 4.43147 6.894 4.55305L8.028 6.82005C9.28209 6.27828 10.6339 5.99921 12 6.00005C13.411 6.00005 14.755 6.29205 15.972 6.82005L17.106 4.55305C17.2247 4.31604 17.4325 4.13583 17.684 4.05201C17.9354 3.96819 18.2099 3.98763 18.447 4.10605ZM7.5 12.0001C7.10218 12.0001 6.72065 12.1581 6.43934 12.4394C6.15804 12.7207 6 13.1022 6 13.5001C6 13.8979 6.15804 14.2794 6.43934 14.5607C6.72065 14.842 7.10218 15.0001 7.5 15.0001C7.89783 15.0001 8.27936 14.842 8.56066 14.5607C8.84197 14.2794 9 13.8979 9 13.5001C9 13.1022 8.84197 12.7207 8.56066 12.4394C8.27936 12.1581 7.89783 12.0001 7.5 12.0001ZM16.5 12.0001C16.1022 12.0001 15.7206 12.1581 15.4393 12.4394C15.158 12.7207 15 13.1022 15 13.5001C15 13.8979 15.158 14.2794 15.4393 14.5607C15.7206 14.842 16.1022 15.0001 16.5 15.0001C16.8978 15.0001 17.2794 14.842 17.5607 14.5607C17.842 14.2794 18 13.8979 18 13.5001C18 13.1022 17.842 12.7207 17.5607 12.4394C17.2794 12.1581 16.8978 12.0001 16.5 12.0001Z"/>',
  },
  /**
   * @set Carbon icons
   */
  'carbon:chevron-sort': {
    body: '<path fill="currentColor" d="m16 28l-7-7l1.41-1.41L16 25.17l5.59-5.58L23 21zm0-24l7 7l-1.41 1.41L16 6.83l-5.59 5.58L9 11z"/>',
  },
  'carbon:zoom-in': {
    body: '<path fill="currentColor" d="M18 12h-4V8h-2v4H8v2h4v4h2v-4h4z"/><path fill="currentColor" d="M21.448 20A10.86 10.86 0 0 0 24 13a11 11 0 1 0-11 11a10.86 10.86 0 0 0 7-2.552L27.586 29L29 27.586ZM13 22a9 9 0 1 1 9-9a9.01 9.01 0 0 1-9 9"/>',
  },
  'carbon:zoom-out': {
    body: '<path fill="currentColor" d="M8 12h10v2H8z"/><path fill="currentColor" d="M21.448 20A10.86 10.86 0 0 0 24 13a11 11 0 1 0-11 11a10.86 10.86 0 0 0 7-2.552L27.586 29L29 27.586ZM13 22a9 9 0 1 1 9-9a9.01 9.01 0 0 1-9 9"/>',
  },
  'carbon:play': {
    body: '<path fill="currentColor" d="M7 28a1 1 0 0 1-1-1V5a1 1 0 0 1 1.482-.876l20 11a1 1 0 0 1 0 1.752l-20 11A1 1 0 0 1 7 28M8 6.69v18.62L24.925 16Z"/>',
  },
  'carbon:pause': {
    body: '<path fill="currentColor" d="M12 8v16H8V8zm0-2H8a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2m12 2v16h-4V8zm0-2h-4a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h4a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2" />',
  },
  'carbon:close': {
    body: '<path fill="currentColor" d="M17.414 16L24 9.414L22.586 8L16 14.586L9.414 8L8 9.414L14.586 16L8 22.586L9.414 24L16 17.414L22.586 24L24 22.586z"/>',
  },
  'carbon:chevron-left': {
    body: '<path fill="currentColor" d="M10 16L20 6l1.4 1.4l-8.6 8.6l8.6 8.6L20 26z"/>',
  },
  'carbon:chevron-right': {
    body: '<path fill="currentColor" d="M22 16L12 26l-1.4-1.4l8.6-8.6l-8.6-8.6L12 6z" />',
  },
  'carbon:menu': {
    body: '<path fill="currentColor" d="M4 6h24v2H4zm0 18h24v2H4zm0-12h24v2H4zm0 6h24v2H4z"/>',
  },
  'carbon:bicycle': {
    body: '<path fill="currentColor" d="M26 16c-.088 0-.173.01-.26.013L24.237 9H28V7h-5a1 1 0 0 0-.978 1.21L22.62 11H12.387l-1-3H14V6H7v2h2.28l1.041 3.123l-2.57 5.14A6 6 0 1 0 11.91 23h2.61a2 2 0 0 0 1.562-.75l7.058-8.824l.644 3.004A5.99 5.99 0 1 0 26 16M6 26a4 4 0 1 1 .836-7.91l-1.73 3.463l.009.004A1 1 0 0 0 5 22a.993.993 0 0 0 1.885.443l.01.004L8.618 19A3.984 3.984 0 0 1 6 26m5.91-5a6 6 0 0 0-2.373-3.836l1.678-3.358L13.613 21Zm3.458-1.06L13.054 13h7.865ZM26 26a3.988 3.988 0 0 1-1.786-7.56l.808 3.77l.02-.004A.986.986 0 0 0 26 23a1 1 0 0 0 1-1a1 1 0 0 0-.041-.206l.02-.004l-.81-3.773A3.993 3.993 0 0 1 26 26"/>',
  },
  'carbon:delivery': {
    body: '<path fill="currentColor" d="M4 16h12v2H4zm-2-5h10v2H2z"/><path fill="currentColor" d="m29.919 16.606l-3-7A1 1 0 0 0 26 9h-3V7a1 1 0 0 0-1-1H6v2h15v12.556A4 4 0 0 0 19.142 23h-6.284a4 4 0 1 0 0 2h6.284a3.98 3.98 0 0 0 7.716 0H29a1 1 0 0 0 1-1v-7a1 1 0 0 0-.081-.394M9 26a2 2 0 1 1 2-2a2 2 0 0 1-2 2m14-15h2.34l2.144 5H23Zm0 15a2 2 0 1 1 2-2a2 2 0 0 1-2 2m5-3h-1.142A3.995 3.995 0 0 0 23 20v-2h5Z"/>',
  },
  'carbon:rocket': {
    body: '<path fill="currentColor" d="m7.288 23.292l7.997-7.997l1.414 1.414l-7.997 7.997z"/><path fill="currentColor" d="M17 30a1 1 0 0 1-.37-.07a1 1 0 0 1-.62-.79l-1-7l2-.28l.75 5.27L21 24.52V17a1 1 0 0 1 .29-.71l4.07-4.07A8.94 8.94 0 0 0 28 5.86V4h-1.86a8.94 8.94 0 0 0-6.36 2.64l-4.07 4.07A1 1 0 0 1 15 11H7.48l-2.61 3.26l5.27.75l-.28 2l-7-1a1 1 0 0 1-.79-.62a1 1 0 0 1 .15-1l4-5A1 1 0 0 1 7 9h7.59l3.77-3.78A10.92 10.92 0 0 1 26.14 2H28a2 2 0 0 1 2 2v1.86a10.92 10.92 0 0 1-3.22 7.78L23 17.41V25a1 1 0 0 1-.38.78l-5 4A1 1 0 0 1 17 30"/>',
  },
  'carbon:skill-level-basic': {
    body: '<path fill="currentColor" d="M30 30h-8V4h8zm-6-2h4V6h-4zm-4 2h-8V12h8zm-6-2h4V14h-4zm-4 2H2V18h8z"/>',
  },
  'carbon:fit-to-screen': {
    body: '<path fill="currentColor" d="M22 16h2V8h-8v2h6zM8 24h8v-2h-6v-6H8z"/><path fill="currentColor" d="M26 28H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h20a2 2 0 0 1 2 2v20a2 2 0 0 1-2 2M6 6v20h20.001L26 6Z"/>',
  },
  'carbon:center-to-fit': {
    body: '<path fill="currentColor" d="M8 2H2v6h2V4h4zm16 0h6v6h-2V4h-4zM8 30H2v-6h2v4h4zm16 0h6v-6h-2v4h-4zm0-6H8a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h16a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2M8 10v12h16V10z" />',
  },
  /**
   * Socials icons
   */
  'socials:linkedin': {
    body: '<path fill="var(--color, #0A66C2)" d="M5.14678 2.52608C5.85835 2.65326 6.45746 3.09997 6.77593 3.74217C6.88945 3.97025 6.95882 4.20149 6.99245 4.46426C7.01558 4.64609 7.00822 4.94775 6.97669 5.12433C6.82323 5.99567 6.18418 6.68832 5.33071 6.9122C5.1699 6.95424 5.03326 6.97316 4.84722 6.98157C3.96327 7.01731 3.14449 6.52856 2.75034 5.72869C2.44342 5.10646 2.44342 4.37597 2.74928 3.75268C3.08983 3.06003 3.73729 2.60281 4.51613 2.50822C4.64962 2.4914 5.00909 2.50191 5.14678 2.52608ZM17.2025 8.64541C17.768 8.70007 18.324 8.84932 18.7844 9.0711C19.1407 9.24242 19.5464 9.50414 19.9154 9.80264C20.3274 10.1358 20.6175 10.5436 20.9549 11.2626C21.2281 11.8449 21.3784 12.341 21.4562 12.9128C21.473 13.0347 21.4741 13.3626 21.4772 17.2715L21.4804 21.5H19.5622H17.644V17.9442C17.644 15.5436 17.6408 14.3538 17.6335 14.2791C17.5452 13.3899 17.1374 12.753 16.4437 12.4188C16.2797 12.3399 16.1704 12.3 15.998 12.2558C15.3159 12.0803 14.5097 12.1791 13.9095 12.5102C13.3514 12.8182 12.931 13.4499 12.7733 14.2161C12.7113 14.5188 12.7145 14.3096 12.7145 18.0598V21.5H10.8015H8.88858V15.1778V8.85563H10.6912H12.4938V9.76585V10.675L12.5715 10.571C12.7344 10.3513 13.0351 10.037 13.2579 9.85204C14.1187 9.13626 15.2244 8.69271 16.2944 8.6349C16.4952 8.62439 17.0491 8.6307 17.2025 8.64541ZM6.72338 15.1778V21.5H4.76313H2.80289V15.1778V8.85563H4.76313H6.72338V15.1778Z" />',
  },
  'socials:facebook': {
    body: '<path fill="var(--color, #1877F2)" d="M14 13.5H16.5L17.5 9.5H14V7.5C14 6.47062 14 5.5 16 5.5H17.5V2.1401C17.1743 2.09685 15.943 2 14.6429 2C11.9284 2 10 3.65686 10 6.69971V9.5H7V13.5H10V22H14V13.5Z" />',
  },
  'socials:github': {
    body: '<path fill="var(--color, var(--palette-text-primary))" d="M12.001 2c-5.525 0-10 4.475-10 10a9.994 9.994 0 0 0 6.837 9.488c.5.087.688-.213.688-.476c0-.237-.013-1.024-.013-1.862c-2.512.463-3.162-.612-3.362-1.175c-.113-.288-.6-1.175-1.025-1.413c-.35-.187-.85-.65-.013-.662c.788-.013 1.35.725 1.538 1.025c.9 1.512 2.337 1.087 2.912.825c.088-.65.35-1.087.638-1.337c-2.225-.25-4.55-1.113-4.55-4.938c0-1.088.387-1.987 1.025-2.687c-.1-.25-.45-1.275.1-2.65c0 0 .837-.263 2.75 1.024a9.28 9.28 0 0 1 2.5-.337c.85 0 1.7.112 2.5.337c1.913-1.3 2.75-1.024 2.75-1.024c.55 1.375.2 2.4.1 2.65c.637.7 1.025 1.587 1.025 2.687c0 3.838-2.337 4.688-4.562 4.938c.362.312.675.912.675 1.85c0 1.337-.013 2.412-.013 2.75c0 .262.188.574.688.474A10.016 10.016 0 0 0 22 12c0-5.525-4.475-10-10-10" />',
  },
  'socials:twitter': {
    body: '<path fill="var(--color, var(--palette-text-primary))" d="M17.7242 3H20.779L14.1069 10.624L21.956 21H15.8117L10.9959 14.7087L5.49201 21H2.43288L9.56798 12.8438L2.04346 3H8.34346L12.692 8.75048L17.7242 3ZM16.6511 19.174H18.343L7.42182 4.73077H5.60451L16.6511 19.174Z" />',
  },
  'socials:google': {
    body: '<path fill="var(--color, #FFC107)" d="M21.8055 10.0415H21V10H12V14H17.6515C16.827 16.3285 14.6115 18 12 18C8.6865 18 6 15.3135 6 12C6 8.6865 8.6865 6 12 6C13.5295 6 14.921 6.577 15.9805 7.5195L18.809 4.691C17.023 3.0265 14.634 2 12 2C6.4775 2 2 6.4775 2 12C2 17.5225 6.4775 22 12 22C17.5225 22 22 17.5225 22 12C22 11.3295 21.931 10.675 21.8055 10.0415Z" /> <path fill="var(--color, #FF3D00)" d="M3.15332 7.3455L6.43882 9.755C7.32782 7.554 9.48082 6 12.0003 6C13.5298 6 14.9213 6.577 15.9808 7.5195L18.8093 4.691C17.0233 3.0265 14.6343 2 12.0003 2C8.15932 2 4.82832 4.1685 3.15332 7.3455Z" /> <path fill="var(--color, #4CAF50)" d="M12.0002 22C14.5832 22 16.9302 21.0115 18.7047 19.404L15.6097 16.785C14.5719 17.5742 13.3039 18.0011 12.0002 18C9.39916 18 7.19066 16.3415 6.35866 14.027L3.09766 16.5395C4.75266 19.778 8.11366 22 12.0002 22Z" /> <path fill="var(--color, #1976D2)" d="M21.8055 10.0415H21V10H12V14H17.6515C17.2571 15.1082 16.5467 16.0766 15.608 16.7855L15.6095 16.7845L18.7045 19.4035C18.4855 19.6025 22 17 22 12C22 11.3295 21.931 10.675 21.8055 10.0415Z" />',
  },
  'socials:instagram': {
    body: '<path d="M22.437 7.67096C22.3859 6.55328 22.2084 5.78997 21.9488 5.12223C21.6852 4.42158 21.2719 3.78688 20.7377 3.26241C20.2132 2.72817 19.5785 2.31476 18.8779 2.05101C18.2099 1.79158 17.4468 1.61423 16.3292 1.56345C15.2094 1.51218 14.8516 1.5 12.0001 1.5C9.14852 1.5 8.79073 1.51218 7.67096 1.56316C6.55328 1.61423 5.79018 1.79175 5.12223 2.05129C4.42156 2.31493 3.78685 2.72826 3.26237 3.26245C2.72813 3.78686 2.31472 4.4215 2.05097 5.12211C1.79154 5.79005 1.61419 6.55332 1.56341 7.67084C1.51218 8.79073 1.5 9.14835 1.5 11.9999C1.5 14.8516 1.51218 15.2094 1.56345 16.3291C1.61439 17.4467 1.79191 18.2099 2.05146 18.8779C2.31509 19.5785 2.7284 20.2132 3.26257 20.7376C3.78701 21.2718 4.4217 21.6851 5.12236 21.9487C5.79018 22.2084 6.55344 22.3857 7.67112 22.4368C8.79106 22.4879 9.14864 22.5 12.0002 22.5C14.8518 22.5 15.2096 22.4879 16.3293 22.4368C17.447 22.3857 18.2101 22.2084 18.8781 21.9487C19.5756 21.6789 20.209 21.2665 20.7378 20.7377C21.2666 20.2089 21.6791 19.5754 21.9488 18.8779C22.2085 18.2099 22.3859 17.4467 22.437 16.3292C22.4879 15.2092 22.5001 14.8516 22.5001 12.0001C22.5001 9.14835 22.4879 8.79073 22.437 7.67096ZM20.5469 16.2432C20.5003 17.2669 20.3292 17.8229 20.1855 18.1928C20.0108 18.6457 19.7432 19.057 19.4 19.4002C19.0568 19.7434 18.6455 20.011 18.1927 20.1856C17.8227 20.3294 17.2668 20.5005 16.243 20.5471C15.1361 20.5977 14.8039 20.6083 12.0001 20.6083C9.19614 20.6083 8.86415 20.5977 7.75701 20.5471C6.73342 20.5005 6.17749 20.3294 5.80736 20.1856C5.35132 20.0173 4.93879 19.7488 4.6001 19.4001C4.25133 19.0614 3.98291 18.6489 3.81457 18.1928C3.67085 17.8229 3.49973 17.2669 3.45309 16.2432C3.40264 15.1361 3.3919 14.8039 3.3919 12.0003C3.3919 9.19642 3.40264 8.86448 3.45309 7.75717C3.49985 6.73342 3.67085 6.17745 3.81457 5.80753C3.98296 5.35144 4.25138 4.93887 4.6001 4.6001C4.93879 4.25132 5.35139 3.98295 5.80753 3.81473C6.17749 3.67085 6.73342 3.49989 7.75722 3.45309C8.86432 3.40264 9.19646 3.3919 12.0001 3.3919C14.8038 3.3919 15.1357 3.40264 16.243 3.45326C17.2668 3.49989 17.8226 3.67101 18.1927 3.81473C18.6487 3.98311 19.0612 4.25147 19.3999 4.6001C19.7487 4.93879 20.0171 5.35139 20.1854 5.80753C20.3292 6.17749 20.5004 6.73342 20.5469 7.75722C20.5974 8.86432 20.6081 9.19646 20.6081 12.0001C20.6081 14.8039 20.5976 15.1358 20.5469 16.2432Z" fill="url(#instagramPath1)"></path><path d="M11.9999 6.60812C9.02211 6.60812 6.60808 9.02223 6.60808 12.0001C6.60808 14.9779 9.02211 17.3919 11.9999 17.3919C14.9779 17.3919 17.3919 14.9779 17.3919 12.0001C17.3919 9.02223 14.9779 6.60812 11.9999 6.60812ZM11.9999 15.5C10.067 15.4999 8.49993 13.9329 8.5001 11.9999C8.5001 10.067 10.067 8.49993 12.0001 8.49993C13.9331 8.5001 15.5 10.067 15.5 11.9999C15.5 13.9329 13.9329 15.5 11.9999 15.5Z" fill="url(#instagramPath2)"></path><path d="M18.8649 6.39516C18.8649 7.091 18.3008 7.65509 17.605 7.65509C16.909 7.65509 16.3449 7.09095 16.3449 6.39516C16.3449 5.69912 16.909 5.13503 17.605 5.13503C18.3008 5.13503 18.8649 5.69916 18.8649 6.39516Z" fill="url(#instagramPath3)"></path><defs><linearGradient id="instagramPath1" x1="3.26229" y1="20.7377" x2="20.7378" y2="3.26212" gradientUnits="userSpaceOnUse"><stop stop-color="var(--color, #FFD600)"></stop><stop offset="0.5" stop-color="var(--color, #FF0100)"></stop><stop offset="1" stop-color="var(--color, #D800B9)"></stop></linearGradient><linearGradient id="instagramPath2" x1="4.57544" y1="19.4246" x2="19.4247" y2="4.57532" gradientUnits="userSpaceOnUse"><stop stop-color="var(--color, #FF6400)"></stop><stop offset="0.5" stop-color="var(--color, #FF0100)"></stop><stop offset="1" stop-color="var(--color, #FD0056)"></stop></linearGradient><linearGradient id="instagramPath3" x1="16.7139" y1="7.28603" x2="18.4957" y2="5.50413" gradientUnits="userSpaceOnUse"><stop stop-color="var(--color, #F30072)"></stop><stop offset="1" stop-color="var(--color, #E50097)"></stop></linearGradient></defs>',
  },
  /**
   * Payments icons
   */
  'payments:mastercard': {
    width: 36,
    height: 24,
    body: '<path d="M21.9213 18.9968H14.0776V5.00525H21.9213V18.9968Z" fill="#FF5F00" /> <path d="M14.5802 12C14.5802 9.16175 15.919 6.63348 18.004 5.00421C16.4793 3.81281 14.5551 3.10168 12.4638 3.10168C7.51317 3.10168 3.5 7.08556 3.5 12C3.5 16.9144 7.51317 20.8983 12.4638 20.8983C14.5551 20.8983 16.4793 20.1872 18.004 18.9958C15.919 17.3665 14.5802 14.8382 14.5802 12Z" fill="#EB001B" /> <path d="M32.5001 12C32.5001 16.9144 28.4869 20.8983 23.5363 20.8983C21.445 20.8983 19.5208 20.1872 17.9956 18.9958C20.0811 17.3665 21.4199 14.8382 21.4199 12C21.4199 9.16175 20.0811 6.63348 17.9956 5.00421C19.5208 3.81281 21.445 3.10168 23.5363 3.10168C28.4869 3.10168 32.5001 7.08556 32.5001 12Z" fill="#F79E1B" />',
  },
  'payments:visa': {
    width: 36,
    height: 24,
    body: '<path d="M13.0102 17.089L14.7298 6.99823H17.4802L15.7594 17.089H13.0102Z" fill="#0E4595" /> <path d="M25.6962 7.21586C25.1513 7.01143 24.2975 6.79205 23.2311 6.79205C20.5134 6.79205 18.5991 8.16065 18.5827 10.1221C18.5674 11.5721 19.9494 12.3809 20.9927 12.8636C22.0633 13.3583 22.4232 13.6737 22.418 14.1153C22.4112 14.7917 21.5631 15.1006 20.7725 15.1006C19.6717 15.1006 19.0869 14.9477 18.1836 14.5711L17.8291 14.4106L17.4431 16.6695C18.0856 16.9513 19.2734 17.1953 20.5069 17.2079C23.3981 17.2079 25.275 15.855 25.2964 13.7603C25.3066 12.6124 24.5739 11.7389 22.9871 11.0187C22.0257 10.5519 21.437 10.2404 21.4432 9.76775C21.4432 9.34832 21.9416 8.89982 23.0184 8.89982C23.9177 8.88585 24.5693 9.08198 25.0769 9.28641L25.3234 9.40286L25.6962 7.21586Z" fill="#0E4595" /> <path d="M32.7738 6.99819H30.6486C29.9902 6.99819 29.4975 7.17788 29.2083 7.83498L25.1236 17.0824H28.0118C28.0118 17.0824 28.484 15.8391 28.5908 15.566C28.9064 15.566 31.7121 15.5704 32.1132 15.5704C32.1955 15.9237 32.4479 17.0824 32.4479 17.0824H35L32.7738 6.99819ZM29.4019 13.514C29.6294 12.9326 30.4977 10.6932 30.4977 10.6932C30.4815 10.7201 30.7235 10.109 30.8624 9.73012L31.0483 10.6001C31.0483 10.6001 31.5749 13.0088 31.685 13.5138H29.4019V13.514Z" fill="#0E4595" /> <path d="M1.03514 6.99823L1 7.20814C2.08726 7.47133 3.05833 7.85226 3.90852 8.32614L6.349 17.0728L9.25903 17.0696L13.5891 6.99823H10.6754L7.98276 13.8794L7.69594 12.4809C7.6825 12.4377 7.66789 12.3944 7.65295 12.3511L6.71687 7.85015C6.55042 7.21118 6.06757 7.0205 5.4702 6.99823H1.03514Z" fill="#0E4595" />',
  },
  'payments:paypal': {
    body: '<path d="M18.6296 8.12603L7.87346 19.863H3.92825C3.65428 19.863 3.4351 19.589 3.4899 19.3151L6.12004 2.65753C6.17483 2.27397 6.5036 2 6.88716 2H13.5721C18.1748 2.16438 19.4351 4.52055 18.6132 8.13699L18.6296 8.12603Z" fill="#002C8A" /> <path d="M18.8052 7.04108C20.449 7.91779 20.8326 9.56162 20.2846 11.7534C19.5723 14.9863 17.4353 16.3561 14.312 16.4109L13.4353 16.4657C13.1066 16.4657 12.8874 16.6849 12.8326 17.0137L12.1203 21.3424C12.0655 21.726 11.7367 22 11.3531 22H8.06546C7.79149 22 7.57231 21.726 7.62711 21.452L8.83258 13.6164C8.88738 13.3424 18.8052 7.04108 18.8052 7.04108Z" fill="#009BE1" /> <path d="M8.7666 14L9.86249 7.04109C9.89844 6.87629 9.98771 6.72792 10.1165 6.61897C10.2452 6.51001 10.4063 6.44653 10.5748 6.43835H15.8351C17.0954 6.43835 18.0269 6.65753 18.794 7.04109C18.52 9.45205 17.3693 13.3425 11.7803 13.4521H9.36934C9.09537 13.4521 8.8214 13.6712 8.7666 14Z" fill="#001F6B" />',
  },
  /**
   * Custom icons
   */
  'custom:menu-duotone': {
    body: '<path fill="currentColor" opacity="0.4" d="M15.7798 4.5H5.2202C4.27169 4.5 3.5 5.06057 3.5 5.75042C3.5 6.43943 4.27169 7 5.2202 7H15.7798C16.7283 7 17.5 6.43943 17.5 5.75042C17.5 5.06054 16.7283 4.5 15.7798 4.5Z" ></path> <path fill="currentColor" d="M18.7798 10.75H8.2202C7.27169 10.75 6.5 11.3106 6.5 12.0004C6.5 12.6894 7.27169 13.25 8.2202 13.25H18.7798C19.7283 13.25 20.5 12.6894 20.5 12.0004C20.5 11.3105 19.7283 10.75 18.7798 10.75Z" ></path> <path fill="currentColor" d="M15.7798 17H5.2202C4.27169 17 3.5 17.5606 3.5 18.2504C3.5 18.9394 4.27169 19.5 5.2202 19.5H15.7798C16.7283 19.5 17.5 18.9394 17.5 18.2504C17.5 17.5606 16.7283 17 15.7798 17Z" ></path>',
  },
  'custom:invoice-duotone': {
    body: '<path fill="currentColor" opacity="0.4" fillRule="evenodd" clipRule="evenodd" d="M17.7556 2.30079C17.3519 2.11371 17.1172 2.08917 17.0632 2.08595C15.766 2.03476 14.1085 2 11.999 2C7.72437 2 5.30557 2.14276 3.97974 2.27571C3.04019 2.36993 2.36895 3.04117 2.27473 3.98072C2.14178 5.30655 1.99902 7.72535 1.99902 12C1.99902 16.6448 2.16757 19.604 2.30894 21.2694C2.37429 22.039 3.24545 22.378 3.83887 21.8834L5.49902 20.5L6.86612 21.8671C7.22642 22.2274 7.80002 22.2592 8.19792 21.9408L9.99902 20.5L11.2919 21.7929C11.6824 22.1834 12.3156 22.1834 12.7061 21.7929L13.999 20.5L15.8001 21.9408C16.198 22.2592 16.7716 22.2274 17.1319 21.8671L18.499 20.5L20.1592 21.8834C20.7526 22.378 21.6238 22.039 21.6891 21.2694C21.8305 19.604 21.999 16.6448 21.999 12C21.999 9.87288 21.9637 8.20528 21.9118 6.90321C21.4743 6.95701 20.8561 7.00045 20 7.00045C19.3705 7.00045 18.8696 6.97695 18.4746 6.94315C17.6146 6.8695 17.0559 6.21195 17.0228 5.3494C17.0092 4.99245 17 4.54875 17 4.00045C17 3.11398 17.0239 2.50092 17.0522 2.08594C17.0522 2.08594 17.2925 2.08635 17.7556 2.30079ZM11.6589 15.2672C12.2031 15.2672 12.5962 15.1752 12.8381 14.9912C13.0901 14.8072 13.2161 14.5817 13.2161 14.3149C13.2161 14.0757 13.1203 13.8825 12.9288 13.7352C12.7373 13.588 12.4501 13.4592 12.0671 13.3488L11.2355 13.1004C10.8223 12.9807 10.4493 12.8519 10.1167 12.7139C9.78412 12.5759 9.50192 12.4103 9.27007 12.217C9.03827 12.0238 8.85682 11.7938 8.72582 11.527C8.59477 11.2601 8.52927 10.9427 8.52927 10.5746C8.52927 9.94895 8.74092 9.4291 9.16427 9.01505C9.58757 8.601 10.1923 8.32495 10.9785 8.18695V7.7944C10.9785 7.3862 11.2613 7.0214 11.6691 7.00345C11.7215 7.00115 11.7736 7 11.8252 7C12.1981 7 12.4652 7.0598 12.6265 7.1794C12.7978 7.29905 12.8835 7.51525 12.8835 7.8281V8.13175C13.5285 8.19615 14.0527 8.33875 14.4558 8.5596C14.859 8.7712 15.0606 9.05185 15.0606 9.4015C15.0606 9.55725 15.0194 9.70145 14.9481 9.8323C14.7585 10.1803 14.2851 10.1546 13.9096 10.0279C13.8023 9.99165 13.687 9.9577 13.5638 9.92595C13.1808 9.81555 12.7625 9.76035 12.309 9.76035C11.805 9.76035 11.427 9.83855 11.1751 9.995C10.9331 10.1422 10.8122 10.3354 10.8122 10.5746C10.8122 10.7679 10.8928 10.9243 11.0541 11.0439C11.2254 11.1635 11.4825 11.2739 11.8252 11.3751L12.6718 11.6098C13.5789 11.8674 14.2744 12.2078 14.7582 12.6311C15.2521 13.0543 15.499 13.6248 15.499 14.3425C15.499 14.9774 15.2773 15.5157 14.8338 15.9573C14.3903 16.3898 13.7402 16.6796 12.8835 16.8268V17.2056C12.8835 17.6138 12.6007 17.9786 12.1929 17.9965C12.1405 17.9988 12.0884 18 12.0368 18C11.6639 18 11.3918 17.9402 11.2204 17.8206C11.0591 17.7009 10.9785 17.4847 10.9785 17.1719V16.8958C10.2427 16.8222 9.64302 16.6612 9.17937 16.4128C8.72582 16.1551 8.49902 15.8331 8.49902 15.4466C8.49902 15.2209 8.58567 15.0249 8.72467 14.8601C8.97352 14.5651 9.41662 14.6382 9.75947 14.8155C9.90572 14.8911 10.0651 14.9634 10.2377 15.0326C10.6509 15.189 11.1247 15.2672 11.6589 15.2672Z" /> <path fill="currentColor" d="M21.9128 6.9031C21.4752 6.95695 20.8567 7.00045 20 7.00045C19.3705 7.00045 18.8696 6.97695 18.4746 6.94315C17.6146 6.8695 17.0559 6.21195 17.0228 5.3494C17.0092 4.99245 17 4.54875 17 4.00045C17 3.11398 17.0239 2.50092 17.0522 2.08594C17.0522 2.08594 18.0872 2.08772 20 4.00045C21.9128 5.9132 21.9128 6.9031 21.9128 6.9031Z" /> <path fill="currentColor" d="M11.6599 15.2672C12.2041 15.2672 12.5972 15.1752 12.8391 14.9912C13.091 14.8072 13.217 14.5817 13.217 14.3149C13.217 14.0757 13.1213 13.8825 12.9298 13.7352C12.7383 13.588 12.4511 13.4592 12.0681 13.3488L11.2365 13.1004C10.8232 12.9807 10.4503 12.8519 10.1177 12.7139C9.7851 12.5759 9.5029 12.4103 9.27105 12.217C9.03925 12.0238 8.8578 11.7938 8.7268 11.527C8.59575 11.2601 8.53025 10.9427 8.53025 10.5746C8.53025 9.94895 8.7419 9.4291 9.16525 9.01505C9.58855 8.601 10.1933 8.32495 10.9795 8.18695V7.7944C10.9795 7.3862 11.2623 7.0214 11.6701 7.00345C11.7225 7.00115 11.7745 7 11.8261 7C12.199 7 12.4662 7.0598 12.6274 7.1794C12.7988 7.29905 12.8844 7.51525 12.8844 7.8281V8.13175C13.5295 8.19615 14.0537 8.33875 14.4568 8.5596C14.86 8.7712 15.0616 9.05185 15.0616 9.4015C15.0616 9.55725 15.0203 9.70145 14.9491 9.8323C14.7594 10.1803 14.2861 10.1546 13.9106 10.0279C13.8032 9.99165 13.688 9.9577 13.5648 9.92595C13.1818 9.81555 12.7635 9.76035 12.3099 9.76035C11.806 9.76035 11.428 9.83855 11.1761 9.995C10.9341 10.1422 10.8132 10.3354 10.8132 10.5746C10.8132 10.7679 10.8938 10.9243 11.0551 11.0439C11.2264 11.1635 11.4834 11.2739 11.8261 11.3751L12.6728 11.6098C13.5799 11.8674 14.2754 12.2078 14.7592 12.6311C15.253 13.0543 15.5 13.6248 15.5 14.3425C15.5 14.9774 15.2783 15.5157 14.8348 15.9573C14.3913 16.3898 13.7412 16.6796 12.8844 16.8268V17.2056C12.8844 17.6138 12.6016 17.9786 12.1938 17.9965C12.1415 17.9988 12.0894 18 12.0378 18C11.6648 18 11.3928 17.9402 11.2214 17.8206C11.0601 17.7009 10.9795 17.4847 10.9795 17.1719V16.8958C10.2437 16.8222 9.644 16.6612 9.18035 16.4128C8.7268 16.1551 8.5 15.8331 8.5 15.4466C8.5 15.2209 8.58665 15.0249 8.72565 14.8601C8.9745 14.5651 9.4176 14.6382 9.76045 14.8155C9.9067 14.8911 10.0661 14.9634 10.2387 15.0326C10.6519 15.189 11.1257 15.2672 11.6599 15.2672Z" />',
  },
  'custom:profile-duotone': {
    body: '<path fill="currentColor" opacity="0.4" d="M2.28099 19.6575C2.36966 20.5161 2.93261 21.1957 3.77688 21.3755C5.1095 21.6592 7.6216 22 12 22C16.3784 22 18.8905 21.6592 20.2232 21.3755C21.0674 21.1957 21.6303 20.5161 21.719 19.6575C21.8505 18.3844 22 16.0469 22 12C22 7.95305 21.8505 5.6156 21.719 4.34251C21.6303 3.48389 21.0674 2.80424 20.2231 2.62451C18.8905 2.34081 16.3784 2 12 2C7.6216 2 5.1095 2.34081 3.77688 2.62451C2.93261 2.80424 2.36966 3.48389 2.28099 4.34251C2.14952 5.6156 2 7.95305 2 12C2 16.0469 2.14952 18.3844 2.28099 19.6575Z" /> <path fill="currentColor" d="M13.9382 13.8559C15.263 13.1583 16.1663 11.7679 16.1663 10.1666C16.1663 7.8655 14.3008 6 11.9996 6C9.69841 6 7.83291 7.8655 7.83291 10.1666C7.83291 11.768 8.73626 13.1584 10.0612 13.856C8.28691 14.532 6.93216 16.1092 6.51251 18.0529C6.45446 18.3219 6.60246 18.5981 6.87341 18.6471C7.84581 18.8231 9.45616 19 12.0006 19C14.545 19 16.1554 18.8231 17.1278 18.6471C17.3977 18.5983 17.5454 18.3231 17.4876 18.0551C17.0685 16.1103 15.7133 14.5321 13.9382 13.8559Z" />',
  },
  'custom:location-fill': {
    body: '<path fill="currentColor" d="M18.8346 14.9163C19.7513 13.583 20.3346 11.9163 20.3346 10.1663C20.3346 5.49967 16.5846 1.83301 12.0013 1.83301C7.41797 1.83301 3.66797 5.58301 3.66797 10.1663C3.66797 11.833 4.16797 13.4163 5.0013 14.6663C5.0013 14.7497 5.08464 14.833 5.16797 14.9163C5.16797 14.9163 5.2513 14.9997 5.2513 15.083C5.41797 15.333 5.58464 15.583 5.83464 15.833C8.0013 18.4163 12.0013 22.1663 12.0013 22.1663C12.0013 22.1663 16.0013 18.4163 18.168 15.9163C18.3346 15.6663 18.5846 15.4163 18.7513 15.1663C18.7513 14.9997 18.8346 14.9997 18.8346 14.9163Z" />',
  },
  'custom:sidebar-unfold-fill': {
    body: '<path fill="currentColor" d="M14.9844 3H17.9844C19.6412 3 20.9844 4.34315 20.9844 6V18C20.9844 19.6569 19.6412 21 17.9844 21H14.9844V3Z" /> <path fill="currentColor" fill-rule="evenodd" clip-rule="evenodd" d="M6.01562 3C4.35938 3 3.01562 4.34277 3.01562 6V18C3.01562 19.6572 4.35938 21 6.01562 21H13.0156V3H6.01562ZM8.10156 9.22559C7.78125 8.94238 7.27344 9.17188 7.27344 9.60156V14.3984C7.27344 14.8281 7.78125 15.0576 8.10156 14.7744L10.8438 12.376C11.0039 12.2354 11.0508 12.0176 10.9844 11.8311C10.957 11.7539 10.9102 11.6826 10.8438 11.624L8.10156 9.22559Z" />',
  },
  'custom:sidebar-fold-fill': {
    body: '<path fill="currentColor" d="M14.9844 3H17.9844C19.6412 3 20.9844 4.34315 20.9844 6V18C20.9844 19.6569 19.6412 21 17.9844 21H14.9844V3Z" /> <path fill="currentColor" fill-rule="evenodd" clip-rule="evenodd" d="M6.01562 3C4.35938 3 3.01562 4.34277 3.01562 6V18C3.01562 19.6572 4.35938 21 6.01562 21H13.0156V3H6.01562ZM10.1875 9.22559C10.5078 8.94238 11.0156 9.17188 11.0156 9.60156V14.3984C11.0156 14.8281 10.5078 15.0576 10.1875 14.7744L7.44531 12.376C7.21875 12.1768 7.21875 11.8232 7.44531 11.624L10.1875 9.22559Z" />',
  },
  'custom:flash-outline': {
    body: '<path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13 10V3L5 14h6v7l8-11z" />',
  },
  'custom:fast-food-fill': {
    body: '<path fill="currentColor" d="M21.3144 5.33352H17.5202L17.8919 3.8477L19.4886 3.30396C19.8281 3.18854 20.0302 2.82771 19.9323 2.48271C19.9074 2.39593 19.8651 2.31511 19.808 2.24516C19.7509 2.1752 19.6802 2.11758 19.6002 2.07577C19.5202 2.03396 19.4325 2.00885 19.3425 2.00195C19.2524 1.99505 19.1619 2.00651 19.0765 2.03564L17.1182 2.7023C17.0127 2.73826 16.9179 2.80008 16.8425 2.88211C16.7671 2.96414 16.7135 3.06376 16.6865 3.17187L16.1461 5.33352H10.6853C10.3266 5.33352 10.0187 5.60935 10.0007 5.96809C9.9964 6.05823 10.0104 6.14831 10.0419 6.23288C10.0734 6.31745 10.1217 6.39474 10.184 6.46007C10.2463 6.5254 10.3211 6.57741 10.4041 6.61296C10.487 6.6485 10.5763 6.66683 10.6666 6.66683H10.7812L10.8228 7.02766C10.8326 7.11193 10.8731 7.18965 10.9365 7.24604C10.9998 7.30243 11.0817 7.33355 11.1666 7.33349C12.7915 7.33349 14.2357 7.78766 15.3382 8.64681C15.9514 9.1193 16.4485 9.72571 16.7915 10.4197C16.9835 10.8101 17.1252 11.2232 17.2132 11.6493C17.2307 11.7323 17.2799 11.8052 17.3502 11.8526C17.9171 12.2372 18.3352 12.8042 18.5351 13.4593C18.7351 14.1144 18.7048 14.8183 18.4494 15.4538C18.4197 15.5274 18.4175 15.6092 18.4432 15.6842C18.5908 16.1072 18.6663 16.552 18.6665 17.0001C18.6665 17.9309 18.3498 18.818 17.7748 19.4979C17.4489 19.8861 17.0388 20.1948 16.5757 20.4008C16.4956 20.4362 16.4325 20.5016 16.4003 20.5829C16.2272 21.0337 15.9828 21.4538 15.6765 21.8271C15.6638 21.8422 15.6556 21.8607 15.653 21.8803C15.6503 21.8999 15.6533 21.9199 15.6617 21.9379C15.67 21.9558 15.6832 21.9711 15.6999 21.9818C15.7165 21.9925 15.7359 21.9982 15.7557 21.9983H17.8061C18.3081 21.9963 18.7911 21.8064 19.1601 21.466C19.5291 21.1256 19.7573 20.6594 19.7998 20.1592L21.2248 6.66683H21.3331C21.4234 6.66694 21.5128 6.64869 21.5959 6.6132C21.6789 6.57771 21.7539 6.52572 21.8162 6.46037C21.8786 6.39503 21.927 6.3177 21.9585 6.23308C21.9901 6.14845 22.0041 6.0583 21.9998 5.96809C21.9823 5.60935 21.6731 5.33352 21.3144 5.33352Z" /> <path fill="currentColor" d="M5.86204 14.6667C5.99353 14.6661 6.12383 14.6916 6.24541 14.7416C6.36699 14.7917 6.47744 14.8654 6.57037 14.9584L7.21661 15.6047C7.23209 15.6201 7.25047 15.6324 7.2707 15.6408C7.29094 15.6492 7.31262 15.6535 7.33453 15.6535C7.35643 15.6535 7.37812 15.6492 7.39835 15.6408C7.41858 15.6324 7.43696 15.6201 7.45244 15.6047L8.09743 14.9584C8.19036 14.8654 8.30081 14.7917 8.42239 14.7416C8.54397 14.6916 8.67427 14.6661 8.80576 14.6667H16.9965C17.0403 14.6672 17.0837 14.659 17.1243 14.6427C17.1649 14.6263 17.2019 14.6021 17.2332 14.5715C17.2644 14.5408 17.2894 14.5043 17.3065 14.4641C17.3237 14.4238 17.3327 14.3805 17.3332 14.3367V14.3334C17.3327 13.9493 17.1998 13.5772 16.957 13.2797C16.7141 12.9821 16.376 12.7775 15.9998 12.7001C15.9657 11.463 15.4582 10.4276 14.5203 9.70013C13.6528 9.02348 12.4936 8.66681 11.1666 8.66681H8.1666C5.32413 8.66681 3.39874 10.2822 3.33332 12.7001C2.95712 12.7775 2.61909 12.9821 2.37622 13.2797C2.13334 13.5772 2.00047 13.9493 2 14.3334C2 14.4218 2.03512 14.5066 2.09763 14.5691C2.16014 14.6316 2.24493 14.6667 2.33333 14.6667H5.86204ZM9.08076 16.0001C9.03697 16 8.99361 16.0086 8.95314 16.0254C8.91268 16.0421 8.8759 16.0666 8.84493 16.0976L7.92244 17.0205C7.76616 17.1767 7.55424 17.2645 7.33328 17.2645C7.11231 17.2645 6.90039 17.1767 6.74412 17.0205L5.82163 16.0976C5.79065 16.0666 5.75387 16.0421 5.71341 16.0254C5.67295 16.0086 5.62958 16 5.5858 16.0001H2.69416C2.53756 15.9994 2.38576 16.0541 2.26559 16.1545C2.14542 16.2549 2.06463 16.3946 2.0375 16.5488C2.01243 16.6979 1.99988 16.8489 2 17.0001C2 18.2746 2.88041 19.3129 3.96915 19.3334C4.07039 19.9634 4.31539 20.5325 4.68414 20.9779C5.22955 21.6367 6.02246 22 6.91661 22H12.4166C13.3107 22 14.1036 21.6367 14.649 20.9771C15.0178 20.5317 15.2628 19.9625 15.364 19.3325C16.4528 19.3129 17.3332 18.2746 17.3332 16.9992C17.3333 16.848 17.3207 16.6971 17.2957 16.548C17.2684 16.3939 17.1875 16.2544 17.0673 16.1542C16.9472 16.0539 16.7955 15.9993 16.639 16.0001H9.08076Z" />',
  },
  'custom:drag-dots-fill': {
    body: '<path fill="currentColor" fill-rule="evenodd" clip-rule="evenodd" d="M11.0625 5.505C11.0625 4.5375 10.2225 3.75 9.1875 3.75C8.1525 3.75 7.3125 4.5375 7.3125 5.505C7.3125 6.474 8.1525 7.26 9.1875 7.26C10.2225 7.26 11.0625 6.474 11.0625 5.505ZM11.0625 18.495C11.0625 17.526 10.2225 16.74 9.1875 16.74C8.1525 16.74 7.3125 17.526 7.3125 18.495C7.3125 19.464 8.1525 20.25 9.1875 20.25C10.2225 20.25 11.0625 19.4625 11.0625 18.495ZM9.1875 10.245C10.2225 10.245 11.0625 11.0325 11.0625 12C11.0625 12.9675 10.2225 13.755 9.1875 13.755C8.1525 13.755 7.3125 12.9675 7.3125 12C7.3125 11.0325 8.1525 10.245 9.1875 10.245ZM16.6875 5.505C16.6875 4.5375 15.8475 3.75 14.8125 3.75C13.7775 3.75 12.9375 4.5375 12.9375 5.505C12.9375 6.474 13.7775 7.26 14.8125 7.26C15.8475 7.26 16.6875 6.474 16.6875 5.505ZM14.8125 16.74C15.8475 16.74 16.6875 17.526 16.6875 18.495C16.6875 19.464 15.8475 20.25 14.8125 20.25C13.7775 20.25 12.9375 19.4625 12.9375 18.495C12.9375 17.526 13.7775 16.74 14.8125 16.74ZM16.6875 12C16.6875 11.0325 15.8475 10.245 14.8125 10.245C13.7775 10.245 12.9375 11.0325 12.9375 12C12.9375 12.9675 13.7775 13.755 14.8125 13.755C15.8475 13.755 16.6875 12.9675 16.6875 12Z" />',
  },
  'custom:send-fill': {
    body: '<path fill="currentColor" fill-rule="evenodd" clip-rule="evenodd" d="M3.40203 6.67292C3.14203 4.33892 5.54503 2.62492 7.66803 3.63092L19.612 9.28892C21.9 10.3719 21.9 13.6279 19.612 14.7109L7.66803 20.3699C5.54503 21.3759 3.14303 19.6619 3.40203 17.3279L3.88203 12.9999H12C12.2652 12.9999 12.5196 12.8946 12.7071 12.707C12.8947 12.5195 13 12.2651 13 11.9999C13 11.7347 12.8947 11.4803 12.7071 11.2928C12.5196 11.1053 12.2652 10.9999 12 10.9999H3.88303L3.40203 6.67292Z" />',
  },
  'custom:calendar-agenda-outline': {
    body: '<path fill="currentColor" d="M21 19C21.0002 19.5046 20.8096 19.9906 20.4665 20.3605C20.1234 20.7305 19.6532 20.9572 19.15 20.995L19 21H5C4.49542 21.0002 4.00943 20.8096 3.63945 20.4665C3.26947 20.1234 3.04284 19.6532 3.005 19.15L3 19L3 5C2.99984 4.49542 3.19041 4.00943 3.5335 3.63945C3.87659 3.26947 4.34685 3.04284 4.85 3.005L5 3L19 3C19.5046 2.99984 19.9906 3.19041 20.3605 3.5335C20.7305 3.87659 20.9572 4.34685 20.995 4.85L21 5V19ZM19 19V5L5 5L5 19H19ZM17 8C17 8.24493 16.91 8.48134 16.7473 8.66437C16.5845 8.84741 16.3603 8.96434 16.117 8.993L16 9L8 9C7.74512 8.99972 7.49997 8.90212 7.31463 8.72715C7.1293 8.55218 7.01777 8.31305 7.00283 8.05861C6.98789 7.80416 7.07067 7.55362 7.23426 7.35817C7.39786 7.16271 7.6299 7.0371 7.883 7.007L8 7L16 7C16.2652 7 16.5196 7.10536 16.7071 7.29289C16.8946 7.48043 17 7.73478 17 8ZM17 12C17 12.2652 16.8946 12.5196 16.7071 12.7071C16.5196 12.8946 16.2652 13 16 13H8C7.73478 13 7.48043 12.8946 7.29289 12.7071C7.10536 12.5196 7 12.2652 7 12C7 11.7348 7.10536 11.4804 7.29289 11.2929C7.48043 11.1054 7.73478 11 8 11H16C16.2652 11 16.5196 11.1054 16.7071 11.2929C16.8946 11.4804 17 11.7348 17 12ZM17 16C17 16.2449 16.91 16.4813 16.7473 16.6644C16.5845 16.8474 16.3603 16.9643 16.117 16.993L16 17H8C7.74512 16.9997 7.49997 16.9021 7.31463 16.7272C7.1293 16.5522 7.01777 16.313 7.00283 16.0586C6.98789 15.8042 7.07067 15.5536 7.23426 15.3582C7.39785 15.1627 7.6299 15.0371 7.883 15.007L8 15H16C16.2652 15 16.5196 15.1054 16.7071 15.2929C16.8946 15.4804 17 15.7348 17 16Z" />',
  },
};
