import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import bulananApi from '../utils/api';
import queryKey from '../constant/queryKey';
import type{ TPortBulananCenceledRequest } from '../types/types';

const useCencelBulanan = (
  props?: Omit<
    UseMutationOptions<any, Error, TPortBulananCenceledRequest, unknown>,
    'mutationKey' | 'mutationFn'
  >
) =>
  useMutation<any, Error, TPortBulananCenceledRequest, unknown>({
    mutationKey: queryKey.bulanan.upload,
    mutationFn: (params: TPortBulananCenceledRequest) => bulananApi.batal(params),
    ...props,
  });

export default useCencelBulanan;
