export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TGetListDataTableDigunggung = {
  id: number;
  npwpPemotong: string;
  nitkuPemotong: string;
  msPajak: string;
  thnPajak: string;
  kdObjPjk: string;
  kdJnsPjk: string;
  statusPPh: string;
  jmlBruto: string;
  tarif: string;
  pphDipotong: string;
  kap: string;
  kjs: string;
  fgFasilitas: string;
  noDokLainnya: string;
  tglpemotongan: string;
  userId: string;
  created_at: string;
  updated_at: string;
  created: string;
  updated: string;
  fgStatus: string;
  internal_id: string;
  dokumen_referensi: TDokReferensi[];
  revNo: number;
  noBupot: string | null;
  idBupot: string | null;
  glAccount: string;
  glName: string | null;
};

export type TGetListDataTableDigunggungResult = TGetListDataTableDigunggung[];

export type TGetListDataKOPDigunggung = {
  kode: string;
  nama: string;
  pasal: string;
  statuspph: string;
  normanetto: string;
  tarif: string;
  kap: string;
  kjs: string;
  noCertificate: number;
  certofDomicile: number;
  otherCert: number;
};

export type TGetListDataKOPDigunggungResult = TGetListDataKOPDigunggung[];

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TDokReferensi = {
  namaDok: string;
  nomorDok: string;
  tglDok: string; // format: DDMMYYYY
};

export type TPostDigunggungRequest = {
  id: string | null;
  idBupot?: string | null;
  noBupot?: string | null;
  kanal: string;
  npwpPemotong: string;
  idTku: string;
  fgTransaction: 'NEW' | 'UPDATE' | 'DELETE' | '';
  revNo: number;
  masaPajak: string;
  tahunPajak: number;
  fgNpwpNik: boolean;
  npwp: string;
  nik: string;
  nama: string;
  idAkun: string;
  sertifikatInsentifDipotong: string;
  nomorSertifikatInsentif: string;
  kodeObjekPajak: string;
  pasalPph: string;
  statusPph: string;
  kap: number;
  kjs: number;
  dokReferensi: TDokReferensi[];
  dpp: number;
  tarif: number;
  pphDipotong: number;
  tglPemotongan: string;
  userId: string;
  glAccount: string;
};

export type TPostUpload = {
  id: string;
};

export type TDeleteRequest = {
  id: string;
};

export type TCancelRequest = {
  id: string | number;
  tglPembatalan: string; // format: DDMMYYYY
};

export type TCancelResponse = TBaseResponseAPI<{
  id: string | number;
  statusBatal?: string;
  message?: string;
}>;
