import Grid from '@mui/material/Grid';
import MenuItem from '@mui/material/MenuItem';
import { useState } from 'react';
import { useFormContext } from 'react-hook-form';
import { useParams } from 'react-router';
import { Field } from 'src/components/hook-form';

type IdentitasProps = {
  isPengganti: boolean;
  //   disabledTambah: boolean;
  //   disabledHapus: boolean;
};

const Identitas = ({ isPengganti }: IdentitasProps) => {
  const { dnId } = useParams();
  const { setValue } = useFormContext();

  const [jumlahKeterangan, setJumlahKeterangan] = useState<number>(0);

  const maxKeterangan = 5;

  const handleTambah = () => {
    if (jumlahKeterangan < maxKeterangan) {
      setJumlahKeterangan(jumlahKeterangan + 1);
    }
  };

  const handleHapus = () => {
    if (jumlahKeterangan > 0) {
      const newCount = jumlahKeterangan - 1;
      setJumlahKeterangan(newCount);
      // reset value form field yang dihapus
      setValue(`keterangan${newCount + 1}`, null);
    }
  };

  const MockNitku = [
    {
      nama: '1091031210912281000000',
    },
    {
      nama: '1091031210912281000001',
    },
  ];

  return (
    <Grid container rowSpacing={2} alignItems="center" columnSpacing={2} sx={{ mb: 4 }}>
        <Grid size={{ md: 6 }}>
          <Field.DatePicker name="tglPemotongan" label="Tanggal Pemotongan" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Select name="status" label="Status" disabled>
            <MenuItem>Normal</MenuItem>
          </Field.Select>
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="noRekAkun" label="Nomor Rekening Akun" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Select name="idTku" label="NITKU Pemotong">
            {MockNitku.map((item, index) => (
              <MenuItem key={index} value={item.nama}>
                {item.nama}
              </MenuItem>
            ))}
          </Field.Select>
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="npwpPemberiPenghasilan" label="NPWP Pemberi Penghasilan" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text
            name="noRekAkunPemberiPenghasilan"
            label="Nomor Rekening Akun Pemberi Penghasilan"
          />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="npwpPenerimaPenghasilan" label="NPWP Penerima Penghasilan" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text
            name="noRekAkunPenerimaPenghasilan"
            label="Nomor Rekening Akun Penerima Penghasilan"
          />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.Text name="kodeBilling" label="Kode Billing" />
        </Grid>
        <Grid size={{ md: 6 }}>
          <Field.DatePicker name="tanggalBilling" label="Tanggal Billing" />
        </Grid>
      </Grid>
  );
};

export default Identitas;
