import { Close } from '@mui/icons-material';
import { Dialog, DialogContent, DialogTitle, IconButton, Typography } from '@mui/material';
// import { useState } from 'react';
import { useForm } from 'react-hook-form';
import { Field } from 'src/components/hook-form';
import { useAppSelector } from 'src/store';

interface DialogPenandatanganProps {
  isOpen: boolean;
  onClose: () => void;
  title?: string;
  //   onSubmit: (data: any) => void;
  //   isLoadingButtonSubmit: boolean;
  //   agreementText?: string;
  //   isPembatalan: boolean;
  //   isPending: boolean;
  //   feature: string;
  //   isWarning: boolean;
  //   isCountDown: boolean;
}

export default function DialogPenandatangan({
  isOpen,
  onClose,
  title = 'Penandatangan',
}: DialogPenandatanganProps) {
  const penandatanganOptions = useAppSelector((state: any) => state.user.data.signer_npwp);

  const form = useForm({
    mode: 'all',
  });

  // const [isCheckedAgreement, setIsCheckedAgreement] = useState(false);

  const handleClose = () => {
    form.reset();
    onClose();
  };

  //   const declareOptions = [
  //     { label: feature === 'spt faktur' ? 'PKP' : 'Wajib Pajak', value: 0 },
  //     { label: 'Wakil/Kuasa', value: 1 },
  //   ];

  const handleSubmitLocal = (data: any) => {
    // if (isCountDown)
    //   setCountdown(30); // start countdown saat submit
    // else setCountdown(null);
    // onSubmit(data); // tetap panggil props onSubmit
  };

  return (
    <Dialog
      fullWidth
      maxWidth="md"
      open={isOpen}
      onClose={handleClose}
      aria-labelledby="dialog-rekap"
    >
      <DialogTitle id="dialog-rekap">
        <Typography textTransform="capitalize" fontWeight="bold" variant="inherit" color="initial">
          {title}
        </Typography>
      </DialogTitle>
      <IconButton
        aria-label="close"
        onClick={handleClose}
        sx={(theme: any) => ({
          position: 'absolute',
          right: 8,
          top: 8,
          color: theme.palette.grey[500],
        })}
      >
        <Close />
      </IconButton>
      <DialogContent>
        {/* <form onSubmit={form.handleSubmit(handleSubmitLocal)}> */}
        <Field.Autocomplete
          name="nikNpwpTtd"
          label="NPWP/NIK Penandatangan"
          options={[{ value: penandatanganOptions, label: `NAMA${penandatanganOptions}` }]}
          sx={{ background: 'white' }}
        />
        {/*
            <Agreement
              isCheckedAgreement={isCheckedAgreement}
              setIsCheckedAgreement={setIsCheckedAgreement}
              text={agreementText}
            />
            <LoadingButton
              loading={isLoadingButtonSubmit}
              disabled={!isCheckedAgreement}
              variant="contained"
              type="submit"
            >
              Save
            </LoadingButton> */}
        {/* </form> */}
      </DialogContent>
    </Dialog>
  );
}
