import { useMutation } from '@tanstack/react-query';
import type { TBaseResponseAPI, TDeleteSspRequest } from '../types/types';
import sspApi from '../utils/api';

const useDeleteDn = (props?: any) =>
  useMutation<TBaseResponseAPI<null>, Error, TDeleteSspRequest>({
    mutationKey: ['delete-ssp'],
    mutationFn: (payload) => sspApi.deleteNr(payload),
    ...props,
  });

export default useDeleteDn;
