import Grid from '@mui/material/Grid';
import dayjs from 'dayjs';
import { useEffect } from 'react';
import { useFormContext } from 'react-hook-form';
import { Field } from 'src/components/hook-form';

type IdentitasProps = {
  isPengganti: boolean;
  existingSsp?: any; // Data penuh dari API (opsional, untuk edit/pengganti)
};

const Identitas = ({ isPengganti, existingSsp }: IdentitasProps) => {
  const { setValue, watch } = useFormContext();

  const tanggalPemotongan = watch('tglPemotongan');

  // 🧩 Auto isi Tahun & Masa Pajak berdasarkan tanggalPemotongan
  useEffect(() => {
    if (tanggalPemotongan) {
      const date = dayjs(tanggalPemotongan);
      setValue('thnPajak', date.format('YYYY'));
      setValue('msPajak', date.format('MM'));
    } else {
      setValue('thnPajak', '');
      setValue('msPajak', '');
    }
  }, [tanggalPemotongan, setValue]);

  return (
    <>
      {/* 📋 Identitas Dasar */}
      <Grid container rowSpacing={2} alignItems="center" columnSpacing={2}>
        {/* 📅 Tanggal & Masa Pajak */}
        <Grid size={{ md: 6 }}>
          <Field.DatePicker
            name="tglPemotongan"
            label="Tanggal Pemotongan"
            format="DD/MM/YYYY"
            maxDate={dayjs()}
            disabled={isPengganti}
          />
        </Grid>
        <Grid size={{ md: 3 }}>
          <Field.DatePicker
            name="thnPajak"
            label="Tahun Pajak"
            view="year"
            format="YYYY"
            disabled={isPengganti}
          />
        </Grid>
        <Grid size={{ md: 3 }}>
          <Field.DatePicker
            name="msPajak"
            label="Masa Pajak"
            view="month"
            format="MM"
            disabled={isPengganti}
          />
        </Grid>
      </Grid>
    </>
  );
};

export default Identitas;
