import { useMutation, type UseMutationOptions } from '@tanstack/react-query';
import bulananApi from '../utils/api';
import type { TPortBulananUploadRequest } from '../types/types';
import queryKey from '../constant/queryKey';

const useUploadBulanan = (
  props?: Omit<
    UseMutationOptions<any, Error, TPortBulananUploadRequest, unknown>,
    'mutationKey' | 'mutationFn'
  >
) =>
  useMutation<any, Error, TPortBulananUploadRequest, unknown>({
    mutationKey: queryKey.bulanan.upload,
    mutationFn: (params: TPortBulananUploadRequest) => bulananApi.upload(params),
    ...props,
  });

export default useUploadBulanan;
