import type { TReturPmForm, TReturPmObjekFaktur } from '../types/types';

const mapObjekFakturTrx017ToRetur = (item: any): TReturPmObjekFaktur => ({
  brgJasa: item.brgJasa,
  kdBrgJasa: item.kdBrgJasa,
  namaBrgJasa: item.namaBrgJasa,
  satuanBrgJasa: item.satuanBrgJasa,

  hargaSatuan: Number(item.hargaSatuan),
  jmlBrgJasa: Number(item.jmlBrgJasa),
  returJmlBrgJasa: Number(item.returJmlBrgJasa),

  totalHarga: Number(item.totalHarga),
  diskon: Number(item.diskon ?? 0),
  returDiskon: Number(item.returDiskon ?? 0),

  cekDppLain: Number(item.cekDppLain ?? 0),

  dpp: Number(item.dpp ?? 0),
  returDpp: Number(item.returDpp ?? 0),

  dppLain: Number(item.dppLain ?? 0),
  returDppLain: Number(item.returDppLain ?? 0),

  tarifPpn: Number(item.tarifPpn ?? 0),
  ppn: Number(item.ppn ?? 0),
  returPpn: Number(item.returPpn ?? 0),

  tarifPpnbm: Number(item.tarifPpnbm ?? 0),
  ppnbm: Number(item.ppnbm ?? 0),
  returPpnbm: Number(item.returPpnbm ?? 0),
});

export const mapTrx017ToReturForm = (res: any): TReturPmForm => ({
  // header
  masaPajakRetur: res.masapajakretur,
  tahunPajakRetur: res.tahunpajakretur,
  tanggalRetur: new Date(),
  nomorFakturDiretur: res.nomorfakturdiretur,
  npwpPembeli: res.npwppembeli,
  npwpPenjual: res.npwppenjual,
  isCreditable: Number(res.iscreditable) as 0 | 1,

  // total
  nilaiReturDpp: Number(res.nilaireturdpp ?? 0),
  nilaiReturDppLain: Number(res.nilaireturdpplain ?? 0),
  nilaiReturDiskon: Number(res.nilaireturdiskon ?? 0),
  nilaiReturPpn: Number(res.nilaireturppn ?? 0),
  nilaireturppnbm: Number(res.nilaireturppnbm ?? 0),

  // detail
  objekFaktur: Array.isArray(res.objekFaktur)
    ? res.objekFaktur.map(mapObjekFakturTrx017ToRetur)
    : [],
});
