import { useEffect, useState } from 'react';

// 👇 opsional tapi recommended: bikin tipe agar mudah reuse
export type DialogProgressStatus = 'Proses sedang berlangsung...' | 'Proses selesai';

interface DetailProgressItem {
  id?: string | number;
  status?: 'success' | 'fail' | 'pending';
  message?: string;
}

interface UseDialogProgressBarReturn {
  status: DialogProgressStatus;
  setStatus: React.Dispatch<React.SetStateAction<DialogProgressStatus>>;
  numberOfDataSuccess: number;
  numberOfDataFail: number;
  numberOfDataProcessed: number;
  numberOfData: number;
  setNumberOfData: React.Dispatch<React.SetStateAction<number>>;
  detailProgressTableData: DetailProgressItem[];
  setDetailProgressTableData: React.Dispatch<React.SetStateAction<DetailProgressItem[]>>;
  processSuccess: () => void;
  processFail: () => void;
  resetToDefault: () => void;
  resetAllToDefault: () => Promise<void>;
  setNumberOfDataProcessed: React.Dispatch<React.SetStateAction<number>>;
  setNumberOfDataSuccess: React.Dispatch<React.SetStateAction<number>>;
  setNumberOfDataFail: React.Dispatch<React.SetStateAction<number>>;
}

const useDialogProgressBar = (): UseDialogProgressBarReturn => {
  const DEFAULT_VALUES = {
    status: 'Proses sedang berlangsung...' as DialogProgressStatus,
    numberOfDataSuccess: 0,
    numberOfDataFail: 0,
    numberOfDataProcessed: 0,
    numberOfData: 0,
    detailProgressTableData: [] as DetailProgressItem[],
  };

  const [status, setStatus] = useState<DialogProgressStatus>(DEFAULT_VALUES.status);
  const [numberOfDataSuccess, setNumberOfDataSuccess] = useState<number>(
    DEFAULT_VALUES.numberOfDataSuccess
  );
  const [numberOfDataFail, setNumberOfDataFail] = useState<number>(DEFAULT_VALUES.numberOfDataFail);
  const [numberOfDataProcessed, setNumberOfDataProcessed] = useState<number>(
    DEFAULT_VALUES.numberOfDataProcessed
  );
  const [numberOfData, setNumberOfData] = useState<number>(DEFAULT_VALUES.numberOfData);
  const [detailProgressTableData, setDetailProgressTableData] = useState<DetailProgressItem[]>(
    DEFAULT_VALUES.detailProgressTableData
  );

  const processSuccess = () => {
    setNumberOfDataProcessed((old) => old + 1);
    setNumberOfDataSuccess((old) => old + 1);
  };

  const processFail = () => {
    setNumberOfDataProcessed((old) => old + 1);
    setNumberOfDataFail((old) => old + 1);
  };

  const resetToDefault = () => {
    setStatus('Proses sedang berlangsung...');
    setNumberOfDataSuccess(0);
    setNumberOfDataFail(0);
    setNumberOfDataProcessed(0);
  };

  const handleStatus = () => {
    if (numberOfData === 0) {
      setStatus('Proses sedang berlangsung...');
    } else if (numberOfDataProcessed < numberOfData) {
      setStatus('Proses sedang berlangsung...');
    } else {
      setStatus('Proses selesai');
    }
  };

  const resetAllToDefault = async () => {
    setStatus(DEFAULT_VALUES.status);
    setNumberOfDataSuccess(DEFAULT_VALUES.numberOfDataSuccess);
    setNumberOfDataFail(DEFAULT_VALUES.numberOfDataFail);
    setNumberOfDataProcessed(DEFAULT_VALUES.numberOfDataProcessed);
    setDetailProgressTableData(DEFAULT_VALUES.detailProgressTableData);
  };

  useEffect(() => {
    handleStatus();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [numberOfDataProcessed, numberOfData]);

  return {
    status,
    setStatus,
    numberOfDataSuccess,
    numberOfDataFail,
    numberOfDataProcessed,
    setNumberOfDataProcessed,
    setNumberOfDataSuccess,
    setNumberOfDataFail,
    processSuccess,
    processFail,
    resetToDefault,
    numberOfData,
    setNumberOfData,
    detailProgressTableData,
    setDetailProgressTableData,
    resetAllToDefault,
  };
};

export default useDialogProgressBar;
