import { useQuery } from '@tanstack/react-query';
import type { TBaseResponseAPI, TGetListDataKOPSspResult } from '../types/types';
import queryKey from '../constant/queryKey';
import sspApi from '../utils/api';

const useGetKodeObjekPajakNr = (params?: Record<string, any>) =>
  useQuery<TBaseResponseAPI<TGetListDataKOPSspResult>>({
    queryKey: queryKey.getKodeObjekPajak(params),
    queryFn: () => sspApi.getKodeObjekPajakNr(params),
  });

export default useGetKodeObjekPajakNr;
