import Divider from '@mui/material/Divider';
import Grid from '@mui/material/Grid';
import MenuItem from '@mui/material/MenuItem';
import { useEffect } from 'react';
import { Field } from 'src/components/hook-form';
import { JENIS_DOKUMEN } from '../../constant';
import dayjs from 'dayjs';
import { useAppSelector } from 'src/store';
import { useFormContext } from 'react-hook-form';

const DokumenReferensi = () => {
  const { watch, setValue } = useFormContext<Record<string, any>>();
  const nitku = useAppSelector((state) => state.user.data.nitku_trial);
  const nitkuValue = watch('idTku');

  useEffect(() => {
    if (!nitkuValue && nitku) {
      setValue('idTku', nitku);
    }
  }, [nitku, nitkuValue, setValue]);

  return (
    <Grid sx={{ mb: 3 }} container rowSpacing={2} columnSpacing={2}>
      <Grid sx={{ mt: 3 }} size={{ md: 12 }}>
        <Divider sx={{ fontWeight: 'bold' }} textAlign="left">
          Daftar Dokumen
        </Divider>
      </Grid>
      <Grid size={{ md: 6 }}>
        <Field.Select name="namaDok" label="Nama Dokumen">
          {JENIS_DOKUMEN.map((item, index) => (
            <MenuItem key={index} value={item.value}>
              {item.label}
            </MenuItem>
          ))}
        </Field.Select>
      </Grid>
      <Grid size={{ md: 6 }}>
        <Field.Text name="nomorDok" label="Nomor Dokumen" />
      </Grid>
      <Grid size={{ md: 6 }}>
        <Field.DatePicker
          name="tglDok"
          label="Tanggal Dokumen"
          maxDate={dayjs()}
          minDate={dayjs('2025-01-01')}
        />
      </Grid>
      <Grid size={{ md: 6 }}>
        <Field.Select name="idTku" label="NITKU Pemotong">
          <MenuItem value={nitku}>{nitku}</MenuItem>
        </Field.Select>
      </Grid>
    </Grid>
  );
};

export default DokumenReferensi;
