export type TBaseResponseAPI<T> = {
  status: string;
  message: string;
  data: T;
  time: string;
  code: number;
  metaPage: TBaseResponseMetaPage;
  total?: number;
};

type TBaseResponseMetaPage = {
  pageNum: number | null;
  rowPerPage: number | null;
  totalRow: number;
};

export type TGetListDataTableNr = {
  id: number;
  npwpPemotong: string;
  idTku: string;
  masaPajak: string;
  tahunPajak: string;
  fgNpwpNik: string;
  npwp: string;
  nik: string;
  nama: string;
  sertifikatInsentifDipotong: string;
  nomorSertifikatInsentif: string;
  kodeObjekPajak: string;
  pasalPPh: string;
  statusPPh: string;
  dpp: string;
  tarif: string;
  pphDipotong: string;
  kap: string;
  kjs: string;
  tglpemotongan: string;
  userId: string;
  created_at: string;
  updated_at: string;
  created_by: string;
  updated_by: string;
  fgStatus: string;
  internal_id: string;
  dokumen_referensi: {
    dokReferensi: string;
    nomorDokumen: string;
    tanggal_Dokumen: string;
    metodePembayaranBendahara: string;
    nomorSP2D: string;
  }[];
  revNo: number;
  noBupot: string;
  idBupot: string;
  npwpNikPenandatangan: string;
  namaPenandatangan: string;
  link: string | null;
  errorMsg: string | null;
  email: string | null;
  glAccount: string;
  fgkirimemail: string;
  glName: string | null;
  keterangan1: string | null;
  keterangan2: string | null;
  keterangan3: string | null;
  keterangan4: string | null;
  keterangan5: string | null;
};

export type TGetListDataTableNrResult = TGetListDataTableNr[];

export type ActionItem = {
  title: string;
  icon: React.ReactNode;
  func?: () => void;
  disabled?: boolean;
};

export type TDokReferensi = {
  dokReferensi: string;
  nomorDokumen: string;
  tanggal_Dokumen: string; // format: DDMMYYYY
};

export type TPostBupot26Request = {
  id: string | null;
  idBupot: string;
  noBupot: string;
  npwpPemotong: string;
  idTku: string;
  masaPajak: string;
  tahunPajak: number;
  tinDipotong: string;
  namaDipotong: string;
  alamatDipotong: string;
  negaraDipotong: string;
  tglLahirDipotong: string;
  tmptLahirDipotong: string;
  nomorPaspor: string;
  nomorKitasKitap: string;
  sertifikatInsentifDipotong: string;
  nomorSertifikatInsentif: string;
  kodeObjekPajak: string;
  pasalPph: string;
  statusPph: string;
  penghasilanBruto: number;
  normaPenghasilanNeto: number;
  tarif: number;
  pphDipotong: number;
  kap: number;
  kjs: number;
  dokReferensi: TDokReferensi[];
  metodePembayaranBendahara: string;
  nomorSP2D: string;
  tglPemotongan: string;
  userId: string;
  kanal: string;
  revNo: number;
  feature: '26'
};

export type TCountry = {
  kode: string;
  nama: string;
};

export type TCountryResult = TCountry[];

export type TPostUpload = {
  id: string;
  feature: '26'
};

export type TDeleteNrRequest = {
  id: string;
  feature: '26'
};

export type TCancelNrRequest = {
  id: string | number;
  tglPembatalan: string; // format: DDMMYYYY
  feature: '26'
};

export type TCancelNrResponse = TBaseResponseAPI<{
  id: string | number;
  feature: '26'
  statusBatal?: string;
  message?: string;
}>;
