import { useMutation } from '@tanstack/react-query';
import type { TCancelNrRequest, TCancelNrResponse } from '../types/types';
import nrApi from '../utils/api';
import queryKey from '../../constant/queryKey';

const useCancelNr = (props?: any) =>
  useMutation<TCancelNrResponse, Error, TCancelNrRequest>({
    mutationKey:queryKey.bupot26.cancel,
    mutationFn: (payload) => nrApi.cancel(payload),
    ...props,
  });

export default useCancelNr;
