import React from 'react';

import Grid from '@mui/material/Grid';
import Divider from '@mui/material/Divider';
import { RHFNumeric } from 'src/components/hook-form/rhf-numeric';

// ----------------------------------------------------------------------

const TotalTransaksi: React.FC = () => (
  <Grid container spacing={2} sx={{ mb: 3 }}>
    <Grid size={{ xs: 12 }} sx={{ mt: 3 }}>
      <Divider sx={{ fontWeight: 'bold', fontSize: '1.2rem', mb: 2 }} textAlign="center">
        Total Transaksi
      </Divider>
    </Grid>

    <Grid size={{ md: 4 }}>
      <RHFNumeric
        name="totalJumlahBarang"
        label="Total Jumlah Barang"
        allowDecimalValue
        decimalScale={2}
        displayOnly
      />
    </Grid>
    <Grid size={{ md: 4 }}>
      <RHFNumeric
        name="totalHarga"
        label="Total Harga (Rp)"
        allowDecimalValue
        decimalScale={2}
        displayOnly
      />
    </Grid>
    <Grid size={{ md: 4 }}>
      <RHFNumeric
        name="totalDiskon"
        label="Total Diskon (Rp)"
        allowDecimalValue
        decimalScale={2}
        displayOnly
      />
    </Grid>

    <Grid size={{ md: 3 }}>
      <RHFNumeric
        name="totalDpp"
        label="Jumlah DPP (Rp)"
        allowDecimalValue
        decimalScale={2}
        displayOnly
      />
    </Grid>
    <Grid size={{ md: 3 }}>
      <RHFNumeric
        name="totalDppLain"
        label="Jumlah DPP Lain (Rp)"
        allowDecimalValue
        decimalScale={2}
        displayOnly
      />
    </Grid>
    <Grid size={{ md: 3 }}>
      <RHFNumeric
        name="totalPpn"
        label="Jumlah PPN (Rp)"
        allowDecimalValue
        decimalScale={2}
        displayOnly
      />
    </Grid>
    <Grid size={{ md: 3 }}>
      <RHFNumeric
        name="totalPpnbm"
        label="Jumlah PPnBM (Rp)"
        allowDecimalValue
        decimalScale={2}
        displayOnly
      />
    </Grid>
  </Grid>
);

export default TotalTransaksi;
